/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.kafka;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.kafka.SpanDecorator;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;

public class TracingCallback
implements Callback {
    private final Callback callback;
    private final Span span;
    private final Tracer tracer;

    public TracingCallback(Callback callback, Span span, Tracer tracer) {
        this.callback = callback;
        this.span = span;
        this.tracer = tracer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompletion(RecordMetadata metadata, Exception exception) {
        if (exception != null) {
            SpanDecorator.onError(exception, this.span);
        }
        try (Scope ignored = this.tracer.scopeManager().activate(this.span);){
            if (this.callback != null) {
                this.callback.onCompletion(metadata, exception);
            }
        }
        finally {
            this.span.finish();
        }
    }
}

