/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.kafka;

import java.util.function.BiFunction;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;

public class ClientSpanNameProvider {
    public static BiFunction<String, ConsumerRecord, String> CONSUMER_OPERATION_NAME = (operationName, consumerRecord) -> ClientSpanNameProvider.replaceIfNull(operationName, "unknown");
    public static BiFunction<String, ProducerRecord, String> PRODUCER_OPERATION_NAME = (operationName, producerRecord) -> ClientSpanNameProvider.replaceIfNull(operationName, "unknown");
    public static BiFunction<String, ConsumerRecord, String> CONSUMER_TOPIC = (operationName, consumerRecord) -> ClientSpanNameProvider.replaceIfNull(consumerRecord, "unknown");
    public static BiFunction<String, ProducerRecord, String> PRODUCER_TOPIC = (operationName, producerRecord) -> ClientSpanNameProvider.replaceIfNull(producerRecord, "unknown");
    public static BiFunction<String, ConsumerRecord, String> CONSUMER_OPERATION_NAME_TOPIC = (operationName, consumerRecord) -> ClientSpanNameProvider.replaceIfNull(operationName, "unknown") + " - " + ClientSpanNameProvider.replaceIfNull(consumerRecord, "unknown");
    public static BiFunction<String, ProducerRecord, String> PRODUCER_OPERATION_NAME_TOPIC = (operationName, producerRecord) -> ClientSpanNameProvider.replaceIfNull(operationName, "unknown") + " - " + ClientSpanNameProvider.replaceIfNull(producerRecord, "unknown");

    public static BiFunction<String, ConsumerRecord, String> CONSUMER_PREFIXED_OPERATION_NAME(String prefix) {
        return (operationName, consumerRecord) -> ClientSpanNameProvider.replaceIfNull(prefix, "") + ClientSpanNameProvider.replaceIfNull(operationName, "unknown");
    }

    public static BiFunction<String, ProducerRecord, String> PRODUCER_PREFIXED_OPERATION_NAME(String prefix) {
        return (operationName, producerRecord) -> ClientSpanNameProvider.replaceIfNull(prefix, "") + ClientSpanNameProvider.replaceIfNull(operationName, "unknown");
    }

    public static BiFunction<String, ConsumerRecord, String> CONSUMER_PREFIXED_TOPIC(String prefix) {
        return (operationName, consumerRecord) -> ClientSpanNameProvider.replaceIfNull(prefix, "") + ClientSpanNameProvider.replaceIfNull(consumerRecord, "unknown");
    }

    public static BiFunction<String, ProducerRecord, String> PRODUCER_PREFIXED_TOPIC(String prefix) {
        return (operationName, producerRecord) -> ClientSpanNameProvider.replaceIfNull(prefix, "") + ClientSpanNameProvider.replaceIfNull(producerRecord, "unknown");
    }

    public static BiFunction<String, ConsumerRecord, String> CONSUMER_PREFIXED_OPERATION_NAME_TOPIC(String prefix) {
        return (operationName, consumerRecord) -> ClientSpanNameProvider.replaceIfNull(prefix, "") + ClientSpanNameProvider.replaceIfNull(operationName, "unknown") + " - " + ClientSpanNameProvider.replaceIfNull(consumerRecord, "unknown");
    }

    public static BiFunction<String, ProducerRecord, String> PRODUCER_PREFIXED_OPERATION_NAME_TOPIC(String prefix) {
        return (operationName, producerRecord) -> ClientSpanNameProvider.replaceIfNull(prefix, "") + ClientSpanNameProvider.replaceIfNull(operationName, "unknown") + " - " + ClientSpanNameProvider.replaceIfNull(producerRecord, "unknown");
    }

    private static String replaceIfNull(String input, String replacement) {
        return input == null ? replacement : input;
    }

    private static String replaceIfNull(ConsumerRecord input, String replacement) {
        return input == null ? replacement : input.topic();
    }

    private static String replaceIfNull(ProducerRecord input, String replacement) {
        return input == null ? replacement : input.topic();
    }
}

