/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.kafka;

import io.opentracing.Tracer;
import io.opentracing.contrib.kafka.ClientSpanNameProvider;
import io.opentracing.contrib.kafka.SpanDecorator;
import io.opentracing.contrib.kafka.TracingKafkaUtils;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;

public class TracingKafkaConsumer<K, V>
implements Consumer<K, V> {
    private final Tracer tracer;
    private final Consumer<K, V> consumer;
    private Collection<SpanDecorator> spanDecorators;
    private final BiFunction<String, ConsumerRecord, String> consumerSpanNameProvider;

    TracingKafkaConsumer(Consumer<K, V> consumer, Tracer tracer, Collection<SpanDecorator> spanDecorators, BiFunction<String, ConsumerRecord, String> consumerSpanNameProvider) {
        this.consumer = consumer;
        this.tracer = tracer;
        this.spanDecorators = Collections.unmodifiableCollection(spanDecorators);
        this.consumerSpanNameProvider = consumerSpanNameProvider == null ? ClientSpanNameProvider.CONSUMER_OPERATION_NAME : consumerSpanNameProvider;
    }

    public TracingKafkaConsumer(Consumer<K, V> consumer, Tracer tracer) {
        this.consumer = consumer;
        this.tracer = tracer;
        this.spanDecorators = Collections.singletonList(SpanDecorator.STANDARD_TAGS);
        this.consumerSpanNameProvider = ClientSpanNameProvider.CONSUMER_OPERATION_NAME;
    }

    public TracingKafkaConsumer(Consumer<K, V> consumer, Tracer tracer, BiFunction<String, ConsumerRecord, String> consumerSpanNameProvider) {
        this.consumer = consumer;
        this.tracer = tracer;
        this.spanDecorators = Collections.singletonList(SpanDecorator.STANDARD_TAGS);
        this.consumerSpanNameProvider = consumerSpanNameProvider == null ? ClientSpanNameProvider.CONSUMER_OPERATION_NAME : consumerSpanNameProvider;
    }

    public Set<TopicPartition> assignment() {
        return this.consumer.assignment();
    }

    public Set<String> subscription() {
        return this.consumer.subscription();
    }

    public void subscribe(Collection<String> topics, ConsumerRebalanceListener listener) {
        this.consumer.subscribe(topics, listener);
    }

    public void subscribe(Collection<String> topics) {
        this.consumer.subscribe(topics);
    }

    public void subscribe(Pattern pattern, ConsumerRebalanceListener listener) {
        this.consumer.subscribe(pattern, listener);
    }

    public void subscribe(Pattern pattern) {
        this.consumer.subscribe(pattern);
    }

    public void unsubscribe() {
        this.consumer.unsubscribe();
    }

    public void assign(Collection<TopicPartition> partitions) {
        this.consumer.assign(partitions);
    }

    @Deprecated
    public ConsumerRecords<K, V> poll(long timeout) {
        ConsumerRecords records = this.consumer.poll(timeout);
        for (ConsumerRecord record : records) {
            TracingKafkaUtils.buildAndFinishChildSpan(record, this.tracer, this.consumerSpanNameProvider, this.spanDecorators);
        }
        return records;
    }

    public ConsumerRecords<K, V> poll(Duration duration) {
        ConsumerRecords records = this.consumer.poll(duration);
        for (ConsumerRecord record : records) {
            TracingKafkaUtils.buildAndFinishChildSpan(record, this.tracer, this.consumerSpanNameProvider, this.spanDecorators);
        }
        return records;
    }

    public void commitSync() {
        this.consumer.commitSync();
    }

    public void commitSync(Duration duration) {
        this.consumer.commitSync(duration);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.consumer.commitSync(offsets);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> map, Duration duration) {
        this.consumer.commitSync(map, duration);
    }

    public void commitAsync() {
        this.consumer.commitAsync();
    }

    public void commitAsync(OffsetCommitCallback callback) {
        this.consumer.commitAsync(callback);
    }

    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        this.consumer.commitAsync(offsets, callback);
    }

    public void seek(TopicPartition partition, long offset) {
        this.consumer.seek(partition, offset);
    }

    public void seek(TopicPartition partition, OffsetAndMetadata offsetAndMetadata) {
        this.consumer.seek(partition, offsetAndMetadata);
    }

    public void seekToBeginning(Collection<TopicPartition> partitions) {
        this.consumer.seekToBeginning(partitions);
    }

    public void seekToEnd(Collection<TopicPartition> partitions) {
        this.consumer.seekToEnd(partitions);
    }

    public long position(TopicPartition partition) {
        return this.consumer.position(partition);
    }

    public long position(TopicPartition topicPartition, Duration duration) {
        return this.consumer.position(topicPartition, duration);
    }

    public OffsetAndMetadata committed(TopicPartition partition) {
        return this.consumer.committed(partition);
    }

    public OffsetAndMetadata committed(TopicPartition topicPartition, Duration duration) {
        return this.consumer.committed(topicPartition, duration);
    }

    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions) {
        return this.consumer.committed(partitions);
    }

    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions, Duration timeout) {
        return this.consumer.committed(partitions, timeout);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.consumer.metrics();
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return this.consumer.partitionsFor(topic);
    }

    public List<PartitionInfo> partitionsFor(String s, Duration duration) {
        return this.consumer.partitionsFor(s, duration);
    }

    public Map<String, List<PartitionInfo>> listTopics() {
        return this.consumer.listTopics();
    }

    public Map<String, List<PartitionInfo>> listTopics(Duration duration) {
        return this.consumer.listTopics(duration);
    }

    public void pause(Collection<TopicPartition> partitions) {
        this.consumer.pause(partitions);
    }

    public void resume(Collection<TopicPartition> partitions) {
        this.consumer.resume(partitions);
    }

    public Set<TopicPartition> paused() {
        return this.consumer.paused();
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch) {
        return this.consumer.offsetsForTimes(timestampsToSearch);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> map, Duration duration) {
        return this.consumer.offsetsForTimes(map, duration);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions) {
        return this.consumer.beginningOffsets(partitions);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> collection, Duration duration) {
        return this.consumer.beginningOffsets(collection, duration);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        return this.consumer.endOffsets(partitions);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> collection, Duration duration) {
        return this.consumer.endOffsets(collection, duration);
    }

    public void close() {
        this.consumer.close();
    }

    @Deprecated
    public void close(long l, TimeUnit timeUnit) {
        this.consumer.close(l, timeUnit);
    }

    public void close(Duration duration) {
        this.consumer.close(duration);
    }

    public void wakeup() {
        this.consumer.wakeup();
    }
}

