/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.kafka;

import io.opentracing.Tracer;
import io.opentracing.contrib.kafka.ClientSpanNameProvider;
import io.opentracing.contrib.kafka.SpanDecorator;
import io.opentracing.contrib.kafka.TracingKafkaConsumer;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiFunction;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class TracingKafkaConsumerBuilder<K, V> {
    private Collection<SpanDecorator> spanDecorators;
    private Consumer<K, V> consumer;
    private Tracer tracer;
    private BiFunction<String, ConsumerRecord, String> consumerSpanNameProvider;

    public TracingKafkaConsumerBuilder(Consumer<K, V> consumer, Tracer tracer) {
        this.tracer = tracer;
        this.consumer = consumer;
        this.spanDecorators = Collections.singletonList(SpanDecorator.STANDARD_TAGS);
        this.consumerSpanNameProvider = ClientSpanNameProvider.CONSUMER_OPERATION_NAME;
    }

    public TracingKafkaConsumerBuilder withDecorators(Collection<SpanDecorator> spanDecorators) {
        this.spanDecorators = Collections.unmodifiableCollection(spanDecorators);
        return this;
    }

    public TracingKafkaConsumerBuilder withSpanNameProvider(BiFunction<String, ConsumerRecord, String> consumerSpanNameProvider) {
        this.consumerSpanNameProvider = consumerSpanNameProvider;
        return this;
    }

    public TracingKafkaConsumer<K, V> build() {
        return new TracingKafkaConsumer<K, V>(this.consumer, this.tracer, this.spanDecorators, this.consumerSpanNameProvider);
    }
}

