/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.kafka;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.kafka.ClientSpanNameProvider;
import io.opentracing.contrib.kafka.TracingCallback;
import io.opentracing.contrib.kafka.TracingKafkaUtils;
import io.opentracing.util.GlobalTracer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;

public class TracingKafkaProducer<K, V>
implements Producer<K, V> {
    private Producer<K, V> producer;
    private final Tracer tracer;
    private final BiFunction<String, ProducerRecord, String> producerSpanNameProvider;

    public TracingKafkaProducer(Producer<K, V> producer, Tracer tracer) {
        this.producer = producer;
        this.tracer = tracer;
        this.producerSpanNameProvider = ClientSpanNameProvider.PRODUCER_OPERATION_NAME;
    }

    public TracingKafkaProducer(Producer<K, V> producer) {
        this(producer, GlobalTracer.get());
    }

    public TracingKafkaProducer(Producer<K, V> producer, Tracer tracer, BiFunction<String, ProducerRecord, String> producerSpanNameProvider) {
        this.producer = producer;
        this.tracer = tracer;
        this.producerSpanNameProvider = producerSpanNameProvider == null ? ClientSpanNameProvider.PRODUCER_OPERATION_NAME : producerSpanNameProvider;
    }

    public TracingKafkaProducer(Producer<K, V> producer, BiFunction<String, ProducerRecord, String> producerSpanNameProvider) {
        this(producer, GlobalTracer.get(), producerSpanNameProvider);
    }

    public void initTransactions() {
        this.producer.initTransactions();
    }

    public void beginTransaction() throws ProducerFencedException {
        this.producer.beginTransaction();
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> map, String s) throws ProducerFencedException {
        this.producer.sendOffsetsToTransaction(map, s);
    }

    public void commitTransaction() throws ProducerFencedException {
        this.producer.commitTransaction();
    }

    public void abortTransaction() throws ProducerFencedException {
        this.producer.abortTransaction();
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
        return this.send(record, null);
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> record, Callback callback) {
        Span span = TracingKafkaUtils.buildAndInjectSpan(record, this.tracer, this.producerSpanNameProvider);
        try (Scope ignored = this.tracer.activateSpan(span);){
            TracingCallback wrappedCallback = new TracingCallback(callback, span, this.tracer);
            Future future = this.producer.send(record, (Callback)wrappedCallback);
            return future;
        }
    }

    public void flush() {
        this.producer.flush();
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return this.producer.partitionsFor(topic);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.producer.metrics();
    }

    public void close() {
        this.producer.close();
    }

    public void close(Duration duration) {
        this.producer.close(duration);
    }

    public void close(long timeout, TimeUnit timeUnit) {
        this.producer.close(timeout, timeUnit);
    }
}

