/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.kafka.spring;

import io.opentracing.Tracer;
import io.opentracing.contrib.kafka.ClientSpanNameProvider;
import io.opentracing.contrib.kafka.SpanDecorator;
import io.opentracing.contrib.kafka.TracingKafkaConsumerBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiFunction;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.serialization.Deserializer;
import org.springframework.kafka.core.ConsumerFactory;

public class TracingConsumerFactory<K, V>
implements ConsumerFactory<K, V> {
    private final ConsumerFactory<K, V> consumerFactory;
    private final Tracer tracer;
    private final Collection<SpanDecorator> spanDecorators;
    private final BiFunction<String, ConsumerRecord, String> consumerSpanNameProvider;

    public TracingConsumerFactory(ConsumerFactory<K, V> consumerFactory, Tracer tracer) {
        this(consumerFactory, tracer, null, null);
    }

    public TracingConsumerFactory(ConsumerFactory<K, V> consumerFactory, Tracer tracer, Collection<SpanDecorator> spanDecorators) {
        this(consumerFactory, tracer, spanDecorators, null);
    }

    public TracingConsumerFactory(ConsumerFactory<K, V> consumerFactory, Tracer tracer, BiFunction<String, ConsumerRecord, String> consumerSpanNameProvider) {
        this(consumerFactory, tracer, null, consumerSpanNameProvider);
    }

    public TracingConsumerFactory(ConsumerFactory<K, V> consumerFactory, Tracer tracer, Collection<SpanDecorator> spanDecorators, BiFunction<String, ConsumerRecord, String> consumerSpanNameProvider) {
        this.tracer = tracer;
        this.consumerFactory = consumerFactory;
        this.spanDecorators = spanDecorators == null ? Collections.singletonList(SpanDecorator.STANDARD_TAGS) : spanDecorators;
        this.consumerSpanNameProvider = consumerSpanNameProvider == null ? ClientSpanNameProvider.CONSUMER_OPERATION_NAME : consumerSpanNameProvider;
    }

    public Consumer<K, V> createConsumer() {
        return new TracingKafkaConsumerBuilder(this.consumerFactory.createConsumer(), this.tracer).withDecorators(this.spanDecorators).withSpanNameProvider(this.consumerSpanNameProvider).build();
    }

    public Consumer<K, V> createConsumer(String clientIdSuffix) {
        return new TracingKafkaConsumerBuilder(this.consumerFactory.createConsumer(clientIdSuffix), this.tracer).withDecorators(this.spanDecorators).withSpanNameProvider(this.consumerSpanNameProvider).build();
    }

    public Consumer<K, V> createConsumer(String groupId, String clientIdSuffix) {
        return new TracingKafkaConsumerBuilder(this.consumerFactory.createConsumer(groupId, clientIdSuffix), this.tracer).withDecorators(this.spanDecorators).withSpanNameProvider(this.consumerSpanNameProvider).build();
    }

    public Consumer<K, V> createConsumer(String groupId, String clientIdPrefix, String clientIdSuffix) {
        return new TracingKafkaConsumerBuilder(this.consumerFactory.createConsumer(groupId, clientIdPrefix, clientIdSuffix), this.tracer).withDecorators(this.spanDecorators).withSpanNameProvider(this.consumerSpanNameProvider).build();
    }

    public Consumer<K, V> createConsumer(String groupId, String clientIdPrefix, String clientIdSuffix, Properties properties) {
        return new TracingKafkaConsumerBuilder(this.consumerFactory.createConsumer(groupId, clientIdPrefix, clientIdSuffix, properties), this.tracer).withDecorators(this.spanDecorators).withSpanNameProvider(this.consumerSpanNameProvider).build();
    }

    public boolean isAutoCommit() {
        return this.consumerFactory.isAutoCommit();
    }

    public Map<String, Object> getConfigurationProperties() {
        return this.consumerFactory.getConfigurationProperties();
    }

    public Deserializer<K> getKeyDeserializer() {
        return this.consumerFactory.getKeyDeserializer();
    }

    public Deserializer<V> getValueDeserializer() {
        return this.consumerFactory.getValueDeserializer();
    }
}

