/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.kafka.streams;

import io.opentracing.Tracer;
import io.opentracing.contrib.kafka.ClientSpanNameProvider;
import io.opentracing.contrib.kafka.SpanDecorator;
import io.opentracing.contrib.kafka.TracingKafkaConsumerBuilder;
import io.opentracing.contrib.kafka.TracingKafkaProducerBuilder;
import io.opentracing.util.GlobalTracer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.KafkaClientSupplier;

public class TracingKafkaClientSupplier
implements KafkaClientSupplier {
    private final Tracer tracer;
    private final Collection<SpanDecorator> spanDecorators;
    private final BiFunction<String, ConsumerRecord, String> consumerSpanNameProvider;
    private final BiFunction<String, ProducerRecord, String> producerSpanNameProvider;

    public TracingKafkaClientSupplier(Tracer tracer) {
        this(tracer, null, null, null);
    }

    public TracingKafkaClientSupplier() {
        this(GlobalTracer.get(), null, null, null);
    }

    public TracingKafkaClientSupplier(Tracer tracer, Collection<SpanDecorator> spanDecorators) {
        this(tracer, spanDecorators, null, null);
    }

    public TracingKafkaClientSupplier(Tracer tracer, BiFunction<String, ConsumerRecord, String> consumerSpanNameProvider, BiFunction<String, ProducerRecord, String> producerSpanNameProvider) {
        this(tracer, null, consumerSpanNameProvider, producerSpanNameProvider);
    }

    public TracingKafkaClientSupplier(Tracer tracer, Collection<SpanDecorator> spanDecorators, BiFunction<String, ConsumerRecord, String> consumerSpanNameProvider, BiFunction<String, ProducerRecord, String> producerSpanNameProvider) {
        this.tracer = tracer;
        this.spanDecorators = spanDecorators == null ? Collections.singletonList(SpanDecorator.STANDARD_TAGS) : spanDecorators;
        this.consumerSpanNameProvider = consumerSpanNameProvider == null ? ClientSpanNameProvider.CONSUMER_OPERATION_NAME : consumerSpanNameProvider;
        this.producerSpanNameProvider = producerSpanNameProvider == null ? ClientSpanNameProvider.PRODUCER_OPERATION_NAME : producerSpanNameProvider;
    }

    public TracingKafkaClientSupplier(BiFunction<String, ConsumerRecord, String> consumerSpanNameProvider, BiFunction<String, ProducerRecord, String> producerSpanNameProvider) {
        this(GlobalTracer.get(), null, consumerSpanNameProvider, producerSpanNameProvider);
    }

    public AdminClient getAdminClient(Map<String, Object> config) {
        return AdminClient.create(config);
    }

    public Producer<byte[], byte[]> getProducer(Map<String, Object> config) {
        return new TracingKafkaProducerBuilder((Producer)new KafkaProducer(config, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer()), this.tracer).withDecorators(this.spanDecorators).withSpanNameProvider(this.producerSpanNameProvider).build();
    }

    public Consumer<byte[], byte[]> getConsumer(Map<String, Object> config) {
        return new TracingKafkaConsumerBuilder((Consumer)new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer()), this.tracer).withDecorators(this.spanDecorators).withSpanNameProvider(this.consumerSpanNameProvider).build();
    }

    public Consumer<byte[], byte[]> getRestoreConsumer(Map<String, Object> config) {
        return new TracingKafkaConsumerBuilder((Consumer)new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer()), this.tracer).withDecorators(this.spanDecorators).withSpanNameProvider(this.consumerSpanNameProvider).build();
    }

    public Consumer<byte[], byte[]> getGlobalConsumer(Map<String, Object> config) {
        return new TracingKafkaConsumerBuilder((Consumer)new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer()), this.tracer).withDecorators(this.spanDecorators).withSpanNameProvider(this.consumerSpanNameProvider).build();
    }
}

