/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.mongo;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoDriverInformation;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ChangeStreamIterable;
import com.mongodb.async.client.ClientSession;
import com.mongodb.async.client.ListDatabasesIterable;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.async.client.MongoClients;
import com.mongodb.async.client.MongoDatabase;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.event.CommandListener;
import io.opentracing.Tracer;
import io.opentracing.contrib.mongo.TracingCommandListener;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;

public class TracingAsyncMongoClient
implements MongoClient {
    private final MongoClient mongoClient;

    public TracingAsyncMongoClient(Tracer tracer, com.mongodb.MongoClientSettings settings) {
        this(tracer, settings, null);
    }

    public TracingAsyncMongoClient(Tracer tracer, com.mongodb.MongoClientSettings settings, MongoDriverInformation mongoDriverInformation) {
        TracingCommandListener tracingCommandListener = new TracingCommandListener(tracer);
        this.mongoClient = MongoClients.create((com.mongodb.MongoClientSettings)com.mongodb.MongoClientSettings.builder((com.mongodb.MongoClientSettings)settings).addCommandListener((CommandListener)tracingCommandListener).build(), (MongoDriverInformation)mongoDriverInformation);
    }

    public void startSession(SingleResultCallback<ClientSession> callback) {
        this.mongoClient.startSession(callback);
    }

    public void startSession(ClientSessionOptions clientSessionOptions, SingleResultCallback<ClientSession> singleResultCallback) {
    }

    public MongoDatabase getDatabase(String name) {
        return this.mongoClient.getDatabase(name);
    }

    public void close() {
        this.mongoClient.close();
    }

    public MongoClientSettings getSettings() {
        return this.mongoClient.getSettings();
    }

    public MongoIterable<String> listDatabaseNames() {
        return this.mongoClient.listDatabaseNames();
    }

    public MongoIterable<String> listDatabaseNames(ClientSession clientSession) {
        return this.mongoClient.listDatabaseNames(clientSession);
    }

    public ListDatabasesIterable<Document> listDatabases() {
        return this.mongoClient.listDatabases();
    }

    public ListDatabasesIterable<Document> listDatabases(ClientSession clientSession) {
        return this.mongoClient.listDatabases(clientSession);
    }

    public <TResult> ListDatabasesIterable<TResult> listDatabases(Class<TResult> tResultClass) {
        return this.mongoClient.listDatabases(tResultClass);
    }

    public <TResult> ListDatabasesIterable<TResult> listDatabases(ClientSession clientSession, Class<TResult> aClass) {
        return this.mongoClient.listDatabases(clientSession, aClass);
    }

    public ChangeStreamIterable<Document> watch() {
        return this.mongoClient.watch();
    }

    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> tResultClass) {
        return this.mongoClient.watch(tResultClass);
    }

    public ChangeStreamIterable<Document> watch(List<? extends Bson> pipeline) {
        return this.mongoClient.watch(pipeline);
    }

    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> pipeline, Class<TResult> tResultClass) {
        return this.mongoClient.watch(pipeline, tResultClass);
    }

    public ChangeStreamIterable<Document> watch(ClientSession clientSession) {
        return this.mongoClient.watch(clientSession);
    }

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, Class<TResult> tResultClass) {
        return this.mongoClient.watch(clientSession, tResultClass);
    }

    public ChangeStreamIterable<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.mongoClient.watch(clientSession, pipeline);
    }

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> tResultClass) {
        return this.mongoClient.watch(pipeline, tResultClass);
    }
}

