/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.mongo;

import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.mongo.providers.MongoSpanNameProvider;
import io.opentracing.contrib.mongo.providers.NoopSpanNameProvider;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TracingCommandListener
implements CommandListener {
    static final String COMPONENT_NAME = "java-mongo";
    private final Tracer tracer;
    private final MongoSpanNameProvider mongoSpanNameProvider;
    private final Map<Integer, Span> cache = new ConcurrentHashMap<Integer, Span>();

    public TracingCommandListener(Tracer tracer) {
        this.tracer = tracer;
        this.mongoSpanNameProvider = new NoopSpanNameProvider();
    }

    public TracingCommandListener() {
        this(GlobalTracer.get());
    }

    public TracingCommandListener(Tracer tracer, MongoSpanNameProvider customNameProvider) {
        this.tracer = tracer;
        this.mongoSpanNameProvider = customNameProvider;
    }

    public TracingCommandListener(MongoSpanNameProvider customNameProvider) {
        this(GlobalTracer.get(), customNameProvider);
    }

    public void commandStarted(CommandStartedEvent event) {
        Span span = this.buildSpan(event);
        this.cache.put(event.getRequestId(), span);
    }

    public void commandSucceeded(CommandSucceededEvent event) {
        Span span = this.cache.remove(event.getRequestId());
        if (span != null) {
            span.finish();
        }
    }

    public void commandFailed(CommandFailedEvent event) {
        Span span = this.cache.remove(event.getRequestId());
        if (span != null) {
            TracingCommandListener.onError(span, event.getThrowable());
            span.finish();
        }
    }

    Span buildSpan(CommandStartedEvent event) {
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(this.mongoSpanNameProvider.generateName(event.getCommandName())).withTag(Tags.SPAN_KIND.getKey(), "client");
        Span span = spanBuilder.start();
        TracingCommandListener.decorate(span, event);
        return span;
    }

    private static void decorate(Span span, CommandStartedEvent event) {
        Tags.COMPONENT.set(span, COMPONENT_NAME);
        Tags.DB_STATEMENT.set(span, event.getCommand().toString());
        Tags.DB_INSTANCE.set(span, event.getDatabaseName());
        Tags.PEER_HOSTNAME.set(span, event.getConnectionDescription().getServerAddress().getHost());
        InetAddress inetAddress = event.getConnectionDescription().getServerAddress().getSocketAddress().getAddress();
        if (inetAddress instanceof Inet4Address) {
            byte[] address = inetAddress.getAddress();
            Tags.PEER_HOST_IPV4.set(span, Integer.valueOf(ByteBuffer.wrap(address).getInt()));
        } else {
            Tags.PEER_HOST_IPV6.set(span, inetAddress.getHostAddress());
        }
        Tags.PEER_PORT.set(span, Integer.valueOf(event.getConnectionDescription().getServerAddress().getPort()));
        Tags.DB_TYPE.set(span, "mongo");
    }

    private static void onError(Span span, Throwable throwable) {
        Tags.ERROR.set(span, Boolean.TRUE);
        span.log(TracingCommandListener.errorLogs(throwable));
    }

    private static Map<String, Object> errorLogs(Throwable throwable) {
        HashMap<String, Object> errorLogs = new HashMap<String, Object>(4);
        errorLogs.put("event", Tags.ERROR.getKey());
        errorLogs.put("error.kind", throwable.getClass().getName());
        errorLogs.put("error.object", throwable);
        errorLogs.put("message", throwable.getMessage());
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        errorLogs.put("stack", sw.toString());
        return errorLogs;
    }
}

