/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.MongoDriverInformation;
import com.mongodb.ServerAddress;
import com.mongodb.event.CommandListener;
import io.opentracing.Tracer;
import io.opentracing.contrib.mongo.TracingCommandListener;
import io.opentracing.contrib.mongo.providers.MongoSpanNameProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TracingMongoClient
extends MongoClient {
    public TracingMongoClient(Tracer tracer) {
        this(tracer, new ServerAddress());
    }

    public TracingMongoClient(Tracer tracer, String host) {
        this(tracer, new ServerAddress(host));
    }

    public TracingMongoClient(Tracer tracer, String host, MongoClientOptions options) {
        this(tracer, new ServerAddress(host), options);
    }

    public TracingMongoClient(Tracer tracer, String host, int port) {
        this(tracer, new ServerAddress(host, port));
    }

    public TracingMongoClient(Tracer tracer, ServerAddress addr) {
        this(tracer, addr, new MongoClientOptions.Builder().build());
    }

    public TracingMongoClient(Tracer tracer, ServerAddress addr, List<MongoCredential> credentialsList) {
        this(tracer, addr, credentialsList, new MongoClientOptions.Builder().build());
    }

    public TracingMongoClient(Tracer tracer, ServerAddress addr, MongoClientOptions options) {
        super(addr, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)new TracingCommandListener(tracer)).build());
    }

    public TracingMongoClient(Tracer tracer, ServerAddress addr, List<MongoCredential> credentialsList, MongoClientOptions options) {
        super(addr, credentialsList, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)new TracingCommandListener(tracer)).build());
    }

    public TracingMongoClient(Tracer tracer, ServerAddress addr, MongoCredential credential, MongoClientOptions options) {
        super(addr, credential, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)new TracingCommandListener(tracer)).build());
    }

    public TracingMongoClient(Tracer tracer, List<ServerAddress> seeds) {
        this(tracer, seeds, new MongoClientOptions.Builder().build());
    }

    public TracingMongoClient(Tracer tracer, List<ServerAddress> seeds, List<MongoCredential> credentialsList) {
        this(tracer, seeds, credentialsList, new MongoClientOptions.Builder().build());
    }

    public TracingMongoClient(Tracer tracer, List<ServerAddress> seeds, MongoClientOptions options) {
        super(seeds, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)new TracingCommandListener(tracer)).build());
    }

    public TracingMongoClient(Tracer tracer, List<ServerAddress> seeds, MongoClientOptions options, MongoSpanNameProvider spanNameProvider) {
        super(seeds, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)new TracingCommandListener(tracer, spanNameProvider)).build());
    }

    public TracingMongoClient(Tracer tracer, List<ServerAddress> seeds, List<MongoCredential> credentialsList, MongoClientOptions options) {
        super(seeds, credentialsList, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)new TracingCommandListener(tracer)).build());
    }

    public TracingMongoClient(Tracer tracer, List<ServerAddress> seeds, List<MongoCredential> credentialsList, MongoClientOptions options, MongoSpanNameProvider spanNameProvider) {
        super(seeds, credentialsList, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)new TracingCommandListener(tracer, spanNameProvider)).build());
    }

    public TracingMongoClient(Tracer tracer, List<ServerAddress> seeds, MongoCredential credential, MongoClientOptions options) {
        super(seeds, credential, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)new TracingCommandListener(tracer)).build());
    }

    public TracingMongoClient(Tracer tracer, MongoClientURI uri) {
        this(tracer, uri, null);
    }

    public TracingMongoClient(Tracer tracer, List<ServerAddress> seeds, MongoCredential credential, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        super(seeds, credential, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)new TracingCommandListener(tracer)).build(), mongoDriverInformation);
    }

    public TracingMongoClient(Tracer tracer, MongoClientURI uri, MongoDriverInformation mongoDriverInformation) {
        this(tracer, TracingMongoClient.toServerAddressList(uri.getHosts()), uri.getCredentials() != null ? Collections.singletonList(uri.getCredentials()) : Collections.emptyList(), uri.getOptions(), mongoDriverInformation);
    }

    public TracingMongoClient(Tracer tracer, ServerAddress addr, List<MongoCredential> credentialsList, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        super(addr, credentialsList, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)new TracingCommandListener(tracer)).build(), mongoDriverInformation);
    }

    public TracingMongoClient(Tracer tracer, List<ServerAddress> seeds, List<MongoCredential> credentialsList, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        super(seeds, credentialsList, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)new TracingCommandListener(tracer)).build(), mongoDriverInformation);
    }

    private static List<ServerAddress> toServerAddressList(List<String> hosts) {
        ArrayList<ServerAddress> list = new ArrayList<ServerAddress>();
        for (String host : hosts) {
            list.add(new ServerAddress(host));
        }
        return list;
    }
}

