/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.reactor;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.reactor.SpanSubscription;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

public class TracedSubscriber<T>
implements SpanSubscription<T> {
    private final Span span;
    private final Subscriber<? super T> subscriber;
    private final Context context;
    private final Tracer tracer;
    private Subscription subscription;

    public TracedSubscriber(Subscriber<? super T> subscriber, Context ctx, Tracer tracer) {
        this.subscriber = subscriber;
        this.tracer = tracer;
        Span span = this.span = ctx != null ? (Span)ctx.getOrDefault(Span.class, (Object)this.tracer.activeSpan()) : null;
        this.context = ctx != null && this.span != null ? ctx.put(Span.class, (Object)this.span) : (ctx != null ? ctx : Context.empty());
    }

    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        this.withActiveSpan(() -> this.subscriber.onSubscribe((Subscription)this));
    }

    public void request(long n) {
        this.withActiveSpan(() -> this.subscription.request(n));
    }

    public void onNext(T o) {
        this.withActiveSpan(() -> this.subscriber.onNext(o));
    }

    public void cancel() {
        this.withActiveSpan(() -> this.subscription.cancel());
    }

    public void onError(Throwable throwable) {
        this.subscriber.onError(throwable);
    }

    public void onComplete() {
        this.subscriber.onComplete();
    }

    public Context currentContext() {
        return this.context;
    }

    private void withActiveSpan(Runnable runnable) {
        if (this.span != null) {
            try (Scope inScope = this.tracer.scopeManager().activate(this.span);){
                runnable.run();
            }
        } else {
            runnable.run();
        }
    }

    public static <T> Function<? super Publisher<T>, ? extends Publisher<T>> asOperator(final Tracer tracer) {
        return Operators.liftPublisher((BiFunction)new BiFunction<Publisher, CoreSubscriber<? super T>, CoreSubscriber<? super T>>(){

            @Override
            public CoreSubscriber<? super T> apply(Publisher publisher, CoreSubscriber<? super T> sub) {
                if (publisher instanceof Fuseable.ScalarCallable) {
                    return sub;
                }
                return new TracedSubscriber(sub, sub.currentContext(), tracer);
            }
        });
    }
}

