/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent.reactor;

import io.opentracing.contrib.specialagent.AgentRule;
import io.opentracing.contrib.specialagent.reactor.FluxAgentIntercept;
import io.opentracing.contrib.specialagent.reactor.MonoAgentIntercept;
import io.opentracing.contrib.specialagent.reactor.ParallelFluxAgentIntercept;
import java.util.Arrays;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;

public class ReactorAgentRule
extends AgentRule {
    public Iterable<? extends AgentBuilder> buildAgent(AgentBuilder builder) throws Exception {
        return Arrays.asList(builder.type((ElementMatcher)ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)"reactor.core.publisher.Mono"))).transform(new AgentBuilder.Transformer(){

            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                return builder.visit((AsmVisitorWrapper)Advice.to(Mono.class).on((ElementMatcher)ElementMatchers.named((String)"onAssembly")));
            }
        }), builder.type((ElementMatcher)ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)"reactor.core.publisher.Flux"))).transform(new AgentBuilder.Transformer(){

            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                return builder.visit((AsmVisitorWrapper)Advice.to(Flux.class).on((ElementMatcher)ElementMatchers.named((String)"onAssembly")));
            }
        }), builder.type((ElementMatcher)ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)"reactor.core.publisher.ParallelFlux"))).transform(new AgentBuilder.Transformer(){

            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                return builder.visit((AsmVisitorWrapper)Advice.to(ParallelFlux.class).on((ElementMatcher)ElementMatchers.named((String)"onAssembly")));
            }
        }));
    }

    public static class ParallelFlux {
        @Advice.OnMethodEnter
        public static void enter(@Advice.Origin String origin) {
            if (AgentRule.isEnabled((String)origin)) {
                ParallelFluxAgentIntercept.enter();
            }
        }
    }

    public static class Flux {
        @Advice.OnMethodEnter
        public static void enter(@Advice.Origin String origin) {
            if (AgentRule.isEnabled((String)origin)) {
                FluxAgentIntercept.enter();
            }
        }
    }

    public static class Mono {
        @Advice.OnMethodEnter
        public static void enter(@Advice.Origin String origin) {
            if (AgentRule.isEnabled((String)origin)) {
                MonoAgentIntercept.enter();
            }
        }
    }
}

