/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.common;

import io.opentracing.Tracer;
import io.opentracing.contrib.redis.common.RedisSpanNameProvider;
import java.util.function.Function;

public class TracingConfiguration {
    static final int DEFAULT_KEYS_MAX_LENGTH = 100;
    private final Tracer tracer;
    private final boolean traceWithActiveSpanOnly;
    private final int keysMaxLength;
    private final Function<String, String> spanNameProvider;

    private TracingConfiguration(Tracer tracer, boolean traceWithActiveSpanOnly, int keysMaxLength, Function<String, String> spanNameProvider) {
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.keysMaxLength = keysMaxLength;
        this.spanNameProvider = spanNameProvider;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public boolean isTraceWithActiveSpanOnly() {
        return this.traceWithActiveSpanOnly;
    }

    public int getKeysMaxLength() {
        return this.keysMaxLength;
    }

    public Function<String, String> getSpanNameProvider() {
        return this.spanNameProvider;
    }

    public static class Builder {
        private final Tracer tracer;
        private boolean traceWithActiveSpanOnly;
        private int keysMaxLength = 100;
        private Function<String, String> spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;

        public Builder(Tracer tracer) {
            this.tracer = tracer;
        }

        public Builder traceWithActiveSpanOnly(boolean traceWithActiveSpanOnly) {
            this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
            return this;
        }

        public Builder withSpanNameProvider(Function<String, String> spanNameProvider) {
            this.spanNameProvider = spanNameProvider;
            return this;
        }

        public Builder withKeysMaxLength(int keysMaxLength) {
            this.keysMaxLength = keysMaxLength;
            return this;
        }

        public TracingConfiguration build() {
            if (this.spanNameProvider == null) {
                this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
            }
            if (this.keysMaxLength <= 0) {
                this.keysMaxLength = 100;
            }
            return new TracingConfiguration(this.tracer, this.traceWithActiveSpanOnly, this.keysMaxLength, this.spanNameProvider);
        }
    }
}

