/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.jedis;

import io.opentracing.BaseSpan;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.redis.common.TracingHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.DebugParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;

public class TracingJedisCluster
extends JedisCluster {
    private final TracingHelper helper;

    public TracingJedisCluster(HostAndPort node, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(node);
        this.helper = new TracingHelper(tracer, traceWithActiveSpanOnly);
    }

    public TracingJedisCluster(HostAndPort node, int timeout, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(node, timeout);
        this.helper = new TracingHelper(tracer, traceWithActiveSpanOnly);
    }

    public TracingJedisCluster(HostAndPort node, int timeout, int maxAttempts, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(node, timeout, maxAttempts);
        this.helper = new TracingHelper(tracer, traceWithActiveSpanOnly);
    }

    public TracingJedisCluster(HostAndPort node, GenericObjectPoolConfig poolConfig, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(node, poolConfig);
        this.helper = new TracingHelper(tracer, traceWithActiveSpanOnly);
    }

    public TracingJedisCluster(HostAndPort node, int timeout, GenericObjectPoolConfig poolConfig, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(node, timeout, poolConfig);
        this.helper = new TracingHelper(tracer, traceWithActiveSpanOnly);
    }

    public TracingJedisCluster(HostAndPort node, int timeout, int maxAttempts, GenericObjectPoolConfig poolConfig, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(node, timeout, maxAttempts, poolConfig);
        this.helper = new TracingHelper(tracer, traceWithActiveSpanOnly);
    }

    public TracingJedisCluster(HostAndPort node, int connectionTimeout, int soTimeout, int maxAttempts, GenericObjectPoolConfig poolConfig, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(node, connectionTimeout, soTimeout, maxAttempts, poolConfig);
        this.helper = new TracingHelper(tracer, traceWithActiveSpanOnly);
    }

    public TracingJedisCluster(HostAndPort node, int connectionTimeout, int soTimeout, int maxAttempts, String password, GenericObjectPoolConfig poolConfig, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(node, connectionTimeout, soTimeout, maxAttempts, password, poolConfig);
        this.helper = new TracingHelper(tracer, traceWithActiveSpanOnly);
    }

    public TracingJedisCluster(Set<HostAndPort> nodes, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(nodes);
        this.helper = new TracingHelper(tracer, traceWithActiveSpanOnly);
    }

    public TracingJedisCluster(Set<HostAndPort> nodes, int timeout, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(nodes, timeout);
        this.helper = new TracingHelper(tracer, traceWithActiveSpanOnly);
    }

    public TracingJedisCluster(Set<HostAndPort> nodes, int timeout, int maxAttempts, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(nodes, timeout, maxAttempts);
        this.helper = new TracingHelper(tracer, traceWithActiveSpanOnly);
    }

    public TracingJedisCluster(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(nodes, poolConfig);
        this.helper = new TracingHelper(tracer, traceWithActiveSpanOnly);
    }

    public TracingJedisCluster(Set<HostAndPort> nodes, int timeout, GenericObjectPoolConfig poolConfig, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(nodes, timeout, poolConfig);
        this.helper = new TracingHelper(tracer, traceWithActiveSpanOnly);
    }

    public TracingJedisCluster(Set<HostAndPort> jedisClusterNode, int timeout, int maxAttempts, GenericObjectPoolConfig poolConfig, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(jedisClusterNode, timeout, maxAttempts, poolConfig);
        this.helper = new TracingHelper(tracer, traceWithActiveSpanOnly);
    }

    public TracingJedisCluster(Set<HostAndPort> jedisClusterNode, int connectionTimeout, int soTimeout, int maxAttempts, GenericObjectPoolConfig poolConfig, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(jedisClusterNode, connectionTimeout, soTimeout, maxAttempts, poolConfig);
        this.helper = new TracingHelper(tracer, traceWithActiveSpanOnly);
    }

    public TracingJedisCluster(Set<HostAndPort> jedisClusterNode, int connectionTimeout, int soTimeout, int maxAttempts, String password, GenericObjectPoolConfig poolConfig, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(jedisClusterNode, connectionTimeout, soTimeout, maxAttempts, password, poolConfig);
        this.helper = new TracingHelper(tracer, traceWithActiveSpanOnly);
    }

    public String set(String key, String value) {
        Span span = this.helper.buildSpan("set", (Object)key);
        span.setTag("value", value);
        try {
            String string = super.set(key, value);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String set(String key, String value, String nxxx, String expx, long time) {
        Span span = this.helper.buildSpan("set", (Object)key);
        span.setTag("value", value);
        span.setTag("nxxx", nxxx);
        span.setTag("expx", expx);
        span.setTag("time", (Number)time);
        try {
            String string = super.set(key, value, nxxx, expx, time);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String get(String key) {
        Span span = this.helper.buildSpan("get", (Object)key);
        try {
            String string = super.get(key);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long exists(String ... keys) {
        Span span = this.helper.buildSpan("exists", (Object[])keys);
        try {
            Long l = super.exists(keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean exists(String key) {
        Span span = this.helper.buildSpan("exists", (Object)key);
        try {
            Boolean bl = super.exists(key);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long del(String ... keys) {
        Span span = this.helper.buildSpan("del", (Object[])keys);
        try {
            Long l = super.del(keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long del(String key) {
        Span span = this.helper.buildSpan("del", (Object)key);
        try {
            Long l = super.del(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String type(String key) {
        Span span = this.helper.buildSpan("type", (Object)key);
        try {
            String string = super.type(key);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String rename(String oldkey, String newkey) {
        Span span = this.helper.buildSpan("rename");
        span.setTag("oldKey", TracingHelper.nullable((Object)oldkey));
        span.setTag("newKey", TracingHelper.nullable((Object)newkey));
        try {
            String string = super.rename(oldkey, newkey);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long renamenx(String oldkey, String newkey) {
        Span span = this.helper.buildSpan("renamenx");
        span.setTag("oldKey", TracingHelper.nullable((Object)oldkey));
        span.setTag("newKey", TracingHelper.nullable((Object)newkey));
        try {
            Long l = super.renamenx(oldkey, newkey);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long expire(String key, int seconds) {
        Span span = this.helper.buildSpan("expire", (Object)key);
        span.setTag("seconds", (Number)seconds);
        try {
            Long l = super.expire(key, seconds);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long expireAt(String key, long unixTime) {
        Span span = this.helper.buildSpan("expireAt", (Object)key);
        span.setTag("unixTime", (Number)unixTime);
        try {
            Long l = super.expireAt(key, unixTime);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long ttl(String key) {
        Span span = this.helper.buildSpan("ttl", (Object)key);
        try {
            Long l = super.ttl(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long move(String key, int dbIndex) {
        Span span = this.helper.buildSpan("move", (Object)key);
        span.setTag("dbIndex", (Number)dbIndex);
        try {
            Long l = super.move(key, dbIndex);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String getSet(String key, String value) {
        Span span = this.helper.buildSpan("getSet", (Object)key);
        span.setTag("value", value);
        try {
            String string = super.getSet(key, value);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<String> mget(String ... keys) {
        Span span = this.helper.buildSpan("mget", (Object[])keys);
        try {
            List list = super.mget(keys);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long setnx(String key, String value) {
        Span span = this.helper.buildSpan("setnx", (Object)key);
        span.setTag("value", value);
        try {
            Long l = super.setnx(key, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String setex(String key, int seconds, String value) {
        Span span = this.helper.buildSpan("setex", (Object)key);
        span.setTag("seconds", (Number)seconds);
        span.setTag("value", value);
        try {
            String string = super.setex(key, seconds, value);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String mset(String ... keysvalues) {
        Span span = this.helper.buildSpan("mset");
        span.setTag("keysvalues", Arrays.toString(keysvalues));
        try {
            String string = super.mset(keysvalues);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long msetnx(String ... keysvalues) {
        Span span = this.helper.buildSpan("msetnx");
        span.setTag("keysvalues", Arrays.toString(keysvalues));
        try {
            Long l = super.msetnx(keysvalues);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long decrBy(String key, long integer) {
        Span span = this.helper.buildSpan("decrBy", (Object)key);
        span.setTag("integer", (Number)integer);
        try {
            Long l = super.decrBy(key, integer);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long decr(String key) {
        Span span = this.helper.buildSpan("decr", (Object)key);
        try {
            Long l = super.decr(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long incrBy(String key, long integer) {
        Span span = this.helper.buildSpan("incrBy", (Object)key);
        span.setTag("integer", (Number)integer);
        try {
            Long l = super.incrBy(key, integer);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Double incrByFloat(String key, double value) {
        Span span = this.helper.buildSpan("incrByFloat", (Object)key);
        span.setTag("value", (Number)value);
        try {
            Double d = super.incrByFloat(key, value);
            return d;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long incr(String key) {
        Span span = this.helper.buildSpan("incr", (Object)key);
        try {
            Long l = super.incr(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long append(String key, String value) {
        Span span = this.helper.buildSpan("append", (Object)key);
        span.setTag("value", value);
        try {
            Long l = super.append(key, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String substr(String key, int start, int end) {
        Span span = this.helper.buildSpan("substr", (Object)key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            String string = super.substr(key, start, end);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long hset(String key, String field, String value) {
        Span span = this.helper.buildSpan("hset", (Object)key);
        span.setTag("field", field);
        span.setTag("value", value);
        try {
            Long l = super.hset(key, field, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String hget(String key, String field) {
        Span span = this.helper.buildSpan("hget", (Object)key);
        span.setTag("field", field);
        try {
            String string = super.hget(key, field);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long hsetnx(String key, String field, String value) {
        Span span = this.helper.buildSpan("hsetnx", (Object)key);
        span.setTag("field", field);
        span.setTag("value", value);
        try {
            Long l = super.hsetnx(key, field, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String hmset(String key, Map<String, String> hash) {
        Span span = this.helper.buildSpan("hmset", (Object)key);
        span.setTag("hash", TracingHelper.toString(hash));
        try {
            String string = super.hmset(key, hash);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<String> hmget(String key, String ... fields) {
        Span span = this.helper.buildSpan("hmget", (Object)key);
        span.setTag("fields", Arrays.toString(fields));
        try {
            List list = super.hmget(key, fields);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long hincrBy(String key, String field, long value) {
        Span span = this.helper.buildSpan("hincrBy", (Object)key);
        span.setTag("field", field);
        span.setTag("value", (Number)value);
        try {
            Long l = super.hincrBy(key, field, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Double hincrByFloat(String key, String field, double value) {
        Span span = this.helper.buildSpan("hincrByFloat", (Object)key);
        span.setTag("field", field);
        span.setTag("value", (Number)value);
        try {
            Double d = super.hincrByFloat(key, field, value);
            return d;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean hexists(String key, String field) {
        Span span = this.helper.buildSpan("hexists", (Object)key);
        span.setTag("field", field);
        try {
            Boolean bl = super.hexists(key, field);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long hdel(String key, String ... fields) {
        Span span = this.helper.buildSpan("hdel", (Object)key);
        span.setTag("fields", Arrays.toString(fields));
        try {
            Long l = super.hdel(key, fields);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long hlen(String key) {
        Span span = this.helper.buildSpan("hlen", (Object)key);
        try {
            Long l = super.hlen(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<String> hkeys(String key) {
        Span span = this.helper.buildSpan("hkeys", (Object)key);
        try {
            Set set = super.hkeys(key);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<String> hvals(String key) {
        Span span = this.helper.buildSpan("hvals", (Object)key);
        try {
            List list = super.hvals(key);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Map<String, String> hgetAll(String key) {
        Span span = this.helper.buildSpan("hgetAll", (Object)key);
        try {
            Map map = super.hgetAll(key);
            return map;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long rpush(String key, String ... strings) {
        Span span = this.helper.buildSpan("rpush", (Object)key);
        span.setTag("strings", Arrays.toString(strings));
        try {
            Long l = super.rpush(key, strings);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long lpush(String key, String ... strings) {
        Span span = this.helper.buildSpan("lpush", (Object)key);
        span.setTag("strings", Arrays.toString(strings));
        try {
            Long l = super.lpush(key, strings);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long llen(String key) {
        Span span = this.helper.buildSpan("llen", (Object)key);
        try {
            Long l = super.llen(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<String> lrange(String key, long start, long end) {
        Span span = this.helper.buildSpan("lrange", (Object)key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            List list = super.lrange(key, start, end);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String ltrim(String key, long start, long end) {
        Span span = this.helper.buildSpan("ltrim", (Object)key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            String string = super.ltrim(key, start, end);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String lindex(String key, long index) {
        Span span = this.helper.buildSpan("lindex", (Object)key);
        span.setTag("index", (Number)index);
        try {
            String string = super.lindex(key, index);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String lset(String key, long index, String value) {
        Span span = this.helper.buildSpan("lset", (Object)key);
        span.setTag("index", (Number)index);
        span.setTag("value", value);
        try {
            String string = super.lset(key, index, value);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long lrem(String key, long count, String value) {
        Span span = this.helper.buildSpan("lrem", (Object)key);
        span.setTag("count", (Number)count);
        span.setTag("value", value);
        try {
            Long l = super.lrem(key, count, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String lpop(String key) {
        Span span = this.helper.buildSpan("lpop", (Object)key);
        try {
            String string = super.lpop(key);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String rpop(String key) {
        Span span = this.helper.buildSpan("rpop", (Object)key);
        try {
            String string = super.rpop(key);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String rpoplpush(String srckey, String dstkey) {
        Span span = this.helper.buildSpan("rpoplpush");
        span.setTag("srckey", srckey);
        span.setTag("dstkey", dstkey);
        try {
            String string = super.rpoplpush(srckey, dstkey);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sadd(String key, String ... members) {
        Span span = this.helper.buildSpan("sadd", (Object)key);
        span.setTag("members", Arrays.toString(members));
        try {
            Long l = super.sadd(key, members);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<String> smembers(String key) {
        Span span = this.helper.buildSpan("smembers", (Object)key);
        try {
            Set set = super.smembers(key);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long srem(String key, String ... members) {
        Span span = this.helper.buildSpan("srem", (Object)key);
        span.setTag("members", Arrays.toString(members));
        try {
            Long l = super.srem(key, members);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String spop(String key) {
        Span span = this.helper.buildSpan("spop", (Object)key);
        try {
            String string = super.spop(key);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<String> spop(String key, long count) {
        Span span = this.helper.buildSpan("spop", (Object)key);
        span.setTag("count", (Number)count);
        try {
            Set set = super.spop(key, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long smove(String srckey, String dstkey, String member) {
        Span span = this.helper.buildSpan("smove");
        span.setTag("srckey", srckey);
        span.setTag("dstkey", dstkey);
        span.setTag("member", member);
        try {
            Long l = super.smove(srckey, dstkey, member);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long scard(String key) {
        Span span = this.helper.buildSpan("scard", (Object)key);
        try {
            Long l = super.scard(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean sismember(String key, String member) {
        Span span = this.helper.buildSpan("sismember", (Object)key);
        span.setTag("member", member);
        try {
            Boolean bl = super.sismember(key, member);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<String> sinter(String ... keys) {
        Span span = this.helper.buildSpan("sinter", (Object[])keys);
        try {
            Set set = super.sinter(keys);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sinterstore(String dstkey, String ... keys) {
        Span span = this.helper.buildSpan("sinterstore", (Object[])keys);
        span.setTag("dstkey", dstkey);
        try {
            Long l = super.sinterstore(dstkey, keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<String> sunion(String ... keys) {
        Span span = this.helper.buildSpan("sunion", (Object[])keys);
        try {
            Set set = super.sunion(keys);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sunionstore(String dstkey, String ... keys) {
        Span span = this.helper.buildSpan("sunionstore", (Object[])keys);
        span.setTag("dstkey", dstkey);
        try {
            Long l = super.sunionstore(dstkey, keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<String> sdiff(String ... keys) {
        Span span = this.helper.buildSpan("sdiff", (Object[])keys);
        try {
            Set set = super.sdiff(keys);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sdiffstore(String dstkey, String ... keys) {
        Span span = this.helper.buildSpan("sdiffstore", (Object[])keys);
        span.setTag("dstkey", dstkey);
        try {
            Long l = super.sdiffstore(dstkey, keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String srandmember(String key) {
        Span span = this.helper.buildSpan("srandmember", (Object)key);
        try {
            String string = super.srandmember(key);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<String> srandmember(String key, int count) {
        Span span = this.helper.buildSpan("srandmember", (Object)key);
        span.setTag("count", (Number)count);
        try {
            List list = super.srandmember(key, count);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zadd(String key, double score, String member) {
        Span span = this.helper.buildSpan("zadd", (Object)key);
        span.setTag("score", (Number)score);
        span.setTag("member", member);
        try {
            Long l = super.zadd(key, score, member);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zadd(String key, double score, String member, ZAddParams params) {
        Span span = this.helper.buildSpan("zadd", (Object)key);
        span.setTag("score", (Number)score);
        span.setTag("member", member);
        span.setTag("params", TracingHelper.toString((byte[][])params.getByteParams()));
        try {
            Long l = super.zadd(key, score, member, params);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zadd(String key, Map<String, Double> scoreMembers) {
        Span span = this.helper.buildSpan("zadd", (Object)key);
        span.setTag("scoreMembers", TracingHelper.toString(scoreMembers));
        try {
            Long l = super.zadd(key, scoreMembers);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        Span span = this.helper.buildSpan("zadd", (Object)key);
        span.setTag("scoreMembers", TracingHelper.toString(scoreMembers));
        span.setTag("params", TracingHelper.toString((byte[][])params.getByteParams()));
        try {
            Long l = super.zadd(key, scoreMembers, params);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<String> zrange(String key, long start, long end) {
        Span span = this.helper.buildSpan("zrange", (Object)key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            Set set = super.zrange(key, start, end);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zrem(String key, String ... members) {
        Span span = this.helper.buildSpan("zrem", (Object)key);
        span.setTag("members", Arrays.toString(members));
        try {
            Long l = super.zrem(key, members);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Double zincrby(String key, double score, String member) {
        Span span = this.helper.buildSpan("zincrby", (Object)key);
        span.setTag("score", (Number)score);
        span.setTag("member", member);
        try {
            Double d = super.zincrby(key, score, member);
            return d;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Double zincrby(String key, double score, String member, ZIncrByParams params) {
        Span span = this.helper.buildSpan("zincrby", (Object)key);
        span.setTag("score", (Number)score);
        span.setTag("member", member);
        span.setTag("params", TracingHelper.toString((byte[][])params.getByteParams()));
        try {
            Double d = super.zincrby(key, score, member, params);
            return d;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zrank(String key, String member) {
        Span span = this.helper.buildSpan("zrank", (Object)key);
        span.setTag("member", member);
        try {
            Long l = super.zrank(key, member);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zrevrank(String key, String member) {
        Span span = this.helper.buildSpan("zrevrank", (Object)key);
        span.setTag("member", member);
        try {
            Long l = super.zrevrank(key, member);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<String> zrevrange(String key, long start, long end) {
        Span span = this.helper.buildSpan("zrevrange", (Object)key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            Set set = super.zrevrange(key, start, end);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        Span span = this.helper.buildSpan("zrangeWithScores", (Object)key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            Set set = super.zrangeWithScores(key, start, end);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<Tuple> zrevrangeWithScores(String key, long start, long end) {
        Span span = this.helper.buildSpan("zrevrangeWithScores", (Object)key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            Set set = super.zrevrangeWithScores(key, start, end);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zcard(String key) {
        Span span = this.helper.buildSpan("zcard", (Object)key);
        try {
            Long l = super.zcard(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Double zscore(String key, String member) {
        Span span = this.helper.buildSpan("zscore", (Object)key);
        span.setTag("member", member);
        try {
            Double d = super.zscore(key, member);
            return d;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<String> sort(String key) {
        Span span = this.helper.buildSpan("sort", (Object)key);
        try {
            List list = super.sort(key);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<String> sort(String key, SortingParams sortingParameters) {
        Span span = this.helper.buildSpan("sort", (Object)key);
        span.setTag("sortingParameters", TracingHelper.toString((Collection)sortingParameters.getParams()));
        try {
            List list = super.sort(key, sortingParameters);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<String> blpop(int timeout, String ... keys) {
        Span span = this.helper.buildSpan("blpop", (Object[])keys);
        span.setTag("timeout", (Number)timeout);
        try {
            List list = super.blpop(timeout, keys);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<String> blpop(String arg) {
        Span span = this.helper.buildSpan("blpop");
        span.setTag("arg", arg);
        try {
            List list = super.blpop(arg);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<String> brpop(String arg) {
        Span span = this.helper.buildSpan("brpop");
        span.setTag("arg", arg);
        try {
            List list = super.brpop(arg);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sort(String key, SortingParams sortingParameters, String dstkey) {
        Span span = this.helper.buildSpan("sort", (Object)key);
        span.setTag("sortingParameters", TracingHelper.toString((Collection)sortingParameters.getParams()));
        span.setTag("dstkey", dstkey);
        try {
            Long l = super.sort(key, sortingParameters, dstkey);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sort(String key, String dstkey) {
        Span span = this.helper.buildSpan("sort", (Object)key);
        span.setTag("dstkey", dstkey);
        try {
            Long l = super.sort(key, dstkey);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<String> brpop(int timeout, String ... keys) {
        Span span = this.helper.buildSpan("brpop", (Object[])keys);
        span.setTag("timeout", (Number)timeout);
        try {
            List list = super.brpop(timeout, keys);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zcount(String key, double min, double max) {
        Span span = this.helper.buildSpan("zcount", (Object)key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        try {
            Long l = super.zcount(key, min, max);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zcount(String key, String min, String max) {
        Span span = this.helper.buildSpan("zcount", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        try {
            Long l = super.zcount(key, min, max);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<String> zrangeByScore(String key, double min, double max) {
        Span span = this.helper.buildSpan("zrangeByScore", (Object)key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        try {
            Set set = super.zrangeByScore(key, min, max);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<String> zrangeByScore(String key, String min, String max) {
        Span span = this.helper.buildSpan("zrangeByScore", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        try {
            Set set = super.zrangeByScore(key, min, max);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        Span span = this.helper.buildSpan("zrangeByScore", (Object)key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Set set = super.zrangeByScore(key, min, max, offset, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        Span span = this.helper.buildSpan("zrangeByScore", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Set set = super.zrangeByScore(key, min, max, offset, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        Span span = this.helper.buildSpan("zrangeByScoreWithScores", (Object)key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        try {
            Set set = super.zrangeByScoreWithScores(key, min, max);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max) {
        Span span = this.helper.buildSpan("zrangeByScoreWithScores", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        try {
            Set set = super.zrangeByScoreWithScores(key, min, max);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        Span span = this.helper.buildSpan("zrangeByScoreWithScores", (Object)key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Set set = super.zrangeByScoreWithScores(key, min, max, offset, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        Span span = this.helper.buildSpan("zrangeByScoreWithScores", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Set set = super.zrangeByScoreWithScores(key, min, max, offset, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<String> zrevrangeByScore(String key, double max, double min) {
        Span span = this.helper.buildSpan("zrevrangeByScore", (Object)key);
        span.setTag("max", (Number)max);
        span.setTag("min", (Number)min);
        try {
            Set set = super.zrevrangeByScore(key, max, min);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<String> zrevrangeByScore(String key, String max, String min) {
        Span span = this.helper.buildSpan("zrevrangeByScore", (Object)key);
        span.setTag("max", max);
        span.setTag("min", min);
        try {
            Set set = super.zrevrangeByScore(key, max, min);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        Span span = this.helper.buildSpan("zrevrangeByScore", (Object)key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Set set = super.zrevrangeByScore(key, max, min, offset, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min) {
        Span span = this.helper.buildSpan("zrevrangeByScoreWithScores", (Object)key);
        span.setTag("max", (Number)max);
        span.setTag("min", (Number)min);
        try {
            Set set = super.zrevrangeByScoreWithScores(key, max, min);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        Span span = this.helper.buildSpan("zrevrangeByScoreWithScores", (Object)key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Set set = super.zrevrangeByScoreWithScores(key, max, min, offset, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        Span span = this.helper.buildSpan("zrevrangeByScoreWithScores", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Set set = super.zrevrangeByScoreWithScores(key, max, min, offset, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        Span span = this.helper.buildSpan("zrevrangeByScore", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Set set = super.zrevrangeByScore(key, max, min, offset, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min) {
        Span span = this.helper.buildSpan("zrevrangeByScoreWithScores", (Object)key);
        span.setTag("max", max);
        span.setTag("min", min);
        try {
            Set set = super.zrevrangeByScoreWithScores(key, max, min);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zremrangeByRank(String key, long start, long end) {
        Span span = this.helper.buildSpan("zremrangeByRank", (Object)key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            Long l = super.zremrangeByRank(key, start, end);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zremrangeByScore(String key, double start, double end) {
        Span span = this.helper.buildSpan("zremrangeByScore", (Object)key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            Long l = super.zremrangeByScore(key, start, end);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zremrangeByScore(String key, String start, String end) {
        Span span = this.helper.buildSpan("zremrangeByScore", (Object)key);
        span.setTag("start", start);
        span.setTag("end", end);
        try {
            Long l = super.zremrangeByScore(key, start, end);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zunionstore(String dstkey, String ... sets) {
        Span span = this.helper.buildSpan("zunionstore");
        span.setTag("dstkey", dstkey);
        span.setTag("sets", Arrays.toString(sets));
        try {
            Long l = super.zunionstore(dstkey, sets);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zunionstore(String dstkey, ZParams params, String ... sets) {
        Span span = this.helper.buildSpan("zunionstore");
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        span.setTag("sets", Arrays.toString(sets));
        try {
            Long l = super.zunionstore(dstkey, params, sets);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zinterstore(String dstkey, String ... sets) {
        Span span = this.helper.buildSpan("zinterstore");
        span.setTag("dstkey", dstkey);
        span.setTag("sets", Arrays.toString(sets));
        try {
            Long l = super.zinterstore(dstkey, sets);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zinterstore(String dstkey, ZParams params, String ... sets) {
        Span span = this.helper.buildSpan("zinterstore");
        span.setTag("dstkey", dstkey);
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        span.setTag("sets", Arrays.toString(sets));
        try {
            Long l = super.zinterstore(dstkey, params, sets);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zlexcount(String key, String min, String max) {
        Span span = this.helper.buildSpan("zlexcount", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        try {
            Long l = super.zlexcount(key, min, max);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<String> zrangeByLex(String key, String min, String max) {
        Span span = this.helper.buildSpan("zrangeByLex", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        try {
            Set set = super.zrangeByLex(key, min, max);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<String> zrangeByLex(String key, String min, String max, int offset, int count) {
        Span span = this.helper.buildSpan("zrangeByLex", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Set set = super.zrangeByLex(key, min, max, offset, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<String> zrevrangeByLex(String key, String max, String min) {
        Span span = this.helper.buildSpan("zrevrangeByLex", (Object)key);
        span.setTag("max", max);
        span.setTag("min", min);
        try {
            Set set = super.zrevrangeByLex(key, max, min);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<String> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        Span span = this.helper.buildSpan("zrevrangeByLex", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Set set = super.zrevrangeByLex(key, max, min, offset, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zremrangeByLex(String key, String min, String max) {
        Span span = this.helper.buildSpan("zremrangeByLex", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        try {
            Long l = super.zremrangeByLex(key, min, max);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long strlen(String key) {
        Span span = this.helper.buildSpan("strlen", (Object)key);
        try {
            Long l = super.strlen(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long lpushx(String key, String ... string) {
        Span span = this.helper.buildSpan("lpushx", (Object)key);
        span.setTag("string", Arrays.toString(string));
        try {
            Long l = super.lpushx(key, string);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long persist(String key) {
        Span span = this.helper.buildSpan("persist", (Object)key);
        try {
            Long l = super.persist(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long rpushx(String key, String ... string) {
        Span span = this.helper.buildSpan("rpushx", (Object)key);
        span.setTag("string", Arrays.toString(string));
        try {
            Long l = super.rpushx(key, string);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String echo(String string) {
        Span span = this.helper.buildSpan("echo");
        span.setTag("string", string);
        try {
            String string2 = super.echo(string);
            return string2;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        Span span = this.helper.buildSpan("linsert", (Object)key);
        span.setTag("where", where.name());
        span.setTag("pivot", pivot);
        span.setTag("value", value);
        try {
            Long l = super.linsert(key, where, pivot, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String brpoplpush(String source, String destination, int timeout) {
        Span span = this.helper.buildSpan("brpoplpush");
        span.setTag("source", source);
        span.setTag("destination", destination);
        span.setTag("timeout", (Number)timeout);
        try {
            String string = super.brpoplpush(source, destination, timeout);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean setbit(String key, long offset, boolean value) {
        Span span = this.helper.buildSpan("setbit", (Object)key);
        span.setTag("offset", (Number)offset);
        span.setTag("value", value);
        try {
            Boolean bl = super.setbit(key, offset, value);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean setbit(String key, long offset, String value) {
        Span span = this.helper.buildSpan("setbit", (Object)key);
        span.setTag("offset", (Number)offset);
        span.setTag("value", value);
        try {
            Boolean bl = super.setbit(key, offset, value);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean getbit(String key, long offset) {
        Span span = this.helper.buildSpan("getbit", (Object)key);
        span.setTag("offset", (Number)offset);
        try {
            Boolean bl = super.getbit(key, offset);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long setrange(String key, long offset, String value) {
        Span span = this.helper.buildSpan("setrange", (Object)key);
        span.setTag("offset", (Number)offset);
        span.setTag("value", value);
        try {
            Long l = super.setrange(key, offset, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String getrange(String key, long startOffset, long endOffset) {
        Span span = this.helper.buildSpan("getrange", (Object)key);
        span.setTag("startOffset", (Number)startOffset);
        span.setTag("endOffset", (Number)endOffset);
        try {
            String string = super.getrange(key, startOffset, endOffset);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long bitpos(String key, boolean value) {
        Span span = this.helper.buildSpan("bitpos", (Object)key);
        span.setTag("value", value);
        try {
            Long l = super.bitpos(key, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long bitpos(String key, boolean value, BitPosParams params) {
        Span span = this.helper.buildSpan("bitpos", (Object)key);
        span.setTag("value", value);
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        try {
            Long l = super.bitpos(key, value, params);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Object eval(String script, int keyCount, String ... params) {
        Span span = this.helper.buildSpan("eval");
        span.setTag("keyCount", (Number)keyCount);
        span.setTag("params", Arrays.toString(params));
        try {
            Object object = super.eval(script, keyCount, params);
            return object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Object eval(String script, String key) {
        Span span = this.helper.buildSpan(Protocol.Command.EVAL.name(), (Object)key);
        span.setTag("script", script);
        try {
            Object object = super.eval(script, key);
            return object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        Span span = this.helper.buildSpan("subscribe");
        span.setTag("channels", Arrays.toString(channels));
        try {
            super.subscribe(jedisPubSub, channels);
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long publish(String channel, String message) {
        Span span = this.helper.buildSpan("publish");
        span.setTag("channel", channel);
        span.setTag("message", message);
        try {
            Long l = super.publish(channel, message);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        Span span = this.helper.buildSpan("psubscribe");
        span.setTag("patterns", Arrays.toString(patterns));
        try {
            super.psubscribe(jedisPubSub, patterns);
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Object eval(String script, List<String> keys, List<String> args) {
        Span span = this.helper.buildSpan("eval");
        span.setTag("keys", TracingHelper.toString(keys));
        span.setTag("args", TracingHelper.toString(args));
        try {
            Object object = super.eval(script, keys, args);
            return object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Object evalsha(String sha1, List<String> keys, List<String> args) {
        Span span = this.helper.buildSpan("evalsha");
        span.setTag("keys", TracingHelper.toString(keys));
        span.setTag("args", TracingHelper.toString(args));
        span.setTag("sha1", sha1);
        try {
            Object object = super.evalsha(sha1, keys, args);
            return object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Object evalsha(String script, String key) {
        Span span = this.helper.buildSpan(Protocol.Command.EVALSHA.name(), (Object)key);
        span.setTag("script", script);
        try {
            Object object = super.evalsha(script, key);
            return object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean scriptExists(String sha1, String key) {
        Span span = this.helper.buildSpan("scriptExists", (Object)key);
        span.setTag("sha1", sha1);
        try {
            Boolean bl = super.scriptExists(sha1, key);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<Boolean> scriptExists(String key, String ... sha1) {
        Span span = this.helper.buildSpan("scriptExists", (Object)key);
        span.setTag("sha1", Arrays.toString(sha1));
        try {
            List list = super.scriptExists(key, sha1);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String scriptLoad(String script, String key) {
        Span span = this.helper.buildSpan("scriptLoad", (Object)key);
        span.setTag("script", script);
        try {
            String string = super.scriptLoad(script, key);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Object evalsha(String sha1, int keyCount, String ... params) {
        Span span = this.helper.buildSpan("evalsha");
        span.setTag("keyCount", (Number)keyCount);
        span.setTag("params", Arrays.toString(params));
        span.setTag("sha1", sha1);
        try {
            Object object = super.evalsha(sha1, keyCount, params);
            return object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long bitcount(String key) {
        Span span = this.helper.buildSpan("bitcount", (Object)key);
        try {
            Long l = super.bitcount(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long bitcount(String key, long start, long end) {
        Span span = this.helper.buildSpan("bitcount", (Object)key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            Long l = super.bitcount(key, start, end);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long bitop(BitOP op, String destKey, String ... srcKeys) {
        Span span = this.helper.buildSpan("bitop");
        span.setTag("destKey", destKey);
        span.setTag("srcKeys", Arrays.toString(srcKeys));
        try {
            Long l = super.bitop(op, destKey, srcKeys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String ping() {
        Span span = this.helper.buildSpan("ping");
        try {
            String string = super.ping();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String set(byte[] key, byte[] value) {
        Span span = this.helper.buildSpan("set", key);
        span.setTag("value", Arrays.toString(value));
        try {
            String string = super.set(key, value);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, long time) {
        Span span = this.helper.buildSpan("set", key);
        span.setTag("nxxx", Arrays.toString(nxxx));
        span.setTag("expx", Arrays.toString(expx));
        span.setTag("time", (Number)time);
        span.setTag("value", Arrays.toString(value));
        try {
            String string = super.set(key, value, nxxx, expx, time);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public byte[] get(byte[] key) {
        Span span = this.helper.buildSpan("get", key);
        try {
            byte[] byArray = super.get(key);
            return byArray;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String quit() {
        Span span = this.helper.buildSpan("quit");
        try {
            String string = super.quit();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long exists(byte[] ... keys) {
        Span span = this.helper.buildSpan("exists");
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        try {
            Long l = super.exists(keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean exists(byte[] key) {
        Span span = this.helper.buildSpan("exists", key);
        try {
            Boolean bl = super.exists(key);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long del(byte[] ... keys) {
        Span span = this.helper.buildSpan("del");
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        try {
            Long l = super.del(keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long del(byte[] key) {
        Span span = this.helper.buildSpan("del", key);
        try {
            Long l = super.del(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String type(byte[] key) {
        Span span = this.helper.buildSpan("type", key);
        try {
            String string = super.type(key);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String flushDB() {
        Span span = this.helper.buildSpan("flushDB");
        try {
            String string = super.flushDB();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String rename(byte[] oldkey, byte[] newkey) {
        Span span = this.helper.buildSpan("rename");
        span.setTag("oldkey", Arrays.toString(oldkey));
        span.setTag("newkey", Arrays.toString(newkey));
        try {
            String string = super.rename(oldkey, newkey);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long renamenx(byte[] oldkey, byte[] newkey) {
        Span span = this.helper.buildSpan("renamenx");
        span.setTag("oldkey", Arrays.toString(oldkey));
        span.setTag("newkey", Arrays.toString(newkey));
        try {
            Long l = super.renamenx(oldkey, newkey);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long dbSize() {
        Span span = this.helper.buildSpan("dbSize");
        try {
            Long l = super.dbSize();
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long expire(byte[] key, int seconds) {
        Span span = this.helper.buildSpan("expire", key);
        span.setTag("seconds", (Number)seconds);
        try {
            Long l = super.expire(key, seconds);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long pexpire(String key, long milliseconds) {
        Span span = this.helper.buildSpan("pexpire", (Object)key);
        span.setTag("milliseconds", (Number)milliseconds);
        try {
            Long l = super.pexpire(key, milliseconds);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long expireAt(byte[] key, long unixTime) {
        Span span = this.helper.buildSpan("expireAt", key);
        span.setTag("unixTime", (Number)unixTime);
        try {
            Long l = super.expireAt(key, unixTime);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long ttl(byte[] key) {
        Span span = this.helper.buildSpan("ttl", key);
        try {
            Long l = super.ttl(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String select(int index) {
        Span span = this.helper.buildSpan("select");
        span.setTag("index", (Number)index);
        try {
            String string = super.select(index);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String flushAll() {
        Span span = this.helper.buildSpan("flushAll");
        try {
            String string = super.flushAll();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public byte[] getSet(byte[] key, byte[] value) {
        Span span = this.helper.buildSpan("getSet", key);
        span.setTag("value", Arrays.toString(value));
        try {
            byte[] byArray = super.getSet(key, value);
            return byArray;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<byte[]> mget(byte[] ... keys) {
        Span span = this.helper.buildSpan("mget");
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        try {
            List list = super.mget(keys);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long setnx(byte[] key, byte[] value) {
        Span span = this.helper.buildSpan("setnx", key);
        span.setTag("value", Arrays.toString(value));
        try {
            Long l = super.setnx(key, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String setex(byte[] key, int seconds, byte[] value) {
        Span span = this.helper.buildSpan("setex", key);
        span.setTag("value", Arrays.toString(value));
        span.setTag("seconds", (Number)seconds);
        try {
            String string = super.setex(key, seconds, value);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String mset(byte[] ... keysvalues) {
        Span span = this.helper.buildSpan("mset");
        span.setTag("keysvalues", TracingHelper.toString((byte[][])keysvalues));
        try {
            String string = super.mset(keysvalues);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long msetnx(byte[] ... keysvalues) {
        Span span = this.helper.buildSpan("msetnx");
        span.setTag("keysvalues", TracingHelper.toString((byte[][])keysvalues));
        try {
            Long l = super.msetnx(keysvalues);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long decrBy(byte[] key, long integer) {
        Span span = this.helper.buildSpan("decrBy", key);
        span.setTag("integer", (Number)integer);
        try {
            Long l = super.decrBy(key, integer);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long decr(byte[] key) {
        Span span = this.helper.buildSpan("decr", key);
        try {
            Long l = super.decr(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long incrBy(byte[] key, long integer) {
        Span span = this.helper.buildSpan("incrBy", key);
        span.setTag("integer", (Number)integer);
        try {
            Long l = super.incrBy(key, integer);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Double incrByFloat(byte[] key, double integer) {
        Span span = this.helper.buildSpan("incrByFloat", key);
        span.setTag("integer", (Number)integer);
        try {
            Double d = super.incrByFloat(key, integer);
            return d;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long incr(byte[] key) {
        Span span = this.helper.buildSpan("incr", key);
        try {
            Long l = super.incr(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long append(byte[] key, byte[] value) {
        Span span = this.helper.buildSpan("append", key);
        span.setTag("value", Arrays.toString(value));
        try {
            Long l = super.append(key, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public byte[] substr(byte[] key, int start, int end) {
        Span span = this.helper.buildSpan("substr", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            byte[] byArray = super.substr(key, start, end);
            return byArray;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long hset(byte[] key, byte[] field, byte[] value) {
        Span span = this.helper.buildSpan("hset", key);
        span.setTag("field", Arrays.toString(field));
        span.setTag("value", Arrays.toString(value));
        try {
            Long l = super.hset(key, field, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public byte[] hget(byte[] key, byte[] field) {
        Span span = this.helper.buildSpan("hget", key);
        span.setTag("field", Arrays.toString(field));
        try {
            byte[] byArray = super.hget(key, field);
            return byArray;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long hsetnx(byte[] key, byte[] field, byte[] value) {
        Span span = this.helper.buildSpan("hsetnx", key);
        span.setTag("field", Arrays.toString(field));
        span.setTag("value", Arrays.toString(value));
        try {
            Long l = super.hsetnx(key, field, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        Span span = this.helper.buildSpan("hmset", key);
        span.setTag("hash", TracingHelper.toStringMap(hash));
        try {
            String string = super.hmset(key, hash);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        Span span = this.helper.buildSpan("hmget", key);
        span.setTag("fields", TracingHelper.toString((byte[][])fields));
        try {
            List list = super.hmget(key, fields);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long hincrBy(byte[] key, byte[] field, long value) {
        Span span = this.helper.buildSpan("hincrBy", key);
        span.setTag("field", Arrays.toString(field));
        span.setTag("value", (Number)value);
        try {
            Long l = super.hincrBy(key, field, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Double hincrByFloat(byte[] key, byte[] field, double value) {
        Span span = this.helper.buildSpan("hincrByFloat", key);
        span.setTag("field", Arrays.toString(field));
        span.setTag("value", (Number)value);
        try {
            Double d = super.hincrByFloat(key, field, value);
            return d;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean hexists(byte[] key, byte[] field) {
        Span span = this.helper.buildSpan("hexists", key);
        span.setTag("field", Arrays.toString(field));
        try {
            Boolean bl = super.hexists(key, field);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long hdel(byte[] key, byte[] ... fields) {
        Span span = this.helper.buildSpan("hdel", key);
        span.setTag("fields", TracingHelper.toString((byte[][])fields));
        try {
            Long l = super.hdel(key, fields);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long hlen(byte[] key) {
        Span span = this.helper.buildSpan("hlen", key);
        try {
            Long l = super.hlen(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<byte[]> hkeys(byte[] key) {
        Span span = this.helper.buildSpan("hkeys", key);
        try {
            Set set = super.hkeys(key);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Collection<byte[]> hvals(byte[] key) {
        Span span = this.helper.buildSpan("hvals", key);
        try {
            Collection collection = super.hvals(key);
            return collection;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Map<byte[], byte[]> hgetAll(byte[] key) {
        Span span = this.helper.buildSpan("hgetAll", key);
        try {
            Map map = super.hgetAll(key);
            return map;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long rpush(byte[] key, byte[] ... strings) {
        Span span = this.helper.buildSpan("rpush", key);
        span.setTag("strings", TracingHelper.toString((byte[][])strings));
        try {
            Long l = super.rpush(key, strings);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long lpush(byte[] key, byte[] ... strings) {
        Span span = this.helper.buildSpan("lpush", key);
        span.setTag("strings", TracingHelper.toString((byte[][])strings));
        try {
            Long l = super.lpush(key, strings);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long llen(byte[] key) {
        Span span = this.helper.buildSpan("llen", key);
        try {
            Long l = super.llen(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<byte[]> lrange(byte[] key, long start, long end) {
        Span span = this.helper.buildSpan("lrange", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            List list = super.lrange(key, start, end);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String ltrim(byte[] key, long start, long end) {
        Span span = this.helper.buildSpan("ltrim", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            String string = super.ltrim(key, start, end);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public byte[] lindex(byte[] key, long index) {
        Span span = this.helper.buildSpan("lindex", key);
        span.setTag("index", (Number)index);
        try {
            byte[] byArray = super.lindex(key, index);
            return byArray;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String lset(byte[] key, long index, byte[] value) {
        Span span = this.helper.buildSpan("lset", key);
        span.setTag("index", (Number)index);
        span.setTag("value", Arrays.toString(value));
        try {
            String string = super.lset(key, index, value);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long lrem(byte[] key, long count, byte[] value) {
        Span span = this.helper.buildSpan("lrem", key);
        span.setTag("count", (Number)count);
        span.setTag("value", Arrays.toString(value));
        try {
            Long l = super.lrem(key, count, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public byte[] lpop(byte[] key) {
        Span span = this.helper.buildSpan("lpop", key);
        try {
            byte[] byArray = super.lpop(key);
            return byArray;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public byte[] rpop(byte[] key) {
        Span span = this.helper.buildSpan("rpop", key);
        try {
            byte[] byArray = super.rpop(key);
            return byArray;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public byte[] rpoplpush(byte[] srckey, byte[] dstkey) {
        Span span = this.helper.buildSpan("rpoplpush");
        span.setTag("srckey", Arrays.toString(srckey));
        span.setTag("dstkey", Arrays.toString(dstkey));
        try {
            byte[] byArray = super.rpoplpush(srckey, dstkey);
            return byArray;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sadd(byte[] key, byte[] ... members) {
        Span span = this.helper.buildSpan("sadd", key);
        span.setTag("members", Arrays.toString((Object[])members));
        try {
            Long l = super.sadd(key, members);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<byte[]> smembers(byte[] key) {
        Span span = this.helper.buildSpan("smembers", key);
        try {
            Set set = super.smembers(key);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long srem(byte[] key, byte[] ... member) {
        Span span = this.helper.buildSpan("srem", key);
        span.setTag("member", Arrays.toString((Object[])member));
        try {
            Long l = super.srem(key, member);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public byte[] spop(byte[] key) {
        Span span = this.helper.buildSpan("spop", key);
        try {
            byte[] byArray = super.spop(key);
            return byArray;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<byte[]> spop(byte[] key, long count) {
        Span span = this.helper.buildSpan("spop", key);
        span.setTag("count", (Number)count);
        try {
            Set set = super.spop(key, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long smove(byte[] srckey, byte[] dstkey, byte[] member) {
        Span span = this.helper.buildSpan("smove");
        span.setTag("srckey", Arrays.toString(srckey));
        span.setTag("dstkey", Arrays.toString(dstkey));
        span.setTag("member", Arrays.toString(member));
        try {
            Long l = super.smove(srckey, dstkey, member);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long scard(byte[] key) {
        Span span = this.helper.buildSpan("scard", key);
        try {
            Long l = super.scard(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean sismember(byte[] key, byte[] member) {
        Span span = this.helper.buildSpan("sismember", key);
        span.setTag("member", Arrays.toString(member));
        try {
            Boolean bl = super.sismember(key, member);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<byte[]> sinter(byte[] ... keys) {
        Span span = this.helper.buildSpan("sinter");
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        try {
            Set set = super.sinter(keys);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sinterstore(byte[] dstkey, byte[] ... keys) {
        Span span = this.helper.buildSpan("sinterstore");
        span.setTag("dstkey", Arrays.toString(dstkey));
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        try {
            Long l = super.sinterstore(dstkey, keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<byte[]> sunion(byte[] ... keys) {
        Span span = this.helper.buildSpan("sunion");
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        try {
            Set set = super.sunion(keys);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sunionstore(byte[] dstkey, byte[] ... keys) {
        Span span = this.helper.buildSpan("sunionstore");
        span.setTag("dstkey", Arrays.toString(dstkey));
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        try {
            Long l = super.sunionstore(dstkey, keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<byte[]> sdiff(byte[] ... keys) {
        Span span = this.helper.buildSpan("sdiff");
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        try {
            Set set = super.sdiff(keys);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sdiffstore(byte[] dstkey, byte[] ... keys) {
        Span span = this.helper.buildSpan("sdiffstore");
        span.setTag("dstkey", Arrays.toString(dstkey));
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        try {
            Long l = super.sdiffstore(dstkey, keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public byte[] srandmember(byte[] key) {
        Span span = this.helper.buildSpan("srandmember", key);
        try {
            byte[] byArray = super.srandmember(key);
            return byArray;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<byte[]> srandmember(byte[] key, int count) {
        Span span = this.helper.buildSpan("srandmember", key);
        span.setTag("count", (Number)count);
        try {
            List list = super.srandmember(key, count);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zadd(byte[] key, double score, byte[] member) {
        Span span = this.helper.buildSpan("zadd", key);
        span.setTag("member", Arrays.toString(member));
        span.setTag("score", (Number)score);
        try {
            Long l = super.zadd(key, score, member);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zadd(byte[] key, double score, byte[] member, ZAddParams params) {
        Span span = this.helper.buildSpan("zadd", key);
        span.setTag("member", Arrays.toString(member));
        span.setTag("score", (Number)score);
        span.setTag("params", TracingHelper.toString((byte[][])params.getByteParams()));
        try {
            Long l = super.zadd(key, score, member, params);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        Span span = this.helper.buildSpan("zadd", key);
        span.setTag("scoreMembers", TracingHelper.toStringMap2(scoreMembers));
        try {
            Long l = super.zadd(key, scoreMembers);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params) {
        Span span = this.helper.buildSpan("zadd", key);
        span.setTag("scoreMembers", TracingHelper.toStringMap2(scoreMembers));
        span.setTag("params", TracingHelper.toString((byte[][])params.getByteParams()));
        try {
            Long l = super.zadd(key, scoreMembers, params);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<byte[]> zrange(byte[] key, long start, long end) {
        Span span = this.helper.buildSpan("zrange", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            Set set = super.zrange(key, start, end);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zrem(byte[] key, byte[] ... members) {
        Span span = this.helper.buildSpan("zrem", key);
        span.setTag("members", Arrays.toString((Object[])members));
        try {
            Long l = super.zrem(key, members);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Double zincrby(byte[] key, double score, byte[] member) {
        Span span = this.helper.buildSpan("zincrby", key);
        span.setTag("member", Arrays.toString(member));
        span.setTag("score", (Number)score);
        try {
            Double d = super.zincrby(key, score, member);
            return d;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Double zincrby(byte[] key, double score, byte[] member, ZIncrByParams params) {
        Span span = this.helper.buildSpan("zincrby", key);
        span.setTag("member", Arrays.toString(member));
        span.setTag("score", (Number)score);
        span.setTag("params", TracingHelper.toString((byte[][])params.getByteParams()));
        try {
            Double d = super.zincrby(key, score, member, params);
            return d;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zrank(byte[] key, byte[] member) {
        Span span = this.helper.buildSpan("zrank", key);
        span.setTag("member", Arrays.toString(member));
        try {
            Long l = super.zrank(key, member);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zrevrank(byte[] key, byte[] member) {
        Span span = this.helper.buildSpan("zrevrank", key);
        span.setTag("member", Arrays.toString(member));
        try {
            Long l = super.zrevrank(key, member);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<byte[]> zrevrange(byte[] key, long start, long end) {
        Span span = this.helper.buildSpan("zrevrange", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            Set set = super.zrevrange(key, start, end);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<Tuple> zrangeWithScores(byte[] key, long start, long end) {
        Span span = this.helper.buildSpan("zrangeWithScores", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            Set set = super.zrangeWithScores(key, start, end);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<Tuple> zrevrangeWithScores(byte[] key, long start, long end) {
        Span span = this.helper.buildSpan("zrevrangeWithScores", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            Set set = super.zrevrangeWithScores(key, start, end);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zcard(byte[] key) {
        Span span = this.helper.buildSpan("zcard", key);
        try {
            Long l = super.zcard(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Double zscore(byte[] key, byte[] member) {
        Span span = this.helper.buildSpan("zscore", key);
        span.setTag("member", Arrays.toString(member));
        try {
            Double d = super.zscore(key, member);
            return d;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long pexpireAt(String key, long millisecondsTimestamp) {
        Span span = this.helper.buildSpan("pexpireAt", (Object)key);
        span.setTag("millisecondsTimestamp", (Number)millisecondsTimestamp);
        try {
            Long l = super.pexpireAt(key, millisecondsTimestamp);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long pttl(String key) {
        Span span = this.helper.buildSpan("pttl", (Object)key);
        try {
            Long l = super.pttl(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String psetex(String key, long milliseconds, String value) {
        Span span = this.helper.buildSpan("psetex", (Object)key);
        span.setTag("value", value);
        span.setTag("milliseconds", (Number)milliseconds);
        try {
            String string = super.psetex(key, milliseconds, value);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String set(String key, String value, String nxxx) {
        Span span = this.helper.buildSpan("set", (Object)key);
        span.setTag("value", value);
        span.setTag("nxxx", nxxx);
        try {
            String string = super.set(key, value, nxxx);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, int cursor) {
        Span span = this.helper.buildSpan("hscan", (Object)key);
        span.setTag("cursor", (Number)cursor);
        try {
            ScanResult scanResult = super.hscan(key, cursor);
            return scanResult;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScanResult<String> sscan(String key, int cursor) {
        Span span = this.helper.buildSpan("sscan", (Object)key);
        span.setTag("cursor", (Number)cursor);
        try {
            ScanResult scanResult = super.sscan(key, cursor);
            return scanResult;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScanResult<Tuple> zscan(String key, int cursor) {
        Span span = this.helper.buildSpan("zscan", (Object)key);
        span.setTag("cursor", (Number)cursor);
        try {
            ScanResult scanResult = super.zscan(key, cursor);
            return scanResult;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScanResult<String> scan(String cursor, ScanParams params) {
        Span span = this.helper.buildSpan("scan");
        span.setTag("cursor", cursor);
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        try {
            ScanResult scanResult = super.scan(cursor, params);
            return scanResult;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        Span span = this.helper.buildSpan("hscan", (Object)key);
        span.setTag("cursor", cursor);
        try {
            ScanResult scanResult = super.hscan(key, cursor);
            return scanResult;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor, ScanParams params) {
        Span span = this.helper.buildSpan("hscan", (Object)key);
        span.setTag("cursor", cursor);
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        try {
            ScanResult scanResult = super.hscan(key, cursor, params);
            return scanResult;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScanResult<String> sscan(String key, String cursor) {
        Span span = this.helper.buildSpan("sscan", (Object)key);
        span.setTag("cursor", cursor);
        try {
            ScanResult scanResult = super.sscan(key, cursor);
            return scanResult;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScanResult<String> sscan(String key, String cursor, ScanParams params) {
        Span span = this.helper.buildSpan("sscan", (Object)key);
        span.setTag("cursor", cursor);
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        try {
            ScanResult scanResult = super.sscan(key, cursor, params);
            return scanResult;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScanResult<Tuple> zscan(String key, String cursor) {
        Span span = this.helper.buildSpan("zscan", (Object)key);
        span.setTag("cursor", cursor);
        try {
            ScanResult scanResult = super.zscan(key, cursor);
            return scanResult;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScanResult<Tuple> zscan(String key, String cursor, ScanParams params) {
        Span span = this.helper.buildSpan("zscan", (Object)key);
        span.setTag("cursor", cursor);
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        try {
            ScanResult scanResult = super.zscan(key, cursor, params);
            return scanResult;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public void close() throws IOException {
        super.close();
    }

    public Map<String, JedisPool> getClusterNodes() {
        Span span = this.helper.buildSpan("getClusterNodes");
        try {
            Map map = super.getClusterNodes();
            return map;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<byte[]> sort(byte[] key) {
        Span span = this.helper.buildSpan("sort", key);
        try {
            List list = super.sort(key);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<byte[]> sort(byte[] key, SortingParams sortingParameters) {
        Span span = this.helper.buildSpan("sort", key);
        span.setTag("sortingParameters", TracingHelper.toString((Collection)sortingParameters.getParams()));
        try {
            List list = super.sort(key, sortingParameters);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<byte[]> blpop(int timeout, byte[] ... keys) {
        Span span = this.helper.buildSpan("blpop");
        span.setTag("timeout", (Number)timeout);
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        try {
            List list = super.blpop(timeout, keys);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        Span span = this.helper.buildSpan("sort", key);
        span.setTag("sortingParameters", TracingHelper.toString((Collection)sortingParameters.getParams()));
        span.setTag("dstkey", Arrays.toString(dstkey));
        try {
            Long l = super.sort(key, sortingParameters, dstkey);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sort(byte[] key, byte[] dstkey) {
        Span span = this.helper.buildSpan("sort", key);
        span.setTag("dstkey", Arrays.toString(dstkey));
        try {
            Long l = super.sort(key, dstkey);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<byte[]> brpop(int timeout, byte[] ... keys) {
        Span span = this.helper.buildSpan("brpop");
        span.setTag("timeout", (Number)timeout);
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        try {
            List list = super.brpop(timeout, keys);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String auth(String password) {
        Span span = this.helper.buildSpan("auth");
        try {
            String string = super.auth(password);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zcount(byte[] key, double min, double max) {
        Span span = this.helper.buildSpan("zcount", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        try {
            Long l = super.zcount(key, min, max);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zcount(byte[] key, byte[] min, byte[] max) {
        Span span = this.helper.buildSpan("zcount", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        try {
            Long l = super.zcount(key, min, max);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<byte[]> zrangeByScore(byte[] key, double min, double max) {
        Span span = this.helper.buildSpan("zrangeByScore", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        try {
            Set set = super.zrangeByScore(key, min, max);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        Span span = this.helper.buildSpan("zrangeByScore", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        try {
            Set set = super.zrangeByScore(key, min, max);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<byte[]> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        Span span = this.helper.buildSpan("zrangeByScore", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Set set = super.zrangeByScore(key, min, max, offset, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        Span span = this.helper.buildSpan("zrangeByScore", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Set set = super.zrangeByScore(key, min, max, offset, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max) {
        Span span = this.helper.buildSpan("zrangeByScoreWithScores", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        try {
            Set set = super.zrangeByScoreWithScores(key, min, max);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        Span span = this.helper.buildSpan("zrangeByScoreWithScores", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        try {
            Set set = super.zrangeByScoreWithScores(key, min, max);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        Span span = this.helper.buildSpan("zrangeByScoreWithScores", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Set set = super.zrangeByScoreWithScores(key, min, max, offset, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        Span span = this.helper.buildSpan("zrangeByScoreWithScores", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Set set = super.zrangeByScoreWithScores(key, min, max, offset, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min) {
        Span span = this.helper.buildSpan("zrevrangeByScore", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        try {
            Set set = super.zrevrangeByScore(key, max, min);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        Span span = this.helper.buildSpan("zrevrangeByScore", key);
        span.setTag("max", Arrays.toString(max));
        span.setTag("min", Arrays.toString(min));
        try {
            Set set = super.zrevrangeByScore(key, max, min);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        Span span = this.helper.buildSpan("zrevrangeByScore", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Set set = super.zrevrangeByScore(key, max, min, offset, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        Span span = this.helper.buildSpan("zrevrangeByScore", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Set set = super.zrevrangeByScore(key, max, min, offset, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        Span span = this.helper.buildSpan("zrevrangeByScoreWithScores", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        try {
            Set set = super.zrevrangeByScoreWithScores(key, max, min);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        Span span = this.helper.buildSpan("zrevrangeByScoreWithScores", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Set set = super.zrevrangeByScoreWithScores(key, max, min, offset, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        Span span = this.helper.buildSpan("zrevrangeByScoreWithScores", key);
        span.setTag("max", Arrays.toString(max));
        span.setTag("min", Arrays.toString(min));
        try {
            Set set = super.zrevrangeByScoreWithScores(key, max, min);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        Span span = this.helper.buildSpan("zrevrangeByScoreWithScores", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Set set = super.zrevrangeByScoreWithScores(key, max, min, offset, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zremrangeByRank(byte[] key, long start, long end) {
        Span span = this.helper.buildSpan("zremrangeByRank", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            Long l = super.zremrangeByRank(key, start, end);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zremrangeByScore(byte[] key, double start, double end) {
        Span span = this.helper.buildSpan("zremrangeByScore", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            Long l = super.zremrangeByScore(key, start, end);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        Span span = this.helper.buildSpan("zremrangeByScore", key);
        span.setTag("start", Arrays.toString(start));
        span.setTag("end", Arrays.toString(end));
        try {
            Long l = super.zremrangeByScore(key, start, end);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zunionstore(byte[] dstkey, byte[] ... sets) {
        Span span = this.helper.buildSpan("zunionstore");
        span.setTag("dstkey", Arrays.toString(dstkey));
        span.setTag("sets", TracingHelper.toString((byte[][])sets));
        try {
            Long l = super.zunionstore(dstkey, sets);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        Span span = this.helper.buildSpan("zunionstore");
        span.setTag("dstkey", Arrays.toString(dstkey));
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        span.setTag("sets", TracingHelper.toString((byte[][])sets));
        try {
            Long l = super.zunionstore(dstkey, params, sets);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zinterstore(byte[] dstkey, byte[] ... sets) {
        Span span = this.helper.buildSpan("zinterstore");
        span.setTag("dstkey", Arrays.toString(dstkey));
        span.setTag("sets", TracingHelper.toString((byte[][])sets));
        try {
            Long l = super.zinterstore(dstkey, sets);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        Span span = this.helper.buildSpan("zinterstore");
        span.setTag("dstkey", Arrays.toString(dstkey));
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        span.setTag("sets", TracingHelper.toString((byte[][])sets));
        try {
            Long l = super.zinterstore(dstkey, params, sets);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zlexcount(byte[] key, byte[] min, byte[] max) {
        Span span = this.helper.buildSpan("zlexcount");
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        try {
            Long l = super.zlexcount(key, min, max);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max) {
        Span span = this.helper.buildSpan("zrangeByLex", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        try {
            Set set = super.zrangeByLex(key, min, max);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        Span span = this.helper.buildSpan("zrangeByLex", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Set set = super.zrangeByLex(key, min, max, offset, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min) {
        Span span = this.helper.buildSpan("zrevrangeByLex", key);
        span.setTag("max", Arrays.toString(max));
        span.setTag("min", Arrays.toString(min));
        try {
            Set set = super.zrevrangeByLex(key, max, min);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count) {
        Span span = this.helper.buildSpan("zrevrangeByLex", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Set set = super.zrevrangeByLex(key, max, min, offset, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        Span span = this.helper.buildSpan("zremrangeByLex", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        try {
            Long l = super.zremrangeByLex(key, min, max);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String save() {
        Span span = this.helper.buildSpan("save");
        try {
            String string = super.save();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String bgsave() {
        Span span = this.helper.buildSpan("bgsave");
        try {
            String string = super.bgsave();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String bgrewriteaof() {
        Span span = this.helper.buildSpan("bgrewriteaof");
        try {
            String string = super.bgrewriteaof();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long lastsave() {
        Span span = this.helper.buildSpan("lastsave");
        try {
            Long l = super.lastsave();
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String shutdown() {
        Span span = this.helper.buildSpan("shutdown");
        try {
            String string = super.shutdown();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String info() {
        Span span = this.helper.buildSpan("info");
        try {
            String string = super.info();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String info(String section) {
        Span span = this.helper.buildSpan("info");
        span.setTag("section", section);
        try {
            String string = super.info(section);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String slaveof(String host, int port) {
        Span span = this.helper.buildSpan("slaveof");
        span.setTag("host", host);
        span.setTag("port", (Number)port);
        try {
            String string = super.slaveof(host, port);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String slaveofNoOne() {
        Span span = this.helper.buildSpan("slaveofNoOne");
        try {
            String string = super.slaveofNoOne();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String configResetStat() {
        Span span = this.helper.buildSpan("configResetStat");
        try {
            String string = super.configResetStat();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long strlen(byte[] key) {
        Span span = this.helper.buildSpan("strlen", key);
        try {
            Long l = super.strlen(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long lpushx(byte[] key, byte[] ... string) {
        Span span = this.helper.buildSpan("lpushx", key);
        span.setTag("string", TracingHelper.toString((byte[][])string));
        try {
            Long l = super.lpushx(key, string);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long persist(byte[] key) {
        Span span = this.helper.buildSpan("persist", key);
        try {
            Long l = super.persist(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long rpushx(byte[] key, byte[] ... string) {
        Span span = this.helper.buildSpan("rpushx", key);
        span.setTag("string", TracingHelper.toString((byte[][])string));
        try {
            Long l = super.rpushx(key, string);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public byte[] echo(byte[] string) {
        Span span = this.helper.buildSpan("echo");
        span.setTag("string", Arrays.toString(string));
        try {
            byte[] byArray = super.echo(string);
            return byArray;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        Span span = this.helper.buildSpan("linsert", key);
        span.setTag("where", where.name());
        span.setTag("pivot", Arrays.toString(pivot));
        span.setTag("value", Arrays.toString(value));
        try {
            Long l = super.linsert(key, where, pivot, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String debug(DebugParams params) {
        Span span = this.helper.buildSpan("debug");
        span.setTag("params", Arrays.toString(params.getCommand()));
        try {
            String string = super.debug(params);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public byte[] brpoplpush(byte[] source, byte[] destination, int timeout) {
        Span span = this.helper.buildSpan("brpoplpush");
        span.setTag("timeout", (Number)timeout);
        span.setTag("source", Arrays.toString(source));
        span.setTag("destination", Arrays.toString(destination));
        try {
            byte[] byArray = super.brpoplpush(source, destination, timeout);
            return byArray;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean setbit(byte[] key, long offset, boolean value) {
        Span span = this.helper.buildSpan("setbit", key);
        span.setTag("offset", (Number)offset);
        span.setTag("value", value);
        try {
            Boolean bl = super.setbit(key, offset, value);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean setbit(byte[] key, long offset, byte[] value) {
        Span span = this.helper.buildSpan("setbit", key);
        span.setTag("offset", (Number)offset);
        span.setTag("value", Arrays.toString(value));
        try {
            Boolean bl = super.setbit(key, offset, value);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean getbit(byte[] key, long offset) {
        Span span = this.helper.buildSpan("getbit", key);
        span.setTag("offset", (Number)offset);
        try {
            Boolean bl = super.getbit(key, offset);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long setrange(byte[] key, long offset, byte[] value) {
        Span span = this.helper.buildSpan("setrange", key);
        span.setTag("offset", (Number)offset);
        span.setTag("value", Arrays.toString(value));
        try {
            Long l = super.setrange(key, offset, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public byte[] getrange(byte[] key, long startOffset, long endOffset) {
        Span span = this.helper.buildSpan("getrange", key);
        span.setTag("startOffset", (Number)startOffset);
        span.setTag("endOffset", (Number)endOffset);
        try {
            byte[] byArray = super.getrange(key, startOffset, endOffset);
            return byArray;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long publish(byte[] channel, byte[] message) {
        Span span = this.helper.buildSpan("publish");
        span.setTag("channel", Arrays.toString(channel));
        span.setTag("message", Arrays.toString(message));
        try {
            Long l = super.publish(channel, message);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public void subscribe(BinaryJedisPubSub jedisPubSub, byte[] ... channels) {
        Span span = this.helper.buildSpan("subscribe");
        span.setTag("channels", Arrays.toString((Object[])channels));
        try {
            super.subscribe(jedisPubSub, channels);
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public void psubscribe(BinaryJedisPubSub jedisPubSub, byte[] ... patterns) {
        Span span = this.helper.buildSpan("psubscribe");
        span.setTag("patterns", Arrays.toString((Object[])patterns));
        try {
            super.psubscribe(jedisPubSub, patterns);
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long getDB() {
        Span span = this.helper.buildSpan("getDB");
        try {
            Long l = super.getDB();
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Object eval(byte[] script, List<byte[]> keys, List<byte[]> args) {
        Span span = this.helper.buildSpan("eval");
        span.setTag("script", Arrays.toString(script));
        span.setTag("keys", TracingHelper.toString(keys));
        span.setTag("args", TracingHelper.toString(args));
        try {
            Object object = super.eval(script, keys, args);
            return object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Object eval(byte[] script, byte[] key) {
        Span span = this.helper.buildSpan("eval", key);
        span.setTag("script", Arrays.toString(script));
        try {
            Object object = super.eval(script, key);
            return object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Object evalsha(byte[] script, byte[] key) {
        Span span = this.helper.buildSpan("evalsha", key);
        span.setTag("script", Arrays.toString(script));
        try {
            Object object = super.evalsha(script, key);
            return object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Object eval(byte[] script, byte[] keyCount, byte[] ... params) {
        Span span = this.helper.buildSpan("eval");
        span.setTag("script", Arrays.toString(script));
        span.setTag("keyCount", Arrays.toString(keyCount));
        span.setTag("params", TracingHelper.toString((byte[][])params));
        try {
            Object object = super.eval(script, keyCount, params);
            return object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Object eval(byte[] script, int keyCount, byte[] ... params) {
        Span span = this.helper.buildSpan("eval");
        span.setTag("script", Arrays.toString(script));
        span.setTag("keyCount", (Number)keyCount);
        span.setTag("params", TracingHelper.toString((byte[][])params));
        try {
            Object object = super.eval(script, keyCount, params);
            return object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Object evalsha(byte[] sha1, List<byte[]> keys, List<byte[]> args) {
        Span span = this.helper.buildSpan("evalsha");
        span.setTag("sha1", Arrays.toString(sha1));
        span.setTag("keys", TracingHelper.toString(keys));
        span.setTag("args", TracingHelper.toString(args));
        try {
            Object object = super.evalsha(sha1, keys, args);
            return object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Object evalsha(byte[] sha1, int keyCount, byte[] ... params) {
        Span span = this.helper.buildSpan("evalsha");
        span.setTag("params", TracingHelper.toString((byte[][])params));
        span.setTag("sha1", Arrays.toString(sha1));
        span.setTag("keyCount", (Number)keyCount);
        try {
            Object object = super.evalsha(sha1, keyCount, params);
            return object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<Long> scriptExists(byte[] key, byte[][] sha1) {
        Span span = this.helper.buildSpan("scriptExists", key);
        span.setTag("sha1", TracingHelper.toString((byte[][])sha1));
        try {
            List list = super.scriptExists(key, sha1);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public byte[] scriptLoad(byte[] script, byte[] key) {
        Span span = this.helper.buildSpan("scriptLoad", key);
        span.setTag("script", Arrays.toString(script));
        try {
            byte[] byArray = super.scriptLoad(script, key);
            return byArray;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String scriptFlush(byte[] key) {
        Span span = this.helper.buildSpan("scriptFlush", key);
        try {
            String string = super.scriptFlush(key);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String scriptKill(byte[] key) {
        Span span = this.helper.buildSpan("scriptKill", key);
        try {
            String string = super.scriptKill(key);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long bitcount(byte[] key) {
        Span span = this.helper.buildSpan("bitcount", key);
        try {
            Long l = super.bitcount(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long bitcount(byte[] key, long start, long end) {
        Span span = this.helper.buildSpan("bitcount", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            Long l = super.bitcount(key, start, end);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        Span span = this.helper.buildSpan("bitop");
        span.setTag("destKey", Arrays.toString(destKey));
        span.setTag("srcKeys", TracingHelper.toString((byte[][])srcKeys));
        try {
            Long l = super.bitop(op, destKey, srcKeys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long pexpire(byte[] key, long milliseconds) {
        Span span = this.helper.buildSpan("pexpire", key);
        span.setTag("milliseconds", (Number)milliseconds);
        try {
            Long l = super.pexpire(key, milliseconds);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long pexpireAt(byte[] key, long millisecondsTimestamp) {
        Span span = this.helper.buildSpan("pexpireAt", key);
        span.setTag("millisecondsTimestamp", (Number)millisecondsTimestamp);
        try {
            Long l = super.pexpireAt(key, millisecondsTimestamp);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long waitReplicas(int replicas, long timeout) {
        Span span = this.helper.buildSpan("waitReplicas");
        span.setTag("replicas", (Number)replicas);
        span.setTag("timeout", (Number)timeout);
        try {
            Long l = super.waitReplicas(replicas, timeout);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long pfadd(byte[] key, byte[] ... elements) {
        Span span = this.helper.buildSpan("pfadd", key);
        span.setTag("elements", TracingHelper.toString((byte[][])elements));
        try {
            Long l = super.pfadd(key, elements);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public long pfcount(byte[] key) {
        Span span = this.helper.buildSpan("pfcount", key);
        try {
            long l = super.pfcount(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String pfmerge(byte[] destkey, byte[] ... sourcekeys) {
        Span span = this.helper.buildSpan("pfmerge");
        span.setTag("destkey", Arrays.toString(destkey));
        span.setTag("sourcekeys", TracingHelper.toString((byte[][])sourcekeys));
        try {
            String string = super.pfmerge(destkey, sourcekeys);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long pfcount(byte[] ... keys) {
        Span span = this.helper.buildSpan("pfcount");
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        try {
            Long l = super.pfcount(keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScanResult<byte[]> scan(byte[] cursor, ScanParams params) {
        Span span = this.helper.buildSpan("scan");
        span.setTag("cursor", Arrays.toString(cursor));
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        try {
            ScanResult scanResult = super.scan(cursor, params);
            return scanResult;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor) {
        Span span = this.helper.buildSpan("hscan", key);
        span.setTag("cursor", Arrays.toString(cursor));
        try {
            ScanResult scanResult = super.hscan(key, cursor);
            return scanResult;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor, ScanParams params) {
        Span span = this.helper.buildSpan("hscan", key);
        span.setTag("cursor", Arrays.toString(cursor));
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        try {
            ScanResult scanResult = super.hscan(key, cursor, params);
            return scanResult;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor) {
        Span span = this.helper.buildSpan("sscan", key);
        span.setTag("cursor", Arrays.toString(cursor));
        try {
            ScanResult scanResult = super.sscan(key, cursor);
            return scanResult;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor, ScanParams params) {
        Span span = this.helper.buildSpan("sscan", key);
        span.setTag("cursor", Arrays.toString(cursor));
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        try {
            ScanResult scanResult = super.sscan(key, cursor, params);
            return scanResult;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor) {
        Span span = this.helper.buildSpan("zscan", key);
        span.setTag("cursor", Arrays.toString(cursor));
        try {
            ScanResult scanResult = super.zscan(key, cursor);
            return scanResult;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor, ScanParams params) {
        Span span = this.helper.buildSpan("zscan", key);
        span.setTag("cursor", Arrays.toString(cursor));
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        try {
            ScanResult scanResult = super.zscan(key, cursor, params);
            return scanResult;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        Span span = this.helper.buildSpan("geoadd", key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("member", Arrays.toString(member));
        try {
            Long l = super.geoadd(key, longitude, latitude, member);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        Span span = this.helper.buildSpan("geoadd", key);
        span.setTag("memberCoordinateMap", TracingHelper.toStringMap2(memberCoordinateMap));
        try {
            Long l = super.geoadd(key, memberCoordinateMap);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Double geodist(byte[] key, byte[] member1, byte[] member2) {
        Span span = this.helper.buildSpan("geodist", key);
        span.setTag("member1", Arrays.toString(member1));
        span.setTag("member2", Arrays.toString(member2));
        try {
            Double d = super.geodist(key, member1, member2);
            return d;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Double geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit) {
        Span span = this.helper.buildSpan("geodist", key);
        span.setTag("member1", Arrays.toString(member1));
        span.setTag("member2", Arrays.toString(member2));
        span.setTag("unit", unit.name());
        try {
            Double d = super.geodist(key, member1, member2, unit);
            return d;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<byte[]> geohash(byte[] key, byte[] ... members) {
        Span span = this.helper.buildSpan("geohash", key);
        span.setTag("members", Arrays.toString((Object[])members));
        try {
            List list = super.geohash(key, members);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<GeoCoordinate> geopos(byte[] key, byte[] ... members) {
        Span span = this.helper.buildSpan("geopos", key);
        span.setTag("members", Arrays.toString((Object[])members));
        try {
            List list = super.geopos(key, members);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        Span span = this.helper.buildSpan("georadius", key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        try {
            List list = super.georadius(key, longitude, latitude, radius, unit);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        Span span = this.helper.buildSpan("georadius", key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        span.setTag("param", TracingHelper.toString((byte[][])param.getByteParams()));
        try {
            List list = super.georadius(key, longitude, latitude, radius, unit, param);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit) {
        Span span = this.helper.buildSpan("georadiusByMember", key);
        span.setTag("member", Arrays.toString(member));
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        try {
            List list = super.georadiusByMember(key, member, radius, unit);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        Span span = this.helper.buildSpan("georadiusByMember", key);
        span.setTag("member", Arrays.toString(member));
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        span.setTag("param", TracingHelper.toString((byte[][])param.getByteParams()));
        try {
            List list = super.georadiusByMember(key, member, radius, unit, param);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<byte[]> bitfield(byte[] key, byte[] ... arguments) {
        Span span = this.helper.buildSpan("bitfield");
        span.setTag("arguments", TracingHelper.toString((byte[][])arguments));
        try {
            List list = super.bitfield(key, arguments);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long pfadd(String key, String ... elements) {
        Span span = this.helper.buildSpan("pfadd");
        span.setTag("elements", Arrays.toString(elements));
        try {
            Long l = super.pfadd(key, elements);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public long pfcount(String key) {
        Span span = this.helper.buildSpan("pfcount", (Object)key);
        try {
            long l = super.pfcount(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public long pfcount(String ... keys) {
        Span span = this.helper.buildSpan("pfcount", (Object[])keys);
        try {
            long l = super.pfcount(keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String pfmerge(String destkey, String ... sourcekeys) {
        Span span = this.helper.buildSpan("pfmerge");
        span.setTag("destkey", destkey);
        span.setTag("sourcekeys", Arrays.toString(sourcekeys));
        try {
            String string = super.pfmerge(destkey, sourcekeys);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<String> blpop(int timeout, String key) {
        Span span = this.helper.buildSpan("blpop");
        span.setTag("timeout", (Number)timeout);
        try {
            List list = super.blpop(timeout, key);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<String> brpop(int timeout, String key) {
        Span span = this.helper.buildSpan("brpop");
        span.setTag("timeout", (Number)timeout);
        try {
            List list = super.brpop(timeout, key);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long geoadd(String key, double longitude, double latitude, String member) {
        Span span = this.helper.buildSpan("geoadd");
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("member", member);
        try {
            Long l = super.geoadd(key, longitude, latitude, member);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        Span span = this.helper.buildSpan("geoadd");
        span.setTag("memberCoordinateMap", TracingHelper.toString(memberCoordinateMap));
        try {
            Long l = super.geoadd(key, memberCoordinateMap);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Double geodist(String key, String member1, String member2) {
        Span span = this.helper.buildSpan("geodist", (Object)key);
        span.setTag("member1", member1);
        span.setTag("member2", member2);
        try {
            Double d = super.geodist(key, member1, member2);
            return d;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Double geodist(String key, String member1, String member2, GeoUnit unit) {
        Span span = this.helper.buildSpan("geodist", (Object)key);
        span.setTag("member1", member1);
        span.setTag("member2", member2);
        span.setTag("unit", unit.name());
        try {
            Double d = super.geodist(key, member1, member2, unit);
            return d;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<String> geohash(String key, String ... members) {
        Span span = this.helper.buildSpan("geohash", (Object)key);
        span.setTag("members", Arrays.toString(members));
        try {
            List list = super.geohash(key, members);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<GeoCoordinate> geopos(String key, String ... members) {
        Span span = this.helper.buildSpan("geopos", (Object)key);
        span.setTag("members", Arrays.toString(members));
        try {
            List list = super.geopos(key, members);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        Span span = this.helper.buildSpan("georadius", (Object)key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        try {
            List list = super.georadius(key, longitude, latitude, radius, unit);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        Span span = this.helper.buildSpan("georadius", (Object)key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        span.setTag("param", TracingHelper.toString((byte[][])param.getByteParams()));
        try {
            List list = super.georadius(key, longitude, latitude, radius, unit, param);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit) {
        Span span = this.helper.buildSpan("georadiusByMember", (Object)key);
        span.setTag("member", member);
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        try {
            List list = super.georadiusByMember(key, member, radius, unit);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        Span span = this.helper.buildSpan("georadiusByMember", (Object)key);
        span.setTag("member", member);
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        span.setTag("param", TracingHelper.toString((byte[][])param.getByteParams()));
        try {
            List list = super.georadiusByMember(key, member, radius, unit, param);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<Long> bitfield(String key, String ... arguments) {
        Span span = this.helper.buildSpan("bitfield", (Object)key);
        span.setTag("arguments", Arrays.toString(arguments));
        try {
            List list = super.bitfield(key, arguments);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (BaseSpan)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }
}

