/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.jedis;

import io.opentracing.contrib.redis.common.TracingConfiguration;
import io.opentracing.contrib.redis.jedis.TracingJedis;
import java.net.URI;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class TracingJedisPool
extends JedisPool {
    private final TracingConfiguration tracingConfiguration;

    public TracingJedisPool(TracingConfiguration tracingConfiguration) {
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(TracingConfiguration tracingConfiguration, Function<String, String> spanNameProvider) {
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, TracingConfiguration tracingConfiguration) {
        super(poolConfig, host);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(String host, int port, TracingConfiguration tracingConfiguration) {
        super(host, port);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(String host, TracingConfiguration tracingConfiguration) {
        super(host);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(String host, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, TracingConfiguration tracingConfiguration) {
        super(host, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(URI uri, TracingConfiguration tracingConfiguration) {
        super(uri);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(URI uri, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, TracingConfiguration tracingConfiguration) {
        super(uri, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(URI uri, int timeout, TracingConfiguration tracingConfiguration) {
        super(uri, timeout);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(URI uri, int timeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, TracingConfiguration tracingConfiguration) {
        super(uri, timeout, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, String password, TracingConfiguration tracingConfiguration) {
        super(poolConfig, host, port, timeout, password);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, String password, boolean ssl, TracingConfiguration tracingConfiguration) {
        super(poolConfig, host, port, timeout, password, ssl);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, String password, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, TracingConfiguration tracingConfiguration) {
        super(poolConfig, host, port, timeout, password, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, TracingConfiguration tracingConfiguration) {
        super(poolConfig, host, port);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, boolean ssl, TracingConfiguration tracingConfiguration) {
        super(poolConfig, host, port, ssl);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, TracingConfiguration tracingConfiguration) {
        super(poolConfig, host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, TracingConfiguration tracingConfiguration) {
        super(poolConfig, host, port, timeout);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, boolean ssl, TracingConfiguration tracingConfiguration) {
        super(poolConfig, host, port, timeout, ssl);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, TracingConfiguration tracingConfiguration) {
        super(poolConfig, host, port, timeout, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, String password, int database, TracingConfiguration tracingConfiguration) {
        super(poolConfig, host, port, timeout, password, database);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, String password, int database, boolean ssl, TracingConfiguration tracingConfiguration) {
        super(poolConfig, host, port, timeout, password, database, ssl);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, String password, int database, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, TracingConfiguration tracingConfiguration) {
        super(poolConfig, host, port, timeout, password, database, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, String password, int database, String clientName, TracingConfiguration tracingConfiguration) {
        this(poolConfig, host, port, timeout, timeout, password, database, clientName, false, null, null, null, tracingConfiguration);
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, String password, int database, String clientName, boolean ssl, TracingConfiguration tracingConfiguration) {
        super(poolConfig, host, port, timeout, password, database, clientName, ssl);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, TracingConfiguration tracingConfiguration) {
        super(poolConfig, host, port, timeout, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int connectionTimeout, int soTimeout, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, TracingConfiguration tracingConfiguration) {
        super(poolConfig, host, port, connectionTimeout, soTimeout, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, URI uri, TracingConfiguration tracingConfiguration) {
        super(poolConfig, uri);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, URI uri, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, TracingConfiguration tracingConfiguration) {
        super(poolConfig, uri, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, URI uri, int timeout, TracingConfiguration tracingConfiguration) {
        super(poolConfig, uri, timeout);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, URI uri, int timeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, TracingConfiguration tracingConfiguration) {
        super(poolConfig, uri, timeout, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, URI uri, int connectionTimeout, int soTimeout, TracingConfiguration tracingConfiguration) {
        super(poolConfig, uri, connectionTimeout, soTimeout);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, URI uri, int connectionTimeout, int soTimeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, TracingConfiguration tracingConfiguration) {
        super(poolConfig, uri, connectionTimeout, soTimeout, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracingConfiguration = tracingConfiguration;
    }

    public Jedis getResource() {
        Jedis resource = super.getResource();
        return new TracingJedisWrapper(resource, this.tracingConfiguration);
    }

    @Deprecated
    public void returnBrokenResource(Jedis resource) {
        super.returnBrokenResource(this.unwrapResource(resource));
    }

    @Deprecated
    public void returnResource(Jedis resource) {
        super.returnResource(this.unwrapResource(resource));
    }

    @Deprecated
    public void returnResourceObject(Jedis resource) {
        super.returnResourceObject((Object)this.unwrapResource(resource));
    }

    private Jedis unwrapResource(Jedis resource) {
        return resource instanceof TracingJedisWrapper ? ((TracingJedisWrapper)resource).getWrapped() : resource;
    }

    private class TracingJedisWrapper
    extends TracingJedis {
        private final Jedis wrapped;

        public TracingJedisWrapper(Jedis jedis, TracingConfiguration tracingConfiguration) {
            super(tracingConfiguration);
            this.client = jedis.getClient();
            this.wrapped = jedis;
        }

        @Override
        public void close() {
            super.close();
            this.wrapped.close();
        }

        public Jedis getWrapped() {
            return this.wrapped;
        }
    }
}

