/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.jedis;

import io.opentracing.Tracer;
import io.opentracing.contrib.redis.common.RedisSpanNameProvider;
import io.opentracing.contrib.redis.jedis.TracingJedis;
import java.net.URI;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class TracingJedisPool
extends JedisPool {
    private final Tracer tracer;
    private final boolean traceWithActiveSpanOnly;
    private Function<String, String> spanNameProvider;

    public TracingJedisPool(Tracer tracer, boolean traceWithActiveSpanOnly) {
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(Tracer tracer, boolean traceWithActiveSpanOnly, Function<String, String> spanNameProvider) {
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = spanNameProvider;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, host);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(String host, int port, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(host, port);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(String host, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(host);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(String host, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(host, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(URI uri, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(uri);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(URI uri, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(uri, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(URI uri, int timeout, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(uri, timeout);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(URI uri, int timeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(uri, timeout, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, String password, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, host, port, timeout, password);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, String password, boolean ssl, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, host, port, timeout, password, ssl);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, String password, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, host, port, timeout, password, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, host, port);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, boolean ssl, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, host, port, ssl);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, host, port, timeout);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, boolean ssl, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, host, port, timeout, ssl);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, host, port, timeout, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, String password, int database, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, host, port, timeout, password, database);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, String password, int database, boolean ssl, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, host, port, timeout, password, database, ssl);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, String password, int database, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, host, port, timeout, password, database, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, String password, int database, String clientName, Tracer tracer, boolean traceWithActiveSpanOnly) {
        this(poolConfig, host, port, timeout, timeout, password, database, clientName, false, null, null, null, tracer, traceWithActiveSpanOnly);
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, String password, int database, String clientName, Tracer tracer, boolean traceWithActiveSpanOnly, Function<String, String> customSpanName) {
        this(poolConfig, host, port, timeout, timeout, password, database, clientName, false, null, null, null, tracer, traceWithActiveSpanOnly, customSpanName);
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, String password, int database, String clientName, boolean ssl, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, host, port, timeout, password, database, clientName, ssl);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, host, port, timeout, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int connectionTimeout, int soTimeout, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, host, port, connectionTimeout, soTimeout, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, String host, int port, int connectionTimeout, int soTimeout, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, Tracer tracer, boolean traceWithActiveSpanOnly, Function<String, String> customSpanName) {
        super(poolConfig, host, port, connectionTimeout, soTimeout, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = customSpanName;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, URI uri, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, uri);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, URI uri, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, uri, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, URI uri, int timeout, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, uri, timeout);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, URI uri, int timeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, uri, timeout, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, URI uri, int connectionTimeout, int soTimeout, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, uri, connectionTimeout, soTimeout);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
    }

    public TracingJedisPool(GenericObjectPoolConfig poolConfig, URI uri, int connectionTimeout, int soTimeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(poolConfig, uri, connectionTimeout, soTimeout, sslSocketFactory, sslParameters, hostnameVerifier);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
    }

    public Jedis getResource() {
        Jedis resource = super.getResource();
        return new TracingJedisWrapper(resource, this.tracer, this.traceWithActiveSpanOnly);
    }

    @Deprecated
    public void returnBrokenResource(Jedis resource) {
        super.returnBrokenResource(this.unwrapResource(resource));
    }

    @Deprecated
    public void returnResource(Jedis resource) {
        super.returnResource(this.unwrapResource(resource));
    }

    @Deprecated
    public void returnResourceObject(Jedis resource) {
        super.returnResourceObject((Object)this.unwrapResource(resource));
    }

    private Jedis unwrapResource(Jedis resource) {
        return resource instanceof TracingJedisWrapper ? ((TracingJedisWrapper)resource).getWrapped() : resource;
    }

    private class TracingJedisWrapper
    extends TracingJedis {
        private final Jedis wrapped;

        public TracingJedisWrapper(Jedis jedis, Tracer tracer, boolean traceWithActiveSpanOnly) {
            super(tracer, traceWithActiveSpanOnly, TracingJedisPool.this.spanNameProvider);
            this.client = jedis.getClient();
            this.wrapped = jedis;
        }

        @Override
        public void close() {
            super.close();
            this.wrapped.close();
        }

        public Jedis getWrapped() {
            return this.wrapped;
        }
    }
}

