/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.jedis;

import io.opentracing.Tracer;
import io.opentracing.contrib.redis.common.RedisSpanNameProvider;
import io.opentracing.contrib.redis.jedis.TracingJedis;
import io.opentracing.util.GlobalTracer;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisSentinelPool;

public class TracingJedisSentinelPool
extends JedisSentinelPool {
    private final Tracer tracer;
    private final boolean traceWithActiveSpanOnly;
    private Function<String, String> spanNameProvider;

    public TracingJedisSentinelPool(Tracer tracer, boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig) {
        super(masterName, sentinels, poolConfig, 2000, null, 0);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisSentinelPool(boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig) {
        this(GlobalTracer.get(), traceWithActiveSpanOnly, masterName, sentinels, poolConfig);
    }

    public TracingJedisSentinelPool(Tracer tracer, boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels) {
        super(masterName, sentinels, new GenericObjectPoolConfig(), 2000, null, 0);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisSentinelPool(boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels) {
        this(GlobalTracer.get(), traceWithActiveSpanOnly, masterName, sentinels);
    }

    public TracingJedisSentinelPool(Tracer tracer, boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, String password) {
        super(masterName, sentinels, new GenericObjectPoolConfig(), 2000, password);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisSentinelPool(boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, String password) {
        this(GlobalTracer.get(), traceWithActiveSpanOnly, masterName, sentinels, password);
    }

    public TracingJedisSentinelPool(Tracer tracer, boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password) {
        super(masterName, sentinels, poolConfig, timeout, password, 0);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisSentinelPool(boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password) {
        this(GlobalTracer.get(), traceWithActiveSpanOnly, masterName, sentinels, poolConfig, timeout, password);
    }

    public TracingJedisSentinelPool(Tracer tracer, boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout) {
        super(masterName, sentinels, poolConfig, timeout, null, 0);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisSentinelPool(boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout) {
        this(GlobalTracer.get(), traceWithActiveSpanOnly, masterName, sentinels, poolConfig, timeout);
    }

    public TracingJedisSentinelPool(Tracer tracer, boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, String password) {
        super(masterName, sentinels, poolConfig, 2000, password);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisSentinelPool(boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, String password) {
        this(GlobalTracer.get(), traceWithActiveSpanOnly, masterName, sentinels, poolConfig, password);
    }

    public TracingJedisSentinelPool(Tracer tracer, boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password, int database) {
        super(masterName, sentinels, poolConfig, timeout, timeout, password, database);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisSentinelPool(boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password, int database) {
        this(GlobalTracer.get(), traceWithActiveSpanOnly, masterName, sentinels, poolConfig, timeout, password, database);
    }

    public TracingJedisSentinelPool(Tracer tracer, boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password, int database, Function<String, String> customSpanName) {
        super(masterName, sentinels, poolConfig, timeout, timeout, password, database);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = customSpanName;
    }

    public TracingJedisSentinelPool(boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password, int database, Function<String, String> customSpanName) {
        this(GlobalTracer.get(), traceWithActiveSpanOnly, masterName, sentinels, poolConfig, timeout, password, database, customSpanName);
    }

    public TracingJedisSentinelPool(Tracer tracer, boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password, int database, String clientName) {
        super(masterName, sentinels, poolConfig, timeout, timeout, password, database, clientName);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisSentinelPool(boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password, int database, String clientName) {
        this(GlobalTracer.get(), traceWithActiveSpanOnly, masterName, sentinels, poolConfig, timeout, password, database, clientName);
    }

    public TracingJedisSentinelPool(Tracer tracer, boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, int soTimeout, String password, int database) {
        super(masterName, sentinels, poolConfig, timeout, soTimeout, password, database, null);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisSentinelPool(boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, int soTimeout, String password, int database) {
        this(GlobalTracer.get(), traceWithActiveSpanOnly, masterName, sentinels, poolConfig, timeout, soTimeout, password, database);
    }

    public TracingJedisSentinelPool(Tracer tracer, boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout, String password, int database, String clientName) {
        super(masterName, sentinels, poolConfig, connectionTimeout, soTimeout, password, database, clientName);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = RedisSpanNameProvider.OPERATION_NAME;
    }

    public TracingJedisSentinelPool(boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout, String password, int database, String clientName) {
        this(GlobalTracer.get(), traceWithActiveSpanOnly, masterName, sentinels, poolConfig, connectionTimeout, soTimeout, password, database, clientName);
    }

    public TracingJedisSentinelPool(Tracer tracer, boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout, String password, int database, String clientName, Function<String, String> customSpanName) {
        super(masterName, sentinels, poolConfig, connectionTimeout, soTimeout, password, database, clientName);
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanNameProvider = customSpanName;
    }

    public TracingJedisSentinelPool(boolean traceWithActiveSpanOnly, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout, String password, int database, String clientName, Function<String, String> customSpanName) {
        this(GlobalTracer.get(), traceWithActiveSpanOnly, masterName, sentinels, poolConfig, connectionTimeout, soTimeout, password, database, clientName, customSpanName);
    }

    public Jedis getResource() {
        Jedis resource = super.getResource();
        return new TracingJedisWrapper(resource, this.tracer, this.traceWithActiveSpanOnly);
    }

    @Deprecated
    public void returnBrokenResource(Jedis resource) {
        super.returnBrokenResource(this.unwrapResource(resource));
    }

    @Deprecated
    public void returnResource(Jedis resource) {
        super.returnResource(this.unwrapResource(resource));
    }

    private Jedis unwrapResource(Jedis resource) {
        return resource instanceof TracingJedisWrapper ? ((TracingJedisWrapper)resource).getWrapped() : resource;
    }

    private class TracingJedisWrapper
    extends TracingJedis {
        private final Jedis wrapped;

        public TracingJedisWrapper(Jedis jedis, Tracer tracer, boolean traceWithActiveSpanOnly) {
            super(tracer, traceWithActiveSpanOnly, TracingJedisSentinelPool.this.spanNameProvider);
            this.client = jedis.getClient();
            this.wrapped = jedis;
        }

        @Override
        public void close() {
            super.close();
            this.wrapped.close();
        }

        public Jedis getWrapped() {
            return this.wrapped;
        }
    }
}

