/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.jedis;

import io.opentracing.contrib.redis.common.TracingConfiguration;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.TracingJedisWrapper;

public class TracingJedisSentinelPool
extends JedisSentinelPool {
    private final TracingConfiguration tracingConfiguration;

    public TracingJedisSentinelPool(TracingConfiguration tracingConfiguration, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig) {
        super(masterName, sentinels, poolConfig, 2000, null, 0);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisSentinelPool(TracingConfiguration tracingConfiguration, String masterName, Set<String> sentinels) {
        super(masterName, sentinels, new GenericObjectPoolConfig(), 2000, null, 0);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisSentinelPool(TracingConfiguration tracingConfiguration, String masterName, Set<String> sentinels, String password) {
        super(masterName, sentinels, new GenericObjectPoolConfig(), 2000, password);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisSentinelPool(TracingConfiguration tracingConfiguration, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password) {
        super(masterName, sentinels, poolConfig, timeout, password, 0);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisSentinelPool(TracingConfiguration tracingConfiguration, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout) {
        super(masterName, sentinels, poolConfig, timeout, null, 0);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisSentinelPool(TracingConfiguration tracingConfiguration, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, String password) {
        super(masterName, sentinels, poolConfig, 2000, password);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisSentinelPool(TracingConfiguration tracingConfiguration, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password, int database) {
        super(masterName, sentinels, poolConfig, timeout, timeout, password, database);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisSentinelPool(TracingConfiguration tracingConfiguration, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password, int database, Function<String, String> customSpanName) {
        super(masterName, sentinels, poolConfig, timeout, timeout, password, database);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisSentinelPool(TracingConfiguration tracingConfiguration, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password, int database, String clientName) {
        super(masterName, sentinels, poolConfig, timeout, timeout, password, database, clientName);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisSentinelPool(TracingConfiguration tracingConfiguration, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, int soTimeout, String password, int database) {
        super(masterName, sentinels, poolConfig, timeout, soTimeout, password, database, null);
        this.tracingConfiguration = tracingConfiguration;
    }

    public TracingJedisSentinelPool(TracingConfiguration tracingConfiguration, String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout, String password, int database, String clientName) {
        super(masterName, sentinels, poolConfig, connectionTimeout, soTimeout, password, database, clientName);
        this.tracingConfiguration = tracingConfiguration;
    }

    public Jedis getResource() {
        Jedis resource = super.getResource();
        return new TracingJedisWrapper(resource, this.tracingConfiguration);
    }

    @Deprecated
    public void returnBrokenResource(Jedis resource) {
        super.returnBrokenResource(this.unwrapResource(resource));
    }

    @Deprecated
    public void returnResource(Jedis resource) {
        super.returnResource(this.unwrapResource(resource));
    }

    private Jedis unwrapResource(Jedis resource) {
        return resource instanceof TracingJedisWrapper ? ((TracingJedisWrapper)resource).getWrapped() : resource;
    }
}

