/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingConfiguration;
import io.opentracing.contrib.redis.common.TracingHelper;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.Client;
import redis.clients.jedis.ClusterReset;
import redis.clients.jedis.DebugParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisMonitor;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.PipelineBlock;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.TransactionBlock;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;
import redis.clients.util.Pool;
import redis.clients.util.Slowlog;

public class TracingJedisWrapper
extends Jedis {
    private final TracingHelper helper;
    private final Jedis wrapped;

    public TracingJedisWrapper(TracingConfiguration tracingConfiguration) {
        this.wrapped = new Jedis();
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public TracingJedisWrapper(String host, TracingConfiguration tracingConfiguration) {
        this.wrapped = new Jedis(host);
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public TracingJedisWrapper(String host, int port, TracingConfiguration tracingConfiguration) {
        this.wrapped = new Jedis(host, port);
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public TracingJedisWrapper(String host, int port, boolean ssl, TracingConfiguration tracingConfiguration) {
        this.wrapped = new Jedis(host, port, ssl);
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public TracingJedisWrapper(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, TracingConfiguration tracingConfiguration) {
        this.wrapped = new Jedis(host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public TracingJedisWrapper(String host, int port, int timeout, TracingConfiguration tracingConfiguration) {
        this.wrapped = new Jedis(host, port, timeout);
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public TracingJedisWrapper(String host, int port, int timeout, boolean ssl, TracingConfiguration tracingConfiguration) {
        this.wrapped = new Jedis(host, port, timeout, ssl);
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public TracingJedisWrapper(String host, int port, int timeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, TracingConfiguration tracingConfiguration) {
        this.wrapped = new Jedis(host, port, timeout, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public TracingJedisWrapper(String host, int port, int connectionTimeout, int soTimeout, TracingConfiguration tracingConfiguration) {
        this.wrapped = new Jedis(host, port, connectionTimeout, soTimeout);
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public TracingJedisWrapper(String host, int port, int connectionTimeout, int soTimeout, boolean ssl, TracingConfiguration tracingConfiguration) {
        this.wrapped = new Jedis(host, port, connectionTimeout, soTimeout, ssl);
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public TracingJedisWrapper(String host, int port, int connectionTimeout, int soTimeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, TracingConfiguration tracingConfiguration) {
        this.wrapped = new TracingJedisWrapper(new Jedis(host, port, connectionTimeout, soTimeout, ssl, sslSocketFactory, sslParameters, hostnameVerifier), tracingConfiguration);
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public TracingJedisWrapper(JedisShardInfo shardInfo, TracingConfiguration tracingConfiguration) {
        this.wrapped = new Jedis(shardInfo);
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public TracingJedisWrapper(URI uri, TracingConfiguration tracingConfiguration) {
        this.wrapped = new Jedis(uri);
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public TracingJedisWrapper(URI uri, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, TracingConfiguration tracingConfiguration) {
        this.wrapped = new Jedis(uri, sslSocketFactory, sslParameters, hostnameVerifier);
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public TracingJedisWrapper(URI uri, int timeout, TracingConfiguration tracingConfiguration) {
        this.wrapped = new Jedis(uri, timeout);
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public TracingJedisWrapper(URI uri, int timeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, TracingConfiguration tracingConfiguration) {
        this.wrapped = new Jedis(uri, timeout, sslSocketFactory, sslParameters, hostnameVerifier);
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public TracingJedisWrapper(URI uri, int connectionTimeout, int soTimeout, TracingConfiguration tracingConfiguration) {
        this.wrapped = new Jedis(uri, connectionTimeout, soTimeout);
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public TracingJedisWrapper(URI uri, int connectionTimeout, int soTimeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, TracingConfiguration tracingConfiguration) {
        this.wrapped = new Jedis(uri, connectionTimeout, soTimeout, sslSocketFactory, sslParameters, hostnameVerifier);
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public TracingJedisWrapper(Jedis jedis, TracingConfiguration tracingConfiguration) {
        this.wrapped = jedis;
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public String ping(String message) {
        Span span = this.helper.buildSpan("ping");
        span.setTag("message", message);
        return (String)this.helper.decorate(span, () -> this.wrapped.ping(message));
    }

    public String set(String key, String value) {
        Span span = this.helper.buildSpan("set", (Object)key);
        span.setTag("value", value);
        return (String)this.helper.decorate(span, () -> this.wrapped.set(key, value));
    }

    public String set(String key, String value, String nxxx, String expx, long time) {
        Span span = this.helper.buildSpan("set", (Object)key);
        span.setTag("nxxx", nxxx);
        span.setTag("expx", expx);
        span.setTag("time", (Number)time);
        span.setTag("value", value);
        return (String)this.helper.decorate(span, () -> this.wrapped.set(key, value, nxxx, expx, time));
    }

    public String set(String key, String value, String expx, long time) {
        Span span = this.helper.buildSpan("set", (Object)key);
        span.setTag("value", value);
        span.setTag("expx", expx);
        span.setTag("time", (Number)time);
        return (String)this.helper.decorate(span, () -> this.wrapped.set(key, value, expx, time));
    }

    public String get(String key) {
        Span span = this.helper.buildSpan("get", (Object)key);
        return (String)this.helper.decorate(span, () -> this.wrapped.get(key));
    }

    public Long exists(String ... keys) {
        Span span = this.helper.buildSpan("exists", (Object[])keys);
        return (Long)this.helper.decorate(span, () -> this.wrapped.exists(keys));
    }

    public Boolean exists(String key) {
        Span span = this.helper.buildSpan("exists", (Object)key);
        return (Boolean)this.helper.decorate(span, () -> this.wrapped.exists(key));
    }

    public Long del(String ... keys) {
        Span span = this.helper.buildSpan("del", (Object[])keys);
        return (Long)this.helper.decorate(span, () -> this.wrapped.del(keys));
    }

    public Long del(String key) {
        Span span = this.helper.buildSpan("del", (Object)key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.del(key));
    }

    public Long unlink(String ... keys) {
        Span span = this.helper.buildSpan("unlink", (Object[])keys);
        return (Long)this.helper.decorate(span, () -> this.wrapped.unlink(keys));
    }

    public Long unlink(String key) {
        Span span = this.helper.buildSpan("unlink", (Object)key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.unlink(key));
    }

    public String type(String key) {
        Span span = this.helper.buildSpan("type", (Object)key);
        return (String)this.helper.decorate(span, () -> this.wrapped.type(key));
    }

    public Set<String> keys(String pattern) {
        Span span = this.helper.buildSpan("keys");
        span.setTag("pattern", TracingHelper.nullable((Object)pattern));
        return (Set)this.helper.decorate(span, () -> this.wrapped.keys(pattern));
    }

    public String randomKey() {
        Span span = this.helper.buildSpan("randomKey");
        return (String)this.helper.decorate(span, () -> this.wrapped.randomKey());
    }

    public String rename(String oldkey, String newkey) {
        Span span = this.helper.buildSpan("rename");
        span.setTag("oldKey", TracingHelper.nullable((Object)oldkey));
        span.setTag("newKey", TracingHelper.nullable((Object)newkey));
        return (String)this.helper.decorate(span, () -> this.wrapped.rename(oldkey, newkey));
    }

    public Long renamenx(String oldkey, String newkey) {
        Span span = this.helper.buildSpan("renamenx");
        span.setTag("oldKey", TracingHelper.nullable((Object)oldkey));
        span.setTag("newKey", TracingHelper.nullable((Object)newkey));
        return (Long)this.helper.decorate(span, () -> this.wrapped.renamenx(oldkey, newkey));
    }

    public Long expire(String key, int seconds) {
        Span span = this.helper.buildSpan("expire", (Object)key);
        span.setTag("seconds", (Number)seconds);
        return (Long)this.helper.decorate(span, () -> this.wrapped.expire(key, seconds));
    }

    public Long expireAt(String key, long unixTime) {
        Span span = this.helper.buildSpan("expireAt", (Object)key);
        span.setTag("unixTime", (Number)unixTime);
        return (Long)this.helper.decorate(span, () -> this.wrapped.expireAt(key, unixTime));
    }

    public Long ttl(String key) {
        Span span = this.helper.buildSpan("ttl", (Object)key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.ttl(key));
    }

    public Long touch(String ... keys) {
        Span span = this.helper.buildSpan("touch", (Object[])keys);
        return (Long)this.helper.decorate(span, () -> this.wrapped.touch(keys));
    }

    public Long touch(String key) {
        Span span = this.helper.buildSpan("touch", (Object)key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.touch(key));
    }

    public Long move(String key, int dbIndex) {
        Span span = this.helper.buildSpan("move", (Object)key);
        span.setTag("dbIndex", (Number)dbIndex);
        return (Long)this.helper.decorate(span, () -> this.wrapped.move(key, dbIndex));
    }

    public String getSet(String key, String value) {
        Span span = this.helper.buildSpan("getSet", (Object)key);
        span.setTag("value", value);
        return (String)this.helper.decorate(span, () -> this.wrapped.getSet(key, value));
    }

    public List<String> mget(String ... keys) {
        Span span = this.helper.buildSpan("mget", (Object[])keys);
        return (List)this.helper.decorate(span, () -> this.wrapped.mget(keys));
    }

    public Long setnx(String key, String value) {
        Span span = this.helper.buildSpan("setnx", (Object)key);
        span.setTag("value", value);
        return (Long)this.helper.decorate(span, () -> this.wrapped.setnx(key, value));
    }

    public String setex(String key, int seconds, String value) {
        Span span = this.helper.buildSpan("setex", (Object)key);
        span.setTag("seconds", (Number)seconds);
        span.setTag("value", value);
        return (String)this.helper.decorate(span, () -> this.wrapped.setex(key, seconds, value));
    }

    public String mset(String ... keysvalues) {
        Span span = this.helper.buildSpan("mset");
        span.setTag("keysvalues", Arrays.toString(keysvalues));
        return (String)this.helper.decorate(span, () -> this.wrapped.mset(keysvalues));
    }

    public Long msetnx(String ... keysvalues) {
        Span span = this.helper.buildSpan("msetnx");
        span.setTag("keysvalues", Arrays.toString(keysvalues));
        return (Long)this.helper.decorate(span, () -> this.wrapped.msetnx(keysvalues));
    }

    public Long decrBy(String key, long integer) {
        Span span = this.helper.buildSpan("decrBy", (Object)key);
        span.setTag("integer", (Number)integer);
        return (Long)this.helper.decorate(span, () -> this.wrapped.decrBy(key, integer));
    }

    public Long decr(String key) {
        Span span = this.helper.buildSpan("decr", (Object)key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.decr(key));
    }

    public Long incrBy(String key, long integer) {
        Span span = this.helper.buildSpan("incrBy", (Object)key);
        span.setTag("integer", (Number)integer);
        return (Long)this.helper.decorate(span, () -> this.wrapped.incrBy(key, integer));
    }

    public Double incrByFloat(String key, double value) {
        Span span = this.helper.buildSpan("incrByFloat", (Object)key);
        span.setTag("value", (Number)value);
        return (Double)this.helper.decorate(span, () -> this.wrapped.incrByFloat(key, value));
    }

    public Long incr(String key) {
        Span span = this.helper.buildSpan("incr", (Object)key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.incr(key));
    }

    public Long append(String key, String value) {
        Span span = this.helper.buildSpan("append", (Object)key);
        span.setTag("value", value);
        return (Long)this.helper.decorate(span, () -> this.wrapped.append(key, value));
    }

    public String substr(String key, int start, int end) {
        Span span = this.helper.buildSpan("substr", (Object)key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return (String)this.helper.decorate(span, () -> this.wrapped.substr(key, start, end));
    }

    public Long hset(String key, String field, String value) {
        Span span = this.helper.buildSpan("hset", (Object)key);
        span.setTag("field", field);
        span.setTag("value", value);
        return (Long)this.helper.decorate(span, () -> this.wrapped.hset(key, field, value));
    }

    public Long hset(String key, Map<String, String> hash) {
        Span span = this.helper.buildSpan("hset", (Object)key);
        span.setTag("hash", TracingHelper.toString(hash));
        return (Long)this.helper.decorate(span, () -> this.wrapped.hset(key, hash));
    }

    public String hget(String key, String field) {
        Span span = this.helper.buildSpan("hget", (Object)key);
        span.setTag("field", field);
        return (String)this.helper.decorate(span, () -> this.wrapped.hget(key, field));
    }

    public Long hsetnx(String key, String field, String value) {
        Span span = this.helper.buildSpan("hsetnx", (Object)key);
        span.setTag("field", field);
        span.setTag("value", value);
        return (Long)this.helper.decorate(span, () -> this.wrapped.hsetnx(key, field, value));
    }

    public String hmset(String key, Map<String, String> hash) {
        Span span = this.helper.buildSpan("hmset", (Object)key);
        span.setTag("hash", TracingHelper.toString(hash));
        return (String)this.helper.decorate(span, () -> this.wrapped.hmset(key, hash));
    }

    public List<String> hmget(String key, String ... fields) {
        Span span = this.helper.buildSpan("hmget", (Object)key);
        span.setTag("fields", Arrays.toString(fields));
        return (List)this.helper.decorate(span, () -> this.wrapped.hmget(key, fields));
    }

    public Long hincrBy(String key, String field, long value) {
        Span span = this.helper.buildSpan("hincrBy", (Object)key);
        span.setTag("field", field);
        span.setTag("value", (Number)value);
        return (Long)this.helper.decorate(span, () -> this.wrapped.hincrBy(key, field, value));
    }

    public Double hincrByFloat(String key, String field, double value) {
        Span span = this.helper.buildSpan("hincrByFloat", (Object)key);
        span.setTag("field", field);
        span.setTag("value", (Number)value);
        return (Double)this.helper.decorate(span, () -> this.wrapped.hincrByFloat(key, field, value));
    }

    public Boolean hexists(String key, String field) {
        Span span = this.helper.buildSpan("hexists", (Object)key);
        span.setTag("field", field);
        return (Boolean)this.helper.decorate(span, () -> this.wrapped.hexists(key, field));
    }

    public Long hdel(String key, String ... fields) {
        Span span = this.helper.buildSpan("hdel", (Object)key);
        span.setTag("fields", Arrays.toString(fields));
        return (Long)this.helper.decorate(span, () -> this.wrapped.hdel(key, fields));
    }

    public Long hlen(String key) {
        Span span = this.helper.buildSpan("hlen", (Object)key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.hlen(key));
    }

    public Set<String> hkeys(String key) {
        Span span = this.helper.buildSpan("hkeys", (Object)key);
        return (Set)this.helper.decorate(span, () -> this.wrapped.hkeys(key));
    }

    public List<String> hvals(String key) {
        Span span = this.helper.buildSpan("hvals", (Object)key);
        return (List)this.helper.decorate(span, () -> this.wrapped.hvals(key));
    }

    public Map<String, String> hgetAll(String key) {
        Span span = this.helper.buildSpan("hgetAll", (Object)key);
        return (Map)this.helper.decorate(span, () -> this.wrapped.hgetAll(key));
    }

    public Long rpush(String key, String ... strings) {
        Span span = this.helper.buildSpan("rpush", (Object)key);
        span.setTag("strings", Arrays.toString(strings));
        return (Long)this.helper.decorate(span, () -> this.wrapped.rpush(key, strings));
    }

    public Long lpush(String key, String ... strings) {
        Span span = this.helper.buildSpan("lpush", (Object)key);
        span.setTag("strings", Arrays.toString(strings));
        return (Long)this.helper.decorate(span, () -> this.wrapped.lpush(key, strings));
    }

    public Long llen(String key) {
        Span span = this.helper.buildSpan("llen", (Object)key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.llen(key));
    }

    public List<String> lrange(String key, long start, long end) {
        Span span = this.helper.buildSpan("lrange", (Object)key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return (List)this.helper.decorate(span, () -> this.wrapped.lrange(key, start, end));
    }

    public String ltrim(String key, long start, long end) {
        Span span = this.helper.buildSpan("ltrim", (Object)key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return (String)this.helper.decorate(span, () -> this.wrapped.ltrim(key, start, end));
    }

    public String lindex(String key, long index) {
        Span span = this.helper.buildSpan("lindex", (Object)key);
        span.setTag("index", (Number)index);
        return (String)this.helper.decorate(span, () -> this.wrapped.lindex(key, index));
    }

    public String lset(String key, long index, String value) {
        Span span = this.helper.buildSpan("lset", (Object)key);
        span.setTag("index", (Number)index);
        span.setTag("value", value);
        return (String)this.helper.decorate(span, () -> this.wrapped.lset(key, index, value));
    }

    public Long lrem(String key, long count, String value) {
        Span span = this.helper.buildSpan("lrem", (Object)key);
        span.setTag("count", (Number)count);
        span.setTag("value", value);
        return (Long)this.helper.decorate(span, () -> this.wrapped.lrem(key, count, value));
    }

    public String lpop(String key) {
        Span span = this.helper.buildSpan("lpop", (Object)key);
        return (String)this.helper.decorate(span, () -> this.wrapped.lpop(key));
    }

    public String rpop(String key) {
        Span span = this.helper.buildSpan("rpop", (Object)key);
        return (String)this.helper.decorate(span, () -> this.wrapped.rpop(key));
    }

    public String rpoplpush(String srckey, String dstkey) {
        Span span = this.helper.buildSpan("rpoplpush");
        span.setTag("srckey", srckey);
        span.setTag("dstkey", dstkey);
        return (String)this.helper.decorate(span, () -> this.wrapped.rpoplpush(srckey, dstkey));
    }

    public Long sadd(String key, String ... members) {
        Span span = this.helper.buildSpan("sadd", (Object)key);
        span.setTag("members", Arrays.toString(members));
        return (Long)this.helper.decorate(span, () -> this.wrapped.sadd(key, members));
    }

    public Set<String> smembers(String key) {
        Span span = this.helper.buildSpan("smembers", (Object)key);
        return (Set)this.helper.decorate(span, () -> this.wrapped.smembers(key));
    }

    public Long srem(String key, String ... members) {
        Span span = this.helper.buildSpan("srem", (Object)key);
        span.setTag("members", Arrays.toString(members));
        return (Long)this.helper.decorate(span, () -> this.wrapped.srem(key, members));
    }

    public String spop(String key) {
        Span span = this.helper.buildSpan("spop", (Object)key);
        return (String)this.helper.decorate(span, () -> this.wrapped.spop(key));
    }

    public Set<String> spop(String key, long count) {
        Span span = this.helper.buildSpan("spop", (Object)key);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.spop(key, count));
    }

    public Long smove(String srckey, String dstkey, String member) {
        Span span = this.helper.buildSpan("smove");
        span.setTag("srckey", srckey);
        span.setTag("dstkey", dstkey);
        span.setTag("member", member);
        return (Long)this.helper.decorate(span, () -> this.wrapped.smove(srckey, dstkey, member));
    }

    public Long scard(String key) {
        Span span = this.helper.buildSpan("scard", (Object)key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.scard(key));
    }

    public Boolean sismember(String key, String member) {
        Span span = this.helper.buildSpan("sismember", (Object)key);
        span.setTag("member", member);
        return (Boolean)this.helper.decorate(span, () -> this.wrapped.sismember(key, member));
    }

    public Set<String> sinter(String ... keys) {
        Span span = this.helper.buildSpan("sinter", (Object[])keys);
        return (Set)this.helper.decorate(span, () -> this.wrapped.sinter(keys));
    }

    public Long sinterstore(String dstkey, String ... keys) {
        Span span = this.helper.buildSpan("sinterstore", (Object[])keys);
        span.setTag("dstkey", dstkey);
        return (Long)this.helper.decorate(span, () -> this.wrapped.sinterstore(dstkey, keys));
    }

    public Set<String> sunion(String ... keys) {
        Span span = this.helper.buildSpan("sunion", (Object[])keys);
        return (Set)this.helper.decorate(span, () -> this.wrapped.sunion(keys));
    }

    public Long sunionstore(String dstkey, String ... keys) {
        Span span = this.helper.buildSpan("sunionstore", (Object[])keys);
        span.setTag("dstkey", dstkey);
        return (Long)this.helper.decorate(span, () -> this.wrapped.sunionstore(dstkey, keys));
    }

    public Set<String> sdiff(String ... keys) {
        Span span = this.helper.buildSpan("sdiff", (Object[])keys);
        return (Set)this.helper.decorate(span, () -> this.wrapped.sdiff(keys));
    }

    public Long sdiffstore(String dstkey, String ... keys) {
        Span span = this.helper.buildSpan("sdiffstore", (Object[])keys);
        span.setTag("dstkey", dstkey);
        return (Long)this.helper.decorate(span, () -> this.wrapped.sdiffstore(dstkey, keys));
    }

    public String srandmember(String key) {
        Span span = this.helper.buildSpan("srandmember", (Object)key);
        return (String)this.helper.decorate(span, () -> this.wrapped.srandmember(key));
    }

    public List<String> srandmember(String key, int count) {
        Span span = this.helper.buildSpan("srandmember", (Object)key);
        span.setTag("count", (Number)count);
        return (List)this.helper.decorate(span, () -> this.wrapped.srandmember(key, count));
    }

    public Long zadd(String key, double score, String member) {
        Span span = this.helper.buildSpan("zadd", (Object)key);
        span.setTag("score", (Number)score);
        span.setTag("member", member);
        return (Long)this.helper.decorate(span, () -> this.wrapped.zadd(key, score, member));
    }

    public Long zadd(String key, double score, String member, ZAddParams params) {
        Span span = this.helper.buildSpan("zadd", (Object)key);
        span.setTag("score", (Number)score);
        span.setTag("member", member);
        span.setTag("params", TracingHelper.toString((byte[][])params.getByteParams()));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zadd(key, score, member, params));
    }

    public Long zadd(String key, Map<String, Double> scoreMembers) {
        Span span = this.helper.buildSpan("zadd", (Object)key);
        span.setTag("scoreMembers", TracingHelper.toString(scoreMembers));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zadd(key, scoreMembers));
    }

    public Long zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        Span span = this.helper.buildSpan("zadd", (Object)key);
        span.setTag("scoreMembers", TracingHelper.toString(scoreMembers));
        span.setTag("params", TracingHelper.toString((byte[][])params.getByteParams()));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zadd(key, scoreMembers, params));
    }

    public Set<String> zrange(String key, long start, long end) {
        Span span = this.helper.buildSpan("zrange", (Object)key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrange(key, start, end));
    }

    public Long zrem(String key, String ... members) {
        Span span = this.helper.buildSpan("zrem", (Object)key);
        span.setTag("members", Arrays.toString(members));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zrem(key, members));
    }

    public Double zincrby(String key, double score, String member) {
        Span span = this.helper.buildSpan("zincrby", (Object)key);
        span.setTag("score", (Number)score);
        span.setTag("member", member);
        return (Double)this.helper.decorate(span, () -> this.wrapped.zincrby(key, score, member));
    }

    public Double zincrby(String key, double score, String member, ZIncrByParams params) {
        Span span = this.helper.buildSpan("zincrby", (Object)key);
        span.setTag("score", (Number)score);
        span.setTag("member", member);
        span.setTag("params", TracingHelper.toString((byte[][])params.getByteParams()));
        return (Double)this.helper.decorate(span, () -> this.wrapped.zincrby(key, score, member, params));
    }

    public Long zrank(String key, String member) {
        Span span = this.helper.buildSpan("zrank", (Object)key);
        span.setTag("member", member);
        return (Long)this.helper.decorate(span, () -> this.wrapped.zrank(key, member));
    }

    public Long zrevrank(String key, String member) {
        Span span = this.helper.buildSpan("zrevrank", (Object)key);
        span.setTag("member", member);
        return (Long)this.helper.decorate(span, () -> this.wrapped.zrevrank(key, member));
    }

    public Set<String> zrevrange(String key, long start, long end) {
        Span span = this.helper.buildSpan("zrevrange", (Object)key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrange(key, start, end));
    }

    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        Span span = this.helper.buildSpan("zrangeWithScores", (Object)key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeWithScores(key, start, end));
    }

    public Set<Tuple> zrevrangeWithScores(String key, long start, long end) {
        Span span = this.helper.buildSpan("zrevrangeWithScores", (Object)key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeWithScores(key, start, end));
    }

    public Long zcard(String key) {
        Span span = this.helper.buildSpan("zcard", (Object)key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.zcard(key));
    }

    public Double zscore(String key, String member) {
        Span span = this.helper.buildSpan("zscore", (Object)key);
        span.setTag("member", member);
        return (Double)this.helper.decorate(span, () -> this.wrapped.zscore(key, member));
    }

    public String watch(String ... keys) {
        Span span = this.helper.buildSpan("watch", (Object[])keys);
        return (String)this.helper.decorate(span, () -> this.wrapped.watch(keys));
    }

    public List<String> sort(String key) {
        Span span = this.helper.buildSpan("sort", (Object)key);
        return (List)this.helper.decorate(span, () -> this.wrapped.sort(key));
    }

    public List<String> sort(String key, SortingParams sortingParameters) {
        Span span = this.helper.buildSpan("sort", (Object)key);
        span.setTag("sortingParameters", TracingHelper.toString((Collection)sortingParameters.getParams()));
        return (List)this.helper.decorate(span, () -> this.wrapped.sort(key, sortingParameters));
    }

    public List<String> blpop(int timeout, String ... keys) {
        Span span = this.helper.buildSpan("blpop", (Object[])keys);
        span.setTag("timeout", (Number)timeout);
        return (List)this.helper.decorate(span, () -> this.wrapped.blpop(timeout, keys));
    }

    public List<String> blpop(String ... args) {
        Span span = this.helper.buildSpan("blpop");
        span.setTag("args", Arrays.toString(args));
        return (List)this.helper.decorate(span, () -> this.wrapped.blpop(args));
    }

    public List<String> brpop(String ... args) {
        Span span = this.helper.buildSpan("brpop");
        span.setTag("args", Arrays.toString(args));
        return (List)this.helper.decorate(span, () -> this.wrapped.brpop(args));
    }

    public List<String> blpop(String arg) {
        Span span = this.helper.buildSpan("blpop");
        span.setTag("arg", arg);
        return (List)this.helper.decorate(span, () -> this.wrapped.blpop(arg));
    }

    public List<String> brpop(String arg) {
        Span span = this.helper.buildSpan("brpop");
        span.setTag("arg", arg);
        return (List)this.helper.decorate(span, () -> this.wrapped.brpop(arg));
    }

    public Long sort(String key, SortingParams sortingParameters, String dstkey) {
        Span span = this.helper.buildSpan("sort", (Object)key);
        span.setTag("sortingParameters", TracingHelper.toString((Collection)sortingParameters.getParams()));
        span.setTag("dstkey", dstkey);
        return (Long)this.helper.decorate(span, () -> this.wrapped.sort(key, sortingParameters, dstkey));
    }

    public Long sort(String key, String dstkey) {
        Span span = this.helper.buildSpan("sort", (Object)key);
        span.setTag("dstkey", dstkey);
        return (Long)this.helper.decorate(span, () -> this.wrapped.sort(key, dstkey));
    }

    public List<String> brpop(int timeout, String ... keys) {
        Span span = this.helper.buildSpan("brpop", (Object[])keys);
        span.setTag("timeout", (Number)timeout);
        return (List)this.helper.decorate(span, () -> this.wrapped.brpop(timeout, keys));
    }

    public Long zcount(String key, double min, double max) {
        Span span = this.helper.buildSpan("zcount", (Object)key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        return (Long)this.helper.decorate(span, () -> this.wrapped.zcount(key, min, max));
    }

    public Long zcount(String key, String min, String max) {
        Span span = this.helper.buildSpan("zcount", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        return (Long)this.helper.decorate(span, () -> this.wrapped.zcount(key, min, max));
    }

    public Set<String> zrangeByScore(String key, double min, double max) {
        Span span = this.helper.buildSpan("zrangeByScore", (Object)key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeByScore(key, min, max));
    }

    public Set<String> zrangeByScore(String key, String min, String max) {
        Span span = this.helper.buildSpan("zrangeByScore", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeByScore(key, min, max));
    }

    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        Span span = this.helper.buildSpan("zrangeByScore", (Object)key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeByScore(key, min, max, offset, count));
    }

    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        Span span = this.helper.buildSpan("zrangeByScore", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeByScore(key, min, max, offset, count));
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        Span span = this.helper.buildSpan("zrangeByScoreWithScores", (Object)key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeByScoreWithScores(key, min, max));
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max) {
        Span span = this.helper.buildSpan("zrangeByScoreWithScores", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeByScoreWithScores(key, min, max));
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        Span span = this.helper.buildSpan("zrangeByScoreWithScores", (Object)key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeByScoreWithScores(key, min, max, offset, count));
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        Span span = this.helper.buildSpan("zrangeByScoreWithScores", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeByScoreWithScores(key, min, max, offset, count));
    }

    public Set<String> zrevrangeByScore(String key, double max, double min) {
        Span span = this.helper.buildSpan("zrevrangeByScore", (Object)key);
        span.setTag("max", (Number)max);
        span.setTag("min", (Number)min);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeByScore(key, max, min));
    }

    public Set<String> zrevrangeByScore(String key, String max, String min) {
        Span span = this.helper.buildSpan("zrevrangeByScore", (Object)key);
        span.setTag("max", max);
        span.setTag("min", min);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeByScore(key, max, min));
    }

    public Set<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        Span span = this.helper.buildSpan("zrevrangeByScore", (Object)key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeByScore(key, max, min, offset, count));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min) {
        Span span = this.helper.buildSpan("zrevrangeByScoreWithScores", (Object)key);
        span.setTag("max", (Number)max);
        span.setTag("min", (Number)min);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeByScoreWithScores(key, max, min));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        Span span = this.helper.buildSpan("zrevrangeByScoreWithScores", (Object)key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeByScoreWithScores(key, max, min, offset, count));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        Span span = this.helper.buildSpan("zrevrangeByScoreWithScores", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeByScoreWithScores(key, max, min, offset, count));
    }

    public Set<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        Span span = this.helper.buildSpan("zrevrangeByScore", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeByScore(key, max, min, offset, count));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min) {
        Span span = this.helper.buildSpan("zrevrangeByScoreWithScores", (Object)key);
        span.setTag("max", max);
        span.setTag("min", min);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeByScoreWithScores(key, max, min));
    }

    public Long zremrangeByRank(String key, long start, long end) {
        Span span = this.helper.buildSpan("zremrangeByRank", (Object)key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return (Long)this.helper.decorate(span, () -> this.wrapped.zremrangeByRank(key, start, end));
    }

    public Long zremrangeByScore(String key, double start, double end) {
        Span span = this.helper.buildSpan("zremrangeByScore", (Object)key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return (Long)this.helper.decorate(span, () -> this.wrapped.zremrangeByScore(key, start, end));
    }

    public Long zremrangeByScore(String key, String start, String end) {
        Span span = this.helper.buildSpan("zremrangeByScore", (Object)key);
        span.setTag("start", start);
        span.setTag("end", end);
        return (Long)this.helper.decorate(span, () -> this.wrapped.zremrangeByScore(key, start, end));
    }

    public Long zunionstore(String dstkey, String ... sets) {
        Span span = this.helper.buildSpan("zunionstore");
        span.setTag("dstkey", dstkey);
        span.setTag("sets", Arrays.toString(sets));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zunionstore(dstkey, sets));
    }

    public Long zunionstore(String dstkey, ZParams params, String ... sets) {
        Span span = this.helper.buildSpan("zunionstore");
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        span.setTag("sets", Arrays.toString(sets));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zunionstore(dstkey, params, sets));
    }

    public Long zinterstore(String dstkey, String ... sets) {
        Span span = this.helper.buildSpan("zinterstore");
        span.setTag("dstkey", dstkey);
        span.setTag("sets", Arrays.toString(sets));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zinterstore(dstkey, sets));
    }

    public Long zinterstore(String dstkey, ZParams params, String ... sets) {
        Span span = this.helper.buildSpan("zinterstore");
        span.setTag("dstkey", dstkey);
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        span.setTag("sets", Arrays.toString(sets));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zinterstore(dstkey, params, sets));
    }

    public Long zlexcount(String key, String min, String max) {
        Span span = this.helper.buildSpan("zlexcount", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        return (Long)this.helper.decorate(span, () -> this.wrapped.zlexcount(key, min, max));
    }

    public Set<String> zrangeByLex(String key, String min, String max) {
        Span span = this.helper.buildSpan("zrangeByLex", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeByLex(key, min, max));
    }

    public Set<String> zrangeByLex(String key, String min, String max, int offset, int count) {
        Span span = this.helper.buildSpan("zrangeByLex", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeByLex(key, min, max, offset, count));
    }

    public Set<String> zrevrangeByLex(String key, String max, String min) {
        Span span = this.helper.buildSpan("zrevrangeByLex", (Object)key);
        span.setTag("max", max);
        span.setTag("min", min);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeByLex(key, max, min));
    }

    public Set<String> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        Span span = this.helper.buildSpan("zrevrangeByLex", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeByLex(key, max, min, offset, count));
    }

    public Long zremrangeByLex(String key, String min, String max) {
        Span span = this.helper.buildSpan("zremrangeByLex", (Object)key);
        span.setTag("min", min);
        span.setTag("max", max);
        return (Long)this.helper.decorate(span, () -> this.wrapped.zremrangeByLex(key, min, max));
    }

    public Long strlen(String key) {
        Span span = this.helper.buildSpan("strlen", (Object)key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.strlen(key));
    }

    public Long lpushx(String key, String ... string) {
        Span span = this.helper.buildSpan("lpushx", (Object)key);
        span.setTag("string", Arrays.toString(string));
        return (Long)this.helper.decorate(span, () -> this.wrapped.lpushx(key, string));
    }

    public Long persist(String key) {
        Span span = this.helper.buildSpan("persist", (Object)key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.persist(key));
    }

    public Long rpushx(String key, String ... string) {
        Span span = this.helper.buildSpan("rpushx", (Object)key);
        span.setTag("string", Arrays.toString(string));
        return (Long)this.helper.decorate(span, () -> this.wrapped.rpushx(key, string));
    }

    public String echo(String string) {
        Span span = this.helper.buildSpan("echo");
        span.setTag("string", string);
        return (String)this.helper.decorate(span, () -> this.wrapped.echo(string));
    }

    public Long linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        Span span = this.helper.buildSpan("linsert", (Object)key);
        span.setTag("where", where.name());
        span.setTag("pivot", pivot);
        span.setTag("value", value);
        return (Long)this.helper.decorate(span, () -> this.wrapped.linsert(key, where, pivot, value));
    }

    public Long linsert(String key, ListPosition where, String pivot, String value) {
        Span span = this.helper.buildSpan("linsert", (Object)key);
        span.setTag("where", TracingHelper.nullable((Object)where));
        span.setTag("pivot", pivot);
        span.setTag("value", value);
        return (Long)this.helper.decorate(span, () -> this.wrapped.linsert(key, where, pivot, value));
    }

    public String brpoplpush(String source, String destination, int timeout) {
        Span span = this.helper.buildSpan("brpoplpush");
        span.setTag("source", source);
        span.setTag("destination", destination);
        span.setTag("timeout", (Number)timeout);
        return (String)this.helper.decorate(span, () -> this.wrapped.brpoplpush(source, destination, timeout));
    }

    public Boolean setbit(String key, long offset, boolean value) {
        Span span = this.helper.buildSpan("setbit", (Object)key);
        span.setTag("offset", (Number)offset);
        span.setTag("value", value);
        return (Boolean)this.helper.decorate(span, () -> this.wrapped.setbit(key, offset, value));
    }

    public Boolean setbit(String key, long offset, String value) {
        Span span = this.helper.buildSpan("setbit", (Object)key);
        span.setTag("offset", (Number)offset);
        span.setTag("value", value);
        return (Boolean)this.helper.decorate(span, () -> this.wrapped.setbit(key, offset, value));
    }

    public Boolean getbit(String key, long offset) {
        Span span = this.helper.buildSpan("getbit", (Object)key);
        span.setTag("offset", (Number)offset);
        return (Boolean)this.helper.decorate(span, () -> this.wrapped.getbit(key, offset));
    }

    public Long setrange(String key, long offset, String value) {
        Span span = this.helper.buildSpan("setrange", (Object)key);
        span.setTag("offset", (Number)offset);
        span.setTag("value", value);
        return (Long)this.helper.decorate(span, () -> this.wrapped.setrange(key, offset, value));
    }

    public String getrange(String key, long startOffset, long endOffset) {
        Span span = this.helper.buildSpan("getrange", (Object)key);
        span.setTag("startOffset", (Number)startOffset);
        span.setTag("endOffset", (Number)endOffset);
        return (String)this.helper.decorate(span, () -> this.wrapped.getrange(key, startOffset, endOffset));
    }

    public Long bitpos(String key, boolean value) {
        Span span = this.helper.buildSpan("bitpos", (Object)key);
        span.setTag("value", value);
        return (Long)this.helper.decorate(span, () -> this.wrapped.bitpos(key, value));
    }

    public Long bitpos(String key, boolean value, BitPosParams params) {
        Span span = this.helper.buildSpan("bitpos", (Object)key);
        span.setTag("value", value);
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        return (Long)this.helper.decorate(span, () -> this.wrapped.bitpos(key, value, params));
    }

    public List<String> configGet(String pattern) {
        Span span = this.helper.buildSpan("configGet");
        span.setTag("pattern", pattern);
        return (List)this.helper.decorate(span, () -> this.wrapped.configGet(pattern));
    }

    public String configSet(String parameter, String value) {
        Span span = this.helper.buildSpan("configSet");
        span.setTag("value", value);
        return (String)this.helper.decorate(span, () -> this.wrapped.configSet(parameter, value));
    }

    public Object eval(String script, int keyCount, String ... params) {
        Span span = this.helper.buildSpan("eval");
        span.setTag("keyCount", (Number)keyCount);
        span.setTag("params", Arrays.toString(params));
        return this.helper.decorate(span, () -> this.wrapped.eval(script, keyCount, params));
    }

    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        Span span = this.helper.buildSpan("subscribe");
        span.setTag("channels", Arrays.toString(channels));
        this.helper.decorate(span, () -> this.wrapped.subscribe(jedisPubSub, channels));
    }

    public Long publish(String channel, String message) {
        Span span = this.helper.buildSpan("publish");
        span.setTag("channel", channel);
        span.setTag("message", message);
        return (Long)this.helper.decorate(span, () -> this.wrapped.publish(channel, message));
    }

    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        Span span = this.helper.buildSpan("psubscribe");
        span.setTag("patterns", Arrays.toString(patterns));
        this.helper.decorate(span, () -> this.wrapped.psubscribe(jedisPubSub, patterns));
    }

    public Object eval(String script, List<String> keys, List<String> args) {
        Span span = this.helper.buildSpan("eval");
        span.setTag("keys", TracingHelper.toString(keys));
        span.setTag("args", TracingHelper.toString(args));
        return this.helper.decorate(span, () -> this.wrapped.eval(script, keys, args));
    }

    public Object eval(String script) {
        Span span = this.helper.buildSpan("eval");
        span.setTag("script", script);
        return this.helper.decorate(span, () -> this.wrapped.eval(script));
    }

    public Object evalsha(String script) {
        Span span = this.helper.buildSpan("evalsha");
        span.setTag("script", script);
        return this.helper.decorate(span, () -> this.wrapped.evalsha(script));
    }

    public Object evalsha(String sha1, List<String> keys, List<String> args) {
        Span span = this.helper.buildSpan("evalsha");
        span.setTag("keys", TracingHelper.toString(keys));
        span.setTag("args", TracingHelper.toString(args));
        span.setTag("sha1", sha1);
        return this.helper.decorate(span, () -> this.wrapped.evalsha(sha1, keys, args));
    }

    public Object evalsha(String sha1, int keyCount, String ... params) {
        Span span = this.helper.buildSpan("evalsha");
        span.setTag("keyCount", (Number)keyCount);
        span.setTag("params", Arrays.toString(params));
        span.setTag("sha1", sha1);
        return this.helper.decorate(span, () -> this.wrapped.evalsha(sha1, keyCount, params));
    }

    public Boolean scriptExists(String sha1) {
        Span span = this.helper.buildSpan("scriptExists");
        span.setTag("sha1", sha1);
        return (Boolean)this.helper.decorate(span, () -> this.wrapped.scriptExists(sha1));
    }

    public List<Boolean> scriptExists(String ... sha1) {
        Span span = this.helper.buildSpan("scriptExists");
        span.setTag("sha1", Arrays.toString(sha1));
        return (List)this.helper.decorate(span, () -> this.wrapped.scriptExists(sha1));
    }

    public String scriptLoad(String script) {
        Span span = this.helper.buildSpan("scriptLoad");
        span.setTag("script", script);
        return (String)this.helper.decorate(span, () -> this.wrapped.scriptLoad(script));
    }

    public List<Slowlog> slowlogGet() {
        Span span = this.helper.buildSpan("slowlogGet");
        return (List)this.helper.decorate(span, () -> this.wrapped.slowlogGet());
    }

    public List<Slowlog> slowlogGet(long entries) {
        Span span = this.helper.buildSpan("slowlogGet");
        span.setTag("entries", (Number)entries);
        return (List)this.helper.decorate(span, () -> this.wrapped.slowlogGet(entries));
    }

    public Long objectRefcount(String string) {
        Span span = this.helper.buildSpan("objectRefcount");
        span.setTag("string", string);
        return (Long)this.helper.decorate(span, () -> this.wrapped.objectRefcount(string));
    }

    public String objectEncoding(String string) {
        Span span = this.helper.buildSpan("objectEncoding");
        span.setTag("string", string);
        return (String)this.helper.decorate(span, () -> this.wrapped.objectEncoding(string));
    }

    public Long objectIdletime(String string) {
        Span span = this.helper.buildSpan("objectIdletime");
        span.setTag("string", string);
        return (Long)this.helper.decorate(span, () -> this.wrapped.objectIdletime(string));
    }

    public Long bitcount(String key) {
        Span span = this.helper.buildSpan("bitcount", (Object)key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.bitcount(key));
    }

    public Long bitcount(String key, long start, long end) {
        Span span = this.helper.buildSpan("bitcount", (Object)key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return (Long)this.helper.decorate(span, () -> this.wrapped.bitcount(key, start, end));
    }

    public Long bitop(BitOP op, String destKey, String ... srcKeys) {
        Span span = this.helper.buildSpan("bitop");
        span.setTag("destKey", destKey);
        span.setTag("srcKeys", Arrays.toString(srcKeys));
        return (Long)this.helper.decorate(span, () -> this.wrapped.bitop(op, destKey, srcKeys));
    }

    public List<Map<String, String>> sentinelMasters() {
        Span span = this.helper.buildSpan("sentinelMasters");
        return (List)this.helper.decorate(span, () -> this.wrapped.sentinelMasters());
    }

    public List<String> sentinelGetMasterAddrByName(String masterName) {
        Span span = this.helper.buildSpan("sentinelGetMasterAddrByName");
        span.setTag("masterName", masterName);
        return (List)this.helper.decorate(span, () -> this.wrapped.sentinelGetMasterAddrByName(masterName));
    }

    public Long sentinelReset(String pattern) {
        Span span = this.helper.buildSpan("sentinelReset");
        span.setTag("pattern", pattern);
        return (Long)this.helper.decorate(span, () -> this.wrapped.sentinelReset(pattern));
    }

    public List<Map<String, String>> sentinelSlaves(String masterName) {
        Span span = this.helper.buildSpan("sentinelSlaves");
        span.setTag("masterName", masterName);
        return (List)this.helper.decorate(span, () -> this.wrapped.sentinelSlaves(masterName));
    }

    public String sentinelFailover(String masterName) {
        Span span = this.helper.buildSpan("sentinelFailover");
        return (String)this.helper.decorate(span, () -> this.wrapped.sentinelFailover(masterName));
    }

    public String sentinelMonitor(String masterName, String ip, int port, int quorum) {
        Span span = this.helper.buildSpan("sentinelMonitor");
        span.setTag("masterName", masterName);
        span.setTag("ip", ip);
        span.setTag("port", (Number)port);
        span.setTag("quorum", (Number)quorum);
        return (String)this.helper.decorate(span, () -> this.wrapped.sentinelMonitor(masterName, ip, port, quorum));
    }

    public String sentinelRemove(String masterName) {
        Span span = this.helper.buildSpan("sentinelRemove");
        span.setTag("masterName", masterName);
        return (String)this.helper.decorate(span, () -> this.wrapped.sentinelRemove(masterName));
    }

    public String sentinelSet(String masterName, Map<String, String> parameterMap) {
        Span span = this.helper.buildSpan("sentinelSet");
        span.setTag("masterName", masterName);
        span.setTag("parameterMap", TracingHelper.toString(parameterMap));
        return (String)this.helper.decorate(span, () -> this.wrapped.sentinelSet(masterName, parameterMap));
    }

    public byte[] dump(String key) {
        Span span = this.helper.buildSpan("dump", (Object)key);
        return (byte[])this.helper.decorate(span, () -> this.wrapped.dump(key));
    }

    public String restore(String key, int ttl, byte[] serializedValue) {
        Span span = this.helper.buildSpan("restore", (Object)key);
        span.setTag("ttl", (Number)ttl);
        span.setTag("serializedValue", Arrays.toString(serializedValue));
        return (String)this.helper.decorate(span, () -> this.wrapped.restore(key, ttl, serializedValue));
    }

    public Long pexpire(String key, int milliseconds) {
        Span span = this.helper.buildSpan("pexpire", (Object)key);
        span.setTag("milliseconds", (Number)milliseconds);
        return (Long)this.helper.decorate(span, () -> this.wrapped.pexpire(key, milliseconds));
    }

    public String restoreReplace(String key, int ttl, byte[] serializedValue) {
        Span span = this.helper.buildSpan("restoreReplace", (Object)key);
        span.setTag("ttl", (Number)ttl);
        span.setTag("serializedValue", Arrays.toString(serializedValue));
        return (String)this.helper.decorate(span, () -> this.wrapped.restoreReplace(key, ttl, serializedValue));
    }

    public Long pexpire(String key, long milliseconds) {
        Span span = this.helper.buildSpan("pexpire", (Object)key);
        span.setTag("milliseconds", (Number)milliseconds);
        return (Long)this.helper.decorate(span, () -> this.wrapped.pexpire(key, milliseconds));
    }

    public Long pexpireAt(String key, long millisecondsTimestamp) {
        Span span = this.helper.buildSpan("pexpireAt", (Object)key);
        span.setTag("millisecondsTimestamp", (Number)millisecondsTimestamp);
        return (Long)this.helper.decorate(span, () -> this.wrapped.pexpireAt(key, millisecondsTimestamp));
    }

    public Long pttl(String key) {
        Span span = this.helper.buildSpan("pttl", (Object)key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.pttl(key));
    }

    public String psetex(String key, int milliseconds, String value) {
        Span span = this.helper.buildSpan("psetex", (Object)key);
        span.setTag("milliseconds", (Number)milliseconds);
        span.setTag("value", value);
        return (String)this.helper.decorate(span, () -> this.wrapped.psetex(key, milliseconds, value));
    }

    public String psetex(String key, long milliseconds, String value) {
        Span span = this.helper.buildSpan("psetex", (Object)key);
        span.setTag("value", value);
        span.setTag("milliseconds", (Number)milliseconds);
        return (String)this.helper.decorate(span, () -> this.wrapped.psetex(key, milliseconds, value));
    }

    public String set(String key, String value, String nxxx) {
        Span span = this.helper.buildSpan("set", (Object)key);
        span.setTag("value", value);
        span.setTag("nxxx", nxxx);
        return (String)this.helper.decorate(span, () -> this.wrapped.set(key, value, nxxx));
    }

    public String set(String key, String value, String nxxx, String expx, int time) {
        Span span = this.helper.buildSpan("set", (Object)key);
        span.setTag("value", value);
        span.setTag("nxxx", nxxx);
        span.setTag("expx", expx);
        span.setTag("time", (Number)time);
        return (String)this.helper.decorate(span, () -> this.wrapped.set(key, value, nxxx, expx, time));
    }

    public String clientKill(String client) {
        Span span = this.helper.buildSpan("clientKill");
        span.setTag("client", client);
        return (String)this.helper.decorate(span, () -> this.wrapped.clientKill(client));
    }

    public String clientGetname() {
        Span span = this.helper.buildSpan("clientGetname");
        return (String)this.helper.decorate(span, () -> this.wrapped.clientGetname());
    }

    public String clientList() {
        Span span = this.helper.buildSpan("clientList");
        return (String)this.helper.decorate(span, () -> this.wrapped.clientList());
    }

    public String clientSetname(String name) {
        Span span = this.helper.buildSpan("clientSetname");
        span.setTag("name", name);
        return (String)this.helper.decorate(span, () -> this.wrapped.clientSetname(name));
    }

    public String migrate(String host, int port, String key, int destinationDb, int timeout) {
        Span span = this.helper.buildSpan("migrate", (Object)key);
        span.setTag("host", host);
        span.setTag("destinationDb", (Number)destinationDb);
        span.setTag("timeout", (Number)timeout);
        span.setTag("port", (Number)port);
        return (String)this.helper.decorate(span, () -> this.wrapped.migrate(host, port, key, destinationDb, timeout));
    }

    public ScanResult<String> scan(int cursor) {
        Span span = this.helper.buildSpan("scan");
        span.setTag("cursor", (Number)cursor);
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.scan(cursor));
    }

    public ScanResult<String> scan(int cursor, ScanParams params) {
        Span span = this.helper.buildSpan("scan");
        span.setTag("cursor", (Number)cursor);
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.scan(cursor, params));
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, int cursor) {
        Span span = this.helper.buildSpan("hscan", (Object)key);
        span.setTag("cursor", (Number)cursor);
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.hscan(key, cursor));
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, int cursor, ScanParams params) {
        Span span = this.helper.buildSpan("hscan", (Object)key);
        span.setTag("cursor", (Number)cursor);
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.hscan(key, cursor, params));
    }

    public ScanResult<String> sscan(String key, int cursor) {
        Span span = this.helper.buildSpan("sscan", (Object)key);
        span.setTag("cursor", (Number)cursor);
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.sscan(key, cursor));
    }

    public ScanResult<String> sscan(String key, int cursor, ScanParams params) {
        Span span = this.helper.buildSpan("sscan", (Object)key);
        span.setTag("cursor", (Number)cursor);
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.sscan(key, cursor, params));
    }

    public ScanResult<Tuple> zscan(String key, int cursor) {
        Span span = this.helper.buildSpan("zscan", (Object)key);
        span.setTag("cursor", (Number)cursor);
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.zscan(key, cursor));
    }

    public ScanResult<Tuple> zscan(String key, int cursor, ScanParams params) {
        Span span = this.helper.buildSpan("zscan", (Object)key);
        span.setTag("cursor", (Number)cursor);
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.zscan(key, cursor, params));
    }

    public ScanResult<String> scan(String cursor) {
        Span span = this.helper.buildSpan("scan");
        span.setTag("cursor", cursor);
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.scan(cursor));
    }

    public ScanResult<String> scan(String cursor, ScanParams params) {
        Span span = this.helper.buildSpan("scan");
        span.setTag("cursor", cursor);
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.scan(cursor, params));
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        Span span = this.helper.buildSpan("hscan", (Object)key);
        span.setTag("cursor", cursor);
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.hscan(key, cursor));
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor, ScanParams params) {
        Span span = this.helper.buildSpan("hscan", (Object)key);
        span.setTag("cursor", cursor);
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.hscan(key, cursor, params));
    }

    public ScanResult<String> sscan(String key, String cursor) {
        Span span = this.helper.buildSpan("sscan", (Object)key);
        span.setTag("cursor", cursor);
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.sscan(key, cursor));
    }

    public ScanResult<String> sscan(String key, String cursor, ScanParams params) {
        Span span = this.helper.buildSpan("sscan", (Object)key);
        span.setTag("cursor", cursor);
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.sscan(key, cursor, params));
    }

    public ScanResult<Tuple> zscan(String key, String cursor) {
        Span span = this.helper.buildSpan("zscan", (Object)key);
        span.setTag("cursor", cursor);
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.zscan(key, cursor));
    }

    public ScanResult<Tuple> zscan(String key, String cursor, ScanParams params) {
        Span span = this.helper.buildSpan("zscan", (Object)key);
        span.setTag("cursor", cursor);
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.zscan(key, cursor, params));
    }

    public String clusterNodes() {
        Span span = this.helper.buildSpan("clusterNodes");
        return (String)this.helper.decorate(span, () -> this.wrapped.clusterNodes());
    }

    public String readonly() {
        Span span = this.helper.buildSpan("readonly");
        return (String)this.helper.decorate(span, () -> this.wrapped.readonly());
    }

    public String clusterMeet(String ip, int port) {
        Span span = this.helper.buildSpan("clusterMeet");
        span.setTag("ip", ip);
        span.setTag("port", (Number)port);
        return (String)this.helper.decorate(span, () -> this.wrapped.clusterMeet(ip, port));
    }

    public String clusterReset(JedisCluster.Reset resetType) {
        Span span = this.helper.buildSpan("clusterReset");
        span.setTag("resetType", resetType.name());
        return (String)this.helper.decorate(span, () -> this.wrapped.clusterReset(resetType));
    }

    public String clusterReset(ClusterReset resetType) {
        Span span = this.helper.buildSpan("clusterReset");
        span.setTag("resetType", resetType.name());
        return (String)this.helper.decorate(span, () -> this.wrapped.clusterReset(resetType));
    }

    public String clusterAddSlots(int ... slots) {
        Span span = this.helper.buildSpan("clusterAddSlots");
        span.setTag("slots", Arrays.toString(slots));
        return (String)this.helper.decorate(span, () -> this.wrapped.clusterAddSlots(slots));
    }

    public String clusterDelSlots(int ... slots) {
        Span span = this.helper.buildSpan("clusterDelSlots");
        span.setTag("slots", Arrays.toString(slots));
        return (String)this.helper.decorate(span, () -> this.wrapped.clusterDelSlots(slots));
    }

    public String clusterInfo() {
        Span span = this.helper.buildSpan("clusterInfo");
        return (String)this.helper.decorate(span, () -> this.wrapped.clusterInfo());
    }

    public List<String> clusterGetKeysInSlot(int slot, int count) {
        Span span = this.helper.buildSpan("clusterGetKeysInSlot");
        span.setTag("slot", (Number)slot);
        span.setTag("count", (Number)count);
        return (List)this.helper.decorate(span, () -> this.wrapped.clusterGetKeysInSlot(slot, count));
    }

    public String clusterSetSlotNode(int slot, String nodeId) {
        Span span = this.helper.buildSpan("clusterSetSlotNode");
        span.setTag("slot", (Number)slot);
        span.setTag("nodeId", nodeId);
        return (String)this.helper.decorate(span, () -> this.wrapped.clusterSetSlotNode(slot, nodeId));
    }

    public String clusterSetSlotMigrating(int slot, String nodeId) {
        Span span = this.helper.buildSpan("clusterSetSlotMigrating");
        span.setTag("slot", (Number)slot);
        span.setTag("nodeId", nodeId);
        return (String)this.helper.decorate(span, () -> this.wrapped.clusterSetSlotMigrating(slot, nodeId));
    }

    public String clusterSetSlotImporting(int slot, String nodeId) {
        Span span = this.helper.buildSpan("clusterSetSlotImporting");
        span.setTag("slot", (Number)slot);
        span.setTag("nodeId", nodeId);
        return (String)this.helper.decorate(span, () -> this.wrapped.clusterSetSlotImporting(slot, nodeId));
    }

    public String clusterSetSlotStable(int slot) {
        Span span = this.helper.buildSpan("clusterSetSlotStable");
        span.setTag("slot", (Number)slot);
        return (String)this.helper.decorate(span, () -> this.wrapped.clusterSetSlotStable(slot));
    }

    public String clusterForget(String nodeId) {
        Span span = this.helper.buildSpan("clusterForget");
        span.setTag("nodeId", nodeId);
        return (String)this.helper.decorate(span, () -> this.wrapped.clusterForget(nodeId));
    }

    public String clusterFlushSlots() {
        Span span = this.helper.buildSpan("clusterFlushSlots");
        return (String)this.helper.decorate(span, () -> this.wrapped.clusterFlushSlots());
    }

    public Long clusterKeySlot(String key) {
        Span span = this.helper.buildSpan("clusterKeySlot", (Object)key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.clusterKeySlot(key));
    }

    public Long clusterCountKeysInSlot(int slot) {
        Span span = this.helper.buildSpan("clusterCountKeysInSlot");
        span.setTag("slot", (Number)slot);
        return (Long)this.helper.decorate(span, () -> this.wrapped.clusterCountKeysInSlot(slot));
    }

    public String clusterSaveConfig() {
        Span span = this.helper.buildSpan("clusterSaveConfig");
        return (String)this.helper.decorate(span, () -> this.wrapped.clusterSaveConfig());
    }

    public String clusterReplicate(String nodeId) {
        Span span = this.helper.buildSpan("clusterReplicate");
        span.setTag("nodeId", nodeId);
        return (String)this.helper.decorate(span, () -> this.wrapped.clusterReplicate(nodeId));
    }

    public List<String> clusterSlaves(String nodeId) {
        Span span = this.helper.buildSpan("clusterSlaves");
        span.setTag("nodeId", nodeId);
        return (List)this.helper.decorate(span, () -> this.wrapped.clusterSlaves(nodeId));
    }

    public String clusterFailover() {
        Span span = this.helper.buildSpan("clusterFailover");
        return (String)this.helper.decorate(span, () -> this.wrapped.clusterFailover());
    }

    public List<Object> clusterSlots() {
        Span span = this.helper.buildSpan("clusterSlots");
        return (List)this.helper.decorate(span, () -> this.wrapped.clusterSlots());
    }

    public String asking() {
        Span span = this.helper.buildSpan("asking");
        return (String)this.helper.decorate(span, () -> this.wrapped.asking());
    }

    public List<String> pubsubChannels(String pattern) {
        Span span = this.helper.buildSpan("pubsubChannels");
        span.setTag("pattern", pattern);
        return (List)this.helper.decorate(span, () -> this.wrapped.pubsubChannels(pattern));
    }

    public Long pubsubNumPat() {
        Span span = this.helper.buildSpan("pubsubNumPat");
        return (Long)this.helper.decorate(span, () -> this.wrapped.pubsubNumPat());
    }

    public Map<String, String> pubsubNumSub(String ... channels) {
        Span span = this.helper.buildSpan("pubsubNumSub");
        span.setTag("channels", Arrays.toString(channels));
        return (Map)this.helper.decorate(span, () -> this.wrapped.pubsubNumSub(channels));
    }

    public void close() {
        this.wrapped.close();
    }

    public void setDataSource(Pool<Jedis> jedisPool) {
        Span span = this.helper.buildSpan("setDataSource");
        this.helper.decorate(span, () -> this.wrapped.setDataSource(jedisPool));
    }

    public Long pfadd(String key, String ... elements) {
        Span span = this.helper.buildSpan("pfadd");
        span.setTag("elements", Arrays.toString(elements));
        return (Long)this.helper.decorate(span, () -> this.wrapped.pfadd(key, elements));
    }

    public long pfcount(String key) {
        Span span = this.helper.buildSpan("pfcount", (Object)key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.pfcount(key));
    }

    public long pfcount(String ... keys) {
        Span span = this.helper.buildSpan("pfcount", (Object[])keys);
        return (Long)this.helper.decorate(span, () -> this.wrapped.pfcount(keys));
    }

    public String pfmerge(String destkey, String ... sourcekeys) {
        Span span = this.helper.buildSpan("pfmerge");
        span.setTag("destkey", destkey);
        span.setTag("sourcekeys", Arrays.toString(sourcekeys));
        return (String)this.helper.decorate(span, () -> this.wrapped.pfmerge(destkey, sourcekeys));
    }

    public List<String> blpop(int timeout, String key) {
        Span span = this.helper.buildSpan("blpop");
        span.setTag("timeout", (Number)timeout);
        return (List)this.helper.decorate(span, () -> this.wrapped.blpop(timeout, key));
    }

    public List<String> brpop(int timeout, String key) {
        Span span = this.helper.buildSpan("brpop");
        span.setTag("timeout", (Number)timeout);
        return (List)this.helper.decorate(span, () -> this.wrapped.brpop(timeout, key));
    }

    public Long geoadd(String key, double longitude, double latitude, String member) {
        Span span = this.helper.buildSpan("geoadd");
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("member", member);
        return (Long)this.helper.decorate(span, () -> this.wrapped.geoadd(key, longitude, latitude, member));
    }

    public Long geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        Span span = this.helper.buildSpan("geoadd");
        span.setTag("memberCoordinateMap", TracingHelper.toString(memberCoordinateMap));
        return (Long)this.helper.decorate(span, () -> this.wrapped.geoadd(key, memberCoordinateMap));
    }

    public Double geodist(String key, String member1, String member2) {
        Span span = this.helper.buildSpan("geodist", (Object)key);
        span.setTag("member1", member1);
        span.setTag("member2", member2);
        return (Double)this.helper.decorate(span, () -> this.wrapped.geodist(key, member1, member2));
    }

    public Double geodist(String key, String member1, String member2, GeoUnit unit) {
        Span span = this.helper.buildSpan("geodist", (Object)key);
        span.setTag("member1", member1);
        span.setTag("member2", member2);
        span.setTag("unit", unit.name());
        return (Double)this.helper.decorate(span, () -> this.wrapped.geodist(key, member1, member2, unit));
    }

    public List<String> geohash(String key, String ... members) {
        Span span = this.helper.buildSpan("geohash", (Object)key);
        span.setTag("members", Arrays.toString(members));
        return (List)this.helper.decorate(span, () -> this.wrapped.geohash(key, members));
    }

    public List<GeoCoordinate> geopos(String key, String ... members) {
        Span span = this.helper.buildSpan("geopos", (Object)key);
        span.setTag("members", Arrays.toString(members));
        return (List)this.helper.decorate(span, () -> this.wrapped.geopos(key, members));
    }

    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        Span span = this.helper.buildSpan("georadius", (Object)key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        return (List)this.helper.decorate(span, () -> this.wrapped.georadius(key, longitude, latitude, radius, unit));
    }

    public List<GeoRadiusResponse> georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        Span span = this.helper.buildSpan("georadiusReadonly", (Object)key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        return (List)this.helper.decorate(span, () -> this.wrapped.georadiusReadonly(key, longitude, latitude, radius, unit));
    }

    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        Span span = this.helper.buildSpan("georadius", (Object)key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        span.setTag("param", TracingHelper.toString((byte[][])param.getByteParams()));
        return (List)this.helper.decorate(span, () -> this.wrapped.georadius(key, longitude, latitude, radius, unit, param));
    }

    public List<GeoRadiusResponse> georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        Span span = this.helper.buildSpan("georadiusReadonly", (Object)key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        span.setTag("param", TracingHelper.toString((byte[][])param.getByteParams()));
        return (List)this.helper.decorate(span, () -> this.wrapped.georadiusReadonly(key, longitude, latitude, radius, unit, param));
    }

    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit) {
        Span span = this.helper.buildSpan("georadiusByMember", (Object)key);
        span.setTag("member", member);
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        return (List)this.helper.decorate(span, () -> this.wrapped.georadiusByMember(key, member, radius, unit));
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        Span span = this.helper.buildSpan("georadiusByMemberReadonly", (Object)key);
        span.setTag("member", member);
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        span.setTag("param", TracingHelper.toString((byte[][])param.getByteParams()));
        return (List)this.helper.decorate(span, () -> this.wrapped.georadiusByMemberReadonly(key, member, radius, unit, param));
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit) {
        Span span = this.helper.buildSpan("georadiusByMemberReadonly", (Object)key);
        span.setTag("member", member);
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        return (List)this.helper.decorate(span, () -> this.wrapped.georadiusByMemberReadonly(key, member, radius, unit));
    }

    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        Span span = this.helper.buildSpan("georadiusByMember", (Object)key);
        span.setTag("member", member);
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        span.setTag("param", TracingHelper.toString((byte[][])param.getByteParams()));
        return (List)this.helper.decorate(span, () -> this.wrapped.georadiusByMember(key, member, radius, unit, param));
    }

    public List<Long> bitfield(String key, String ... arguments) {
        Span span = this.helper.buildSpan("bitfield", (Object)key);
        span.setTag("arguments", Arrays.toString(arguments));
        return (List)this.helper.decorate(span, () -> this.wrapped.bitfield(key, arguments));
    }

    public Long hstrlen(String key, String field) {
        Span span = this.helper.buildSpan("hstrlen", (Object)key);
        span.setTag("field", field);
        return (Long)this.helper.decorate(span, () -> this.wrapped.hstrlen(key, field));
    }

    public String ping() {
        Span span = this.helper.buildSpan("ping");
        return (String)this.helper.decorate(span, () -> this.wrapped.ping());
    }

    public byte[] ping(byte[] message) {
        Span span = this.helper.buildSpan("ping");
        span.setTag("message", Arrays.toString(message));
        return (byte[])this.helper.decorate(span, () -> this.wrapped.ping(message));
    }

    public String set(byte[] key, byte[] value) {
        Span span = this.helper.buildSpan("set", key);
        span.setTag("value", Arrays.toString(value));
        return (String)this.helper.decorate(span, () -> this.wrapped.set(key, value));
    }

    public String set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, long time) {
        Span span = this.helper.buildSpan("set", key);
        span.setTag("nxxx", Arrays.toString(nxxx));
        span.setTag("expx", Arrays.toString(expx));
        span.setTag("time", (Number)time);
        span.setTag("value", Arrays.toString(value));
        return (String)this.helper.decorate(span, () -> this.wrapped.set(key, value, nxxx, expx, time));
    }

    public String set(byte[] key, byte[] value, byte[] expx, long time) {
        Span span = this.helper.buildSpan("set", key);
        span.setTag("value", Arrays.toString(value));
        span.setTag("expx", Arrays.toString(expx));
        span.setTag("time", (Number)time);
        return (String)this.helper.decorate(span, () -> this.wrapped.set(key, value, expx, time));
    }

    public byte[] get(byte[] key) {
        Span span = this.helper.buildSpan("get", key);
        return (byte[])this.helper.decorate(span, () -> this.wrapped.get(key));
    }

    public String quit() {
        Span span = this.helper.buildSpan("quit");
        return (String)this.helper.decorate(span, () -> this.wrapped.quit());
    }

    public Long exists(byte[] ... keys) {
        Span span = this.helper.buildSpan("exists");
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        return (Long)this.helper.decorate(span, () -> this.wrapped.exists(keys));
    }

    public Boolean exists(byte[] key) {
        Span span = this.helper.buildSpan("exists", key);
        return (Boolean)this.helper.decorate(span, () -> this.wrapped.exists(key));
    }

    public Long del(byte[] ... keys) {
        Span span = this.helper.buildSpan("del");
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        return (Long)this.helper.decorate(span, () -> this.wrapped.del(keys));
    }

    public Long del(byte[] key) {
        Span span = this.helper.buildSpan("del", key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.del(key));
    }

    public Long unlink(byte[] ... keys) {
        Span span = this.helper.buildSpan("unlink", keys);
        return (Long)this.helper.decorate(span, () -> this.wrapped.unlink(keys));
    }

    public Long unlink(byte[] key) {
        Span span = this.helper.buildSpan("unlink", key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.unlink(key));
    }

    public String type(byte[] key) {
        Span span = this.helper.buildSpan("type", key);
        return (String)this.helper.decorate(span, () -> this.wrapped.type(key));
    }

    public String flushDB() {
        Span span = this.helper.buildSpan("flushDB");
        return (String)this.helper.decorate(span, () -> this.wrapped.flushDB());
    }

    public Set<byte[]> keys(byte[] pattern) {
        Span span = this.helper.buildSpan("keys");
        span.setTag("pattern", Arrays.toString(pattern));
        return (Set)this.helper.decorate(span, () -> this.wrapped.keys(pattern));
    }

    public byte[] randomBinaryKey() {
        Span span = this.helper.buildSpan("randomBinaryKey");
        return (byte[])this.helper.decorate(span, () -> this.wrapped.randomBinaryKey());
    }

    public String rename(byte[] oldkey, byte[] newkey) {
        Span span = this.helper.buildSpan("rename");
        span.setTag("oldkey", Arrays.toString(oldkey));
        span.setTag("newkey", Arrays.toString(newkey));
        return (String)this.helper.decorate(span, () -> this.wrapped.rename(oldkey, newkey));
    }

    public Long renamenx(byte[] oldkey, byte[] newkey) {
        Span span = this.helper.buildSpan("renamenx");
        span.setTag("oldkey", Arrays.toString(oldkey));
        span.setTag("newkey", Arrays.toString(newkey));
        return (Long)this.helper.decorate(span, () -> this.wrapped.renamenx(oldkey, newkey));
    }

    public Long dbSize() {
        Span span = this.helper.buildSpan("dbSize");
        return (Long)this.helper.decorate(span, () -> this.wrapped.dbSize());
    }

    public Long expire(byte[] key, int seconds) {
        Span span = this.helper.buildSpan("expire", key);
        span.setTag("seconds", (Number)seconds);
        return (Long)this.helper.decorate(span, () -> this.wrapped.expire(key, seconds));
    }

    public Long expireAt(byte[] key, long unixTime) {
        Span span = this.helper.buildSpan("expireAt", key);
        span.setTag("unixTime", (Number)unixTime);
        return (Long)this.helper.decorate(span, () -> this.wrapped.expireAt(key, unixTime));
    }

    public Long ttl(byte[] key) {
        Span span = this.helper.buildSpan("ttl", key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.ttl(key));
    }

    public Long touch(byte[] ... keys) {
        Span span = this.helper.buildSpan("touch", keys);
        return (Long)this.helper.decorate(span, () -> this.wrapped.touch(keys));
    }

    public Long touch(byte[] key) {
        Span span = this.helper.buildSpan("touch", key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.touch(key));
    }

    public String select(int index) {
        Span span = this.helper.buildSpan("select");
        span.setTag("index", (Number)index);
        return (String)this.helper.decorate(span, () -> this.wrapped.select(index));
    }

    public String swapDB(int index1, int index2) {
        Span span = this.helper.buildSpan("swapDB");
        span.setTag("index1", (Number)index1);
        span.setTag("index2", (Number)index2);
        return (String)this.helper.decorate(span, () -> this.wrapped.swapDB(index1, index2));
    }

    public Long move(byte[] key, int dbIndex) {
        Span span = this.helper.buildSpan("move", key);
        span.setTag("dbIndex", (Number)dbIndex);
        return (Long)this.helper.decorate(span, () -> this.wrapped.move(key, dbIndex));
    }

    public String flushAll() {
        Span span = this.helper.buildSpan("flushAll");
        return (String)this.helper.decorate(span, () -> this.wrapped.flushAll());
    }

    public byte[] getSet(byte[] key, byte[] value) {
        Span span = this.helper.buildSpan("getSet", key);
        span.setTag("value", Arrays.toString(value));
        return (byte[])this.helper.decorate(span, () -> this.wrapped.getSet(key, value));
    }

    public List<byte[]> mget(byte[] ... keys) {
        Span span = this.helper.buildSpan("mget");
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        return (List)this.helper.decorate(span, () -> this.wrapped.mget(keys));
    }

    public Long setnx(byte[] key, byte[] value) {
        Span span = this.helper.buildSpan("setnx", key);
        span.setTag("value", Arrays.toString(value));
        return (Long)this.helper.decorate(span, () -> this.wrapped.setnx(key, value));
    }

    public String setex(byte[] key, int seconds, byte[] value) {
        Span span = this.helper.buildSpan("setex", key);
        span.setTag("value", Arrays.toString(value));
        span.setTag("seconds", (Number)seconds);
        return (String)this.helper.decorate(span, () -> this.wrapped.setex(key, seconds, value));
    }

    public String mset(byte[] ... keysvalues) {
        Span span = this.helper.buildSpan("mset");
        span.setTag("keysvalues", TracingHelper.toString((byte[][])keysvalues));
        return (String)this.helper.decorate(span, () -> this.wrapped.mset(keysvalues));
    }

    public Long msetnx(byte[] ... keysvalues) {
        Span span = this.helper.buildSpan("msetnx");
        span.setTag("keysvalues", TracingHelper.toString((byte[][])keysvalues));
        return (Long)this.helper.decorate(span, () -> this.wrapped.msetnx(keysvalues));
    }

    public Long decrBy(byte[] key, long integer) {
        Span span = this.helper.buildSpan("decrBy", key);
        span.setTag("integer", (Number)integer);
        return (Long)this.helper.decorate(span, () -> this.wrapped.decrBy(key, integer));
    }

    public Long decr(byte[] key) {
        Span span = this.helper.buildSpan("decr", key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.decr(key));
    }

    public Long incrBy(byte[] key, long integer) {
        Span span = this.helper.buildSpan("incrBy", key);
        span.setTag("integer", (Number)integer);
        return (Long)this.helper.decorate(span, () -> this.wrapped.incrBy(key, integer));
    }

    public Double incrByFloat(byte[] key, double integer) {
        Span span = this.helper.buildSpan("incrByFloat", key);
        span.setTag("integer", (Number)integer);
        return (Double)this.helper.decorate(span, () -> this.wrapped.incrByFloat(key, integer));
    }

    public Long incr(byte[] key) {
        Span span = this.helper.buildSpan("incr", key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.incr(key));
    }

    public Long append(byte[] key, byte[] value) {
        Span span = this.helper.buildSpan("append", key);
        span.setTag("value", Arrays.toString(value));
        return (Long)this.helper.decorate(span, () -> this.wrapped.append(key, value));
    }

    public byte[] substr(byte[] key, int start, int end) {
        Span span = this.helper.buildSpan("substr", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return (byte[])this.helper.decorate(span, () -> this.wrapped.substr(key, start, end));
    }

    public Long hset(byte[] key, byte[] field, byte[] value) {
        Span span = this.helper.buildSpan("hset", key);
        span.setTag("field", Arrays.toString(field));
        span.setTag("value", Arrays.toString(value));
        return (Long)this.helper.decorate(span, () -> this.wrapped.hset(key, field, value));
    }

    public Long hset(byte[] key, Map<byte[], byte[]> hash) {
        Span span = this.helper.buildSpan("hset", key);
        span.setTag("hash", TracingHelper.toStringMap(hash));
        return (Long)this.helper.decorate(span, () -> this.wrapped.hset(key, hash));
    }

    public byte[] hget(byte[] key, byte[] field) {
        Span span = this.helper.buildSpan("hget", key);
        span.setTag("field", Arrays.toString(field));
        return (byte[])this.helper.decorate(span, () -> this.wrapped.hget(key, field));
    }

    public Long hsetnx(byte[] key, byte[] field, byte[] value) {
        Span span = this.helper.buildSpan("hsetnx", key);
        span.setTag("field", Arrays.toString(field));
        span.setTag("value", Arrays.toString(value));
        return (Long)this.helper.decorate(span, () -> this.wrapped.hsetnx(key, field, value));
    }

    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        Span span = this.helper.buildSpan("hmset", key);
        span.setTag("hash", TracingHelper.toStringMap(hash));
        return (String)this.helper.decorate(span, () -> this.wrapped.hmset(key, hash));
    }

    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        Span span = this.helper.buildSpan("hmget", key);
        span.setTag("fields", TracingHelper.toString((byte[][])fields));
        return (List)this.helper.decorate(span, () -> this.wrapped.hmget(key, fields));
    }

    public Long hincrBy(byte[] key, byte[] field, long value) {
        Span span = this.helper.buildSpan("hincrBy", key);
        span.setTag("field", Arrays.toString(field));
        span.setTag("value", (Number)value);
        return (Long)this.helper.decorate(span, () -> this.wrapped.hincrBy(key, field, value));
    }

    public Double hincrByFloat(byte[] key, byte[] field, double value) {
        Span span = this.helper.buildSpan("hincrByFloat", key);
        span.setTag("field", Arrays.toString(field));
        span.setTag("value", (Number)value);
        return (Double)this.helper.decorate(span, () -> this.wrapped.hincrByFloat(key, field, value));
    }

    public Boolean hexists(byte[] key, byte[] field) {
        Span span = this.helper.buildSpan("hexists", key);
        span.setTag("field", Arrays.toString(field));
        return (Boolean)this.helper.decorate(span, () -> this.wrapped.hexists(key, field));
    }

    public Long hdel(byte[] key, byte[] ... fields) {
        Span span = this.helper.buildSpan("hdel", key);
        span.setTag("fields", TracingHelper.toString((byte[][])fields));
        return (Long)this.helper.decorate(span, () -> this.wrapped.hdel(key, fields));
    }

    public Long hlen(byte[] key) {
        Span span = this.helper.buildSpan("hlen", key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.hlen(key));
    }

    public Set<byte[]> hkeys(byte[] key) {
        Span span = this.helper.buildSpan("hkeys", key);
        return (Set)this.helper.decorate(span, () -> this.wrapped.hkeys(key));
    }

    public List<byte[]> hvals(byte[] key) {
        Span span = this.helper.buildSpan("hvals", key);
        return (List)this.helper.decorate(span, () -> this.wrapped.hvals(key));
    }

    public Map<byte[], byte[]> hgetAll(byte[] key) {
        Span span = this.helper.buildSpan("hgetAll", key);
        return (Map)this.helper.decorate(span, () -> this.wrapped.hgetAll(key));
    }

    public Long rpush(byte[] key, byte[] ... strings) {
        Span span = this.helper.buildSpan("rpush", key);
        span.setTag("strings", TracingHelper.toString((byte[][])strings));
        return (Long)this.helper.decorate(span, () -> this.wrapped.rpush(key, strings));
    }

    public Long lpush(byte[] key, byte[] ... strings) {
        Span span = this.helper.buildSpan("lpush", key);
        span.setTag("strings", TracingHelper.toString((byte[][])strings));
        return (Long)this.helper.decorate(span, () -> this.wrapped.lpush(key, strings));
    }

    public Long llen(byte[] key) {
        Span span = this.helper.buildSpan("llen", key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.llen(key));
    }

    public List<byte[]> lrange(byte[] key, long start, long end) {
        Span span = this.helper.buildSpan("lrange", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return (List)this.helper.decorate(span, () -> this.wrapped.lrange(key, start, end));
    }

    public String ltrim(byte[] key, long start, long end) {
        Span span = this.helper.buildSpan("ltrim", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return (String)this.helper.decorate(span, () -> this.wrapped.ltrim(key, start, end));
    }

    public byte[] lindex(byte[] key, long index) {
        Span span = this.helper.buildSpan("lindex", key);
        span.setTag("index", (Number)index);
        return (byte[])this.helper.decorate(span, () -> this.wrapped.lindex(key, index));
    }

    public String lset(byte[] key, long index, byte[] value) {
        Span span = this.helper.buildSpan("lset", key);
        span.setTag("index", (Number)index);
        span.setTag("value", Arrays.toString(value));
        return (String)this.helper.decorate(span, () -> this.wrapped.lset(key, index, value));
    }

    public Long lrem(byte[] key, long count, byte[] value) {
        Span span = this.helper.buildSpan("lrem", key);
        span.setTag("count", (Number)count);
        span.setTag("value", Arrays.toString(value));
        return (Long)this.helper.decorate(span, () -> this.wrapped.lrem(key, count, value));
    }

    public byte[] lpop(byte[] key) {
        Span span = this.helper.buildSpan("lpop", key);
        return (byte[])this.helper.decorate(span, () -> this.wrapped.lpop(key));
    }

    public byte[] rpop(byte[] key) {
        Span span = this.helper.buildSpan("rpop", key);
        return (byte[])this.helper.decorate(span, () -> this.wrapped.rpop(key));
    }

    public byte[] rpoplpush(byte[] srckey, byte[] dstkey) {
        Span span = this.helper.buildSpan("rpoplpush");
        span.setTag("srckey", Arrays.toString(srckey));
        span.setTag("dstkey", Arrays.toString(dstkey));
        return (byte[])this.helper.decorate(span, () -> this.wrapped.rpoplpush(srckey, dstkey));
    }

    public Long sadd(byte[] key, byte[] ... members) {
        Span span = this.helper.buildSpan("sadd", key);
        span.setTag("members", Arrays.toString((Object[])members));
        return (Long)this.helper.decorate(span, () -> this.wrapped.sadd(key, members));
    }

    public Set<byte[]> smembers(byte[] key) {
        Span span = this.helper.buildSpan("smembers", key);
        return (Set)this.helper.decorate(span, () -> this.wrapped.smembers(key));
    }

    public Long srem(byte[] key, byte[] ... member) {
        Span span = this.helper.buildSpan("srem", key);
        span.setTag("member", Arrays.toString((Object[])member));
        return (Long)this.helper.decorate(span, () -> this.wrapped.srem(key, member));
    }

    public byte[] spop(byte[] key) {
        Span span = this.helper.buildSpan("spop", key);
        return (byte[])this.helper.decorate(span, () -> this.wrapped.spop(key));
    }

    public Set<byte[]> spop(byte[] key, long count) {
        Span span = this.helper.buildSpan("spop", key);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.spop(key, count));
    }

    public Long smove(byte[] srckey, byte[] dstkey, byte[] member) {
        Span span = this.helper.buildSpan("smove");
        span.setTag("srckey", Arrays.toString(srckey));
        span.setTag("dstkey", Arrays.toString(dstkey));
        span.setTag("member", Arrays.toString(member));
        return (Long)this.helper.decorate(span, () -> this.wrapped.smove(srckey, dstkey, member));
    }

    public Long scard(byte[] key) {
        Span span = this.helper.buildSpan("scard", key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.scard(key));
    }

    public Boolean sismember(byte[] key, byte[] member) {
        Span span = this.helper.buildSpan("sismember", key);
        span.setTag("member", Arrays.toString(member));
        return (Boolean)this.helper.decorate(span, () -> this.wrapped.sismember(key, member));
    }

    public Set<byte[]> sinter(byte[] ... keys) {
        Span span = this.helper.buildSpan("sinter");
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        return (Set)this.helper.decorate(span, () -> this.wrapped.sinter(keys));
    }

    public Long sinterstore(byte[] dstkey, byte[] ... keys) {
        Span span = this.helper.buildSpan("sinterstore");
        span.setTag("dstkey", Arrays.toString(dstkey));
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        return (Long)this.helper.decorate(span, () -> this.wrapped.sinterstore(dstkey, keys));
    }

    public Set<byte[]> sunion(byte[] ... keys) {
        Span span = this.helper.buildSpan("sunion");
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        return (Set)this.helper.decorate(span, () -> this.wrapped.sunion(keys));
    }

    public Long sunionstore(byte[] dstkey, byte[] ... keys) {
        Span span = this.helper.buildSpan("sunionstore");
        span.setTag("dstkey", Arrays.toString(dstkey));
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        return (Long)this.helper.decorate(span, () -> this.wrapped.sunionstore(dstkey, keys));
    }

    public Set<byte[]> sdiff(byte[] ... keys) {
        Span span = this.helper.buildSpan("sdiff");
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        return (Set)this.helper.decorate(span, () -> this.wrapped.sdiff(keys));
    }

    public Long sdiffstore(byte[] dstkey, byte[] ... keys) {
        Span span = this.helper.buildSpan("sdiffstore");
        span.setTag("dstkey", Arrays.toString(dstkey));
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        return (Long)this.helper.decorate(span, () -> this.wrapped.sdiffstore(dstkey, keys));
    }

    public byte[] srandmember(byte[] key) {
        Span span = this.helper.buildSpan("srandmember", key);
        return (byte[])this.helper.decorate(span, () -> this.wrapped.srandmember(key));
    }

    public List<byte[]> srandmember(byte[] key, int count) {
        Span span = this.helper.buildSpan("srandmember", key);
        span.setTag("count", (Number)count);
        return (List)this.helper.decorate(span, () -> this.wrapped.srandmember(key, count));
    }

    public Long zadd(byte[] key, double score, byte[] member) {
        Span span = this.helper.buildSpan("zadd", key);
        span.setTag("member", Arrays.toString(member));
        span.setTag("score", (Number)score);
        return (Long)this.helper.decorate(span, () -> this.wrapped.zadd(key, score, member));
    }

    public Long zadd(byte[] key, double score, byte[] member, ZAddParams params) {
        Span span = this.helper.buildSpan("zadd", key);
        span.setTag("member", Arrays.toString(member));
        span.setTag("score", (Number)score);
        span.setTag("params", TracingHelper.toString((byte[][])params.getByteParams()));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zadd(key, score, member, params));
    }

    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        Span span = this.helper.buildSpan("zadd", key);
        span.setTag("scoreMembers", TracingHelper.toStringMap2(scoreMembers));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zadd(key, scoreMembers));
    }

    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params) {
        Span span = this.helper.buildSpan("zadd", key);
        span.setTag("scoreMembers", TracingHelper.toStringMap2(scoreMembers));
        span.setTag("params", TracingHelper.toString((byte[][])params.getByteParams()));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zadd(key, scoreMembers, params));
    }

    public Set<byte[]> zrange(byte[] key, long start, long end) {
        Span span = this.helper.buildSpan("zrange", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrange(key, start, end));
    }

    public Long zrem(byte[] key, byte[] ... members) {
        Span span = this.helper.buildSpan("zrem", key);
        span.setTag("members", Arrays.toString((Object[])members));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zrem(key, members));
    }

    public Double zincrby(byte[] key, double score, byte[] member) {
        Span span = this.helper.buildSpan("zincrby", key);
        span.setTag("member", Arrays.toString(member));
        span.setTag("score", (Number)score);
        return (Double)this.helper.decorate(span, () -> this.wrapped.zincrby(key, score, member));
    }

    public Double zincrby(byte[] key, double increment, byte[] member, ZIncrByParams params) {
        Span span = this.helper.buildSpan("zincrby", key);
        span.setTag("increment", (Number)increment);
        span.setTag("member", Arrays.toString(member));
        span.setTag("params", TracingHelper.toString((byte[][])params.getByteParams()));
        return (Double)this.helper.decorate(span, () -> this.wrapped.zincrby(key, increment, member, params));
    }

    public Long zrank(byte[] key, byte[] member) {
        Span span = this.helper.buildSpan("zrank", key);
        span.setTag("member", Arrays.toString(member));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zrank(key, member));
    }

    public Long zrevrank(byte[] key, byte[] member) {
        Span span = this.helper.buildSpan("zrevrank", key);
        span.setTag("member", Arrays.toString(member));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zrevrank(key, member));
    }

    public Set<byte[]> zrevrange(byte[] key, long start, long end) {
        Span span = this.helper.buildSpan("zrevrange", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrange(key, start, end));
    }

    public Set<Tuple> zrangeWithScores(byte[] key, long start, long end) {
        Span span = this.helper.buildSpan("zrangeWithScores", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeWithScores(key, start, end));
    }

    public Set<Tuple> zrevrangeWithScores(byte[] key, long start, long end) {
        Span span = this.helper.buildSpan("zrevrangeWithScores", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeWithScores(key, start, end));
    }

    public Long zcard(byte[] key) {
        Span span = this.helper.buildSpan("zcard", key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.zcard(key));
    }

    public Double zscore(byte[] key, byte[] member) {
        Span span = this.helper.buildSpan("zscore", key);
        span.setTag("member", Arrays.toString(member));
        return (Double)this.helper.decorate(span, () -> this.wrapped.zscore(key, member));
    }

    public Transaction multi() {
        Span span = this.helper.buildSpan("multi");
        return (Transaction)this.helper.decorate(span, () -> this.wrapped.multi());
    }

    public List<Object> multi(TransactionBlock jedisTransaction) {
        Span span = this.helper.buildSpan("multi");
        return (List)this.helper.decorate(span, () -> this.wrapped.multi(jedisTransaction));
    }

    protected void checkIsInMultiOrPipeline() {
        Span span = this.helper.buildSpan("checkisinmultiorpipeline");
        this.helper.decorate(span, () -> this.wrapped.checkIsInMultiOrPipeline());
    }

    public void connect() {
        Span span = this.helper.buildSpan("connect");
        this.helper.decorate(span, () -> this.wrapped.connect());
    }

    public void disconnect() {
        Span span = this.helper.buildSpan("disconnect");
        this.helper.decorate(span, () -> this.wrapped.disconnect());
    }

    public void resetState() {
        Span span = this.helper.buildSpan("resetState");
        this.helper.decorate(span, () -> this.wrapped.resetState());
    }

    public String watch(byte[] ... keys) {
        Span span = this.helper.buildSpan("watch");
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        return (String)this.helper.decorate(span, () -> this.wrapped.watch(keys));
    }

    public String unwatch() {
        Span span = this.helper.buildSpan("unwatch");
        return (String)this.helper.decorate(span, () -> this.wrapped.unwatch());
    }

    public List<byte[]> sort(byte[] key) {
        Span span = this.helper.buildSpan("sort", key);
        return (List)this.helper.decorate(span, () -> this.wrapped.sort(key));
    }

    public List<byte[]> sort(byte[] key, SortingParams sortingParameters) {
        Span span = this.helper.buildSpan("sort", key);
        span.setTag("sortingParameters", TracingHelper.toString((Collection)sortingParameters.getParams()));
        return (List)this.helper.decorate(span, () -> this.wrapped.sort(key, sortingParameters));
    }

    public List<byte[]> blpop(int timeout, byte[] ... keys) {
        Span span = this.helper.buildSpan("blpop");
        span.setTag("timeout", (Number)timeout);
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        return (List)this.helper.decorate(span, () -> this.wrapped.blpop(timeout, keys));
    }

    public Long sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        Span span = this.helper.buildSpan("sort", key);
        span.setTag("sortingParameters", TracingHelper.toString((Collection)sortingParameters.getParams()));
        span.setTag("dstkey", Arrays.toString(dstkey));
        return (Long)this.helper.decorate(span, () -> this.wrapped.sort(key, sortingParameters, dstkey));
    }

    public Long sort(byte[] key, byte[] dstkey) {
        Span span = this.helper.buildSpan("sort", key);
        span.setTag("dstkey", Arrays.toString(dstkey));
        return (Long)this.helper.decorate(span, () -> this.wrapped.sort(key, dstkey));
    }

    public List<byte[]> brpop(int timeout, byte[] ... keys) {
        Span span = this.helper.buildSpan("brpop");
        span.setTag("timeout", (Number)timeout);
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        return (List)this.helper.decorate(span, () -> this.wrapped.brpop(timeout, keys));
    }

    public List<byte[]> blpop(byte[] arg) {
        Span span = this.helper.buildSpan("blpop");
        span.setTag("arg", Arrays.toString(arg));
        return (List)this.helper.decorate(span, () -> this.wrapped.blpop(arg));
    }

    public List<byte[]> brpop(byte[] arg) {
        Span span = this.helper.buildSpan("brpop");
        span.setTag("arg", Arrays.toString(arg));
        return (List)this.helper.decorate(span, () -> this.wrapped.brpop(arg));
    }

    public List<byte[]> blpop(byte[] ... args) {
        Span span = this.helper.buildSpan("blpop");
        span.setTag("args", TracingHelper.toString((byte[][])args));
        return (List)this.helper.decorate(span, () -> this.wrapped.blpop(args));
    }

    public List<byte[]> brpop(byte[] ... args) {
        Span span = this.helper.buildSpan("brpop");
        span.setTag("args", TracingHelper.toString((byte[][])args));
        return (List)this.helper.decorate(span, () -> this.wrapped.brpop(args));
    }

    public String auth(String password) {
        Span span = this.helper.buildSpan("auth");
        return (String)this.helper.decorate(span, () -> this.wrapped.auth(password));
    }

    public List<Object> pipelined(PipelineBlock jedisPipeline) {
        Span span = this.helper.buildSpan("pipelined");
        return (List)this.helper.decorate(span, () -> this.wrapped.pipelined(jedisPipeline));
    }

    public Pipeline pipelined() {
        Span span = this.helper.buildSpan("pipelined");
        return (Pipeline)this.helper.decorate(span, () -> this.wrapped.pipelined());
    }

    public Long zcount(byte[] key, double min, double max) {
        Span span = this.helper.buildSpan("zcount", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        return (Long)this.helper.decorate(span, () -> this.wrapped.zcount(key, min, max));
    }

    public Long zcount(byte[] key, byte[] min, byte[] max) {
        Span span = this.helper.buildSpan("zcount", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zcount(key, min, max));
    }

    public Set<byte[]> zrangeByScore(byte[] key, double min, double max) {
        Span span = this.helper.buildSpan("zrangeByScore", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeByScore(key, min, max));
    }

    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        Span span = this.helper.buildSpan("zrangeByScore", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeByScore(key, min, max));
    }

    public Set<byte[]> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        Span span = this.helper.buildSpan("zrangeByScore", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeByScore(key, min, max, offset, count));
    }

    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        Span span = this.helper.buildSpan("zrangeByScore", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeByScore(key, min, max, offset, count));
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max) {
        Span span = this.helper.buildSpan("zrangeByScoreWithScores", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeByScoreWithScores(key, min, max));
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        Span span = this.helper.buildSpan("zrangeByScoreWithScores", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeByScoreWithScores(key, min, max));
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        Span span = this.helper.buildSpan("zrangeByScoreWithScores", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeByScoreWithScores(key, min, max, offset, count));
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        Span span = this.helper.buildSpan("zrangeByScoreWithScores", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeByScoreWithScores(key, min, max, offset, count));
    }

    protected Set<Tuple> getTupledSet() {
        Span span = this.helper.buildSpan("gettupledset");
        return (Set)this.helper.decorate(span, () -> this.wrapped.getTupledSet());
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min) {
        Span span = this.helper.buildSpan("zrevrangeByScore", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeByScore(key, max, min));
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        Span span = this.helper.buildSpan("zrevrangeByScore", key);
        span.setTag("max", Arrays.toString(max));
        span.setTag("min", Arrays.toString(min));
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeByScore(key, max, min));
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        Span span = this.helper.buildSpan("zrevrangeByScore", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeByScore(key, max, min, offset, count));
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        Span span = this.helper.buildSpan("zrevrangeByScore", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeByScore(key, max, min, offset, count));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        Span span = this.helper.buildSpan("zrevrangeByScoreWithScores", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeByScoreWithScores(key, max, min));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        Span span = this.helper.buildSpan("zrevrangeByScoreWithScores", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeByScoreWithScores(key, max, min, offset, count));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        Span span = this.helper.buildSpan("zrevrangeByScoreWithScores", key);
        span.setTag("max", Arrays.toString(max));
        span.setTag("min", Arrays.toString(min));
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeByScoreWithScores(key, max, min));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        Span span = this.helper.buildSpan("zrevrangeByScoreWithScores", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeByScoreWithScores(key, max, min, offset, count));
    }

    public Long zremrangeByRank(byte[] key, long start, long end) {
        Span span = this.helper.buildSpan("zremrangeByRank", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return (Long)this.helper.decorate(span, () -> this.wrapped.zremrangeByRank(key, start, end));
    }

    public Long zremrangeByScore(byte[] key, double start, double end) {
        Span span = this.helper.buildSpan("zremrangeByScore", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return (Long)this.helper.decorate(span, () -> this.wrapped.zremrangeByScore(key, start, end));
    }

    public Long zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        Span span = this.helper.buildSpan("zremrangeByScore", key);
        span.setTag("start", Arrays.toString(start));
        span.setTag("end", Arrays.toString(end));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zremrangeByScore(key, start, end));
    }

    public Long zunionstore(byte[] dstkey, byte[] ... sets) {
        Span span = this.helper.buildSpan("zunionstore");
        span.setTag("dstkey", Arrays.toString(dstkey));
        span.setTag("sets", TracingHelper.toString((byte[][])sets));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zunionstore(dstkey, sets));
    }

    public Long zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        Span span = this.helper.buildSpan("zunionstore");
        span.setTag("dstkey", Arrays.toString(dstkey));
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        span.setTag("sets", TracingHelper.toString((byte[][])sets));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zunionstore(dstkey, params, sets));
    }

    public Long zinterstore(byte[] dstkey, byte[] ... sets) {
        Span span = this.helper.buildSpan("zinterstore");
        span.setTag("dstkey", Arrays.toString(dstkey));
        span.setTag("sets", TracingHelper.toString((byte[][])sets));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zinterstore(dstkey, sets));
    }

    public Long zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        Span span = this.helper.buildSpan("zinterstore");
        span.setTag("dstkey", Arrays.toString(dstkey));
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        span.setTag("sets", TracingHelper.toString((byte[][])sets));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zinterstore(dstkey, params, sets));
    }

    public Long zlexcount(byte[] key, byte[] min, byte[] max) {
        Span span = this.helper.buildSpan("zlexcount");
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zlexcount(key, min, max));
    }

    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max) {
        Span span = this.helper.buildSpan("zrangeByLex", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeByLex(key, min, max));
    }

    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        Span span = this.helper.buildSpan("zrangeByLex", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrangeByLex(key, min, max, offset, count));
    }

    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min) {
        Span span = this.helper.buildSpan("zrevrangeByLex", key);
        span.setTag("max", Arrays.toString(max));
        span.setTag("min", Arrays.toString(min));
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeByLex(key, max, min));
    }

    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count) {
        Span span = this.helper.buildSpan("zrevrangeByLex", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.helper.decorate(span, () -> this.wrapped.zrevrangeByLex(key, max, min, offset, count));
    }

    public Long zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        Span span = this.helper.buildSpan("zremrangeByLex", key);
        span.setTag("min", Arrays.toString(min));
        span.setTag("max", Arrays.toString(max));
        return (Long)this.helper.decorate(span, () -> this.wrapped.zremrangeByLex(key, min, max));
    }

    public String save() {
        Span span = this.helper.buildSpan("save");
        return (String)this.helper.decorate(span, () -> this.wrapped.save());
    }

    public String bgsave() {
        Span span = this.helper.buildSpan("bgsave");
        return (String)this.helper.decorate(span, () -> this.wrapped.bgsave());
    }

    public String bgrewriteaof() {
        Span span = this.helper.buildSpan("bgrewriteaof");
        return (String)this.helper.decorate(span, () -> this.wrapped.bgrewriteaof());
    }

    public Long lastsave() {
        Span span = this.helper.buildSpan("lastsave");
        return (Long)this.helper.decorate(span, () -> this.wrapped.lastsave());
    }

    public String shutdown() {
        Span span = this.helper.buildSpan("shutdown");
        return (String)this.helper.decorate(span, () -> this.wrapped.shutdown());
    }

    public String info() {
        Span span = this.helper.buildSpan("info");
        return (String)this.helper.decorate(span, () -> this.wrapped.info());
    }

    public String info(String section) {
        Span span = this.helper.buildSpan("info");
        span.setTag("section", section);
        return (String)this.helper.decorate(span, () -> this.wrapped.info(section));
    }

    public void monitor(JedisMonitor jedisMonitor) {
        Span span = this.helper.buildSpan("monitor");
        this.helper.decorate(span, () -> this.wrapped.monitor(jedisMonitor));
    }

    public String slaveof(String host, int port) {
        Span span = this.helper.buildSpan("slaveof");
        span.setTag("host", host);
        span.setTag("port", (Number)port);
        return (String)this.helper.decorate(span, () -> this.wrapped.slaveof(host, port));
    }

    public String slaveofNoOne() {
        Span span = this.helper.buildSpan("slaveofNoOne");
        return (String)this.helper.decorate(span, () -> this.wrapped.slaveofNoOne());
    }

    public List<byte[]> configGet(byte[] pattern) {
        Span span = this.helper.buildSpan("configGet");
        span.setTag("pattern", Arrays.toString(pattern));
        return (List)this.helper.decorate(span, () -> this.wrapped.configGet(pattern));
    }

    public String configResetStat() {
        Span span = this.helper.buildSpan("configResetStat");
        return (String)this.helper.decorate(span, () -> this.wrapped.configResetStat());
    }

    public String configRewrite() {
        return this.wrapped.configRewrite();
    }

    public byte[] configSet(byte[] parameter, byte[] value) {
        Span span = this.helper.buildSpan("configSet");
        span.setTag("parameter", Arrays.toString(parameter));
        span.setTag("value", Arrays.toString(value));
        return (byte[])this.helper.decorate(span, () -> this.wrapped.configSet(parameter, value));
    }

    public boolean isConnected() {
        Span span = this.helper.buildSpan("isConnected");
        return (Boolean)this.helper.decorate(span, () -> this.wrapped.isConnected());
    }

    public Long strlen(byte[] key) {
        Span span = this.helper.buildSpan("strlen", key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.strlen(key));
    }

    public void sync() {
        Span span = this.helper.buildSpan("sync");
        this.helper.decorate(span, () -> this.wrapped.sync());
    }

    public Long lpushx(byte[] key, byte[] ... string) {
        Span span = this.helper.buildSpan("lpushx", key);
        span.setTag("string", TracingHelper.toString((byte[][])string));
        return (Long)this.helper.decorate(span, () -> this.wrapped.lpushx(key, string));
    }

    public Long persist(byte[] key) {
        Span span = this.helper.buildSpan("persist", key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.persist(key));
    }

    public Long rpushx(byte[] key, byte[] ... string) {
        Span span = this.helper.buildSpan("rpushx", key);
        span.setTag("string", TracingHelper.toString((byte[][])string));
        return (Long)this.helper.decorate(span, () -> this.wrapped.rpushx(key, string));
    }

    public byte[] echo(byte[] string) {
        Span span = this.helper.buildSpan("echo");
        span.setTag("string", Arrays.toString(string));
        return (byte[])this.helper.decorate(span, () -> this.wrapped.echo(string));
    }

    public Long linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        Span span = this.helper.buildSpan("linsert", key);
        span.setTag("where", where.name());
        span.setTag("pivot", Arrays.toString(pivot));
        span.setTag("value", Arrays.toString(value));
        return (Long)this.helper.decorate(span, () -> this.wrapped.linsert(key, where, pivot, value));
    }

    public Long linsert(byte[] key, ListPosition where, byte[] pivot, byte[] value) {
        Span span = this.helper.buildSpan("linsert", key);
        span.setTag("where", where.name());
        span.setTag("pivot", Arrays.toString(pivot));
        span.setTag("value", Arrays.toString(value));
        return (Long)this.helper.decorate(span, () -> this.wrapped.linsert(key, where, pivot, value));
    }

    public String debug(DebugParams params) {
        Span span = this.helper.buildSpan("debug");
        span.setTag("params", Arrays.toString(params.getCommand()));
        return (String)this.helper.decorate(span, () -> this.wrapped.debug(params));
    }

    public Client getClient() {
        Span span = this.helper.buildSpan("getClient");
        return (Client)this.helper.decorate(span, () -> this.wrapped.getClient());
    }

    public byte[] brpoplpush(byte[] source, byte[] destination, int timeout) {
        Span span = this.helper.buildSpan("brpoplpush");
        span.setTag("timeout", (Number)timeout);
        span.setTag("source", Arrays.toString(source));
        span.setTag("destination", Arrays.toString(destination));
        return (byte[])this.helper.decorate(span, () -> this.wrapped.brpoplpush(source, destination, timeout));
    }

    public Boolean setbit(byte[] key, long offset, boolean value) {
        Span span = this.helper.buildSpan("setbit", key);
        span.setTag("offset", (Number)offset);
        span.setTag("value", value);
        return (Boolean)this.helper.decorate(span, () -> this.wrapped.setbit(key, offset, value));
    }

    public Boolean setbit(byte[] key, long offset, byte[] value) {
        Span span = this.helper.buildSpan("setbit", key);
        span.setTag("offset", (Number)offset);
        span.setTag("value", Arrays.toString(value));
        return (Boolean)this.helper.decorate(span, () -> this.wrapped.setbit(key, offset, value));
    }

    public Boolean getbit(byte[] key, long offset) {
        Span span = this.helper.buildSpan("getbit", key);
        span.setTag("offset", (Number)offset);
        return (Boolean)this.helper.decorate(span, () -> this.wrapped.getbit(key, offset));
    }

    public Long bitpos(byte[] key, boolean value) {
        Span span = this.helper.buildSpan("bitpos", key);
        span.setTag("value", value);
        return (Long)this.helper.decorate(span, () -> this.wrapped.bitpos(key, value));
    }

    public Long bitpos(byte[] key, boolean value, BitPosParams params) {
        Span span = this.helper.buildSpan("bitpos", key);
        span.setTag("value", value);
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        return (Long)this.helper.decorate(span, () -> this.wrapped.bitpos(key, value, params));
    }

    public Long setrange(byte[] key, long offset, byte[] value) {
        Span span = this.helper.buildSpan("setrange", key);
        span.setTag("offset", (Number)offset);
        span.setTag("value", Arrays.toString(value));
        return (Long)this.helper.decorate(span, () -> this.wrapped.setrange(key, offset, value));
    }

    public byte[] getrange(byte[] key, long startOffset, long endOffset) {
        Span span = this.helper.buildSpan("getrange", key);
        span.setTag("startOffset", (Number)startOffset);
        span.setTag("endOffset", (Number)endOffset);
        return (byte[])this.helper.decorate(span, () -> this.wrapped.getrange(key, startOffset, endOffset));
    }

    public Long publish(byte[] channel, byte[] message) {
        Span span = this.helper.buildSpan("publish");
        span.setTag("channel", Arrays.toString(channel));
        span.setTag("message", Arrays.toString(message));
        return (Long)this.helper.decorate(span, () -> this.wrapped.publish(channel, message));
    }

    public void subscribe(BinaryJedisPubSub jedisPubSub, byte[] ... channels) {
        Span span = this.helper.buildSpan("subscribe");
        span.setTag("channels", Arrays.toString((Object[])channels));
        this.helper.decorate(span, () -> this.wrapped.subscribe(jedisPubSub, channels));
    }

    public void psubscribe(BinaryJedisPubSub jedisPubSub, byte[] ... patterns) {
        Span span = this.helper.buildSpan("psubscribe");
        span.setTag("patterns", Arrays.toString((Object[])patterns));
        this.helper.decorate(span, () -> this.wrapped.psubscribe(jedisPubSub, patterns));
    }

    public Long getDB() {
        Span span = this.helper.buildSpan("getDB");
        return (Long)this.helper.decorate(span, () -> this.wrapped.getDB());
    }

    public Object eval(byte[] script, List<byte[]> keys, List<byte[]> args) {
        Span span = this.helper.buildSpan("eval");
        span.setTag("script", Arrays.toString(script));
        span.setTag("keys", TracingHelper.toString(keys));
        span.setTag("args", TracingHelper.toString(args));
        return this.helper.decorate(span, () -> this.wrapped.eval(script, keys, args));
    }

    public Object eval(byte[] script, byte[] keyCount, byte[] ... params) {
        Span span = this.helper.buildSpan("eval");
        span.setTag("script", Arrays.toString(script));
        span.setTag("keyCount", Arrays.toString(keyCount));
        span.setTag("params", TracingHelper.toString((byte[][])params));
        return this.helper.decorate(span, () -> this.wrapped.eval(script, keyCount, params));
    }

    public Object eval(byte[] script, int keyCount, byte[] ... params) {
        Span span = this.helper.buildSpan("eval");
        span.setTag("script", Arrays.toString(script));
        span.setTag("keyCount", (Number)keyCount);
        span.setTag("params", TracingHelper.toString((byte[][])params));
        return this.helper.decorate(span, () -> this.wrapped.eval(script, keyCount, params));
    }

    public Object eval(byte[] script) {
        Span span = this.helper.buildSpan("eval");
        span.setTag("script", Arrays.toString(script));
        return this.helper.decorate(span, () -> this.wrapped.eval(script));
    }

    public Object evalsha(byte[] sha1) {
        Span span = this.helper.buildSpan("evalsha");
        span.setTag("sha1", Arrays.toString(sha1));
        return this.helper.decorate(span, () -> this.wrapped.evalsha(sha1));
    }

    public Object evalsha(byte[] sha1, List<byte[]> keys, List<byte[]> args) {
        Span span = this.helper.buildSpan("evalsha");
        span.setTag("sha1", Arrays.toString(sha1));
        span.setTag("keys", TracingHelper.toString(keys));
        span.setTag("args", TracingHelper.toString(args));
        return this.helper.decorate(span, () -> this.wrapped.evalsha(sha1, keys, args));
    }

    public Object evalsha(byte[] sha1, int keyCount, byte[] ... params) {
        Span span = this.helper.buildSpan("evalsha");
        span.setTag("params", TracingHelper.toString((byte[][])params));
        span.setTag("sha1", Arrays.toString(sha1));
        span.setTag("keyCount", (Number)keyCount);
        return this.helper.decorate(span, () -> this.wrapped.evalsha(sha1, keyCount, params));
    }

    public String scriptFlush() {
        Span span = this.helper.buildSpan("scriptFlush");
        return (String)this.helper.decorate(span, () -> this.wrapped.scriptFlush());
    }

    public Long scriptExists(byte[] sha1) {
        Span span = this.helper.buildSpan("scriptExists");
        span.setTag("sha1", Arrays.toString(sha1));
        return (Long)this.helper.decorate(span, () -> this.wrapped.scriptExists(sha1));
    }

    public List<Long> scriptExists(byte[] ... sha1) {
        Span span = this.helper.buildSpan("scriptExists");
        span.setTag("sha1", TracingHelper.toString((byte[][])sha1));
        return (List)this.helper.decorate(span, () -> this.wrapped.scriptExists(sha1));
    }

    public byte[] scriptLoad(byte[] script) {
        Span span = this.helper.buildSpan("scriptLoad");
        span.setTag("script", Arrays.toString(script));
        return (byte[])this.helper.decorate(span, () -> this.wrapped.scriptLoad(script));
    }

    public String scriptKill() {
        Span span = this.helper.buildSpan("scriptKill");
        return (String)this.helper.decorate(span, () -> this.wrapped.scriptKill());
    }

    public String slowlogReset() {
        Span span = this.helper.buildSpan("slowlogReset");
        return (String)this.helper.decorate(span, () -> this.wrapped.slowlogReset());
    }

    public Long slowlogLen() {
        Span span = this.helper.buildSpan("slowlogLen");
        return (Long)this.helper.decorate(span, () -> this.wrapped.slowlogLen());
    }

    public List<byte[]> slowlogGetBinary() {
        Span span = this.helper.buildSpan("slowlogGetBinary");
        return (List)this.helper.decorate(span, () -> this.wrapped.slowlogGetBinary());
    }

    public List<byte[]> slowlogGetBinary(long entries) {
        Span span = this.helper.buildSpan("slowlogGetBinary");
        span.setTag("entries", (Number)entries);
        return (List)this.helper.decorate(span, () -> this.wrapped.slowlogGetBinary(entries));
    }

    public Long objectRefcount(byte[] key) {
        Span span = this.helper.buildSpan("objectRefcount", key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.objectRefcount(key));
    }

    public byte[] objectEncoding(byte[] key) {
        Span span = this.helper.buildSpan("objectEncoding", key);
        return (byte[])this.helper.decorate(span, () -> this.wrapped.objectEncoding(key));
    }

    public Long objectIdletime(byte[] key) {
        Span span = this.helper.buildSpan("objectIdletime", key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.objectIdletime(key));
    }

    public Long bitcount(byte[] key) {
        Span span = this.helper.buildSpan("bitcount", key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.bitcount(key));
    }

    public Long bitcount(byte[] key, long start, long end) {
        Span span = this.helper.buildSpan("bitcount", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return (Long)this.helper.decorate(span, () -> this.wrapped.bitcount(key, start, end));
    }

    public Long bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        Span span = this.helper.buildSpan("bitop");
        span.setTag("destKey", Arrays.toString(destKey));
        span.setTag("srcKeys", TracingHelper.toString((byte[][])srcKeys));
        return (Long)this.helper.decorate(span, () -> this.wrapped.bitop(op, destKey, srcKeys));
    }

    public byte[] dump(byte[] key) {
        Span span = this.helper.buildSpan("dump", key);
        return (byte[])this.helper.decorate(span, () -> this.wrapped.dump(key));
    }

    public String restore(byte[] key, int ttl, byte[] serializedValue) {
        Span span = this.helper.buildSpan("restore", key);
        span.setTag("ttl", (Number)ttl);
        span.setTag("serializedValue", Arrays.toString(serializedValue));
        return (String)this.helper.decorate(span, () -> this.wrapped.restore(key, ttl, serializedValue));
    }

    public String restoreReplace(byte[] key, int ttl, byte[] serializedValue) {
        Span span = this.helper.buildSpan("restoreReplace", key);
        span.setTag("ttl", (Number)ttl);
        span.setTag("serializedValue", Arrays.toString(serializedValue));
        return (String)this.helper.decorate(span, () -> this.wrapped.restoreReplace(key, ttl, serializedValue));
    }

    public Long pexpire(byte[] key, int milliseconds) {
        Span span = this.helper.buildSpan("pexpire", key);
        span.setTag("milliseconds", (Number)milliseconds);
        return (Long)this.helper.decorate(span, () -> this.wrapped.pexpire(key, milliseconds));
    }

    public Long pexpire(byte[] key, long milliseconds) {
        Span span = this.helper.buildSpan("pexpire", key);
        span.setTag("milliseconds", (Number)milliseconds);
        return (Long)this.helper.decorate(span, () -> this.wrapped.pexpire(key, milliseconds));
    }

    public Long pexpireAt(byte[] key, long millisecondsTimestamp) {
        Span span = this.helper.buildSpan("pexpireAt", key);
        span.setTag("millisecondsTimestamp", (Number)millisecondsTimestamp);
        return (Long)this.helper.decorate(span, () -> this.wrapped.pexpireAt(key, millisecondsTimestamp));
    }

    public Long pttl(byte[] key) {
        Span span = this.helper.buildSpan("pttl", key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.pttl(key));
    }

    public String psetex(byte[] key, int milliseconds, byte[] value) {
        Span span = this.helper.buildSpan("psetex", key);
        span.setTag("value", Arrays.toString(value));
        span.setTag("milliseconds", (Number)milliseconds);
        return (String)this.helper.decorate(span, () -> this.wrapped.psetex(key, milliseconds, value));
    }

    public String psetex(byte[] key, long milliseconds, byte[] value) {
        Span span = this.helper.buildSpan("psetex", key);
        span.setTag("milliseconds", (Number)milliseconds);
        span.setTag("value", Arrays.toString(value));
        return (String)this.helper.decorate(span, () -> this.wrapped.psetex(key, milliseconds, value));
    }

    public String set(byte[] key, byte[] value, byte[] nxxx) {
        Span span = this.helper.buildSpan("set", key);
        span.setTag("nxxx", Arrays.toString(nxxx));
        span.setTag("value", Arrays.toString(value));
        return (String)this.helper.decorate(span, () -> this.wrapped.set(key, value, nxxx));
    }

    public String set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, int time) {
        Span span = this.helper.buildSpan("set", key);
        span.setTag("nxxx", Arrays.toString(nxxx));
        span.setTag("expx", Arrays.toString(expx));
        span.setTag("time", (Number)time);
        span.setTag("value", Arrays.toString(value));
        return (String)this.helper.decorate(span, () -> this.wrapped.set(key, value, nxxx, expx, time));
    }

    public String clientKill(byte[] client) {
        Span span = this.helper.buildSpan("clientKill");
        span.setTag("client", Arrays.toString(client));
        return (String)this.helper.decorate(span, () -> this.wrapped.clientKill(client));
    }

    public String clientKill(String ip, int port) {
        Span span = this.helper.buildSpan("clientKill");
        span.setTag("ip", ip);
        span.setTag("port", (Number)port);
        return (String)this.helper.decorate(span, () -> this.wrapped.clientKill(ip, port));
    }

    public byte[] clientGetnameBinary() {
        Span span = this.helper.buildSpan("clientGetnameBinary");
        return (byte[])this.helper.decorate(span, () -> ((Jedis)this.wrapped).clientGetnameBinary());
    }

    public byte[] clientListBinary() {
        Span span = this.helper.buildSpan("clientListBinary");
        return (byte[])this.helper.decorate(span, () -> ((Jedis)this.wrapped).clientListBinary());
    }

    public String clientSetname(byte[] name) {
        Span span = this.helper.buildSpan("clientSetname");
        span.setTag("name", Arrays.toString(name));
        return (String)this.helper.decorate(span, () -> this.wrapped.clientSetname(name));
    }

    public String clientPause(long timeout) {
        Span span = this.helper.buildSpan("clientPause");
        span.setTag("timeout", (Number)timeout);
        return (String)this.helper.decorate(span, () -> this.wrapped.clientPause(timeout));
    }

    public List<String> time() {
        Span span = this.helper.buildSpan("time");
        return (List)this.helper.decorate(span, () -> this.wrapped.time());
    }

    public String migrate(byte[] host, int port, byte[] key, int destinationDb, int timeout) {
        Span span = this.helper.buildSpan("migrate", key);
        span.setTag("host", Arrays.toString(host));
        span.setTag("destinationDb", (Number)destinationDb);
        span.setTag("timeout", (Number)timeout);
        span.setTag("port", (Number)port);
        return (String)this.helper.decorate(span, () -> this.wrapped.migrate(host, port, key, destinationDb, timeout));
    }

    public String migrate(String host, int port, byte[] key, int destinationDb, int timeout) {
        Span span = this.helper.buildSpan("migrate", key);
        span.setTag("host", host);
        span.setTag("port", (Number)port);
        span.setTag("destinationDb", (Number)destinationDb);
        span.setTag("timeout", (Number)timeout);
        return (String)this.helper.decorate(span, () -> this.wrapped.migrate(host, port, key, destinationDb, timeout));
    }

    public Long waitReplicas(int replicas, long timeout) {
        Span span = this.helper.buildSpan("waitReplicas");
        span.setTag("replicas", (Number)replicas);
        span.setTag("timeout", (Number)timeout);
        return (Long)this.helper.decorate(span, () -> this.wrapped.waitReplicas(replicas, timeout));
    }

    public Long pfadd(byte[] key, byte[] ... elements) {
        Span span = this.helper.buildSpan("pfadd", key);
        span.setTag("elements", TracingHelper.toString((byte[][])elements));
        return (Long)this.helper.decorate(span, () -> this.wrapped.pfadd(key, elements));
    }

    public long pfcount(byte[] key) {
        Span span = this.helper.buildSpan("pfcount", key);
        return (Long)this.helper.decorate(span, () -> this.wrapped.pfcount(key));
    }

    public String pfmerge(byte[] destkey, byte[] ... sourcekeys) {
        Span span = this.helper.buildSpan("pfmerge");
        span.setTag("destkey", Arrays.toString(destkey));
        span.setTag("sourcekeys", TracingHelper.toString((byte[][])sourcekeys));
        return (String)this.helper.decorate(span, () -> this.wrapped.pfmerge(destkey, sourcekeys));
    }

    public Long pfcount(byte[] ... keys) {
        Span span = this.helper.buildSpan("pfcount");
        span.setTag("keys", TracingHelper.toString((byte[][])keys));
        return (Long)this.helper.decorate(span, () -> this.wrapped.pfcount(keys));
    }

    public ScanResult<byte[]> scan(byte[] cursor) {
        Span span = this.helper.buildSpan("scan");
        span.setTag("cursor", Arrays.toString(cursor));
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.scan(cursor));
    }

    public ScanResult<byte[]> scan(byte[] cursor, ScanParams params) {
        Span span = this.helper.buildSpan("scan");
        span.setTag("cursor", Arrays.toString(cursor));
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.scan(cursor, params));
    }

    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor) {
        Span span = this.helper.buildSpan("hscan", key);
        span.setTag("cursor", Arrays.toString(cursor));
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.hscan(key, cursor));
    }

    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor, ScanParams params) {
        Span span = this.helper.buildSpan("hscan", key);
        span.setTag("cursor", Arrays.toString(cursor));
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.hscan(key, cursor, params));
    }

    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor) {
        Span span = this.helper.buildSpan("sscan", key);
        span.setTag("cursor", Arrays.toString(cursor));
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.sscan(key, cursor));
    }

    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor, ScanParams params) {
        Span span = this.helper.buildSpan("sscan", key);
        span.setTag("cursor", Arrays.toString(cursor));
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.sscan(key, cursor, params));
    }

    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor) {
        Span span = this.helper.buildSpan("zscan", key);
        span.setTag("cursor", Arrays.toString(cursor));
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.zscan(key, cursor));
    }

    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor, ScanParams params) {
        Span span = this.helper.buildSpan("zscan", key);
        span.setTag("cursor", Arrays.toString(cursor));
        span.setTag("params", TracingHelper.toString((Collection)params.getParams()));
        return (ScanResult)this.helper.decorate(span, () -> this.wrapped.zscan(key, cursor, params));
    }

    public Long geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        Span span = this.helper.buildSpan("geoadd", key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("member", Arrays.toString(member));
        return (Long)this.helper.decorate(span, () -> this.wrapped.geoadd(key, longitude, latitude, member));
    }

    public Long geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        Span span = this.helper.buildSpan("geoadd", key);
        span.setTag("memberCoordinateMap", TracingHelper.toStringMap2(memberCoordinateMap));
        return (Long)this.helper.decorate(span, () -> this.wrapped.geoadd(key, memberCoordinateMap));
    }

    public Double geodist(byte[] key, byte[] member1, byte[] member2) {
        Span span = this.helper.buildSpan("geodist", key);
        span.setTag("member1", Arrays.toString(member1));
        span.setTag("member2", Arrays.toString(member2));
        return (Double)this.helper.decorate(span, () -> this.wrapped.geodist(key, member1, member2));
    }

    public Double geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit) {
        Span span = this.helper.buildSpan("geodist", key);
        span.setTag("member1", Arrays.toString(member1));
        span.setTag("member2", Arrays.toString(member2));
        span.setTag("unit", unit.name());
        return (Double)this.helper.decorate(span, () -> this.wrapped.geodist(key, member1, member2, unit));
    }

    public List<byte[]> geohash(byte[] key, byte[] ... members) {
        Span span = this.helper.buildSpan("geohash", key);
        span.setTag("members", Arrays.toString((Object[])members));
        return (List)this.helper.decorate(span, () -> this.wrapped.geohash(key, members));
    }

    public List<GeoCoordinate> geopos(byte[] key, byte[] ... members) {
        Span span = this.helper.buildSpan("geopos", key);
        span.setTag("members", Arrays.toString((Object[])members));
        return (List)this.helper.decorate(span, () -> this.wrapped.geopos(key, members));
    }

    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        Span span = this.helper.buildSpan("georadius", key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        return (List)this.helper.decorate(span, () -> this.wrapped.georadius(key, longitude, latitude, radius, unit));
    }

    public List<GeoRadiusResponse> georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        Span span = this.helper.buildSpan("georadiusReadonly", key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        return (List)this.helper.decorate(span, () -> this.wrapped.georadiusReadonly(key, longitude, latitude, radius, unit));
    }

    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        Span span = this.helper.buildSpan("georadius", key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        span.setTag("param", TracingHelper.toString((byte[][])param.getByteParams()));
        return (List)this.helper.decorate(span, () -> this.wrapped.georadius(key, longitude, latitude, radius, unit, param));
    }

    public List<GeoRadiusResponse> georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        Span span = this.helper.buildSpan("georadiusReadonly", key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        span.setTag("param", TracingHelper.toString((byte[][])param.getByteParams()));
        return (List)this.helper.decorate(span, () -> this.wrapped.georadiusReadonly(key, longitude, latitude, radius, unit, param));
    }

    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit) {
        Span span = this.helper.buildSpan("georadiusByMember", key);
        span.setTag("member", Arrays.toString(member));
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        return (List)this.helper.decorate(span, () -> this.wrapped.georadiusByMember(key, member, radius, unit));
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit) {
        Span span = this.helper.buildSpan("georadiusByMemberReadonly", key);
        span.setTag("member", Arrays.toString(member));
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        return (List)this.helper.decorate(span, () -> this.wrapped.georadiusByMemberReadonly(key, member, radius, unit));
    }

    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        Span span = this.helper.buildSpan("georadiusByMember", key);
        span.setTag("member", Arrays.toString(member));
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        span.setTag("param", TracingHelper.toString((byte[][])param.getByteParams()));
        return (List)this.helper.decorate(span, () -> this.wrapped.georadiusByMember(key, member, radius, unit, param));
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        Span span = this.helper.buildSpan("georadiusByMemberReadonly", key);
        span.setTag("member", Arrays.toString(member));
        span.setTag("radius", (Number)radius);
        span.setTag("unit", unit.name());
        span.setTag("param", TracingHelper.toString((byte[][])param.getByteParams()));
        return (List)this.helper.decorate(span, () -> this.wrapped.georadiusByMemberReadonly(key, member, radius, unit, param));
    }

    public List<Long> bitfield(byte[] key, byte[] ... arguments) {
        Span span = this.helper.buildSpan("bitfield", key);
        span.setTag("arguments", Arrays.toString((Object[])arguments));
        return (List)this.helper.decorate(span, () -> this.wrapped.bitfield(key, arguments));
    }

    public Long hstrlen(byte[] key, byte[] field) {
        Span span = this.helper.buildSpan("hstrlen", key);
        span.setTag("field", Arrays.toString(field));
        return (Long)this.helper.decorate(span, () -> this.wrapped.hstrlen(key, field));
    }

    public Jedis getWrapped() {
        return this.wrapped;
    }
}

