/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.redisson.TracingRExpirable;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import org.redisson.api.RAtomicDouble;
import org.redisson.api.RExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;

public class TracingRAtomicDouble
extends TracingRExpirable
implements RAtomicDouble {
    private final RAtomicDouble atomicDouble;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRAtomicDouble(RAtomicDouble atomicDouble, TracingRedissonHelper tracingRedissonHelper) {
        super((RExpirable)atomicDouble, tracingRedissonHelper);
        this.atomicDouble = atomicDouble;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public double getAndDecrement() {
        Span span = this.tracingRedissonHelper.buildSpan("getAndDecrement", (RObject)this.atomicDouble);
        return (Double)this.tracingRedissonHelper.decorate(span, () -> ((RAtomicDouble)this.atomicDouble).getAndDecrement());
    }

    public double addAndGet(double delta) {
        Span span = this.tracingRedissonHelper.buildSpan("addAndGet", (RObject)this.atomicDouble);
        span.setTag("delta", (Number)delta);
        return (Double)this.tracingRedissonHelper.decorate(span, () -> this.atomicDouble.addAndGet(delta));
    }

    public boolean compareAndSet(double expect, double update) {
        Span span = this.tracingRedissonHelper.buildSpan("compareAndSet", (RObject)this.atomicDouble);
        span.setTag("expect", (Number)expect);
        span.setTag("update", (Number)update);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.atomicDouble.compareAndSet(expect, update));
    }

    public double decrementAndGet() {
        Span span = this.tracingRedissonHelper.buildSpan("decrementAndGet", (RObject)this.atomicDouble);
        return (Double)this.tracingRedissonHelper.decorate(span, () -> ((RAtomicDouble)this.atomicDouble).decrementAndGet());
    }

    public double get() {
        Span span = this.tracingRedissonHelper.buildSpan("get", (RObject)this.atomicDouble);
        return (Double)this.tracingRedissonHelper.decorate(span, () -> ((RAtomicDouble)this.atomicDouble).get());
    }

    public double getAndDelete() {
        Span span = this.tracingRedissonHelper.buildSpan("getAndDelete", (RObject)this.atomicDouble);
        return (Double)this.tracingRedissonHelper.decorate(span, () -> ((RAtomicDouble)this.atomicDouble).getAndDelete());
    }

    public double getAndAdd(double delta) {
        Span span = this.tracingRedissonHelper.buildSpan("getAndAdd", (RObject)this.atomicDouble);
        span.setTag("delta", (Number)delta);
        return (Double)this.tracingRedissonHelper.decorate(span, () -> this.atomicDouble.getAndAdd(delta));
    }

    public double getAndSet(double newValue) {
        Span span = this.tracingRedissonHelper.buildSpan("getAndSet", (RObject)this.atomicDouble);
        span.setTag("newValue", (Number)newValue);
        return (Double)this.tracingRedissonHelper.decorate(span, () -> this.atomicDouble.getAndSet(newValue));
    }

    public double incrementAndGet() {
        Span span = this.tracingRedissonHelper.buildSpan("incrementAndGet", (RObject)this.atomicDouble);
        return (Double)this.tracingRedissonHelper.decorate(span, () -> ((RAtomicDouble)this.atomicDouble).incrementAndGet());
    }

    public double getAndIncrement() {
        Span span = this.tracingRedissonHelper.buildSpan("getAndIncrement", (RObject)this.atomicDouble);
        return (Double)this.tracingRedissonHelper.decorate(span, () -> ((RAtomicDouble)this.atomicDouble).getAndIncrement());
    }

    public void set(double newValue) {
        Span span = this.tracingRedissonHelper.buildSpan("set", (RObject)this.atomicDouble);
        span.setTag("newValue", (Number)newValue);
        this.tracingRedissonHelper.decorate(span, () -> this.atomicDouble.set(newValue));
    }

    public RFuture<Boolean> compareAndSetAsync(double expect, double update) {
        Span span = this.tracingRedissonHelper.buildSpan("compareAndSetAsync", (RObject)this.atomicDouble);
        span.setTag("expect", (Number)expect);
        span.setTag("update", (Number)update);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.atomicDouble.compareAndSetAsync(expect, update));
    }

    public RFuture<Double> addAndGetAsync(double delta) {
        Span span = this.tracingRedissonHelper.buildSpan("addAndGetAsync", (RObject)this.atomicDouble);
        span.setTag("delta", (Number)delta);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.atomicDouble.addAndGetAsync(delta));
    }

    public RFuture<Double> decrementAndGetAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("decrementAndGetAsync", (RObject)this.atomicDouble);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RAtomicDouble)this.atomicDouble).decrementAndGetAsync());
    }

    public RFuture<Double> getAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("getAsync", (RObject)this.atomicDouble);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RAtomicDouble)this.atomicDouble).getAsync());
    }

    public RFuture<Double> getAndDeleteAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("getAndDeleteAsync", (RObject)this.atomicDouble);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RAtomicDouble)this.atomicDouble).getAndDeleteAsync());
    }

    public RFuture<Double> getAndAddAsync(double delta) {
        Span span = this.tracingRedissonHelper.buildSpan("getAndAddAsync", (RObject)this.atomicDouble);
        span.setTag("delta", (Number)delta);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.atomicDouble.getAndAddAsync(delta));
    }

    public RFuture<Double> getAndSetAsync(double newValue) {
        Span span = this.tracingRedissonHelper.buildSpan("getAndSetAsync", (RObject)this.atomicDouble);
        span.setTag("newValue", (Number)newValue);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.atomicDouble.getAndSetAsync(newValue));
    }

    public RFuture<Double> incrementAndGetAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("incrementAndGetAsync", (RObject)this.atomicDouble);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RAtomicDouble)this.atomicDouble).incrementAndGetAsync());
    }

    public RFuture<Double> getAndIncrementAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("getAndIncrementAsync", (RObject)this.atomicDouble);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RAtomicDouble)this.atomicDouble).getAndIncrementAsync());
    }

    public RFuture<Double> getAndDecrementAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("getAndDecrementAsync", (RObject)this.atomicDouble);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RAtomicDouble)this.atomicDouble).getAndDecrementAsync());
    }

    public RFuture<Void> setAsync(double newValue) {
        Span span = this.tracingRedissonHelper.buildSpan("setAsync", (RObject)this.atomicDouble);
        span.setTag("newValue", (Number)newValue);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.atomicDouble.setAsync(newValue));
    }
}

