/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.redisson.TracingRExpirable;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;

public class TracingRAtomicLong
extends TracingRExpirable
implements RAtomicLong {
    private final RAtomicLong atomicLong;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRAtomicLong(RAtomicLong atomicLong, TracingRedissonHelper tracingRedissonHelper) {
        super((RExpirable)atomicLong, tracingRedissonHelper);
        this.atomicLong = atomicLong;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public long getAndDecrement() {
        Span span = this.tracingRedissonHelper.buildSpan("getAndDecrement", (RObject)this.atomicLong);
        return (Long)this.tracingRedissonHelper.decorate(span, () -> ((RAtomicLong)this.atomicLong).getAndDecrement());
    }

    public long addAndGet(long delta) {
        Span span = this.tracingRedissonHelper.buildSpan("addAndGet", (RObject)this.atomicLong);
        span.setTag("delta", (Number)delta);
        return (Long)this.tracingRedissonHelper.decorate(span, () -> this.atomicLong.addAndGet(delta));
    }

    public boolean compareAndSet(long expect, long update) {
        Span span = this.tracingRedissonHelper.buildSpan("compareAndSet", (RObject)this.atomicLong);
        span.setTag("expect", (Number)expect);
        span.setTag("update", (Number)update);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.atomicLong.compareAndSet(expect, update));
    }

    public long decrementAndGet() {
        Span span = this.tracingRedissonHelper.buildSpan("decrementAndGet", (RObject)this.atomicLong);
        return (Long)this.tracingRedissonHelper.decorate(span, () -> ((RAtomicLong)this.atomicLong).decrementAndGet());
    }

    public long get() {
        Span span = this.tracingRedissonHelper.buildSpan("get", (RObject)this.atomicLong);
        return (Long)this.tracingRedissonHelper.decorate(span, () -> ((RAtomicLong)this.atomicLong).get());
    }

    public long getAndDelete() {
        Span span = this.tracingRedissonHelper.buildSpan("getAndDelete", (RObject)this.atomicLong);
        return (Long)this.tracingRedissonHelper.decorate(span, () -> ((RAtomicLong)this.atomicLong).getAndDelete());
    }

    public long getAndAdd(long delta) {
        Span span = this.tracingRedissonHelper.buildSpan("getAndAdd", (RObject)this.atomicLong);
        span.setTag("delta", (Number)delta);
        return (Long)this.tracingRedissonHelper.decorate(span, () -> this.atomicLong.getAndAdd(delta));
    }

    public long getAndSet(long newValue) {
        Span span = this.tracingRedissonHelper.buildSpan("getAndSet", (RObject)this.atomicLong);
        span.setTag("newValue", (Number)newValue);
        return (Long)this.tracingRedissonHelper.decorate(span, () -> this.atomicLong.getAndSet(newValue));
    }

    public long incrementAndGet() {
        Span span = this.tracingRedissonHelper.buildSpan("incrementAndGet", (RObject)this.atomicLong);
        return (Long)this.tracingRedissonHelper.decorate(span, () -> ((RAtomicLong)this.atomicLong).incrementAndGet());
    }

    public long getAndIncrement() {
        Span span = this.tracingRedissonHelper.buildSpan("getAndIncrement", (RObject)this.atomicLong);
        return (Long)this.tracingRedissonHelper.decorate(span, () -> ((RAtomicLong)this.atomicLong).getAndIncrement());
    }

    public void set(long newValue) {
        Span span = this.tracingRedissonHelper.buildSpan("set", (RObject)this.atomicLong);
        span.setTag("newValue", (Number)newValue);
        this.tracingRedissonHelper.decorate(span, () -> this.atomicLong.set(newValue));
    }

    public RFuture<Boolean> compareAndSetAsync(long expect, long update) {
        Span span = this.tracingRedissonHelper.buildSpan("compareAndSetAsync", (RObject)this.atomicLong);
        span.setTag("expect", (Number)expect);
        span.setTag("update", (Number)update);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.atomicLong.compareAndSetAsync(expect, update));
    }

    public RFuture<Long> addAndGetAsync(long delta) {
        Span span = this.tracingRedissonHelper.buildSpan("addAndGetAsync", (RObject)this.atomicLong);
        span.setTag("delta", (Number)delta);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.atomicLong.addAndGetAsync(delta));
    }

    public RFuture<Long> decrementAndGetAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("decrementAndGetAsync", (RObject)this.atomicLong);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RAtomicLong)this.atomicLong).decrementAndGetAsync());
    }

    public RFuture<Long> getAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("getAsync", (RObject)this.atomicLong);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RAtomicLong)this.atomicLong).getAsync());
    }

    public RFuture<Long> getAndDeleteAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("getAndDeleteAsync", (RObject)this.atomicLong);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RAtomicLong)this.atomicLong).getAndDeleteAsync());
    }

    public RFuture<Long> getAndAddAsync(long delta) {
        Span span = this.tracingRedissonHelper.buildSpan("getAndAddAsync", (RObject)this.atomicLong);
        span.setTag("delta", (Number)delta);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.atomicLong.getAndAddAsync(delta));
    }

    public RFuture<Long> getAndSetAsync(long newValue) {
        Span span = this.tracingRedissonHelper.buildSpan("getAndSetAsync", (RObject)this.atomicLong);
        span.setTag("newValue", (Number)newValue);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.atomicLong.getAndSetAsync(newValue));
    }

    public RFuture<Long> incrementAndGetAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("incrementAndGetAsync", (RObject)this.atomicLong);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RAtomicLong)this.atomicLong).incrementAndGetAsync());
    }

    public RFuture<Long> getAndIncrementAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("getAndIncrementAsync", (RObject)this.atomicLong);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RAtomicLong)this.atomicLong).getAndIncrementAsync());
    }

    public RFuture<Long> getAndDecrementAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("getAndDecrementAsync", (RObject)this.atomicLong);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RAtomicLong)this.atomicLong).getAndDecrementAsync());
    }

    public RFuture<Void> setAsync(long newValue) {
        Span span = this.tracingRedissonHelper.buildSpan("setAsync", (RObject)this.atomicLong);
        span.setTag("newValue", (Number)newValue);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.atomicLong.setAsync(newValue));
    }
}

