/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRExpirable;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Arrays;
import java.util.BitSet;
import org.redisson.api.RBitSet;
import org.redisson.api.RExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;

public class TracingRBitSet
extends TracingRExpirable
implements RBitSet {
    private final RBitSet bitSet;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRBitSet(RBitSet bitSet, TracingRedissonHelper tracingRedissonHelper) {
        super((RExpirable)bitSet, tracingRedissonHelper);
        this.bitSet = bitSet;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public long length() {
        Span span = this.tracingRedissonHelper.buildSpan("length", (RObject)this.bitSet);
        return (Long)this.tracingRedissonHelper.decorate(span, () -> ((RBitSet)this.bitSet).length());
    }

    public void set(long fromIndex, long toIndex, boolean value) {
        Span span = this.tracingRedissonHelper.buildSpan("set", (RObject)this.bitSet);
        span.setTag("fromIndex", (Number)fromIndex);
        span.setTag("toIndex", (Number)toIndex);
        span.setTag("value", value);
        this.tracingRedissonHelper.decorate(span, () -> this.bitSet.set(fromIndex, toIndex, value));
    }

    public void clear(long fromIndex, long toIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("clear", (RObject)this.bitSet);
        span.setTag("fromIndex", (Number)fromIndex);
        span.setTag("toIndex", (Number)toIndex);
        this.tracingRedissonHelper.decorate(span, () -> this.bitSet.clear(fromIndex, toIndex));
    }

    public void set(BitSet bs) {
        Span span = this.tracingRedissonHelper.buildSpan("set", (RObject)this.bitSet);
        span.setTag("bs", TracingHelper.nullable((Object)bs));
        this.tracingRedissonHelper.decorate(span, () -> this.bitSet.set(bs));
    }

    public void not() {
        Span span = this.tracingRedissonHelper.buildSpan("not", (RObject)this.bitSet);
        this.tracingRedissonHelper.decorate(span, () -> ((RBitSet)this.bitSet).not());
    }

    public void set(long fromIndex, long toIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("set", (RObject)this.bitSet);
        span.setTag("fromIndex", (Number)fromIndex);
        span.setTag("toIndex", (Number)toIndex);
        this.tracingRedissonHelper.decorate(span, () -> this.bitSet.set(fromIndex, toIndex));
    }

    public long size() {
        Span span = this.tracingRedissonHelper.buildSpan("size", (RObject)this.bitSet);
        return (Long)this.tracingRedissonHelper.decorate(span, () -> ((RBitSet)this.bitSet).size());
    }

    public boolean get(long bitIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("get", (RObject)this.bitSet);
        span.setTag("bitIndex", (Number)bitIndex);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.bitSet.get(bitIndex));
    }

    public boolean set(long bitIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("set", (RObject)this.bitSet);
        span.setTag("bitIndex", (Number)bitIndex);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.bitSet.set(bitIndex));
    }

    public void set(long bitIndex, boolean value) {
        Span span = this.tracingRedissonHelper.buildSpan("set", (RObject)this.bitSet);
        span.setTag("bitIndex", (Number)bitIndex);
        span.setTag("value", value);
        this.tracingRedissonHelper.decorate(span, () -> this.bitSet.set(bitIndex, value));
    }

    public byte[] toByteArray() {
        Span span = this.tracingRedissonHelper.buildSpan("toByteArray", (RObject)this.bitSet);
        return (byte[])this.tracingRedissonHelper.decorate(span, () -> ((RBitSet)this.bitSet).toByteArray());
    }

    public long cardinality() {
        Span span = this.tracingRedissonHelper.buildSpan("cardinality", (RObject)this.bitSet);
        return (Long)this.tracingRedissonHelper.decorate(span, () -> ((RBitSet)this.bitSet).cardinality());
    }

    public boolean clear(long bitIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("clear", (RObject)this.bitSet);
        span.setTag("bitIndex", (Number)bitIndex);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.bitSet.clear(bitIndex));
    }

    public void clear() {
        Span span = this.tracingRedissonHelper.buildSpan("clear", (RObject)this.bitSet);
        this.tracingRedissonHelper.decorate(span, () -> this.bitSet.clear());
    }

    public BitSet asBitSet() {
        Span span = this.tracingRedissonHelper.buildSpan("asBitSet", (RObject)this.bitSet);
        return (BitSet)this.tracingRedissonHelper.decorate(span, () -> ((RBitSet)this.bitSet).asBitSet());
    }

    public void or(String ... bitSetNames) {
        Span span = this.tracingRedissonHelper.buildSpan("or", (RObject)this.bitSet);
        span.setTag("bitSetNames", Arrays.toString(bitSetNames));
        this.tracingRedissonHelper.decorate(span, () -> this.bitSet.or(bitSetNames));
    }

    public void and(String ... bitSetNames) {
        Span span = this.tracingRedissonHelper.buildSpan("and", (RObject)this.bitSet);
        span.setTag("bitSetNames", Arrays.toString(bitSetNames));
        this.tracingRedissonHelper.decorate(span, () -> this.bitSet.and(bitSetNames));
    }

    public void xor(String ... bitSetNames) {
        Span span = this.tracingRedissonHelper.buildSpan("xor", (RObject)this.bitSet);
        span.setTag("bitSetNames", Arrays.toString(bitSetNames));
        this.tracingRedissonHelper.decorate(span, () -> this.bitSet.xor(bitSetNames));
    }

    public RFuture<byte[]> toByteArrayAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("toByteArrayAsync", (RObject)this.bitSet);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RBitSet)this.bitSet).toByteArrayAsync());
    }

    public RFuture<Long> lengthAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("lengthAsync", (RObject)this.bitSet);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RBitSet)this.bitSet).lengthAsync());
    }

    public RFuture<Void> setAsync(long fromIndex, long toIndex, boolean value) {
        Span span = this.tracingRedissonHelper.buildSpan("setAsync", (RObject)this.bitSet);
        span.setTag("fromIndex", (Number)fromIndex);
        span.setTag("toIndex", (Number)toIndex);
        span.setTag("value", value);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.bitSet.setAsync(fromIndex, toIndex, value));
    }

    public RFuture<Void> clearAsync(long fromIndex, long toIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("clearAsync", (RObject)this.bitSet);
        span.setTag("fromIndex", (Number)fromIndex);
        span.setTag("toIndex", (Number)toIndex);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.bitSet.clearAsync(fromIndex, toIndex));
    }

    public RFuture<Void> setAsync(BitSet bs) {
        Span span = this.tracingRedissonHelper.buildSpan("setAsync", (RObject)this.bitSet);
        span.setTag("bs", TracingHelper.nullable((Object)bs));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.bitSet.setAsync(bs));
    }

    public RFuture<Void> notAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("notAsync", (RObject)this.bitSet);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RBitSet)this.bitSet).notAsync());
    }

    public RFuture<Void> setAsync(long fromIndex, long toIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("setAsync", (RObject)this.bitSet);
        span.setTag("fromIndex", (Number)fromIndex);
        span.setTag("toIndex", (Number)toIndex);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.bitSet.setAsync(fromIndex, toIndex));
    }

    public RFuture<Long> sizeAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("sizeAsync", (RObject)this.bitSet);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RBitSet)this.bitSet).sizeAsync());
    }

    public RFuture<Boolean> getAsync(long bitIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("getAsync", (RObject)this.bitSet);
        span.setTag("bitIndex", (Number)bitIndex);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.bitSet.getAsync(bitIndex));
    }

    public RFuture<Boolean> setAsync(long bitIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("setAsync", (RObject)this.bitSet);
        span.setTag("bitIndex", (Number)bitIndex);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.bitSet.setAsync(bitIndex));
    }

    public RFuture<Boolean> setAsync(long bitIndex, boolean value) {
        Span span = this.tracingRedissonHelper.buildSpan("setAsync", (RObject)this.bitSet);
        span.setTag("bitIndex", (Number)bitIndex);
        span.setTag("value", value);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.bitSet.setAsync(bitIndex, value));
    }

    public RFuture<Long> cardinalityAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("cardinalityAsync", (RObject)this.bitSet);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RBitSet)this.bitSet).cardinalityAsync());
    }

    public RFuture<Boolean> clearAsync(long bitIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("clearAsync", (RObject)this.bitSet);
        span.setTag("bitIndex", (Number)bitIndex);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.bitSet.clearAsync(bitIndex));
    }

    public RFuture<Void> clearAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("clearAsync", (RObject)this.bitSet);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RBitSet)this.bitSet).clearAsync());
    }

    public RFuture<Void> orAsync(String ... bitSetNames) {
        Span span = this.tracingRedissonHelper.buildSpan("orAsync", (RObject)this.bitSet);
        span.setTag("bitSetNames", Arrays.toString(bitSetNames));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.bitSet.orAsync(bitSetNames));
    }

    public RFuture<Void> andAsync(String ... bitSetNames) {
        Span span = this.tracingRedissonHelper.buildSpan("andAsync", (RObject)this.bitSet);
        span.setTag("bitSetNames", Arrays.toString(bitSetNames));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.bitSet.andAsync(bitSetNames));
    }

    public RFuture<Void> xorAsync(String ... bitSetNames) {
        Span span = this.tracingRedissonHelper.buildSpan("xorAsync", (RObject)this.bitSet);
        span.setTag("bitSetNames", Arrays.toString(bitSetNames));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.bitSet.xorAsync(bitSetNames));
    }
}

