/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRObject;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;

public class TracingRCountDownLatch
extends TracingRObject
implements RCountDownLatch {
    private final RCountDownLatch latch;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRCountDownLatch(RCountDownLatch latch, TracingRedissonHelper tracingRedissonHelper) {
        super((RObject)latch, tracingRedissonHelper);
        this.latch = latch;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public void await() throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("await", (RObject)this.latch);
        this.tracingRedissonHelper.decorateThrowing(span, () -> this.latch.await());
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("await", (RObject)this.latch);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (Boolean)this.tracingRedissonHelper.decorateThrowing(span, () -> this.latch.await(timeout, unit));
    }

    public void countDown() {
        Span span = this.tracingRedissonHelper.buildSpan("countDown", (RObject)this.latch);
        this.tracingRedissonHelper.decorate(span, () -> ((RCountDownLatch)this.latch).countDown());
    }

    public long getCount() {
        Span span = this.tracingRedissonHelper.buildSpan("getCount", (RObject)this.latch);
        return (Long)this.tracingRedissonHelper.decorate(span, () -> ((RCountDownLatch)this.latch).getCount());
    }

    public boolean trySetCount(long count) {
        Span span = this.tracingRedissonHelper.buildSpan("trySetCount", (RObject)this.latch);
        span.setTag("count", (Number)count);
        return (Boolean)this.tracingRedissonHelper.decorateThrowing(span, () -> this.latch.trySetCount(count));
    }

    public RFuture<Void> awaitAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("awaitAsync", (RObject)this.latch);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RCountDownLatch)this.latch).awaitAsync());
    }

    public RFuture<Boolean> awaitAsync(long waitTime, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("awaitAsync", (RObject)this.latch);
        span.setTag("waitTime", (Number)waitTime);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.latch.awaitAsync(waitTime, unit));
    }

    public RFuture<Void> countDownAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("countDownAsync", (RObject)this.latch);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RCountDownLatch)this.latch).countDownAsync());
    }

    public RFuture<Long> getCountAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("getCountAsync", (RObject)this.latch);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RCountDownLatch)this.latch).getCountAsync());
    }

    public RFuture<Boolean> trySetCountAsync(long count) {
        Span span = this.tracingRedissonHelper.buildSpan("trySetCountAsync", (RObject)this.latch);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.latch.trySetCountAsync(count));
    }
}

