/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRQueue;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Iterator;
import java.util.List;
import org.redisson.api.RDeque;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;

public class TracingRDeque<V>
extends TracingRQueue<V>
implements RDeque<V> {
    private final RDeque<V> deque;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRDeque(RDeque<V> deque, TracingRedissonHelper tracingRedissonHelper) {
        super(deque, tracingRedissonHelper);
        this.deque = deque;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public void addFirst(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("addFirst", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        this.tracingRedissonHelper.decorate(span, () -> this.deque.addFirst(v));
    }

    public void addLast(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("addLast", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        this.tracingRedissonHelper.decorate(span, () -> this.deque.addLast(v));
    }

    public boolean offerFirst(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("offerFirst", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.offerFirst(v));
    }

    public boolean offerLast(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("offerLast", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.offerLast(v));
    }

    public V removeFirst() {
        Span span = this.tracingRedissonHelper.buildSpan("removeFirst", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.removeFirst());
    }

    public V removeLast() {
        Span span = this.tracingRedissonHelper.buildSpan("removeLast", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.removeLast());
    }

    public V pollFirst() {
        Span span = this.tracingRedissonHelper.buildSpan("pollFirst", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.pollFirst());
    }

    public V pollLast() {
        Span span = this.tracingRedissonHelper.buildSpan("pollLast", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.pollLast());
    }

    public V getFirst() {
        Span span = this.tracingRedissonHelper.buildSpan("getFirst", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.getFirst());
    }

    public V getLast() {
        Span span = this.tracingRedissonHelper.buildSpan("getLast", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.getLast());
    }

    public V peekFirst() {
        Span span = this.tracingRedissonHelper.buildSpan("peekFirst", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.peekFirst());
    }

    public V peekLast() {
        Span span = this.tracingRedissonHelper.buildSpan("peekLast", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.peekLast());
    }

    public boolean removeFirstOccurrence(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("removeFirstOccurrence", (RObject)this.deque);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.removeFirstOccurrence(o));
    }

    public boolean removeLastOccurrence(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("removeLastOccurrence", (RObject)this.deque);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.removeLastOccurrence(o));
    }

    @Override
    public boolean add(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("add", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.add(v));
    }

    @Override
    public boolean offer(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("offer", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.offer(v));
    }

    @Override
    public V remove() {
        Span span = this.tracingRedissonHelper.buildSpan("remove", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.remove());
    }

    @Override
    public V poll() {
        Span span = this.tracingRedissonHelper.buildSpan("poll", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.poll());
    }

    @Override
    public V element() {
        Span span = this.tracingRedissonHelper.buildSpan("element", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.element());
    }

    @Override
    public V peek() {
        Span span = this.tracingRedissonHelper.buildSpan("peek", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.peek());
    }

    public void push(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("push", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        this.tracingRedissonHelper.decorate(span, () -> this.deque.push(v));
    }

    public V pop() {
        Span span = this.tracingRedissonHelper.buildSpan("pop", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.pop());
    }

    @Override
    public boolean remove(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("remove", (RObject)this.deque);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.remove(o));
    }

    @Override
    public boolean contains(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("contains", (RObject)this.deque);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.contains(o));
    }

    @Override
    public int size() {
        Span span = this.tracingRedissonHelper.buildSpan("size", (RObject)this.deque);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.deque.size());
    }

    @Override
    public Iterator<V> iterator() {
        return this.deque.iterator();
    }

    public Iterator<V> descendingIterator() {
        return this.deque.descendingIterator();
    }

    public RFuture<Boolean> removeLastOccurrenceAsync(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("removeLastOccurrenceAsync", (RObject)this.deque);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.removeLastOccurrenceAsync(o));
    }

    public RFuture<V> removeLastAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("removeLastAsync", (RObject)this.deque);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.removeLastAsync());
    }

    public RFuture<V> removeFirstAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("removeFirstAsync", (RObject)this.deque);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.removeFirstAsync());
    }

    public RFuture<Boolean> removeFirstOccurrenceAsync(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("removeFirstOccurrenceAsync", (RObject)this.deque);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.removeFirstOccurrenceAsync(o));
    }

    public RFuture<Void> pushAsync(V e) {
        Span span = this.tracingRedissonHelper.buildSpan("pushAsync", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(e));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.pushAsync(e));
    }

    public RFuture<V> popAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("popAsync", (RObject)this.deque);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.popAsync());
    }

    public RFuture<V> pollLastAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("pollLastAsync", (RObject)this.deque);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.pollLastAsync());
    }

    public RFuture<V> pollFirstAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("pollFirstAsync", (RObject)this.deque);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.pollFirstAsync());
    }

    public RFuture<V> peekLastAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("peekLastAsync", (RObject)this.deque);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.peekLastAsync());
    }

    public RFuture<V> peekFirstAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("peekFirstAsync", (RObject)this.deque);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.peekFirstAsync());
    }

    public RFuture<Boolean> offerLastAsync(V e) {
        Span span = this.tracingRedissonHelper.buildSpan("offerLastAsync", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(e));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.offerLastAsync(e));
    }

    public RFuture<V> getLastAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("getLastAsync", (RObject)this.deque);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.getLastAsync());
    }

    public RFuture<Void> addLastAsync(V e) {
        Span span = this.tracingRedissonHelper.buildSpan("addLastAsync", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(e));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.addLastAsync(e));
    }

    public RFuture<Void> addFirstAsync(V e) {
        Span span = this.tracingRedissonHelper.buildSpan("addFirstAsync", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(e));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.addFirstAsync(e));
    }

    public RFuture<Boolean> offerFirstAsync(V e) {
        Span span = this.tracingRedissonHelper.buildSpan("offerFirstAsync", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(e));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.offerFirstAsync(e));
    }

    public RFuture<List<V>> pollFirstAsync(int limit) {
        Span span = this.tracingRedissonHelper.buildSpan("pollFirstAsync", (RObject)this.deque);
        span.setTag("limit", (Number)limit);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.pollFirstAsync(limit));
    }

    public RFuture<List<V>> pollLastAsync(int limit) {
        Span span = this.tracingRedissonHelper.buildSpan("pollLastAsync", (RObject)this.deque);
        span.setTag("limit", (Number)limit);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.pollLastAsync(limit));
    }

    public List<V> pollLast(int limit) {
        Span span = this.tracingRedissonHelper.buildSpan("pollLast", (RObject)this.deque);
        span.setTag("limit", (Number)limit);
        return (List)this.tracingRedissonHelper.decorate(span, () -> this.deque.pollLast(limit));
    }

    public List<V> pollFirst(int limit) {
        Span span = this.tracingRedissonHelper.buildSpan("pollFirst", (RObject)this.deque);
        span.setTag("limit", (Number)limit);
        return (List)this.tracingRedissonHelper.decorate(span, () -> this.deque.pollFirst(limit));
    }
}

