/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRExpirable;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RDoubleAdder;
import org.redisson.api.RExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;

public class TracingRDoubleAdder
extends TracingRExpirable
implements RDoubleAdder {
    private final RDoubleAdder doubleAdder;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRDoubleAdder(RDoubleAdder doubleAdder, TracingRedissonHelper tracingRedissonHelper) {
        super((RExpirable)doubleAdder, tracingRedissonHelper);
        this.doubleAdder = doubleAdder;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public void add(double x) {
        Span span = this.tracingRedissonHelper.buildSpan("add", (RObject)this.doubleAdder);
        span.setTag("value", (Number)x);
        this.tracingRedissonHelper.decorate(span, () -> this.doubleAdder.add(x));
    }

    public void increment() {
        Span span = this.tracingRedissonHelper.buildSpan("increment", (RObject)this.doubleAdder);
        this.tracingRedissonHelper.decorate(span, () -> ((RDoubleAdder)this.doubleAdder).increment());
    }

    public void decrement() {
        Span span = this.tracingRedissonHelper.buildSpan("decrement", (RObject)this.doubleAdder);
        this.tracingRedissonHelper.decorate(span, () -> ((RDoubleAdder)this.doubleAdder).decrement());
    }

    public double sum() {
        Span span = this.tracingRedissonHelper.buildSpan("sum", (RObject)this.doubleAdder);
        return (Double)this.tracingRedissonHelper.decorate(span, () -> ((RDoubleAdder)this.doubleAdder).sum());
    }

    public void reset() {
        Span span = this.tracingRedissonHelper.buildSpan("reset", (RObject)this.doubleAdder);
        this.tracingRedissonHelper.decorate(span, () -> ((RDoubleAdder)this.doubleAdder).reset());
    }

    public RFuture<Double> sumAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("sumAsync", (RObject)this.doubleAdder);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RDoubleAdder)this.doubleAdder).sumAsync());
    }

    public RFuture<Double> sumAsync(long timeout, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("sumAsync", (RObject)this.doubleAdder);
        span.setTag("timeout", (Number)timeout);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.doubleAdder.sumAsync(timeout, timeUnit));
    }

    public RFuture<Void> resetAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("resetAsync", (RObject)this.doubleAdder);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RDoubleAdder)this.doubleAdder).resetAsync());
    }

    public RFuture<Void> resetAsync(long timeout, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("resetAsync", (RObject)this.doubleAdder);
        span.setTag("timeout", (Number)timeout);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.doubleAdder.resetAsync(timeout, timeUnit));
    }

    public void destroy() {
        Span span = this.tracingRedissonHelper.buildSpan("destroy", (RObject)this.doubleAdder);
        this.tracingRedissonHelper.decorate(span, () -> ((RDoubleAdder)this.doubleAdder).destroy());
    }
}

