/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRObject;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;

public class TracingRExpirable
extends TracingRObject
implements RExpirable {
    private final RExpirable expirable;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRExpirable(RExpirable expirable, TracingRedissonHelper tracingRedissonHelper) {
        super((RObject)expirable, tracingRedissonHelper);
        this.expirable = expirable;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public boolean expire(long timeToLive, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("expire", (RObject)this.expirable);
        span.setTag("timeToLive", (Number)timeToLive);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.expirable.expire(timeToLive, timeUnit));
    }

    public boolean expireAt(long timestamp) {
        Span span = this.tracingRedissonHelper.buildSpan("expireAt", (RObject)this.expirable);
        span.setTag("timestamp", (Number)timestamp);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.expirable.expireAt(timestamp));
    }

    public boolean expireAt(Date timestamp) {
        Span span = this.tracingRedissonHelper.buildSpan("expireAt", (RObject)this.expirable);
        span.setTag("timestamp", TracingHelper.nullable((Object)timestamp));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.expirable.expireAt(timestamp));
    }

    public boolean clearExpire() {
        Span span = this.tracingRedissonHelper.buildSpan("clearExpire", (RObject)this.expirable);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> ((RExpirable)this.expirable).clearExpire());
    }

    public long remainTimeToLive() {
        Span span = this.tracingRedissonHelper.buildSpan("remainTimeToLive", (RObject)this.expirable);
        return (Long)this.tracingRedissonHelper.decorate(span, () -> ((RExpirable)this.expirable).remainTimeToLive());
    }

    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("expireAsync", (RObject)this.expirable);
        span.setTag("timeToLive", (Number)timeToLive);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.expirable.expireAsync(timeToLive, timeUnit));
    }

    public RFuture<Boolean> expireAtAsync(Date timestamp) {
        Span span = this.tracingRedissonHelper.buildSpan("expireAtAsync", (RObject)this.expirable);
        span.setTag("timestamp", TracingHelper.nullable((Object)timestamp));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.expirable.expireAtAsync(timestamp));
    }

    public RFuture<Boolean> expireAtAsync(long timestamp) {
        Span span = this.tracingRedissonHelper.buildSpan("expireAtAsync", (RObject)this.expirable);
        span.setTag("timestamp", (Number)timestamp);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.expirable.expireAtAsync(timestamp));
    }

    public RFuture<Boolean> clearExpireAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("clearExpireAsync", (RObject)this.expirable);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RExpirable)this.expirable).clearExpireAsync());
    }

    public RFuture<Long> remainTimeToLiveAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("remainTimeToLiveAsync", (RObject)this.expirable);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RExpirable)this.expirable).remainTimeToLiveAsync());
    }
}

