/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRCollectionMapReduce;
import io.opentracing.contrib.redis.redisson.TracingRExpirable;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.redisson.api.RExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RList;
import org.redisson.api.RObject;
import org.redisson.api.SortOrder;
import org.redisson.api.mapreduce.RCollectionMapReduce;

public class TracingRList<V>
extends TracingRExpirable
implements RList<V> {
    private final RList<V> list;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRList(RList<V> list, TracingRedissonHelper tracingRedissonHelper) {
        super((RExpirable)list, tracingRedissonHelper);
        this.list = list;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public List<V> get(int ... indexes) {
        Span span = this.tracingRedissonHelper.buildSpan("get", (RObject)this.list);
        span.setTag("indexes", Arrays.toString(indexes));
        return (List)this.tracingRedissonHelper.decorate(span, () -> this.list.get(indexes));
    }

    public <KOut, VOut> RCollectionMapReduce<V, KOut, VOut> mapReduce() {
        return new TracingRCollectionMapReduce(this.list.mapReduce(), this.tracingRedissonHelper);
    }

    public int addAfter(V elementToFind, V element) {
        Span span = this.tracingRedissonHelper.buildSpan("addAfter", (RObject)this.list);
        span.setTag("elementToFind", TracingHelper.nullable(elementToFind));
        span.setTag("element", TracingHelper.nullable(element));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.list.addAfter(elementToFind, element));
    }

    public int addBefore(V elementToFind, V element) {
        Span span = this.tracingRedissonHelper.buildSpan("addBefore", (RObject)this.list);
        span.setTag("elementToFind", TracingHelper.nullable(elementToFind));
        span.setTag("element", TracingHelper.nullable(element));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.list.addBefore(elementToFind, element));
    }

    public void fastSet(int index, V element) {
        Span span = this.tracingRedissonHelper.buildSpan("fastSet", (RObject)this.list);
        span.setTag("index", (Number)index);
        span.setTag("element", TracingHelper.nullable(element));
        this.tracingRedissonHelper.decorate(span, () -> this.list.fastSet(index, element));
    }

    public RList<V> subList(int fromIndex, int toIndex) {
        return new TracingRList<V>(this.list.subList(fromIndex, toIndex), this.tracingRedissonHelper);
    }

    public List<V> readAll() {
        Span span = this.tracingRedissonHelper.buildSpan("readAll", (RObject)this.list);
        return (List)this.tracingRedissonHelper.decorate(span, () -> this.list.readAll());
    }

    public void trim(int fromIndex, int toIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("trim", (RObject)this.list);
        span.setTag("fromIndex", (Number)fromIndex);
        span.setTag("toIndex", (Number)toIndex);
        this.tracingRedissonHelper.decorate(span, () -> this.list.trim(fromIndex, toIndex));
    }

    public List<V> range(int toIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("range", (RObject)this.list);
        span.setTag("toIndex", (Number)toIndex);
        return (List)this.tracingRedissonHelper.decorate(span, () -> this.list.range(toIndex));
    }

    public List<V> range(int fromIndex, int toIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("range", (RObject)this.list);
        span.setTag("fromIndex", (Number)fromIndex);
        span.setTag("toIndex", (Number)toIndex);
        return (List)this.tracingRedissonHelper.decorate(span, () -> this.list.range(fromIndex, toIndex));
    }

    public void fastRemove(int index) {
        Span span = this.tracingRedissonHelper.buildSpan("fastRemove", (RObject)this.list);
        span.setTag("index", (Number)index);
        this.tracingRedissonHelper.decorate(span, () -> this.list.fastRemove(index));
    }

    public boolean remove(Object object, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("remove", (RObject)this.list);
        span.setTag("object", TracingHelper.nullable((Object)object));
        span.setTag("count", (Number)count);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.list.remove(object, count));
    }

    public int size() {
        Span span = this.tracingRedissonHelper.buildSpan("size", (RObject)this.list);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.list.size());
    }

    public boolean isEmpty() {
        Span span = this.tracingRedissonHelper.buildSpan("isEmpty", (RObject)this.list);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.list.isEmpty());
    }

    public boolean contains(Object object) {
        Span span = this.tracingRedissonHelper.buildSpan("contains", (RObject)this.list);
        span.setTag("object", TracingHelper.nullable((Object)object));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.list.contains(object));
    }

    public Iterator<V> iterator() {
        return this.list.iterator();
    }

    public Object[] toArray() {
        Span span = this.tracingRedissonHelper.buildSpan("toArray", (RObject)this.list);
        return (Object[])this.tracingRedissonHelper.decorate(span, () -> this.list.toArray());
    }

    public <T> T[] toArray(T[] a) {
        Span span = this.tracingRedissonHelper.buildSpan("toArray", (RObject)this.list);
        return (Object[])this.tracingRedissonHelper.decorate(span, () -> this.list.toArray(a));
    }

    public boolean add(V element) {
        Span span = this.tracingRedissonHelper.buildSpan("add", (RObject)this.list);
        span.setTag("element", TracingHelper.nullable(element));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.list.add(element));
    }

    public boolean remove(Object object) {
        Span span = this.tracingRedissonHelper.buildSpan("remove", (RObject)this.list);
        span.setTag("object", TracingHelper.nullable((Object)object));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.list.remove(object));
    }

    public boolean containsAll(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("containsAll", (RObject)this.list);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.list.containsAll(c));
    }

    public boolean addAll(Collection<? extends V> c) {
        Span span = this.tracingRedissonHelper.buildSpan("addAll", (RObject)this.list);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.list.addAll(c));
    }

    public boolean addAll(int index, Collection<? extends V> c) {
        Span span = this.tracingRedissonHelper.buildSpan("addAll", (RObject)this.list);
        span.setTag("index", (Number)index);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.list.addAll(index, c));
    }

    public boolean removeAll(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAll", (RObject)this.list);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.list.removeAll(c));
    }

    public boolean retainAll(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("retainAll", (RObject)this.list);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.list.retainAll(c));
    }

    public void replaceAll(UnaryOperator<V> operator) {
        Span span = this.tracingRedissonHelper.buildSpan("replaceAll", (RObject)this.list);
        span.setTag("operator", TracingHelper.nullable(operator));
        this.tracingRedissonHelper.decorate(span, () -> this.list.replaceAll(operator));
    }

    public void sort(Comparator<? super V> comparator) {
        Span span = this.tracingRedissonHelper.buildSpan("sort", (RObject)this.list);
        span.setTag("comparator", TracingHelper.nullable(comparator));
        this.tracingRedissonHelper.decorate(span, () -> this.list.sort(comparator));
    }

    public void clear() {
        Span span = this.tracingRedissonHelper.buildSpan("clear", (RObject)this.list);
        this.tracingRedissonHelper.decorate(span, () -> this.list.clear());
    }

    @Override
    public boolean equals(Object object) {
        Span span = this.tracingRedissonHelper.buildSpan("equals", (RObject)this.list);
        span.setTag("object", TracingHelper.nullable((Object)object));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.list.equals(object));
    }

    @Override
    public int hashCode() {
        Span span = this.tracingRedissonHelper.buildSpan("hashCode", (RObject)this.list);
        return (Integer)this.tracingRedissonHelper.decorate(span, this.list::hashCode);
    }

    public V get(int index) {
        Span span = this.tracingRedissonHelper.buildSpan("get", (RObject)this.list);
        span.setTag("index", (Number)index);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.list.get(index));
    }

    public V set(int index, V element) {
        Span span = this.tracingRedissonHelper.buildSpan("set", (RObject)this.list);
        span.setTag("index", (Number)index);
        span.setTag("element", TracingHelper.nullable(element));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.list.set(index, element));
    }

    public void add(int index, V element) {
        Span span = this.tracingRedissonHelper.buildSpan("add", (RObject)this.list);
        span.setTag("index", (Number)index);
        span.setTag("element", TracingHelper.nullable(element));
        this.tracingRedissonHelper.decorate(span, () -> this.list.add(index, element));
    }

    public V remove(int index) {
        Span span = this.tracingRedissonHelper.buildSpan("remove", (RObject)this.list);
        span.setTag("index", (Number)index);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.list.remove(index));
    }

    public int indexOf(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("indexOf", (RObject)this.list);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.list.indexOf(o));
    }

    public int lastIndexOf(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("lastIndexOf", (RObject)this.list);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.list.lastIndexOf(o));
    }

    public ListIterator<V> listIterator() {
        return this.list.listIterator();
    }

    public ListIterator<V> listIterator(int index) {
        return this.list.listIterator(index);
    }

    public Spliterator<V> spliterator() {
        return this.list.spliterator();
    }

    public boolean removeIf(Predicate<? super V> filter) {
        Span span = this.tracingRedissonHelper.buildSpan("removeIf", (RObject)this.list);
        span.setTag("filter", TracingHelper.nullable(filter));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.list.removeIf(filter));
    }

    public Stream<V> stream() {
        return this.list.stream();
    }

    public Stream<V> parallelStream() {
        return this.list.parallelStream();
    }

    public void forEach(Consumer<? super V> action) {
        Span span = this.tracingRedissonHelper.buildSpan("forEach", (RObject)this.list);
        span.setTag("action", TracingHelper.nullable(action));
        this.tracingRedissonHelper.decorate(span, () -> this.list.forEach(action));
    }

    public RFuture<List<V>> getAsync(int ... indexes) {
        Span span = this.tracingRedissonHelper.buildSpan("getAsync", (RObject)this.list);
        span.setTag("indexes", Arrays.toString(indexes));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.getAsync(indexes));
    }

    public RFuture<Integer> addAfterAsync(V elementToFind, V element) {
        Span span = this.tracingRedissonHelper.buildSpan("addAfterAsync", (RObject)this.list);
        span.setTag("elementToFind", TracingHelper.nullable(elementToFind));
        span.setTag("element", TracingHelper.nullable(element));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.addAfterAsync(elementToFind, element));
    }

    public RFuture<Integer> addBeforeAsync(V elementToFind, V element) {
        Span span = this.tracingRedissonHelper.buildSpan("addBeforeAsync", (RObject)this.list);
        span.setTag("elementToFind", TracingHelper.nullable(elementToFind));
        span.setTag("element", TracingHelper.nullable(element));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.addBeforeAsync(elementToFind, element));
    }

    public RFuture<Boolean> addAsync(int index, V element) {
        Span span = this.tracingRedissonHelper.buildSpan("addAsync", (RObject)this.list);
        span.setTag("index", (Number)index);
        span.setTag("element", TracingHelper.nullable(element));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.addAsync(index, element));
    }

    public RFuture<Boolean> addAllAsync(int index, Collection<? extends V> coll) {
        Span span = this.tracingRedissonHelper.buildSpan("addAllAsync", (RObject)this.list);
        span.setTag("index", (Number)index);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.addAllAsync(index, coll));
    }

    public RFuture<Integer> lastIndexOfAsync(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("lastIndexOfAsync", (RObject)this.list);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.lastIndexOfAsync(o));
    }

    public RFuture<Integer> indexOfAsync(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("indexOfAsync", (RObject)this.list);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.indexOfAsync(o));
    }

    public RFuture<Void> fastSetAsync(int index, V element) {
        Span span = this.tracingRedissonHelper.buildSpan("fastSetAsync", (RObject)this.list);
        span.setTag("index", (Number)index);
        span.setTag("element", TracingHelper.nullable(element));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.fastSetAsync(index, element));
    }

    public RFuture<V> setAsync(int index, V element) {
        Span span = this.tracingRedissonHelper.buildSpan("setAsync", (RObject)this.list);
        span.setTag("index", (Number)index);
        span.setTag("element", TracingHelper.nullable(element));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.setAsync(index, element));
    }

    public RFuture<V> getAsync(int index) {
        Span span = this.tracingRedissonHelper.buildSpan("getAsync", (RObject)this.list);
        span.setTag("index", (Number)index);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.getAsync(index));
    }

    public RFuture<List<V>> readAllAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("readAllAsync", (RObject)this.list);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.readAllAsync());
    }

    public RFuture<Void> trimAsync(int fromIndex, int toIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("trimAsync", (RObject)this.list);
        span.setTag("fromIndex", (Number)fromIndex);
        span.setTag("toIndex", (Number)toIndex);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.trimAsync(fromIndex, toIndex));
    }

    public RFuture<Void> fastRemoveAsync(int index) {
        Span span = this.tracingRedissonHelper.buildSpan("fastRemoveAsync", (RObject)this.list);
        span.setTag("index", (Number)index);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.fastRemoveAsync(index));
    }

    public RFuture<V> removeAsync(int index) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAsync", (RObject)this.list);
        span.setTag("index", (Number)index);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.removeAsync(index));
    }

    public RFuture<Boolean> removeAsync(Object o, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAsync", (RObject)this.list);
        span.setTag("object", TracingHelper.nullable((Object)o));
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.removeAsync(o, count));
    }

    public RFuture<List<V>> rangeAsync(int toIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeAsync", (RObject)this.list);
        span.setTag("toIndex", (Number)toIndex);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.rangeAsync(toIndex));
    }

    public RFuture<List<V>> rangeAsync(int fromIndex, int toIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeAsync", (RObject)this.list);
        span.setTag("fromIndex", (Number)fromIndex);
        span.setTag("toIndex", (Number)toIndex);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.rangeAsync(fromIndex, toIndex));
    }

    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("retainAllAsync", (RObject)this.list);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.retainAllAsync(c));
    }

    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("retainAllAsync", (RObject)this.list);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.removeAllAsync(c));
    }

    public RFuture<Boolean> containsAsync(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("containsAsync", (RObject)this.list);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.containsAsync(o));
    }

    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("containsAllAsync", (RObject)this.list);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.containsAllAsync(c));
    }

    public RFuture<Boolean> removeAsync(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAsync", (RObject)this.list);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.removeAsync(o));
    }

    public RFuture<Integer> sizeAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("sizeAsync", (RObject)this.list);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.sizeAsync());
    }

    public RFuture<Boolean> addAsync(V e) {
        Span span = this.tracingRedissonHelper.buildSpan("addAsync", (RObject)this.list);
        span.setTag("element", TracingHelper.nullable(e));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.addAsync(e));
    }

    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        Span span = this.tracingRedissonHelper.buildSpan("addAllAsync", (RObject)this.list);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.addAllAsync(c));
    }

    public RFuture<List<V>> readSortAsync(SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAsync", (RObject)this.list);
        span.setTag("order", TracingHelper.nullable((Object)order));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.readSortAsync(order));
    }

    public RFuture<List<V>> readSortAsync(SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAsync", (RObject)this.list);
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.readSortAsync(order, offset, count));
    }

    public RFuture<List<V>> readSortAsync(String byPattern, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAsync", (RObject)this.list);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.readSortAsync(byPattern, order));
    }

    public RFuture<List<V>> readSortAsync(String byPattern, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAsync", (RObject)this.list);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.readSortAsync(byPattern, order, offset, count));
    }

    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAsync", (RObject)this.list);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.readSortAsync(byPattern, getPatterns, order));
    }

    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAsync", (RObject)this.list);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.readSortAsync(byPattern, getPatterns, order, offset, count));
    }

    public RFuture<List<V>> readSortAlphaAsync(SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlphaAsync", (RObject)this.list);
        span.setTag("order", TracingHelper.nullable((Object)order));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.readSortAlphaAsync(order));
    }

    public RFuture<List<V>> readSortAlphaAsync(SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlphaAsync", (RObject)this.list);
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.readSortAlphaAsync(order, offset, count));
    }

    public RFuture<List<V>> readSortAlphaAsync(String byPattern, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlphaAsync", (RObject)this.list);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.readSortAlphaAsync(byPattern, order));
    }

    public RFuture<List<V>> readSortAlphaAsync(String byPattern, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlphaAsync", (RObject)this.list);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.readSortAlphaAsync(byPattern, order, offset, count));
    }

    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlphaAsync", (RObject)this.list);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.readSortAlphaAsync(byPattern, getPatterns, order));
    }

    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlphaAsync", (RObject)this.list);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.readSortAlphaAsync(byPattern, getPatterns, order, offset, count));
    }

    public RFuture<Integer> sortToAsync(String destName, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("sortToAsync", (RObject)this.list);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.sortToAsync(destName, order));
    }

    public RFuture<Integer> sortToAsync(String destName, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("sortToAsync", (RObject)this.list);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.sortToAsync(destName, order, offset, count));
    }

    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("sortToAsync", (RObject)this.list);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.sortToAsync(destName, byPattern, order));
    }

    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("sortToAsync", (RObject)this.list);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.sortToAsync(destName, byPattern, order, offset, count));
    }

    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("sortToAsync", (RObject)this.list);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.sortToAsync(destName, byPattern, getPatterns, order));
    }

    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("sortToAsync", (RObject)this.list);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.list.sortToAsync(destName, byPattern, getPatterns, order, offset, count));
    }

    public List<V> readSort(SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSort", (RObject)this.list);
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (List)this.tracingRedissonHelper.decorate(span, () -> (List)this.list.readSort(order));
    }

    public List<V> readSort(SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSort", (RObject)this.list);
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (List)this.tracingRedissonHelper.decorate(span, () -> (List)this.list.readSort(order, offset, count));
    }

    public List<V> readSort(String byPattern, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSort", (RObject)this.list);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (List)this.tracingRedissonHelper.decorate(span, () -> (List)this.list.readSort(byPattern, order));
    }

    public List<V> readSort(String byPattern, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSort", (RObject)this.list);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (List)this.tracingRedissonHelper.decorate(span, () -> (List)this.list.readSort(byPattern, order, offset, count));
    }

    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSort", (RObject)this.list);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.list.readSort(byPattern, getPatterns, order));
    }

    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSort", (RObject)this.list);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.list.readSort(byPattern, getPatterns, order, offset, count));
    }

    public List<V> readSortAlpha(SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlpha", (RObject)this.list);
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (List)this.tracingRedissonHelper.decorate(span, () -> (List)this.list.readSortAlpha(order));
    }

    public List<V> readSortAlpha(SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlpha", (RObject)this.list);
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (List)this.tracingRedissonHelper.decorate(span, () -> (List)this.list.readSortAlpha(order, offset, count));
    }

    public List<V> readSortAlpha(String byPattern, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlpha", (RObject)this.list);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (List)this.tracingRedissonHelper.decorate(span, () -> (List)this.list.readSortAlpha(byPattern, order));
    }

    public List<V> readSortAlpha(String byPattern, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlpha", (RObject)this.list);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (List)this.tracingRedissonHelper.decorate(span, () -> (List)this.list.readSortAlpha(byPattern, order, offset, count));
    }

    public <T> Collection<T> readSortAlpha(String byPattern, List<String> getPatterns, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlpha", (RObject)this.list);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.list.readSortAlpha(byPattern, getPatterns, order));
    }

    public <T> Collection<T> readSortAlpha(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlpha", (RObject)this.list);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.list.readSortAlpha(byPattern, getPatterns, order, offset, count));
    }

    public int sortTo(String destName, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("sortTo", (RObject)this.list);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.list.sortTo(destName, order));
    }

    public int sortTo(String destName, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("sortTo", (RObject)this.list);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.list.sortTo(destName, order, offset, count));
    }

    public int sortTo(String destName, String byPattern, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("sortTo", (RObject)this.list);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.list.sortTo(destName, byPattern, order));
    }

    public int sortTo(String destName, String byPattern, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("sortTo", (RObject)this.list);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.list.sortTo(destName, byPattern, order, offset, count));
    }

    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("sortTo", (RObject)this.list);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.list.sortTo(destName, byPattern, getPatterns, order));
    }

    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("sortTo", (RObject)this.list);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.list.sortTo(destName, byPattern, getPatterns, order, offset, count));
    }
}

