/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRList;
import io.opentracing.contrib.redis.redisson.TracingRMultimap;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.List;
import org.redisson.api.RList;
import org.redisson.api.RListMultimap;
import org.redisson.api.RObject;

public class TracingRListMultimap<K, V>
extends TracingRMultimap<K, V>
implements RListMultimap<K, V> {
    private final RListMultimap<K, V> map;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRListMultimap(RListMultimap<K, V> map, TracingRedissonHelper tracingRedissonHelper) {
        super(map, tracingRedissonHelper);
        this.map = map;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    @Override
    public RList<V> get(K key) {
        Span span = this.tracingRedissonHelper.buildSpan("get", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return (RList)this.tracingRedissonHelper.decorate(span, () -> new TracingRList(this.map.get(key), this.tracingRedissonHelper));
    }

    @Override
    public List<V> getAll(K key) {
        Span span = this.tracingRedissonHelper.buildSpan("getAll", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return (List)this.tracingRedissonHelper.decorate(span, () -> this.map.getAll(key));
    }

    @Override
    public List<V> removeAll(Object key) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAll", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable((Object)key));
        return (List)this.tracingRedissonHelper.decorate(span, () -> this.map.removeAll(key));
    }

    @Override
    public List<V> replaceValues(K key, Iterable<? extends V> values) {
        Span span = this.tracingRedissonHelper.buildSpan("replaceValues", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("values", TracingHelper.nullable(values));
        return (List)this.tracingRedissonHelper.decorate(span, () -> this.map.replaceValues(key, values));
    }
}

