/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.redisson.TracingRMap;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.redisson.api.RFuture;
import org.redisson.api.RLocalCachedMap;
import org.redisson.api.RObject;

public class TracingRLocalCachedMap<K, V>
extends TracingRMap<K, V>
implements RLocalCachedMap<K, V> {
    private final RLocalCachedMap<K, V> map;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRLocalCachedMap(RLocalCachedMap<K, V> map, TracingRedissonHelper tracingRedissonHelper) {
        super(map, tracingRedissonHelper);
        this.map = map;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public void preloadCache() {
        Span span = this.tracingRedissonHelper.buildSpan("preloadCache", (RObject)this.map);
        this.tracingRedissonHelper.decorate(span, () -> this.map.preloadCache());
    }

    public void preloadCache(int count) {
        Span span = this.tracingRedissonHelper.buildSpan("preloadCache", (RObject)this.map);
        span.setTag("count", (Number)count);
        this.tracingRedissonHelper.decorate(span, () -> this.map.preloadCache(count));
    }

    public RFuture<Void> clearLocalCacheAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("clearLocalCacheAsync", (RObject)this.map);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.clearLocalCacheAsync());
    }

    public void clearLocalCache() {
        Span span = this.tracingRedissonHelper.buildSpan("clearLocalCache", (RObject)this.map);
        this.tracingRedissonHelper.decorate(span, () -> this.map.clearLocalCache());
    }

    public Set<K> cachedKeySet() {
        Span span = this.tracingRedissonHelper.buildSpan("cachedKeySet", (RObject)this.map);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.map.cachedKeySet());
    }

    public Collection<V> cachedValues() {
        Span span = this.tracingRedissonHelper.buildSpan("cachedValues", (RObject)this.map);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.map.cachedValues());
    }

    public Set<Map.Entry<K, V>> cachedEntrySet() {
        Span span = this.tracingRedissonHelper.buildSpan("cachedEntrySet", (RObject)this.map);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.map.cachedEntrySet());
    }

    public Map<K, V> getCachedMap() {
        Span span = this.tracingRedissonHelper.buildSpan("getCachedMap", (RObject)this.map);
        return (Map)this.tracingRedissonHelper.decorate(span, () -> this.map.getCachedMap());
    }

    public void destroy() {
        Span span = this.tracingRedissonHelper.buildSpan("destroy", (RObject)this.map);
        this.tracingRedissonHelper.decorate(span, () -> this.map.destroy());
    }
}

