/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;

public class TracingRLock
implements RLock {
    private final RLock lock;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRLock(RLock lock, TracingRedissonHelper tracingRedissonHelper) {
        this.lock = lock;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public String getName() {
        return this.lock.getName();
    }

    public void lockInterruptibly(long leaseTime, TimeUnit unit) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("lockInterruptibly", this.lock);
        span.setTag("leaseTime", (Number)leaseTime);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        this.tracingRedissonHelper.decorateThrowing(span, () -> this.lock.lockInterruptibly(leaseTime, unit));
    }

    public boolean tryLock(long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("tryLock", this.lock);
        span.setTag("leaseTime", (Number)leaseTime);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (Boolean)this.tracingRedissonHelper.decorateThrowing(span, () -> this.lock.tryLock(waitTime, leaseTime, unit));
    }

    public void lock(long leaseTime, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("lock", this.lock);
        span.setTag("leaseTime", (Number)leaseTime);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        this.tracingRedissonHelper.decorate(span, () -> this.lock.lock(leaseTime, unit));
    }

    public boolean forceUnlock() {
        Span span = this.tracingRedissonHelper.buildSpan("forceUnlock", this.lock);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> ((RLock)this.lock).forceUnlock());
    }

    public boolean isLocked() {
        Span span = this.tracingRedissonHelper.buildSpan("isLocked", this.lock);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> ((RLock)this.lock).isLocked());
    }

    public boolean isHeldByThread(long threadId) {
        Span span = this.tracingRedissonHelper.buildSpan("isHeldByThread", this.lock);
        span.setTag("threadId", (Number)threadId);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.lock.isHeldByThread(threadId));
    }

    public boolean isHeldByCurrentThread() {
        Span span = this.tracingRedissonHelper.buildSpan("isHeldByCurrentThread", this.lock);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> ((RLock)this.lock).isHeldByCurrentThread());
    }

    public int getHoldCount() {
        Span span = this.tracingRedissonHelper.buildSpan("getHoldCount", this.lock);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> ((RLock)this.lock).getHoldCount());
    }

    public long remainTimeToLive() {
        Span span = this.tracingRedissonHelper.buildSpan("remainTimeToLive", this.lock);
        return (Long)this.tracingRedissonHelper.decorate(span, () -> ((RLock)this.lock).remainTimeToLive());
    }

    public void lock() {
        Span span = this.tracingRedissonHelper.buildSpan("lock", this.lock);
        this.tracingRedissonHelper.decorate(span, () -> this.lock.lock());
    }

    public void lockInterruptibly() throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("lockInterruptibly", this.lock);
        this.tracingRedissonHelper.decorateThrowing(span, () -> this.lock.lockInterruptibly());
    }

    public boolean tryLock() {
        Span span = this.tracingRedissonHelper.buildSpan("tryLock", this.lock);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.lock.tryLock());
    }

    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("tryLock", this.lock);
        span.setTag("time", (Number)time);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (Boolean)this.tracingRedissonHelper.decorateThrowing(span, () -> this.lock.tryLock(time, unit));
    }

    public void unlock() {
        Span span = this.tracingRedissonHelper.buildSpan("unlock", this.lock);
        this.tracingRedissonHelper.decorate(span, () -> this.lock.unlock());
    }

    public Condition newCondition() {
        Span span = this.tracingRedissonHelper.buildSpan("newCondition", this.lock);
        return (Condition)this.tracingRedissonHelper.decorate(span, () -> this.lock.newCondition());
    }

    public RFuture<Boolean> forceUnlockAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("forceUnlockAsync", this.lock);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RLock)this.lock).forceUnlockAsync());
    }

    public RFuture<Void> unlockAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("unlockAsync", this.lock);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RLock)this.lock).unlockAsync());
    }

    public RFuture<Void> unlockAsync(long threadId) {
        Span span = this.tracingRedissonHelper.buildSpan("unlockAsync", this.lock);
        span.setTag("threadId", (Number)threadId);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.lock.unlockAsync(threadId));
    }

    public RFuture<Boolean> tryLockAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("tryLockAsync", this.lock);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RLock)this.lock).tryLockAsync());
    }

    public RFuture<Void> lockAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("lockAsync", this.lock);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RLock)this.lock).lockAsync());
    }

    public RFuture<Void> lockAsync(long threadId) {
        Span span = this.tracingRedissonHelper.buildSpan("lockAsync", this.lock);
        span.setTag("threadId", (Number)threadId);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.lock.lockAsync(threadId));
    }

    public RFuture<Void> lockAsync(long leaseTime, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("lockAsync", this.lock);
        span.setTag("leaseTime", (Number)leaseTime);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.lock.lockAsync(leaseTime, unit));
    }

    public RFuture<Void> lockAsync(long leaseTime, TimeUnit unit, long threadId) {
        Span span = this.tracingRedissonHelper.buildSpan("lockAsync", this.lock);
        span.setTag("leaseTime", (Number)leaseTime);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        span.setTag("threadId", (Number)threadId);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.lock.lockAsync(leaseTime, unit, threadId));
    }

    public RFuture<Boolean> tryLockAsync(long threadId) {
        Span span = this.tracingRedissonHelper.buildSpan("tryLockAsync", this.lock);
        span.setTag("threadId", (Number)threadId);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.lock.tryLockAsync(threadId));
    }

    public RFuture<Boolean> tryLockAsync(long waitTime, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("tryLockAsync", this.lock);
        span.setTag("waitTime", (Number)waitTime);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.lock.tryLockAsync(waitTime, unit));
    }

    public RFuture<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("tryLockAsync", this.lock);
        span.setTag("waitTime", (Number)waitTime);
        span.setTag("leaseTime", (Number)leaseTime);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.lock.tryLockAsync(waitTime, leaseTime, unit));
    }

    public RFuture<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit, long threadId) {
        Span span = this.tracingRedissonHelper.buildSpan("tryLockAsync", this.lock);
        span.setTag("waitTime", (Number)waitTime);
        span.setTag("leaseTime", (Number)leaseTime);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        span.setTag("threadId", (Number)threadId);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.lock.tryLockAsync(waitTime, leaseTime, unit, threadId));
    }

    public RFuture<Integer> getHoldCountAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("getHoldCountAsync", this.lock);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RLock)this.lock).getHoldCountAsync());
    }

    public RFuture<Boolean> isLockedAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("isLockedAsync", this.lock);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RLock)this.lock).isLockedAsync());
    }

    public RFuture<Long> remainTimeToLiveAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("remainTimeToLiveAsync", this.lock);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RLock)this.lock).remainTimeToLiveAsync());
    }
}

