/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRMap;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.api.RMapCache;
import org.redisson.api.RObject;
import org.redisson.api.map.event.MapEntryListener;

public class TracingRMapCache<K, V>
extends TracingRMap<K, V>
implements RMapCache<K, V> {
    private final RMapCache<K, V> cache;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRMapCache(RMapCache<K, V> cache, TracingRedissonHelper tracingRedissonHelper) {
        super(cache, tracingRedissonHelper);
        this.cache = cache;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public void setMaxSize(int maxSize) {
        Span span = this.tracingRedissonHelper.buildSpan("setMaxSize", (RObject)this.cache);
        span.setTag("maxSize", (Number)maxSize);
        this.tracingRedissonHelper.decorate(span, () -> this.cache.setMaxSize(maxSize));
    }

    public boolean trySetMaxSize(int maxSize) {
        Span span = this.tracingRedissonHelper.buildSpan("trySetMaxSize", (RObject)this.cache);
        span.setTag("maxSize", (Number)maxSize);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.cache.trySetMaxSize(maxSize));
    }

    public V putIfAbsent(K key, V value, long ttl, TimeUnit ttlUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("putIfAbsent", (RObject)this.cache);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("ttlUnit", TracingHelper.nullable((Object)((Object)ttlUnit)));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.cache.putIfAbsent(key, value, ttl, ttlUnit));
    }

    public V putIfAbsent(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("putIfAbsent", (RObject)this.cache);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("ttlUnit", TracingHelper.nullable((Object)((Object)ttlUnit)));
        span.setTag("maxIdleTime", (Number)maxIdleTime);
        span.setTag("maxIdleUnit", TracingHelper.nullable((Object)((Object)maxIdleUnit)));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.cache.putIfAbsent(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit));
    }

    public V put(K key, V value, long ttl, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("put", (RObject)this.cache);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.cache.put(key, value, ttl, unit));
    }

    public V put(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("put", (RObject)this.cache);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("ttlUnit", TracingHelper.nullable((Object)((Object)ttlUnit)));
        span.setTag("maxIdleTime", (Number)maxIdleTime);
        span.setTag("maxIdleUnit", TracingHelper.nullable((Object)((Object)maxIdleUnit)));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.cache.put(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit));
    }

    public boolean fastPut(K key, V value, long ttl, TimeUnit ttlUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("fastPut", (RObject)this.cache);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("ttlUnit", TracingHelper.nullable((Object)((Object)ttlUnit)));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.cache.fastPut(key, value, ttl, ttlUnit));
    }

    public boolean fastPut(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("fastPut", (RObject)this.cache);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("ttlUnit", TracingHelper.nullable((Object)((Object)ttlUnit)));
        span.setTag("maxIdleTime", (Number)maxIdleTime);
        span.setTag("maxIdleUnit", TracingHelper.nullable((Object)((Object)maxIdleUnit)));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.cache.fastPut(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit));
    }

    public boolean fastPutIfAbsent(K key, V value, long ttl, TimeUnit ttlUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("fastPutIfAbsent", (RObject)this.cache);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("ttlUnit", TracingHelper.nullable((Object)((Object)ttlUnit)));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.cache.fastPutIfAbsent(key, value, ttl, ttlUnit));
    }

    public boolean fastPutIfAbsent(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("fastPutIfAbsent", (RObject)this.cache);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("ttlUnit", TracingHelper.nullable((Object)((Object)ttlUnit)));
        span.setTag("maxIdleTime", (Number)maxIdleTime);
        span.setTag("maxIdleUnit", TracingHelper.nullable((Object)((Object)maxIdleUnit)));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.cache.fastPutIfAbsent(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit));
    }

    public void putAll(Map<? extends K, ? extends V> map, long ttl, TimeUnit ttlUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("putAll", (RObject)this.cache);
        span.setTag("ttl", (Number)ttl);
        span.setTag("ttlUnit", TracingHelper.nullable((Object)((Object)ttlUnit)));
        this.tracingRedissonHelper.decorate(span, () -> this.cache.putAll(map, ttl, ttlUnit));
    }

    public RFuture<Void> putAllAsync(Map<? extends K, ? extends V> map, long ttl, TimeUnit ttlUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("putAllAsync", (RObject)this.cache);
        span.setTag("ttl", (Number)ttl);
        span.setTag("ttlUnit", TracingHelper.nullable((Object)((Object)ttlUnit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.putAllAsync(map, ttl, ttlUnit));
    }

    @Override
    public int size() {
        Span span = this.tracingRedissonHelper.buildSpan("size", (RObject)this.cache);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.cache.size());
    }

    public int addListener(MapEntryListener listener) {
        return this.cache.addListener(listener);
    }

    @Override
    public void removeListener(int listenerId) {
        this.cache.removeListener(listenerId);
    }

    public long remainTimeToLive(K key) {
        Span span = this.tracingRedissonHelper.buildSpan("remainTimeToLive", (RObject)this.cache);
        span.setTag("key", TracingHelper.nullable(key));
        return (Long)this.tracingRedissonHelper.decorate(span, () -> this.cache.remainTimeToLive(key));
    }

    public RFuture<Void> setMaxSizeAsync(int maxSize) {
        Span span = this.tracingRedissonHelper.buildSpan("setMaxSizeAsync", (RObject)this.cache);
        span.setTag("maxSize", (Number)maxSize);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.setMaxSizeAsync(maxSize));
    }

    public RFuture<Boolean> trySetMaxSizeAsync(int maxSize) {
        Span span = this.tracingRedissonHelper.buildSpan("trySetMaxSizeAsync", (RObject)this.cache);
        span.setTag("maxSize", (Number)maxSize);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.trySetMaxSizeAsync(maxSize));
    }

    public RFuture<V> putIfAbsentAsync(K key, V value, long ttl, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("putIfAbsentAsync", (RObject)this.cache);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.putIfAbsentAsync(key, value, ttl, unit));
    }

    public RFuture<V> putIfAbsentAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("putIfAbsentAsync", (RObject)this.cache);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("ttlUnit", TracingHelper.nullable((Object)((Object)ttlUnit)));
        span.setTag("maxIdleTime", (Number)maxIdleTime);
        span.setTag("maxIdleUnit", TracingHelper.nullable((Object)((Object)maxIdleUnit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.putIfAbsentAsync(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit));
    }

    public RFuture<V> putAsync(K key, V value, long ttl, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("putAsync", (RObject)this.cache);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.putAsync(key, value, ttl, unit));
    }

    public RFuture<V> putAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("putAsync", (RObject)this.cache);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("ttlUnit", TracingHelper.nullable((Object)((Object)ttlUnit)));
        span.setTag("maxIdleTime", (Number)maxIdleTime);
        span.setTag("maxIdleUnit", TracingHelper.nullable((Object)((Object)maxIdleUnit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.putAsync(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit));
    }

    public RFuture<Boolean> fastPutAsync(K key, V value, long ttl, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("fastPutAsync", (RObject)this.cache);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.fastPutAsync(key, value, ttl, unit));
    }

    public RFuture<Boolean> fastPutAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("fastPutAsync", (RObject)this.cache);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("ttlUnit", TracingHelper.nullable((Object)((Object)ttlUnit)));
        span.setTag("maxIdleTime", (Number)maxIdleTime);
        span.setTag("maxIdleUnit", TracingHelper.nullable((Object)((Object)maxIdleUnit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.fastPutAsync(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit));
    }

    public RFuture<Boolean> fastPutIfAbsentAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("fastPutIfAbsentAsync", (RObject)this.cache);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("ttlUnit", TracingHelper.nullable((Object)((Object)ttlUnit)));
        span.setTag("maxIdleTime", (Number)maxIdleTime);
        span.setTag("maxIdleUnit", TracingHelper.nullable((Object)((Object)maxIdleUnit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.fastPutIfAbsentAsync(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit));
    }

    public RFuture<Long> remainTimeToLiveAsync(K key) {
        Span span = this.tracingRedissonHelper.buildSpan("remainTimeToLiveAsync", (RObject)this.cache);
        span.setTag("key", TracingHelper.nullable(key));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.remainTimeToLiveAsync(key));
    }

    public void destroy() {
        Span span = this.tracingRedissonHelper.buildSpan("destroy", (RObject)this.cache);
        this.tracingRedissonHelper.decorate(span, () -> this.cache.destroy());
    }
}

