/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Map;
import org.redisson.api.RFuture;
import org.redisson.api.mapreduce.RCollator;
import org.redisson.api.mapreduce.RMapReduceExecutor;

public class TracingRMapReduceExecutor<VIn, KOut, VOut>
implements RMapReduceExecutor<VIn, KOut, VOut> {
    private final RMapReduceExecutor<VIn, KOut, VOut> executor;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRMapReduceExecutor(RMapReduceExecutor<VIn, KOut, VOut> executor, TracingRedissonHelper tracingRedissonHelper) {
        this.executor = executor;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public Map<KOut, VOut> execute() {
        Span span = this.tracingRedissonHelper.buildSpan("execute");
        return (Map)this.tracingRedissonHelper.decorate(span, () -> this.executor.execute());
    }

    public RFuture<Map<KOut, VOut>> executeAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("executeAsync");
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.executor.executeAsync());
    }

    public void execute(String resultMapName) {
        Span span = this.tracingRedissonHelper.buildSpan("execute");
        span.setTag("resultMapName", TracingHelper.nullable((Object)resultMapName));
        this.tracingRedissonHelper.decorate(span, () -> this.executor.execute(resultMapName));
    }

    public RFuture<Void> executeAsync(String resultMapName) {
        Span span = this.tracingRedissonHelper.buildSpan("executeAsync");
        span.setTag("resultMapName", TracingHelper.nullable((Object)resultMapName));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.executor.executeAsync(resultMapName));
    }

    public <R> R execute(RCollator<KOut, VOut, R> collator) {
        Span span = this.tracingRedissonHelper.buildSpan("execute");
        span.setTag("collator", TracingHelper.nullable(collator));
        return (R)this.tracingRedissonHelper.decorate(span, () -> this.executor.execute(collator));
    }

    public <R> RFuture<R> executeAsync(RCollator<KOut, VOut, R> collator) {
        Span span = this.tracingRedissonHelper.buildSpan("executeAsync");
        span.setTag("collator", TracingHelper.nullable(collator));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.executor.executeAsync(collator));
    }
}

