/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRCountDownLatch;
import io.opentracing.contrib.redis.redisson.TracingRExpirable;
import io.opentracing.contrib.redis.redisson.TracingRLock;
import io.opentracing.contrib.redis.redisson.TracingRPermitExpirableSemaphore;
import io.opentracing.contrib.redis.redisson.TracingRReadWriteLock;
import io.opentracing.contrib.redis.redisson.TracingRSemaphore;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RMultimap;
import org.redisson.api.RObject;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RSemaphore;

public class TracingRMultimap<K, V>
extends TracingRExpirable
implements RMultimap<K, V> {
    private final RMultimap<K, V> map;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRMultimap(RMultimap<K, V> map, TracingRedissonHelper tracingRedissonHelper) {
        super((RExpirable)map, tracingRedissonHelper);
        this.map = map;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public RCountDownLatch getCountDownLatch(K key) {
        return new TracingRCountDownLatch(this.map.getCountDownLatch(key), this.tracingRedissonHelper);
    }

    public RPermitExpirableSemaphore getPermitExpirableSemaphore(K key) {
        return new TracingRPermitExpirableSemaphore(this.map.getPermitExpirableSemaphore(key), this.tracingRedissonHelper);
    }

    public RSemaphore getSemaphore(K key) {
        return new TracingRSemaphore(this.map.getSemaphore(key), this.tracingRedissonHelper);
    }

    public RLock getFairLock(K key) {
        return new TracingRLock(this.map.getFairLock(key), this.tracingRedissonHelper);
    }

    public RReadWriteLock getReadWriteLock(K key) {
        return new TracingRReadWriteLock(this.map.getReadWriteLock(key), this.tracingRedissonHelper);
    }

    public RLock getLock(K key) {
        return new TracingRLock(this.map.getLock(key), this.tracingRedissonHelper);
    }

    public int size() {
        Span span = this.tracingRedissonHelper.buildSpan("size", (RObject)this.map);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.map.size());
    }

    public boolean isEmpty() {
        Span span = this.tracingRedissonHelper.buildSpan("isEmpty", (RObject)this.map);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.map.isEmpty());
    }

    public boolean containsKey(Object key) {
        Span span = this.tracingRedissonHelper.buildSpan("containsKey", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable((Object)key));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.map.containsKey(key));
    }

    public boolean containsValue(Object value) {
        Span span = this.tracingRedissonHelper.buildSpan("containsValue", (RObject)this.map);
        span.setTag("value", TracingHelper.nullable((Object)value));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.map.containsValue(value));
    }

    public boolean containsEntry(Object key, Object value) {
        Span span = this.tracingRedissonHelper.buildSpan("containsEntry", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable((Object)key));
        span.setTag("value", TracingHelper.nullable((Object)value));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.map.containsEntry(key, value));
    }

    public boolean put(K key, V value) {
        Span span = this.tracingRedissonHelper.buildSpan("put", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.map.put(key, value));
    }

    public boolean remove(Object key, Object value) {
        Span span = this.tracingRedissonHelper.buildSpan("remove", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable((Object)key));
        span.setTag("value", TracingHelper.nullable((Object)value));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.map.remove(key, value));
    }

    public boolean putAll(K key, Iterable<? extends V> values) {
        Span span = this.tracingRedissonHelper.buildSpan("putAll", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("values", TracingHelper.nullable(values));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.map.putAll(key, values));
    }

    public Collection<V> replaceValues(K key, Iterable<? extends V> values) {
        Span span = this.tracingRedissonHelper.buildSpan("replaceValues", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("values", TracingHelper.nullable(values));
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.map.replaceValues(key, values));
    }

    public Collection<V> removeAll(Object key) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAll", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable((Object)key));
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.map.removeAll(key));
    }

    public void clear() {
        Span span = this.tracingRedissonHelper.buildSpan("clear", (RObject)this.map);
        this.tracingRedissonHelper.decorate(span, () -> this.map.clear());
    }

    public Collection<V> get(K key) {
        Span span = this.tracingRedissonHelper.buildSpan("get", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.map.get(key));
    }

    public Collection<V> getAll(K key) {
        Span span = this.tracingRedissonHelper.buildSpan("getAll", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.map.getAll(key));
    }

    public Set<K> keySet() {
        Span span = this.tracingRedissonHelper.buildSpan("keySet", (RObject)this.map);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.map.keySet());
    }

    public int keySize() {
        Span span = this.tracingRedissonHelper.buildSpan("keySize", (RObject)this.map);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.map.keySize());
    }

    public Collection<V> values() {
        Span span = this.tracingRedissonHelper.buildSpan("values", (RObject)this.map);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.map.values());
    }

    public Collection<Map.Entry<K, V>> entries() {
        Span span = this.tracingRedissonHelper.buildSpan("entries", (RObject)this.map);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.map.entries());
    }

    public long fastRemove(K ... keys) {
        Span span = this.tracingRedissonHelper.buildSpan("fastRemove", (RObject)this.map);
        span.setTag("keys", Arrays.toString(keys));
        return (Long)this.tracingRedissonHelper.decorate(span, () -> this.map.fastRemove(keys));
    }

    public Set<K> readAllKeySet() {
        Span span = this.tracingRedissonHelper.buildSpan("readAllKeySet", (RObject)this.map);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.map.readAllKeySet());
    }

    public RFuture<Integer> sizeAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("sizeAsync", (RObject)this.map);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.sizeAsync());
    }

    public RFuture<Boolean> containsKeyAsync(Object key) {
        Span span = this.tracingRedissonHelper.buildSpan("containsKeyAsync", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable((Object)key));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.containsKeyAsync(key));
    }

    public RFuture<Boolean> containsValueAsync(Object value) {
        Span span = this.tracingRedissonHelper.buildSpan("containsValueAsync", (RObject)this.map);
        span.setTag("value", TracingHelper.nullable((Object)value));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.containsValueAsync(value));
    }

    public RFuture<Boolean> containsEntryAsync(Object key, Object value) {
        Span span = this.tracingRedissonHelper.buildSpan("containsEntryAsync", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable((Object)key));
        span.setTag("value", TracingHelper.nullable((Object)value));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.containsEntryAsync(key, value));
    }

    public RFuture<Boolean> putAsync(K key, V value) {
        Span span = this.tracingRedissonHelper.buildSpan("putAsync", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.putAsync(key, value));
    }

    public RFuture<Boolean> removeAsync(Object key, Object value) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAsync", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable((Object)key));
        span.setTag("value", TracingHelper.nullable((Object)value));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.removeAsync(key, value));
    }

    public RFuture<Boolean> putAllAsync(K key, Iterable<? extends V> values) {
        Span span = this.tracingRedissonHelper.buildSpan("putAllAsync", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("values", TracingHelper.nullable(values));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.putAllAsync(key, values));
    }

    public RFuture<Collection<V>> replaceValuesAsync(K key, Iterable<? extends V> values) {
        Span span = this.tracingRedissonHelper.buildSpan("replaceValuesAsync", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("values", TracingHelper.nullable(values));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.replaceValuesAsync(key, values));
    }

    public RFuture<Collection<V>> removeAllAsync(Object key) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAllAsync", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable((Object)key));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.removeAllAsync(key));
    }

    public RFuture<Collection<V>> getAllAsync(K key) {
        Span span = this.tracingRedissonHelper.buildSpan("getAllAsync", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.getAllAsync(key));
    }

    public RFuture<Integer> keySizeAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("keySizeAsync", (RObject)this.map);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.keySizeAsync());
    }

    public RFuture<Long> fastRemoveAsync(K ... keys) {
        Span span = this.tracingRedissonHelper.buildSpan("fastRemoveAsync", (RObject)this.map);
        span.setTag("keys", Arrays.toString(keys));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.fastRemoveAsync(keys));
    }

    public RFuture<Set<K>> readAllKeySetAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("readAllKeySetAsync", (RObject)this.map);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.readAllKeySetAsync());
    }
}

