/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRPriorityQueue;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Iterator;
import java.util.stream.Stream;
import org.redisson.api.RObject;
import org.redisson.api.RPriorityDeque;

public class TracingRPriorityDeque<V>
extends TracingRPriorityQueue<V>
implements RPriorityDeque<V> {
    private final RPriorityDeque<V> deque;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRPriorityDeque(RPriorityDeque<V> deque, TracingRedissonHelper tracingRedissonHelper) {
        super(deque, tracingRedissonHelper);
        this.deque = deque;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public void addFirst(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("addFirst", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        this.tracingRedissonHelper.decorate(span, () -> this.deque.addFirst(v));
    }

    public void addLast(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("addLast", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        this.tracingRedissonHelper.decorate(span, () -> this.deque.addLast(v));
    }

    public boolean offerFirst(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("offerFirst", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.offerFirst(v));
    }

    public boolean offerLast(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("offerLast", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.offerLast(v));
    }

    public V removeFirst() {
        Span span = this.tracingRedissonHelper.buildSpan("removeFirst", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.removeFirst());
    }

    public V removeLast() {
        Span span = this.tracingRedissonHelper.buildSpan("removeLast", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.removeLast());
    }

    public V pollFirst() {
        Span span = this.tracingRedissonHelper.buildSpan("pollFirst", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.pollFirst());
    }

    public V pollLast() {
        Span span = this.tracingRedissonHelper.buildSpan("pollLast", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.pollLast());
    }

    public V getFirst() {
        Span span = this.tracingRedissonHelper.buildSpan("getFirst", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.getFirst());
    }

    public V getLast() {
        Span span = this.tracingRedissonHelper.buildSpan("getLast", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.getLast());
    }

    public V peekFirst() {
        Span span = this.tracingRedissonHelper.buildSpan("peekFirst", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.peekFirst());
    }

    public V peekLast() {
        Span span = this.tracingRedissonHelper.buildSpan("peekLast", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.peekLast());
    }

    public boolean removeFirstOccurrence(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("removeFirstOccurrence", (RObject)this.deque);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.removeFirstOccurrence(o));
    }

    public boolean removeLastOccurrence(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("removeLastOccurrence", (RObject)this.deque);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.removeLastOccurrence(o));
    }

    @Override
    public boolean add(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("add", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.add(v));
    }

    @Override
    public boolean offer(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("offer", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.offer(v));
    }

    @Override
    public V remove() {
        Span span = this.tracingRedissonHelper.buildSpan("remove", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.remove());
    }

    @Override
    public V poll() {
        Span span = this.tracingRedissonHelper.buildSpan("poll", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.poll());
    }

    @Override
    public V element() {
        Span span = this.tracingRedissonHelper.buildSpan("element", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.element());
    }

    @Override
    public V peek() {
        Span span = this.tracingRedissonHelper.buildSpan("peek", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.peek());
    }

    public void push(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("push", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        this.tracingRedissonHelper.decorate(span, () -> this.deque.push(v));
    }

    public V pop() {
        Span span = this.tracingRedissonHelper.buildSpan("pop", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.pop());
    }

    @Override
    public boolean remove(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("remove", (RObject)this.deque);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.remove(o));
    }

    @Override
    public boolean contains(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("contains", (RObject)this.deque);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.contains(o));
    }

    @Override
    public int size() {
        Span span = this.tracingRedissonHelper.buildSpan("size", (RObject)this.deque);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.deque.size());
    }

    @Override
    public Iterator<V> iterator() {
        return this.deque.iterator();
    }

    public Iterator<V> descendingIterator() {
        return this.deque.descendingIterator();
    }

    public Stream<V> descendingStream() {
        Span span = this.tracingRedissonHelper.buildSpan("descendingStream", (RObject)this.deque);
        return (Stream)this.tracingRedissonHelper.decorate(span, () -> this.deque.descendingStream());
    }
}

