/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.redisson.TracingRQueue;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;
import org.redisson.api.RRingBuffer;

public class TracingRRingBuffer<V>
extends TracingRQueue<V>
implements RRingBuffer<V> {
    private final RRingBuffer<V> ringBuffer;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRRingBuffer(RRingBuffer<V> ringBuffer, TracingRedissonHelper tracingRedissonHelper) {
        super(ringBuffer, tracingRedissonHelper);
        this.ringBuffer = ringBuffer;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public boolean trySetCapacity(int capacity) {
        Span span = this.tracingRedissonHelper.buildSpan("trySetCapacity", (RObject)this.ringBuffer);
        span.setTag("capacity", (Number)capacity);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.ringBuffer.trySetCapacity(capacity));
    }

    public int remainingCapacity() {
        Span span = this.tracingRedissonHelper.buildSpan("remainingCapacity", (RObject)this.ringBuffer);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.ringBuffer.remainingCapacity());
    }

    public int capacity() {
        Span span = this.tracingRedissonHelper.buildSpan("capacity", (RObject)this.ringBuffer);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.ringBuffer.capacity());
    }

    public RFuture<Boolean> trySetCapacityAsync(int capacity) {
        Span span = this.tracingRedissonHelper.buildSpan("trySetCapacityAsync", (RObject)this.ringBuffer);
        span.setTag("capacity", (Number)capacity);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.ringBuffer.trySetCapacityAsync(capacity));
    }

    public RFuture<Integer> remainingCapacityAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("remainingCapacityAsync", (RObject)this.ringBuffer);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.ringBuffer.remainingCapacityAsync());
    }

    public RFuture<Integer> capacityAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("capacityAsync", (RObject)this.ringBuffer);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.ringBuffer.capacityAsync());
    }
}

