/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRCollectionMapReduce;
import io.opentracing.contrib.redis.redisson.TracingRExpirable;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.redisson.api.RExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;
import org.redisson.api.RScoredSortedSet;
import org.redisson.api.SortOrder;
import org.redisson.api.mapreduce.RCollectionMapReduce;
import org.redisson.client.protocol.ScoredEntry;

public class TracingRScoredSortedSet<V>
extends TracingRExpirable
implements RScoredSortedSet<V> {
    private final RScoredSortedSet<V> set;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRScoredSortedSet(RScoredSortedSet<V> set, TracingRedissonHelper tracingRedissonHelper) {
        super((RExpirable)set, tracingRedissonHelper);
        this.set = set;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public <KOut, VOut> RCollectionMapReduce<V, KOut, VOut> mapReduce() {
        return new TracingRCollectionMapReduce(this.set.mapReduce(), this.tracingRedissonHelper);
    }

    public V pollLastFromAny(long timeout, TimeUnit unit, String ... queueNames) {
        Span span = this.tracingRedissonHelper.buildSpan("pollLastFromAny", (RObject)this.set);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        span.setTag("queueNames", Arrays.toString(queueNames));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.set.pollLastFromAny(timeout, unit, queueNames));
    }

    public V pollFirstFromAny(long timeout, TimeUnit unit, String ... queueNames) {
        Span span = this.tracingRedissonHelper.buildSpan("pollFirstFromAny", (RObject)this.set);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        span.setTag("queueNames", Arrays.toString(queueNames));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.set.pollFirstFromAny(timeout, unit, queueNames));
    }

    public V takeFirst() {
        Span span = this.tracingRedissonHelper.buildSpan("takeFirst", (RObject)this.set);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.set.takeFirst());
    }

    public V takeLast() {
        Span span = this.tracingRedissonHelper.buildSpan("takeLast", (RObject)this.set);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.set.takeLast());
    }

    public int subscribeOnFirstElements(Consumer<V> consumer) {
        Span span = this.tracingRedissonHelper.buildSpan("subscribeOnFirstElements", (RObject)this.set);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.subscribeOnFirstElements(consumer));
    }

    public int subscribeOnLastElements(Consumer<V> consumer) {
        Span span = this.tracingRedissonHelper.buildSpan("subscribeOnLastElements", (RObject)this.set);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.subscribeOnLastElements(consumer));
    }

    public void unsubscribe(int listenerId) {
        Span span = this.tracingRedissonHelper.buildSpan("unsubscribe", (RObject)this.set);
        span.setTag("listenerId", (Number)listenerId);
        this.tracingRedissonHelper.decorate(span, () -> this.set.unsubscribe(listenerId));
    }

    public V pollFirst(long timeout, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("pollFirst", (RObject)this.set);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.set.pollFirst(timeout, unit));
    }

    public V pollLast(long timeout, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("pollLast", (RObject)this.set);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.set.pollLast(timeout, unit));
    }

    public Collection<V> pollFirst(int count) {
        Span span = this.tracingRedissonHelper.buildSpan("pollFirst", (RObject)this.set);
        span.setTag("count", (Number)count);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.pollFirst(count));
    }

    public Collection<V> pollLast(int count) {
        Span span = this.tracingRedissonHelper.buildSpan("pollLast", (RObject)this.set);
        span.setTag("count", (Number)count);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.pollLast(count));
    }

    public V pollFirst() {
        Span span = this.tracingRedissonHelper.buildSpan("pollFirst", (RObject)this.set);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.set.pollFirst());
    }

    public V pollLast() {
        Span span = this.tracingRedissonHelper.buildSpan("pollLast", (RObject)this.set);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.set.pollLast());
    }

    public V first() {
        Span span = this.tracingRedissonHelper.buildSpan("first", (RObject)this.set);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.set.first());
    }

    public V last() {
        Span span = this.tracingRedissonHelper.buildSpan("last", (RObject)this.set);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.set.last());
    }

    public Double firstScore() {
        Span span = this.tracingRedissonHelper.buildSpan("firstScore", (RObject)this.set);
        return (Double)this.tracingRedissonHelper.decorate(span, () -> this.set.firstScore());
    }

    public Double lastScore() {
        Span span = this.tracingRedissonHelper.buildSpan("lastScore", (RObject)this.set);
        return (Double)this.tracingRedissonHelper.decorate(span, () -> this.set.lastScore());
    }

    public int addAll(Map<V, Double> objects) {
        Span span = this.tracingRedissonHelper.buildSpan("addAll", (RObject)this.set);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.addAll(objects));
    }

    public int removeRangeByScore(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("removeRangeByScore", (RObject)this.set);
        span.setTag("startScore", (Number)startScore);
        span.setTag("startScoreInclusive", startScoreInclusive);
        span.setTag("endScore", (Number)endScore);
        span.setTag("endScoreInclusive", endScoreInclusive);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.removeRangeByScore(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    public int removeRangeByRank(int startIndex, int endIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("removeRangeByRank", (RObject)this.set);
        span.setTag("startIndex", (Number)startIndex);
        span.setTag("endIndex", (Number)endIndex);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.removeRangeByRank(startIndex, endIndex));
    }

    public Integer rank(V o) {
        Span span = this.tracingRedissonHelper.buildSpan("rank", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable(o));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.rank(o));
    }

    public Integer revRank(V o) {
        Span span = this.tracingRedissonHelper.buildSpan("revRank", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable(o));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.revRank(o));
    }

    public Double getScore(V o) {
        Span span = this.tracingRedissonHelper.buildSpan("getScore", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable(o));
        return (Double)this.tracingRedissonHelper.decorate(span, () -> this.set.getScore(o));
    }

    public boolean add(double score, V object) {
        Span span = this.tracingRedissonHelper.buildSpan("add", (RObject)this.set);
        span.setTag("score", (Number)score);
        span.setTag("object", TracingHelper.nullable(object));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.add(score, object));
    }

    public Integer addAndGetRank(double score, V object) {
        Span span = this.tracingRedissonHelper.buildSpan("addAndGetRank", (RObject)this.set);
        span.setTag("score", (Number)score);
        span.setTag("object", TracingHelper.nullable(object));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.addAndGetRank(score, object));
    }

    public Integer addAndGetRevRank(double score, V object) {
        Span span = this.tracingRedissonHelper.buildSpan("addAndGetRevRank", (RObject)this.set);
        span.setTag("score", (Number)score);
        span.setTag("object", TracingHelper.nullable(object));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.addAndGetRevRank(score, object));
    }

    public boolean tryAdd(double score, V object) {
        Span span = this.tracingRedissonHelper.buildSpan("tryAdd", (RObject)this.set);
        span.setTag("score", (Number)score);
        span.setTag("object", TracingHelper.nullable(object));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.tryAdd(score, object));
    }

    public int size() {
        Span span = this.tracingRedissonHelper.buildSpan("size", (RObject)this.set);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.size());
    }

    public boolean isEmpty() {
        Span span = this.tracingRedissonHelper.buildSpan("isEmpty", (RObject)this.set);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.isEmpty());
    }

    public Stream<V> stream() {
        Span span = this.tracingRedissonHelper.buildSpan("stream", (RObject)this.set);
        return (Stream)this.tracingRedissonHelper.decorate(span, () -> this.set.stream());
    }

    public Stream<V> stream(String pattern) {
        Span span = this.tracingRedissonHelper.buildSpan("stream", (RObject)this.set);
        span.setTag("pattern", TracingHelper.nullable((Object)pattern));
        return (Stream)this.tracingRedissonHelper.decorate(span, () -> this.set.stream(pattern));
    }

    public Stream<V> stream(int count) {
        Span span = this.tracingRedissonHelper.buildSpan("stream", (RObject)this.set);
        span.setTag("count", (Number)count);
        return (Stream)this.tracingRedissonHelper.decorate(span, () -> this.set.stream(count));
    }

    public Stream<V> stream(String pattern, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("stream", (RObject)this.set);
        span.setTag("pattern", TracingHelper.nullable((Object)pattern));
        span.setTag("count", (Number)count);
        return (Stream)this.tracingRedissonHelper.decorate(span, () -> this.set.stream(pattern, count));
    }

    public Iterator<V> iterator(String pattern) {
        return this.set.iterator(pattern);
    }

    public Iterator<V> iterator(int count) {
        return this.set.iterator(count);
    }

    public Iterator<V> iterator(String pattern, int count) {
        return this.set.iterator(pattern, count);
    }

    public boolean contains(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("contains", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.contains(o));
    }

    public Object[] toArray() {
        Span span = this.tracingRedissonHelper.buildSpan("toArray", (RObject)this.set);
        return (Object[])this.tracingRedissonHelper.decorate(span, () -> this.set.toArray());
    }

    public <T> T[] toArray(T[] a) {
        Span span = this.tracingRedissonHelper.buildSpan("toArray", (RObject)this.set);
        return (Object[])this.tracingRedissonHelper.decorate(span, () -> this.set.toArray(a));
    }

    public boolean remove(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("remove", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.remove(o));
    }

    public boolean containsAll(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("containsAll", (RObject)this.set);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.containsAll(c));
    }

    public boolean removeAll(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAll", (RObject)this.set);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.removeAll(c));
    }

    public boolean retainAll(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("retainAll", (RObject)this.set);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.retainAll(c));
    }

    public void clear() {
        Span span = this.tracingRedissonHelper.buildSpan("clear", (RObject)this.set);
        this.tracingRedissonHelper.decorate(span, () -> this.set.clear());
    }

    public Double addScore(V object, Number value) {
        Span span = this.tracingRedissonHelper.buildSpan("addScore", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable(object));
        span.setTag("value", TracingHelper.nullable((Object)value));
        return (Double)this.tracingRedissonHelper.decorate(span, () -> this.set.addScore(object, value));
    }

    public Integer addScoreAndGetRank(V object, Number value) {
        Span span = this.tracingRedissonHelper.buildSpan("addScoreAndGetRank", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable(object));
        span.setTag("value", TracingHelper.nullable((Object)value));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.addScoreAndGetRank(object, value));
    }

    public Integer addScoreAndGetRevRank(V object, Number value) {
        Span span = this.tracingRedissonHelper.buildSpan("addScoreAndGetRevRank", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable(object));
        span.setTag("value", TracingHelper.nullable((Object)value));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.addScoreAndGetRevRank(object, value));
    }

    public Collection<V> valueRange(int startIndex, int endIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("valueRange", (RObject)this.set);
        span.setTag("startIndex", (Number)startIndex);
        span.setTag("endIndex", (Number)endIndex);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.valueRange(startIndex, endIndex));
    }

    public Collection<V> valueRangeReversed(int startIndex, int endIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("valueRangeReversed", (RObject)this.set);
        span.setTag("startIndex", (Number)startIndex);
        span.setTag("endIndex", (Number)endIndex);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.valueRangeReversed(startIndex, endIndex));
    }

    public Collection<ScoredEntry<V>> entryRange(int startIndex, int endIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("entryRange", (RObject)this.set);
        span.setTag("startIndex", (Number)startIndex);
        span.setTag("endIndex", (Number)endIndex);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.entryRange(startIndex, endIndex));
    }

    public Collection<ScoredEntry<V>> entryRangeReversed(int startIndex, int endIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("entryRangeReversed", (RObject)this.set);
        span.setTag("startIndex", (Number)startIndex);
        span.setTag("endIndex", (Number)endIndex);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.entryRangeReversed(startIndex, endIndex));
    }

    public Collection<V> valueRange(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("valueRange", (RObject)this.set);
        span.setTag("startScore", (Number)startScore);
        span.setTag("startScoreInclusive", startScoreInclusive);
        span.setTag("endScore", (Number)endScore);
        span.setTag("endScoreInclusive", endScoreInclusive);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.valueRange(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    public Collection<V> valueRangeReversed(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("valueRangeReversed", (RObject)this.set);
        span.setTag("startScore", (Number)startScore);
        span.setTag("startScoreInclusive", startScoreInclusive);
        span.setTag("endScore", (Number)endScore);
        span.setTag("endScoreInclusive", endScoreInclusive);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.valueRangeReversed(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    public Collection<ScoredEntry<V>> entryRange(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("entryRange", (RObject)this.set);
        span.setTag("startScore", (Number)startScore);
        span.setTag("startScoreInclusive", startScoreInclusive);
        span.setTag("endScore", (Number)endScore);
        span.setTag("endScoreInclusive", endScoreInclusive);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.entryRange(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    public Collection<V> valueRange(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("valueRange", (RObject)this.set);
        span.setTag("startScore", (Number)startScore);
        span.setTag("startScoreInclusive", startScoreInclusive);
        span.setTag("endScore", (Number)endScore);
        span.setTag("endScoreInclusive", endScoreInclusive);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.valueRange(startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count));
    }

    public Collection<V> valueRangeReversed(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("valueRangeReversed", (RObject)this.set);
        span.setTag("startScore", (Number)startScore);
        span.setTag("startScoreInclusive", startScoreInclusive);
        span.setTag("endScore", (Number)endScore);
        span.setTag("endScoreInclusive", endScoreInclusive);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.valueRangeReversed(startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count));
    }

    public Collection<ScoredEntry<V>> entryRange(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("entryRange", (RObject)this.set);
        span.setTag("startScore", (Number)startScore);
        span.setTag("startScoreInclusive", startScoreInclusive);
        span.setTag("endScore", (Number)endScore);
        span.setTag("endScoreInclusive", endScoreInclusive);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.entryRange(startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count));
    }

    public Collection<ScoredEntry<V>> entryRangeReversed(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("entryRangeReversed", (RObject)this.set);
        span.setTag("startScore", (Number)startScore);
        span.setTag("startScoreInclusive", startScoreInclusive);
        span.setTag("endScore", (Number)endScore);
        span.setTag("endScoreInclusive", endScoreInclusive);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.entryRangeReversed(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    public Collection<ScoredEntry<V>> entryRangeReversed(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("entryRangeReversed", (RObject)this.set);
        span.setTag("startScore", (Number)startScore);
        span.setTag("startScoreInclusive", startScoreInclusive);
        span.setTag("endScore", (Number)endScore);
        span.setTag("endScoreInclusive", endScoreInclusive);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.entryRangeReversed(startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count));
    }

    public int count(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("count", (RObject)this.set);
        span.setTag("startScore", (Number)startScore);
        span.setTag("startScoreInclusive", startScoreInclusive);
        span.setTag("endScore", (Number)endScore);
        span.setTag("endScoreInclusive", endScoreInclusive);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.count(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    public Collection<V> readAll() {
        Span span = this.tracingRedissonHelper.buildSpan("readAll", (RObject)this.set);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.readAll());
    }

    public int intersection(String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("intersection", (RObject)this.set);
        span.setTag("names", Arrays.toString(names));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.intersection(names));
    }

    public int intersection(RScoredSortedSet.Aggregate aggregate, String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("intersection", (RObject)this.set);
        span.setTag("aggregate", TracingHelper.nullable((Object)aggregate));
        span.setTag("names", Arrays.toString(names));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.intersection(aggregate, names));
    }

    public int intersection(Map<String, Double> nameWithWeight) {
        Span span = this.tracingRedissonHelper.buildSpan("intersection", (RObject)this.set);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.intersection(nameWithWeight));
    }

    public int intersection(RScoredSortedSet.Aggregate aggregate, Map<String, Double> nameWithWeight) {
        Span span = this.tracingRedissonHelper.buildSpan("intersection", (RObject)this.set);
        span.setTag("aggregate", TracingHelper.nullable((Object)aggregate));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.intersection(aggregate, nameWithWeight));
    }

    public int union(String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("union", (RObject)this.set);
        span.setTag("names", Arrays.toString(names));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.union(names));
    }

    public int union(RScoredSortedSet.Aggregate aggregate, String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("union", (RObject)this.set);
        span.setTag("aggregate", TracingHelper.nullable((Object)aggregate));
        span.setTag("names", Arrays.toString(names));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.union(aggregate, names));
    }

    public int union(Map<String, Double> nameWithWeight) {
        Span span = this.tracingRedissonHelper.buildSpan("union", (RObject)this.set);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.union(nameWithWeight));
    }

    public int union(RScoredSortedSet.Aggregate aggregate, Map<String, Double> nameWithWeight) {
        Span span = this.tracingRedissonHelper.buildSpan("union", (RObject)this.set);
        span.setTag("aggregate", TracingHelper.nullable((Object)aggregate));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.union(aggregate, nameWithWeight));
    }

    public RFuture<V> pollLastFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        Span span = this.tracingRedissonHelper.buildSpan("pollLastFromAnyAsync", (RObject)this.set);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        span.setTag("queueNames", Arrays.toString(queueNames));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.pollLastFromAnyAsync(timeout, unit, queueNames));
    }

    public RFuture<V> pollFirstFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        Span span = this.tracingRedissonHelper.buildSpan("pollFirstFromAnyAsync", (RObject)this.set);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        span.setTag("queueNames", Arrays.toString(queueNames));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.pollFirstFromAnyAsync(timeout, unit, queueNames));
    }

    public RFuture<V> pollFirstAsync(long timeout, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("pollFirstAsync", (RObject)this.set);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.pollFirstAsync(timeout, unit));
    }

    public RFuture<V> takeFirstAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("takeFirstAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.takeFirstAsync());
    }

    public RFuture<V> takeLastAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("takeLastAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.takeLastAsync());
    }

    public RFuture<V> pollLastAsync(long timeout, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("pollLastAsync", (RObject)this.set);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.pollLastAsync(timeout, unit));
    }

    public RFuture<Collection<V>> pollFirstAsync(int count) {
        Span span = this.tracingRedissonHelper.buildSpan("pollFirstAsync", (RObject)this.set);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.pollFirstAsync(count));
    }

    public RFuture<Collection<V>> pollLastAsync(int count) {
        Span span = this.tracingRedissonHelper.buildSpan("pollLastAsync", (RObject)this.set);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.pollLastAsync(count));
    }

    public RFuture<V> pollFirstAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("pollFirstAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.pollFirstAsync());
    }

    public RFuture<V> pollLastAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("pollLastAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.pollLastAsync());
    }

    public RFuture<V> firstAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("firstAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.firstAsync());
    }

    public RFuture<V> lastAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("lastAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.lastAsync());
    }

    public RFuture<Double> firstScoreAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("firstScoreAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.firstScoreAsync());
    }

    public RFuture<Double> lastScoreAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("lastScoreAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.lastScoreAsync());
    }

    public RFuture<Integer> addAllAsync(Map<V, Double> objects) {
        Span span = this.tracingRedissonHelper.buildSpan("addAllAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.addAllAsync(objects));
    }

    public RFuture<Integer> removeRangeByScoreAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("removeRangeByScoreAsync", (RObject)this.set);
        span.setTag("startScore", (Number)startScore);
        span.setTag("startScoreInclusive", startScoreInclusive);
        span.setTag("endScore", (Number)endScore);
        span.setTag("endScoreInclusive", endScoreInclusive);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.removeRangeByScoreAsync(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    public RFuture<Integer> removeRangeByRankAsync(int startIndex, int endIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("removeRangeByRankAsync", (RObject)this.set);
        span.setTag("startIndex", (Number)startIndex);
        span.setTag("endIndex", (Number)endIndex);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.removeRangeByRankAsync(startIndex, endIndex));
    }

    public RFuture<Integer> rankAsync(V o) {
        Span span = this.tracingRedissonHelper.buildSpan("rankAsync", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable(o));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.rankAsync(o));
    }

    public RFuture<Integer> revRankAsync(V o) {
        Span span = this.tracingRedissonHelper.buildSpan("revRankAsync", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable(o));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.revRankAsync(o));
    }

    public RFuture<Double> getScoreAsync(V o) {
        Span span = this.tracingRedissonHelper.buildSpan("getScoreAsync", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable(o));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.getScoreAsync(o));
    }

    public RFuture<Boolean> addAsync(double score, V object) {
        Span span = this.tracingRedissonHelper.buildSpan("addAsync", (RObject)this.set);
        span.setTag("score", (Number)score);
        span.setTag("object", TracingHelper.nullable(object));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.addAsync(score, object));
    }

    public RFuture<Integer> addAndGetRankAsync(double score, V object) {
        Span span = this.tracingRedissonHelper.buildSpan("addAndGetRankAsync", (RObject)this.set);
        span.setTag("score", (Number)score);
        span.setTag("object", TracingHelper.nullable(object));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.addAndGetRankAsync(score, object));
    }

    public RFuture<Integer> addAndGetRevRankAsync(double score, V object) {
        Span span = this.tracingRedissonHelper.buildSpan("addAndGetRevRankAsync", (RObject)this.set);
        span.setTag("score", (Number)score);
        span.setTag("object", TracingHelper.nullable(object));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.addAndGetRevRankAsync(score, object));
    }

    public RFuture<Boolean> tryAddAsync(double score, V object) {
        Span span = this.tracingRedissonHelper.buildSpan("tryAddAsync", (RObject)this.set);
        span.setTag("score", (Number)score);
        span.setTag("object", TracingHelper.nullable(object));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.tryAddAsync(score, object));
    }

    public RFuture<Boolean> removeAsync(V object) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAsync", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable(object));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.removeAsync(object));
    }

    public RFuture<Integer> sizeAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("sizeAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.sizeAsync());
    }

    public RFuture<Boolean> containsAsync(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("containsAsync", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.containsAsync(o));
    }

    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("containsAllAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.containsAllAsync(c));
    }

    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAllAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.removeAllAsync(c));
    }

    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("retainAllAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.retainAllAsync(c));
    }

    public RFuture<Double> addScoreAsync(V object, Number value) {
        Span span = this.tracingRedissonHelper.buildSpan("addScoreAsync", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable(object));
        span.setTag("value", TracingHelper.nullable((Object)value));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.addScoreAsync(object, value));
    }

    public RFuture<Integer> addScoreAndGetRevRankAsync(V object, Number value) {
        Span span = this.tracingRedissonHelper.buildSpan("addScoreAndGetRevRankAsync", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable(object));
        span.setTag("value", TracingHelper.nullable((Object)value));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.addScoreAndGetRevRankAsync(object, value));
    }

    public RFuture<Integer> addScoreAndGetRankAsync(V object, Number value) {
        Span span = this.tracingRedissonHelper.buildSpan("addScoreAndGetRankAsync", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable(object));
        span.setTag("value", TracingHelper.nullable((Object)value));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.addScoreAndGetRankAsync(object, value));
    }

    public RFuture<Collection<V>> valueRangeAsync(int startIndex, int endIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("valueRangeAsync", (RObject)this.set);
        span.setTag("startIndex", (Number)startIndex);
        span.setTag("endIndex", (Number)endIndex);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.valueRangeAsync(startIndex, endIndex));
    }

    public RFuture<Collection<V>> valueRangeReversedAsync(int startIndex, int endIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("valueRangeReversedAsync", (RObject)this.set);
        span.setTag("startIndex", (Number)startIndex);
        span.setTag("endIndex", (Number)endIndex);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.valueRangeReversedAsync(startIndex, endIndex));
    }

    public RFuture<Collection<ScoredEntry<V>>> entryRangeAsync(int startIndex, int endIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("entryRangeAsync", (RObject)this.set);
        span.setTag("startIndex", (Number)startIndex);
        span.setTag("endIndex", (Number)endIndex);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.entryRangeAsync(startIndex, endIndex));
    }

    public RFuture<Collection<ScoredEntry<V>>> entryRangeReversedAsync(int startIndex, int endIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("entryRangeReversedAsync", (RObject)this.set);
        span.setTag("startIndex", (Number)startIndex);
        span.setTag("endIndex", (Number)endIndex);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.entryRangeReversedAsync(startIndex, endIndex));
    }

    public RFuture<Collection<V>> valueRangeAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("valueRangeAsync", (RObject)this.set);
        span.setTag("startScore", (Number)startScore);
        span.setTag("startScoreInclusive", startScoreInclusive);
        span.setTag("endScore", (Number)endScore);
        span.setTag("endScoreInclusive", endScoreInclusive);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.valueRangeAsync(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    public RFuture<Collection<V>> valueRangeReversedAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("valueRangeReversedAsync", (RObject)this.set);
        span.setTag("startScore", (Number)startScore);
        span.setTag("startScoreInclusive", startScoreInclusive);
        span.setTag("endScore", (Number)endScore);
        span.setTag("endScoreInclusive", endScoreInclusive);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.valueRangeReversedAsync(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    public RFuture<Collection<ScoredEntry<V>>> entryRangeAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("entryRangeAsync", (RObject)this.set);
        span.setTag("startScore", (Number)startScore);
        span.setTag("startScoreInclusive", startScoreInclusive);
        span.setTag("endScore", (Number)endScore);
        span.setTag("endScoreInclusive", endScoreInclusive);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.entryRangeAsync(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    public RFuture<Collection<V>> valueRangeAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("valueRangeAsync", (RObject)this.set);
        span.setTag("startScore", (Number)startScore);
        span.setTag("startScoreInclusive", startScoreInclusive);
        span.setTag("endScore", (Number)endScore);
        span.setTag("endScoreInclusive", endScoreInclusive);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.valueRangeAsync(startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count));
    }

    public RFuture<Collection<V>> valueRangeReversedAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("valueRangeReversedAsync", (RObject)this.set);
        span.setTag("startScore", (Number)startScore);
        span.setTag("startScoreInclusive", startScoreInclusive);
        span.setTag("endScore", (Number)endScore);
        span.setTag("endScoreInclusive", endScoreInclusive);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.valueRangeReversedAsync(startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count));
    }

    public RFuture<Collection<ScoredEntry<V>>> entryRangeAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("entryRangeAsync", (RObject)this.set);
        span.setTag("startScore", (Number)startScore);
        span.setTag("startScoreInclusive", startScoreInclusive);
        span.setTag("endScore", (Number)endScore);
        span.setTag("endScoreInclusive", endScoreInclusive);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.entryRangeAsync(startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count));
    }

    public RFuture<Collection<ScoredEntry<V>>> entryRangeReversedAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("entryRangeReversedAsync", (RObject)this.set);
        span.setTag("startScore", (Number)startScore);
        span.setTag("startScoreInclusive", startScoreInclusive);
        span.setTag("endScore", (Number)endScore);
        span.setTag("endScoreInclusive", endScoreInclusive);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.entryRangeReversedAsync(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    public RFuture<Collection<ScoredEntry<V>>> entryRangeReversedAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("entryRangeReversedAsync", (RObject)this.set);
        span.setTag("startScore", (Number)startScore);
        span.setTag("startScoreInclusive", startScoreInclusive);
        span.setTag("endScore", (Number)endScore);
        span.setTag("endScoreInclusive", endScoreInclusive);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.entryRangeReversedAsync(startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count));
    }

    public RFuture<Integer> countAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("countAsync", (RObject)this.set);
        span.setTag("startScore", (Number)startScore);
        span.setTag("startScoreInclusive", startScoreInclusive);
        span.setTag("endScore", (Number)endScore);
        span.setTag("endScoreInclusive", endScoreInclusive);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.countAsync(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    public RFuture<Collection<V>> readAllAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("readAllAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readAllAsync());
    }

    public RFuture<Integer> intersectionAsync(String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("intersectionAsync", (RObject)this.set);
        span.setTag("names", Arrays.toString(names));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.intersectionAsync(names));
    }

    public RFuture<Integer> intersectionAsync(RScoredSortedSet.Aggregate aggregate, String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("intersectionAsync", (RObject)this.set);
        span.setTag("aggregate", TracingHelper.nullable((Object)aggregate));
        span.setTag("names", Arrays.toString(names));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.intersectionAsync(aggregate, names));
    }

    public RFuture<Integer> intersectionAsync(Map<String, Double> nameWithWeight) {
        Span span = this.tracingRedissonHelper.buildSpan("intersectionAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.intersectionAsync(nameWithWeight));
    }

    public RFuture<Integer> intersectionAsync(RScoredSortedSet.Aggregate aggregate, Map<String, Double> nameWithWeight) {
        Span span = this.tracingRedissonHelper.buildSpan("intersectionAsync", (RObject)this.set);
        span.setTag("aggregate", TracingHelper.nullable((Object)aggregate));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.intersectionAsync(aggregate, nameWithWeight));
    }

    public RFuture<Integer> unionAsync(String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("unionAsync", (RObject)this.set);
        span.setTag("names", Arrays.toString(names));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.unionAsync(names));
    }

    public RFuture<Integer> unionAsync(RScoredSortedSet.Aggregate aggregate, String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("unionAsync", (RObject)this.set);
        span.setTag("aggregate", TracingHelper.nullable((Object)aggregate));
        span.setTag("names", Arrays.toString(names));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.unionAsync(aggregate, names));
    }

    public RFuture<Integer> unionAsync(Map<String, Double> nameWithWeight) {
        Span span = this.tracingRedissonHelper.buildSpan("unionAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.unionAsync(nameWithWeight));
    }

    public RFuture<Integer> unionAsync(RScoredSortedSet.Aggregate aggregate, Map<String, Double> nameWithWeight) {
        Span span = this.tracingRedissonHelper.buildSpan("unionAsync", (RObject)this.set);
        span.setTag("aggregate", TracingHelper.nullable((Object)aggregate));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.unionAsync(aggregate, nameWithWeight));
    }

    public RFuture<Set<V>> readSortAsync(SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAsync", (RObject)this.set);
        span.setTag("order", TracingHelper.nullable((Object)order));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAsync(order));
    }

    public RFuture<Set<V>> readSortAsync(SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAsync", (RObject)this.set);
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAsync(order, offset, count));
    }

    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAsync", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAsync(byPattern, order));
    }

    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAsync", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAsync(byPattern, order, offset, count));
    }

    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAsync", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAsync(byPattern, getPatterns, order));
    }

    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAsync", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAsync(byPattern, getPatterns, order, offset, count));
    }

    public RFuture<Set<V>> readSortAlphaAsync(SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlphaAsync", (RObject)this.set);
        span.setTag("order", TracingHelper.nullable((Object)order));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAlphaAsync(order));
    }

    public RFuture<Set<V>> readSortAlphaAsync(SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlphaAsync", (RObject)this.set);
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAlphaAsync(order, offset, count));
    }

    public RFuture<Set<V>> readSortAlphaAsync(String byPattern, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlphaAsync", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAlphaAsync(byPattern, order));
    }

    public RFuture<Set<V>> readSortAlphaAsync(String byPattern, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlphaAsync", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAlphaAsync(byPattern, order, offset, count));
    }

    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlphaAsync", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAlphaAsync(byPattern, getPatterns, order));
    }

    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlphaAsync", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAlphaAsync(byPattern, getPatterns, order, offset, count));
    }

    public RFuture<Integer> sortToAsync(String destName, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("sortToAsync", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.sortToAsync(destName, order));
    }

    public RFuture<Integer> sortToAsync(String destName, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("sortToAsync", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.sortToAsync(destName, order, offset, count));
    }

    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("sortToAsync", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.sortToAsync(destName, byPattern, order));
    }

    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("sortToAsync", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.sortToAsync(destName, byPattern, order, offset, count));
    }

    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("sortToAsync", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.sortToAsync(destName, byPattern, getPatterns, order));
    }

    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("sortToAsync", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.sortToAsync(destName, byPattern, getPatterns, order, offset, count));
    }

    public Iterator<V> iterator() {
        return this.set.iterator();
    }

    public void forEach(Consumer<? super V> action) {
        Span span = this.tracingRedissonHelper.buildSpan("forEach", (RObject)this.set);
        span.setTag("action", TracingHelper.nullable(action));
        this.tracingRedissonHelper.decorate(span, () -> this.set.forEach(action));
    }

    public Spliterator<V> spliterator() {
        return this.set.spliterator();
    }

    public Set<V> readSort(SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSort", (RObject)this.set);
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Set)this.tracingRedissonHelper.decorate(span, () -> (Set)this.set.readSort(order));
    }

    public Set<V> readSort(SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSort", (RObject)this.set);
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> (Set)this.set.readSort(order, offset, count));
    }

    public Set<V> readSort(String byPattern, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSort", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Set)this.tracingRedissonHelper.decorate(span, () -> (Set)this.set.readSort(byPattern, order));
    }

    public Set<V> readSort(String byPattern, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSort", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> (Set)this.set.readSort(byPattern, order, offset, count));
    }

    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSort", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.readSort(byPattern, getPatterns, order));
    }

    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSort", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.readSort(byPattern, getPatterns, order, offset, count));
    }

    public Set<V> readSortAlpha(SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlpha", (RObject)this.set);
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Set)this.tracingRedissonHelper.decorate(span, () -> (Set)this.set.readSortAlpha(order));
    }

    public Set<V> readSortAlpha(SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlpha", (RObject)this.set);
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> (Set)this.set.readSortAlpha(order, offset, count));
    }

    public Set<V> readSortAlpha(String byPattern, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlpha", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Set)this.tracingRedissonHelper.decorate(span, () -> (Set)this.set.readSortAlpha(byPattern, order));
    }

    public Set<V> readSortAlpha(String byPattern, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlpha", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> (Set)this.set.readSortAlpha(byPattern, order, offset, count));
    }

    public <T> Collection<T> readSortAlpha(String byPattern, List<String> getPatterns, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlpha", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.readSortAlpha(byPattern, getPatterns, order));
    }

    public <T> Collection<T> readSortAlpha(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlpha", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.readSortAlpha(byPattern, getPatterns, order, offset, count));
    }

    public int sortTo(String destName, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("sortTo", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.sortTo(destName, order));
    }

    public int sortTo(String destName, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("sortTo", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.sortTo(destName, order, offset, count));
    }

    public int sortTo(String destName, String byPattern, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("sortTo", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.sortTo(destName, byPattern, order));
    }

    public int sortTo(String destName, String byPattern, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("sortTo", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.sortTo(destName, byPattern, order, offset, count));
    }

    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("sortTo", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.sortTo(destName, byPattern, getPatterns, order));
    }

    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("sortTo", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.sortTo(destName, byPattern, getPatterns, order, offset, count));
    }
}

