/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRMultimap;
import io.opentracing.contrib.redis.redisson.TracingRSet;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Map;
import java.util.Set;
import org.redisson.api.RObject;
import org.redisson.api.RSet;
import org.redisson.api.RSetMultimap;

public class TracingRSetMultimap<K, V>
extends TracingRMultimap<K, V>
implements RSetMultimap<K, V> {
    private final RSetMultimap<K, V> set;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRSetMultimap(RSetMultimap<K, V> set, TracingRedissonHelper tracingRedissonHelper) {
        super(set, tracingRedissonHelper);
        this.set = set;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    @Override
    public RSet<V> get(K key) {
        Span span = this.tracingRedissonHelper.buildSpan("get", (RObject)this.set);
        span.setTag("key", TracingHelper.nullable(key));
        return (RSet)this.tracingRedissonHelper.decorate(span, () -> new TracingRSet(this.set.get(key), this.tracingRedissonHelper));
    }

    @Override
    public Set<V> getAll(K key) {
        Span span = this.tracingRedissonHelper.buildSpan("getAll", (RObject)this.set);
        span.setTag("key", TracingHelper.nullable(key));
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.set.getAll(key));
    }

    @Override
    public Set<V> removeAll(Object key) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAll", (RObject)this.set);
        span.setTag("key", TracingHelper.nullable((Object)key));
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.set.removeAll(key));
    }

    @Override
    public Set<V> replaceValues(K key, Iterable<? extends V> values) {
        Span span = this.tracingRedissonHelper.buildSpan("replaceValues", (RObject)this.set);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("values", TracingHelper.nullable(values));
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.set.replaceValues(key, values));
    }

    @Override
    public Set<Map.Entry<K, V>> entries() {
        Span span = this.tracingRedissonHelper.buildSpan("entries", (RObject)this.set);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.set.entries());
    }
}

