/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRCollectionMapReduce;
import io.opentracing.contrib.redis.redisson.TracingRObject;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;
import org.redisson.api.RSortedSet;
import org.redisson.api.mapreduce.RCollectionMapReduce;

public class TracingRSortedSet<V>
extends TracingRObject
implements RSortedSet<V> {
    private final RSortedSet<V> set;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRSortedSet(RSortedSet<V> set, TracingRedissonHelper tracingRedissonHelper) {
        super((RObject)set, tracingRedissonHelper);
        this.set = set;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public <KOut, VOut> RCollectionMapReduce<V, KOut, VOut> mapReduce() {
        return new TracingRCollectionMapReduce(this.set.mapReduce(), this.tracingRedissonHelper);
    }

    public Collection<V> readAll() {
        Span span = this.tracingRedissonHelper.buildSpan("readAll", (RObject)this.set);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.readAll());
    }

    public RFuture<Collection<V>> readAllAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("readAllAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readAllAsync());
    }

    public RFuture<Boolean> addAsync(V value) {
        Span span = this.tracingRedissonHelper.buildSpan("addAsync", (RObject)this.set);
        span.setTag("value", TracingHelper.nullable(value));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.addAsync(value));
    }

    public RFuture<Boolean> removeAsync(Object value) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAsync", (RObject)this.set);
        span.setTag("value", TracingHelper.nullable((Object)value));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.removeAsync(value));
    }

    public boolean trySetComparator(Comparator<? super V> comparator) {
        Span span = this.tracingRedissonHelper.buildSpan("trySetComparator", (RObject)this.set);
        span.setTag("comparator", TracingHelper.nullable(comparator));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.trySetComparator(comparator));
    }

    public Comparator<? super V> comparator() {
        return this.set.comparator();
    }

    public SortedSet<V> subSet(V fromElement, V toElement) {
        Span span = this.tracingRedissonHelper.buildSpan("subSet", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable(fromElement));
        span.setTag("toElement", TracingHelper.nullable(toElement));
        return (SortedSet)this.tracingRedissonHelper.decorate(span, () -> this.set.subSet(fromElement, toElement));
    }

    public SortedSet<V> headSet(V toElement) {
        Span span = this.tracingRedissonHelper.buildSpan("headSet", (RObject)this.set);
        span.setTag("toElement", TracingHelper.nullable(toElement));
        return (SortedSet)this.tracingRedissonHelper.decorate(span, () -> this.set.headSet(toElement));
    }

    public SortedSet<V> tailSet(V fromElement) {
        Span span = this.tracingRedissonHelper.buildSpan("tailSet", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable(fromElement));
        return (SortedSet)this.tracingRedissonHelper.decorate(span, () -> this.set.tailSet(fromElement));
    }

    public V first() {
        Span span = this.tracingRedissonHelper.buildSpan("first", (RObject)this.set);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.set.first());
    }

    public V last() {
        Span span = this.tracingRedissonHelper.buildSpan("last", (RObject)this.set);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.set.last());
    }

    public Spliterator<V> spliterator() {
        return this.set.spliterator();
    }

    public int size() {
        Span span = this.tracingRedissonHelper.buildSpan("size", (RObject)this.set);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.size());
    }

    public boolean isEmpty() {
        Span span = this.tracingRedissonHelper.buildSpan("isEmpty", (RObject)this.set);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.isEmpty());
    }

    public boolean contains(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("contains", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.contains(o));
    }

    public Iterator<V> iterator() {
        return this.set.iterator();
    }

    public Object[] toArray() {
        Span span = this.tracingRedissonHelper.buildSpan("toArray", (RObject)this.set);
        return (Object[])this.tracingRedissonHelper.decorate(span, () -> this.set.toArray());
    }

    public <T> T[] toArray(T[] a) {
        Span span = this.tracingRedissonHelper.buildSpan("toArray", (RObject)this.set);
        return (Object[])this.tracingRedissonHelper.decorate(span, () -> this.set.toArray(a));
    }

    public boolean add(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("add", (RObject)this.set);
        span.setTag("element", TracingHelper.nullable(v));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.add(v));
    }

    public boolean remove(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("remove", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.remove(o));
    }

    public boolean containsAll(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("containsAll", (RObject)this.set);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.containsAll(c));
    }

    public boolean addAll(Collection<? extends V> c) {
        Span span = this.tracingRedissonHelper.buildSpan("addAll", (RObject)this.set);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.addAll(c));
    }

    public boolean retainAll(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("retainAll", (RObject)this.set);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.retainAll(c));
    }

    public boolean removeAll(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAll", (RObject)this.set);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.removeAll(c));
    }

    public void clear() {
        Span span = this.tracingRedissonHelper.buildSpan("clear", (RObject)this.set);
        this.tracingRedissonHelper.decorate(span, () -> this.set.clear());
    }

    public boolean removeIf(Predicate<? super V> filter) {
        Span span = this.tracingRedissonHelper.buildSpan("removeIf", (RObject)this.set);
        span.setTag("filter", TracingHelper.nullable(filter));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.removeIf(filter));
    }

    public Stream<V> stream() {
        return this.set.stream();
    }

    public Stream<V> parallelStream() {
        return this.set.parallelStream();
    }

    public void forEach(Consumer<? super V> action) {
        Span span = this.tracingRedissonHelper.buildSpan("forEach", (RObject)this.set);
        span.setTag("action", TracingHelper.nullable(action));
        this.tracingRedissonHelper.decorate(span, () -> this.set.forEach(action));
    }
}

