/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRBlockingQueue;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;
import org.redisson.api.RTransferQueue;

public class TracingRTransferQueue<V>
extends TracingRBlockingQueue<V>
implements RTransferQueue<V> {
    private final RTransferQueue<V> queue;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRTransferQueue(RTransferQueue<V> queue, TracingRedissonHelper tracingRedissonHelper) {
        super(queue, tracingRedissonHelper);
        this.queue = queue;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public boolean tryTransfer(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("tryTransfer", (RObject)this.queue);
        span.setTag("element", TracingHelper.nullable(v));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.tryTransfer(v));
    }

    public void transfer(V v) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("transfer", (RObject)this.queue);
        span.setTag("element", TracingHelper.nullable(v));
        this.tracingRedissonHelper.decorateThrowing(span, () -> this.queue.transfer(v));
    }

    public boolean tryTransfer(V v, long timeout, TimeUnit unit) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("tryTransfer", (RObject)this.queue);
        span.setTag("element", TracingHelper.nullable(v));
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (Boolean)this.tracingRedissonHelper.decorateThrowing(span, () -> this.queue.tryTransfer(v, timeout, unit));
    }

    public boolean hasWaitingConsumer() {
        Span span = this.tracingRedissonHelper.buildSpan("hasWaitingConsumer", (RObject)this.queue);
        return (Boolean)this.tracingRedissonHelper.decorateThrowing(span, () -> this.queue.hasWaitingConsumer());
    }

    public int getWaitingConsumerCount() {
        Span span = this.tracingRedissonHelper.buildSpan("getWaitingConsumerCount", (RObject)this.queue);
        return (Integer)this.tracingRedissonHelper.decorateThrowing(span, () -> this.queue.getWaitingConsumerCount());
    }

    public RFuture<Boolean> tryTransferAsync(V e) {
        Span span = this.tracingRedissonHelper.buildSpan("tryTransferAsync", (RObject)this.queue);
        span.setTag("element", TracingHelper.nullable(e));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.tryTransferAsync(e));
    }

    public RFuture<Void> transferAsync(V e) {
        Span span = this.tracingRedissonHelper.buildSpan("transferAsync", (RObject)this.queue);
        span.setTag("element", TracingHelper.nullable(e));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.transferAsync(e));
    }

    public RFuture<Boolean> tryTransferAsync(V e, long timeout, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("tryTransferAsync", (RObject)this.queue);
        span.setTag("element", TracingHelper.nullable(e));
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.tryTransferAsync(e, timeout, unit));
    }
}

