/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingConfiguration;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.CompletableRFuture;
import java.util.function.Supplier;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;

class TracingRedissonHelper
extends TracingHelper {
    TracingRedissonHelper(TracingConfiguration tracingConfiguration) {
        super(tracingConfiguration);
    }

    Span buildSpan(String operationName, RObject rObject) {
        return this.buildSpan(operationName).setTag("name", rObject.getName());
    }

    private <T> RFuture<T> continueScopeSpan(RFuture<T> redisFuture) {
        Span span = this.tracer.activeSpan();
        CompletableRFuture customRedisFuture = new CompletableRFuture(redisFuture);
        redisFuture.whenComplete((v, throwable) -> {
            try (Scope ignored = this.tracer.scopeManager().activate(span);){
                if (throwable != null) {
                    customRedisFuture.completeExceptionally((Throwable)throwable);
                } else {
                    customRedisFuture.complete(v);
                }
            }
        });
        return customRedisFuture;
    }

    private <V> RFuture<V> setCompleteAction(RFuture<V> future, Span span) {
        future.whenComplete((v, throwable) -> {
            if (throwable != null) {
                TracingRedissonHelper.onError((Throwable)throwable, (Span)span);
            }
            span.finish();
        });
        return future;
    }

    <V> RFuture<V> prepareRFuture(Span span, Supplier<RFuture<V>> futureSupplier) {
        RFuture<V> future;
        try {
            future = futureSupplier.get();
        }
        catch (Exception e) {
            TracingRedissonHelper.onError((Throwable)e, (Span)span);
            span.finish();
            throw e;
        }
        return this.continueScopeSpan(this.setCompleteAction(future, span));
    }
}

