/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.spring.data2.connection;

import io.opentracing.Tracer;
import io.opentracing.contrib.redis.common.TracingHelper;
import org.springframework.data.redis.connection.ReactiveClusterGeoCommands;
import org.springframework.data.redis.connection.ReactiveClusterHashCommands;
import org.springframework.data.redis.connection.ReactiveClusterHyperLogLogCommands;
import org.springframework.data.redis.connection.ReactiveClusterKeyCommands;
import org.springframework.data.redis.connection.ReactiveClusterListCommands;
import org.springframework.data.redis.connection.ReactiveClusterNumberCommands;
import org.springframework.data.redis.connection.ReactiveClusterServerCommands;
import org.springframework.data.redis.connection.ReactiveClusterSetCommands;
import org.springframework.data.redis.connection.ReactiveClusterStringCommands;
import org.springframework.data.redis.connection.ReactiveClusterZSetCommands;
import org.springframework.data.redis.connection.ReactivePubSubCommands;
import org.springframework.data.redis.connection.ReactiveRedisClusterConnection;
import org.springframework.data.redis.connection.ReactiveScriptingCommands;
import org.springframework.data.redis.connection.RedisClusterNode;
import reactor.core.publisher.Mono;

public class TracingReactiveRedisClusterConnection
implements ReactiveRedisClusterConnection {
    private final ReactiveRedisClusterConnection reactiveRedisClusterConnection;
    private final boolean withActiveSpanOnly;
    private final Tracer tracer;

    public TracingReactiveRedisClusterConnection(ReactiveRedisClusterConnection reactiveRedisClusterConnection, boolean withActiveSpanOnly, Tracer tracer) {
        this.reactiveRedisClusterConnection = reactiveRedisClusterConnection;
        this.withActiveSpanOnly = withActiveSpanOnly;
        this.tracer = tracer;
    }

    public ReactiveClusterKeyCommands keyCommands() {
        return this.reactiveRedisClusterConnection.keyCommands();
    }

    public ReactiveClusterStringCommands stringCommands() {
        return this.reactiveRedisClusterConnection.stringCommands();
    }

    public ReactiveClusterNumberCommands numberCommands() {
        return this.reactiveRedisClusterConnection.numberCommands();
    }

    public ReactiveClusterListCommands listCommands() {
        return this.reactiveRedisClusterConnection.listCommands();
    }

    public ReactiveClusterSetCommands setCommands() {
        return this.reactiveRedisClusterConnection.setCommands();
    }

    public ReactiveClusterZSetCommands zSetCommands() {
        return this.reactiveRedisClusterConnection.zSetCommands();
    }

    public ReactiveClusterHashCommands hashCommands() {
        return this.reactiveRedisClusterConnection.hashCommands();
    }

    public ReactiveClusterGeoCommands geoCommands() {
        return this.reactiveRedisClusterConnection.geoCommands();
    }

    public ReactiveClusterHyperLogLogCommands hyperLogLogCommands() {
        return this.reactiveRedisClusterConnection.hyperLogLogCommands();
    }

    public ReactivePubSubCommands pubSubCommands() {
        return this.reactiveRedisClusterConnection.pubSubCommands();
    }

    public ReactiveClusterServerCommands serverCommands() {
        return this.reactiveRedisClusterConnection.serverCommands();
    }

    public Mono<String> ping(RedisClusterNode node) {
        return (Mono)TracingHelper.doInScope((String)"PING", () -> this.reactiveRedisClusterConnection.ping(node), (boolean)this.withActiveSpanOnly, (Tracer)this.tracer);
    }

    public void close() {
        this.reactiveRedisClusterConnection.close();
    }

    public Mono<Void> closeLater() {
        return this.reactiveRedisClusterConnection.closeLater();
    }

    public ReactiveScriptingCommands scriptingCommands() {
        return this.reactiveRedisClusterConnection.scriptingCommands();
    }

    public Mono<String> ping() {
        return (Mono)TracingHelper.doInScope((String)"PING", () -> ((ReactiveRedisClusterConnection)this.reactiveRedisClusterConnection).ping(), (boolean)this.withActiveSpanOnly, (Tracer)this.tracer);
    }
}

