/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.spring.data2.connection;

import io.opentracing.Tracer;
import io.opentracing.contrib.redis.common.TracingHelper;
import org.springframework.data.redis.connection.ReactiveGeoCommands;
import org.springframework.data.redis.connection.ReactiveHashCommands;
import org.springframework.data.redis.connection.ReactiveHyperLogLogCommands;
import org.springframework.data.redis.connection.ReactiveKeyCommands;
import org.springframework.data.redis.connection.ReactiveListCommands;
import org.springframework.data.redis.connection.ReactiveNumberCommands;
import org.springframework.data.redis.connection.ReactivePubSubCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveScriptingCommands;
import org.springframework.data.redis.connection.ReactiveServerCommands;
import org.springframework.data.redis.connection.ReactiveSetCommands;
import org.springframework.data.redis.connection.ReactiveStringCommands;
import org.springframework.data.redis.connection.ReactiveZSetCommands;
import reactor.core.publisher.Mono;

public class TracingReactiveRedisConnection
implements ReactiveRedisConnection {
    private final ReactiveRedisConnection reactiveRedisConnection;
    private final boolean withActiveSpanOnly;
    private final Tracer tracer;

    public TracingReactiveRedisConnection(ReactiveRedisConnection reactiveRedisConnection, boolean withActiveSpanOnly, Tracer tracer) {
        this.reactiveRedisConnection = reactiveRedisConnection;
        this.withActiveSpanOnly = withActiveSpanOnly;
        this.tracer = tracer;
    }

    public void close() {
        this.reactiveRedisConnection.close();
    }

    public Mono<Void> closeLater() {
        return this.reactiveRedisConnection.closeLater();
    }

    public ReactiveKeyCommands keyCommands() {
        return this.reactiveRedisConnection.keyCommands();
    }

    public ReactiveStringCommands stringCommands() {
        return this.reactiveRedisConnection.stringCommands();
    }

    public ReactiveNumberCommands numberCommands() {
        return this.reactiveRedisConnection.numberCommands();
    }

    public ReactiveListCommands listCommands() {
        return this.reactiveRedisConnection.listCommands();
    }

    public ReactiveSetCommands setCommands() {
        return this.reactiveRedisConnection.setCommands();
    }

    public ReactiveZSetCommands zSetCommands() {
        return this.reactiveRedisConnection.zSetCommands();
    }

    public ReactiveHashCommands hashCommands() {
        return this.reactiveRedisConnection.hashCommands();
    }

    public ReactiveGeoCommands geoCommands() {
        return this.reactiveRedisConnection.geoCommands();
    }

    public ReactiveHyperLogLogCommands hyperLogLogCommands() {
        return this.reactiveRedisConnection.hyperLogLogCommands();
    }

    public ReactivePubSubCommands pubSubCommands() {
        return this.reactiveRedisConnection.pubSubCommands();
    }

    public ReactiveScriptingCommands scriptingCommands() {
        return this.reactiveRedisConnection.scriptingCommands();
    }

    public ReactiveServerCommands serverCommands() {
        return this.reactiveRedisConnection.serverCommands();
    }

    public Mono<String> ping() {
        return (Mono)TracingHelper.doInScope((String)"PING", () -> ((ReactiveRedisConnection)this.reactiveRedisConnection).ping(), (boolean)this.withActiveSpanOnly, (Tracer)this.tracer);
    }
}

