/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.spring.data2.connection;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingConfiguration;
import io.opentracing.contrib.redis.common.TracingHelper;
import java.io.IOException;
import java.util.Collection;
import org.springframework.data.redis.connection.NamedNode;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.RedisServer;

public class TracingRedisSentinelConnection
implements RedisSentinelConnection {
    private final RedisSentinelConnection redisSentinelConnection;
    private final TracingHelper helper;

    public TracingRedisSentinelConnection(RedisSentinelConnection redisSentinelConnection, TracingConfiguration configuration) {
        this.redisSentinelConnection = redisSentinelConnection;
        this.helper = new TracingHelper(configuration);
    }

    public boolean isOpen() {
        Span span = this.helper.buildSpan("isOpen");
        return (Boolean)this.helper.decorate(span, () -> ((RedisSentinelConnection)this.redisSentinelConnection).isOpen());
    }

    public void failover(NamedNode master) {
        Span span = this.helper.buildSpan("failover");
        this.helper.decorate(span, () -> this.redisSentinelConnection.failover(master));
    }

    public Collection<RedisServer> masters() {
        Span span = this.helper.buildSpan("masters");
        return (Collection)this.helper.decorate(span, () -> ((RedisSentinelConnection)this.redisSentinelConnection).masters());
    }

    public Collection<RedisServer> slaves(NamedNode master) {
        Span span = this.helper.buildSpan("slaves");
        return (Collection)this.helper.decorate(span, () -> this.redisSentinelConnection.slaves(master));
    }

    public void remove(NamedNode master) {
        Span span = this.helper.buildSpan("remove");
        this.helper.decorate(span, () -> this.redisSentinelConnection.remove(master));
    }

    public void monitor(RedisServer master) {
        Span span = this.helper.buildSpan("monitor");
        this.helper.decorate(span, () -> this.redisSentinelConnection.monitor(master));
    }

    public void close() throws IOException {
        Span span = this.helper.buildSpan("close");
        this.helper.decorateThrowing(span, () -> this.redisSentinelConnection.close());
    }
}

