/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.feign;

import io.opentracing.Tracer;
import io.opentracing.contrib.spring.cloud.feign.TraceFeignContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.netflix.feign.FeignContext;

public class FeignContextBeanPostProcessor
implements BeanPostProcessor {
    private Tracer tracer;
    private BeanFactory beanFactory;

    FeignContextBeanPostProcessor(Tracer tracer, BeanFactory beanFactory) {
        this.tracer = tracer;
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String name) throws BeansException {
        if (bean instanceof FeignContext && !(bean instanceof TraceFeignContext)) {
            return new TraceFeignContext(this.tracer, (FeignContext)bean, this.beanFactory);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String name) throws BeansException {
        return bean;
    }
}

