/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.feign;

import feign.Client;
import feign.opentracing.TracingClient;
import io.opentracing.Tracer;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.netflix.feign.FeignContext;
import org.springframework.cloud.netflix.feign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.netflix.feign.ribbon.LoadBalancerFeignClient;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;

public class TraceFeignContext
extends FeignContext {
    private FeignContext delegate;
    private Tracer tracer;
    private BeanFactory beanFactory;

    TraceFeignContext(Tracer tracer, FeignContext delegate, BeanFactory beanFactory) {
        this.delegate = delegate;
        this.tracer = tracer;
        this.beanFactory = beanFactory;
    }

    public <T> T getInstance(String name, Class<T> type) {
        Object object = this.delegate.getInstance(name, type);
        return (T)this.addTracingClient(object);
    }

    public <T> Map<String, T> getInstances(String name, Class<T> type) {
        Map instances = this.delegate.getInstances(name, type);
        if (instances == null) {
            return null;
        }
        HashMap tracedInstances = new HashMap();
        for (Map.Entry instanceEntry : instances.entrySet()) {
            tracedInstances.put(instanceEntry.getKey(), this.addTracingClient(instanceEntry.getValue()));
        }
        return tracedInstances;
    }

    private Object addTracingClient(Object bean) {
        if (bean instanceof TracingClient || bean instanceof LoadBalancedTracedFeign) {
            return bean;
        }
        if (bean instanceof Client) {
            if (bean instanceof LoadBalancerFeignClient && !(bean instanceof LoadBalancedTracedFeign)) {
                return new LoadBalancedTracedFeign((Client)new TracingClient(((LoadBalancerFeignClient)bean).getDelegate(), this.tracer), (CachingSpringLoadBalancerFactory)this.beanFactory.getBean(CachingSpringLoadBalancerFactory.class), (SpringClientFactory)this.beanFactory.getBean(SpringClientFactory.class));
            }
            return new TracingClient((Client)bean, this.tracer);
        }
        return bean;
    }

    static class LoadBalancedTracedFeign
    extends LoadBalancerFeignClient {
        public LoadBalancedTracedFeign(Client delegate, CachingSpringLoadBalancerFactory lbClientFactory, SpringClientFactory clientFactory) {
            super(delegate, lbClientFactory, clientFactory);
        }
    }
}

