/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.feign;

import feign.Client;
import feign.opentracing.FeignSpanDecorator;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.cloud.feign.TracedFeignBeanFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.openfeign.FeignContext;

class TraceFeignContext
extends FeignContext {
    private final FeignContext delegate;
    private final TracedFeignBeanFactory tracedFeignBeanFactory;

    TraceFeignContext(Tracer tracer, FeignContext delegate, BeanFactory beanFactory, List<FeignSpanDecorator> spanDecorators) {
        this.delegate = delegate;
        this.tracedFeignBeanFactory = new TracedFeignBeanFactory(tracer, beanFactory, spanDecorators);
    }

    public <T> T getInstance(String name, Class<T> type) {
        Object object = this.delegate.getInstance(name, type);
        if (object == null && type.isAssignableFrom(Client.class)) {
            object = new Client.Default(null, null);
        }
        return (T)this.addTracingClient(object);
    }

    public <T> Map<String, T> getInstances(String name, Class<T> type) {
        Map instances = this.delegate.getInstances(name, type);
        if (instances == null) {
            return null;
        }
        HashMap tracedInstances = new HashMap();
        for (Map.Entry instanceEntry : instances.entrySet()) {
            tracedInstances.put(instanceEntry.getKey(), this.addTracingClient(instanceEntry.getValue()));
        }
        return tracedInstances;
    }

    private Object addTracingClient(Object bean) {
        return this.tracedFeignBeanFactory.from(bean);
    }
}

