/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.feign;

import feign.Client;
import feign.opentracing.FeignSpanDecorator;
import feign.opentracing.TracingClient;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.cloud.feign.TracingClientBuilder;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.context.annotation.Lazy;

class TracedFeignBeanFactory {
    private final Tracer tracer;
    private final BeanFactory beanFactory;
    private final List<FeignSpanDecorator> spanDecorators;

    public TracedFeignBeanFactory(Tracer tracer, BeanFactory beanFactory, @Lazy List<FeignSpanDecorator> spanDecorators) {
        this.tracer = tracer;
        this.beanFactory = beanFactory;
        this.spanDecorators = spanDecorators;
    }

    public Object from(Object bean) {
        if (bean instanceof TracingClient || bean instanceof LoadBalancedTracedFeign) {
            return bean;
        }
        if (bean instanceof Client) {
            if (bean instanceof LoadBalancerFeignClient) {
                return new LoadBalancedTracedFeign((Client)this.buildTracingClient(((LoadBalancerFeignClient)bean).getDelegate(), this.tracer), (CachingSpringLoadBalancerFactory)this.beanFactory.getBean(CachingSpringLoadBalancerFactory.class), (SpringClientFactory)this.beanFactory.getBean(SpringClientFactory.class));
            }
            return this.buildTracingClient((Client)bean, this.tracer);
        }
        return bean;
    }

    private TracingClient buildTracingClient(Client delegate, Tracer tracer) {
        return new TracingClientBuilder(delegate, tracer).withFeignSpanDecorators(this.spanDecorators).build();
    }

    static class LoadBalancedTracedFeign
    extends LoadBalancerFeignClient {
        public LoadBalancedTracedFeign(Client delegate, CachingSpringLoadBalancerFactory lbClientFactory, SpringClientFactory clientFactory) {
            super(delegate, lbClientFactory, clientFactory);
        }
    }
}

