/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.redis;

import io.opentracing.contrib.redis.spring.data2.connection.TracingRedisClusterConnection;
import io.opentracing.contrib.redis.spring.data2.connection.TracingRedisConnection;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;

@Aspect
public class RedisAspect {
    @Pointcut(value="target(org.springframework.data.redis.connection.RedisConnectionFactory)")
    public void connectionFactory() {
    }

    @Pointcut(value="execution(org.springframework.data.redis.connection.RedisConnection *.getConnection(..))")
    public void getConnection() {
    }

    @Pointcut(value="execution(org.springframework.data.redis.connection.RedisClusterConnection *.getClusterConnection(..))")
    public void getClusterConnection() {
    }

    @Around(value="getConnection() && connectionFactory()")
    public Object aroundGetConnection(ProceedingJoinPoint pjp) throws Throwable {
        RedisConnection connection = (RedisConnection)pjp.proceed();
        return new TracingRedisConnection(connection, false, null);
    }

    @Around(value="getClusterConnection() && connectionFactory()")
    public Object aroundGetClusterConnection(ProceedingJoinPoint pjp) throws Throwable {
        RedisClusterConnection clusterConnection = (RedisClusterConnection)pjp.proceed();
        return new TracingRedisClusterConnection(clusterConnection, false, null);
    }
}

