/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.websocket;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.cloud.websocket.TextMapExtractAdapter;
import io.opentracing.contrib.spring.cloud.websocket.TextMapInjectAdapter;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.support.ChannelInterceptorAdapter;
import org.springframework.messaging.support.ExecutorChannelInterceptor;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.web.socket.messaging.SubProtocolWebSocketHandler;
import org.springframework.web.socket.messaging.WebSocketAnnotationMethodMessageHandler;

public class TracingChannelInterceptor
extends ChannelInterceptorAdapter
implements ExecutorChannelInterceptor {
    protected static final String WEBSOCKET = "websocket";
    protected static final String SIMP_DESTINATION = "simpDestination";
    protected static final String SIMP_MESSAGE_TYPE = "simpMessageType";
    private static final String UNKNOWN_DESTINATION = "Unknown";
    protected static final String OPENTRACING_SPAN = "opentracing.span";
    protected static final String OPENTRACING_SCOPE = "opentracing.scope";
    private Tracer tracer;
    private String spanKind;

    public TracingChannelInterceptor(Tracer tracer, String spanKind) {
        this.tracer = tracer;
        this.spanKind = spanKind;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        if (SimpMessageType.MESSAGE.equals(message.getHeaders().get((Object)SIMP_MESSAGE_TYPE))) {
            if ("server".equals(this.spanKind)) {
                return this.preSendServerSpan(message);
            }
            if ("client".equals(this.spanKind)) {
                return this.preSendClientSpan(message);
            }
        }
        return message;
    }

    private Message<?> preSendClientSpan(Message<?> message) {
        Span span = this.tracer.buildSpan((String)message.getHeaders().getOrDefault((Object)SIMP_DESTINATION, (Object)UNKNOWN_DESTINATION)).withTag(Tags.SPAN_KIND.getKey(), this.spanKind).withTag(Tags.COMPONENT.getKey(), WEBSOCKET).start();
        MessageBuilder messageBuilder = MessageBuilder.fromMessage(message).setHeader(OPENTRACING_SPAN, (Object)span);
        this.tracer.inject(span.context(), Format.Builtin.TEXT_MAP, (Object)new TextMapInjectAdapter(messageBuilder));
        return messageBuilder.build();
    }

    private Message<?> preSendServerSpan(Message<?> message) {
        Span span = this.tracer.buildSpan((String)message.getHeaders().getOrDefault((Object)SIMP_DESTINATION, (Object)UNKNOWN_DESTINATION)).asChildOf(this.tracer.extract(Format.Builtin.TEXT_MAP, (Object)new TextMapExtractAdapter(message.getHeaders()))).withTag(Tags.SPAN_KIND.getKey(), this.spanKind).withTag(Tags.COMPONENT.getKey(), WEBSOCKET).start();
        return MessageBuilder.fromMessage(message).setHeader(OPENTRACING_SPAN, (Object)span).build();
    }

    public void afterMessageHandled(Message<?> message, MessageChannel channel, MessageHandler handler, Exception arg3) {
        if ((handler instanceof WebSocketAnnotationMethodMessageHandler || handler instanceof SubProtocolWebSocketHandler) && SimpMessageType.MESSAGE.equals(message.getHeaders().get((Object)SIMP_MESSAGE_TYPE))) {
            ((Scope)message.getHeaders().get((Object)OPENTRACING_SCOPE, Scope.class)).close();
            ((Span)message.getHeaders().get((Object)OPENTRACING_SPAN, Span.class)).finish();
        }
    }

    public Message<?> beforeHandle(Message<?> message, MessageChannel channel, MessageHandler handler) {
        if ((handler instanceof WebSocketAnnotationMethodMessageHandler || handler instanceof SubProtocolWebSocketHandler) && SimpMessageType.MESSAGE.equals(message.getHeaders().get((Object)SIMP_MESSAGE_TYPE))) {
            Span span = (Span)message.getHeaders().get((Object)OPENTRACING_SPAN, Span.class);
            Scope scope = this.tracer.scopeManager().activate(span);
            message = MessageBuilder.fromMessage(message).setHeader(OPENTRACING_SCOPE, (Object)scope).build();
        }
        return message;
    }
}

