/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.websocket;

import io.opentracing.Tracer;
import io.opentracing.contrib.spring.cloud.websocket.TracingChannelInterceptor;
import io.opentracing.contrib.spring.tracer.configuration.TracerAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurationSupport;

@Configuration
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={TracerAutoConfiguration.class})
@ConditionalOnClass(value={ChannelInterceptor.class, WebSocketMessageBrokerConfigurationSupport.class})
@ConditionalOnProperty(name={"opentracing.spring.cloud.websocket.enabled"}, havingValue="true", matchIfMissing=true)
public class WebsocketAutoConfiguration {
    @Autowired
    private Tracer tracer;

    @Bean
    @ConditionalOnBean(value={WebSocketMessageBrokerConfigurationSupport.class})
    public TracingChannelInterceptor tracingInboundChannelInterceptor(WebSocketMessageBrokerConfigurationSupport config) {
        TracingChannelInterceptor interceptor = new TracingChannelInterceptor(this.tracer, "server");
        config.clientInboundChannel().addInterceptor((ChannelInterceptor)interceptor);
        return interceptor;
    }

    @Bean
    @ConditionalOnBean(value={WebSocketMessageBrokerConfigurationSupport.class})
    public TracingChannelInterceptor tracingOutboundChannelInterceptor(WebSocketMessageBrokerConfigurationSupport config) {
        TracingChannelInterceptor interceptor = new TracingChannelInterceptor(this.tracer, "client");
        config.clientOutboundChannel().addInterceptor((ChannelInterceptor)interceptor);
        return interceptor;
    }
}

